######### Modular Exponentiation Operators (MEO's) ######### 

# N=35 a=4 r=6 m=5 => U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U16_N35_a4(U, u_ver, trnc_lv,  barrier=False): # same as U4
    """U16 for N=35 a=4 r=6"""
    # cycles
    # 1 -> 11 -> 16 -> 1
    # 4 -> 9  -> 29 -> 4
    a = 4
    r = 6
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N35_a4(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # same as U4
        if barrier: U.barrier()
        # 1 -> 11
        U.cx(0, 1)
        U.cx(0, 3)
        if barrier: U.barrier()
        # 11 -> 16
        U.x(1)
        U.ccx(0, 1, 4)
        U.x(1)
        U.cx(4, 0)
        if barrier: U.barrier()
        # 16 -> 1
        U.x(1)
        U.ccx(0, 1, 4)
        U.x(1)
        if barrier: U.barrier()
        # 4 -> 9
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 9 -> 29
        U.x( 3 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 3 )
        if barrier: U.barrier()
        # 29 -> 4
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle-1 1 -> 11 -> 16 -> 1
        # cycle-2 4 -> 9 -> 29 -> 4
        # same as U4
        # 1: 1 -> 11
        if barrier: U.barrier()        
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 3)
        # 2: 11 -> 16
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 1 )
            U.cx( 1 , 0 )
            U.cx( 1 , 4 )
            U.x( 1 )
        # 3: 16 -> 1
        if barrier: U.barrier()
        if 3 <= r - trnc_lv: pass
        # 4: 4 -> 9
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 1 )
        # 5: 9 -> 29
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 3 )
            #
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
        # 6: 29 -> 4
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 3, 4] , 0 )
            U.mct( [1, 3, 4] , 2 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U8_N35_a4(U, u_ver, trnc_lv,  barrier=False): # same as U2
    """U8 for N=35 a=4 r=6"""    
    a = 4
    r = 6
    # 1 -> 16 -> 11 -> 1
    # 4 -> 29 -> 9  -> 4
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N35_a4(U, u_ver, trnc_lv,  barrier)
    elif u_ver ==1:
        # same as U2
        if barrier: U.barrier()
        # 1 -> 16
        U.cx(0, 4)
        U.cx(4, 0)
        if barrier: U.barrier()
        # 16 -> 11
        U.cx(0, 1)
        U.cx(0, 3)        
        U.cx(0, 4)
        if barrier: U.barrier()
        # 11 -> 1
        U.x(0)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        U.x(0)
        U.swap(0, 1)
        if barrier: U.barrier()
        # 4 -> 29
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        if barrier: U.barrier()        
        # 29 -> 9
        U.x(4)
        U.mct([4, 3, 0], 1)
        U.mct([4, 3, 1], 0)
        U.mct([4, 3, 0], 1)        
        U.x(4)
        if barrier: U.barrier()        
        U.x(4)
        U.x(1)
        U.mct([4, 3, 1], 2)
        U.x(4)
        U.x(1)
        if barrier: U.barrier()
        # 9 -> 4
        U.x(0)
        U.x(1)
        U.mct([3, 1, 0], 2)
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.mct([2, 1, 0], 4)
        U.mct([2, 1, 0], 3)        
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
    elif u_ver ==2:
        if barrier: U.barrier()
        # cycle-1 1 -> 16 -> 11 -> 1
        # cycle-2 4 -> 29 -> 9 -> 4
        # same as U2
        # 1: 1 -> 16
        if 1 <= r - trnc_lv:
            U.cx(0, 4)
            U.cx(4, 0)
        if barrier: U.barrier()
        # 2: 16 -> 11
        if 2 <= r - trnc_lv:
            U.cx( 0 , 1 )
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
        if barrier: U.barrier()
        # 3: 11 -> 1
        if 3 <= r - trnc_lv:
            U.ccx( 3 , 4 , 0 )
            U.ccx( 3 , 4 , 1 )
            #
            U.x( 1 )
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 4: 4 -> 29
        if 4 <= r - trnc_lv:
            U.x( 1 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 3 )
            U.ccx( 1 , 2 , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 5: 29 -> 9
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.x( 3 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.x( 2 )
            U.x( 1 )
        if barrier: U.barrier()
        # 6: 9 -> 4
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 2 )
            #
            U.x( 0 )
            U.ccx( 0 , 3 , 2 )
            U.ccx( 0 , 3 , 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 2 , 3 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U4_N35_a4(U, u_ver, trnc_lv,  barrier=False):
    """U4 for N=35 a=4 r=6"""        
    a = 4
    r = 6
    # 1 -> 11 -> 16 -> 1
    # 4 -> 9  -> 29 -> 4
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N35_a4(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        if barrier: U.barrier()
        # cycle-1 1 -> 11 -> 16 -> 1
        # 1 -> 11
        U.cx(0, 1)
        U.cx(0, 3)
        if barrier: U.barrier()
        # 11 -> 16
        U.x(1)
        U.ccx(0, 1, 4)
        U.x(1)
        U.cx(4, 0)
        if barrier: U.barrier()
        # 16 -> 1
        U.x(1)
        U.ccx(0, 1, 4)
        U.x(1)
        if barrier: U.barrier()
        # cycle-2 4 -> 9  -> 29 -> 4
        # 4 -> 9
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 9 -> 29
        U.x( 3 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 3 )
        if barrier: U.barrier()
        # 29 -> 4
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        if barrier: U.barrier()
        # cycle-1 1 -> 11 -> 16 -> 1
        # cycle-2 4 -> 9 -> 29 -> 4
        # 1: 1 -> 11
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 3)
        if barrier: U.barrier()
        # 2: 11 -> 16
        if 2 <= r - trnc_lv:
            U.x( 1 )
            U.cx( 1 , 0 )
            U.cx( 1 , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 3: 16 -> 1
        if 3 <= r - trnc_lv: pass
        if barrier: U.barrier()
        # 4: 4 -> 9
        if 4 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 5: 9 -> 29
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 3 )
            #
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
        if barrier: U.barrier()
        # 6: 29 -> 4
        if 6 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 3, 4] , 0 )
            U.mct( [1, 3, 4] , 2 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U2_N35_a4(U, u_ver, trnc_lv,  barrier=False):
    """U2 for N=35 a=4 r=6"""        
    a = 4
    r = 6
    # cyle-1 1 -> 16 -> 11 -> 1
    # cycle-2 4 -> 29 -> 9 -> 4
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N35_a4(U, u_ver, trnc_lv,  barrier)
    if u_ver == 1:
        if barrier: U.barrier()
        # cycle-1 1 -> 16 -> 11 -> 1
        # 1 -> 16
        U.cx(0, 4)
        U.cx(4, 0)
        if barrier: U.barrier()
        # 16 -> 11
        U.cx(0, 1)
        U.cx(0, 3)        
        U.cx(0, 4)
        if barrier: U.barrier()
        # 11 -> 1
        U.x(0)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        U.x(0)
        U.swap(0, 1)
        if barrier: U.barrier()
        # cycle-2 4 -> 29 -> 9 -> 4
        # 4 -> 29
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        if barrier: U.barrier()        
        # 29 -> 9
        U.x(4)
        U.mct([4, 3, 0], 1)
        U.mct([4, 3, 1], 0)
        U.mct([4, 3, 0], 1)        
        U.x(4)
        if barrier: U.barrier()        
        U.x(4)
        U.x(1)
        U.mct([4, 3, 1], 2)
        U.x(4)
        U.x(1)
        if barrier: U.barrier()
        # 9 -> 4
        U.x(0)
        U.x(1)
        U.mct([3, 1, 0], 2)
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.mct([2, 1, 0], 4)
        U.mct([2, 1, 0], 3)        
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
    if u_ver == 2:
        if barrier: U.barrier()
        # cycle-1 1 -> 16 -> 11 -> 1
        # cycle-2 4 -> 29 -> 9 -> 4
        # 1: 1 -> 16
        if 1 <= r - trnc_lv:
            U.cx(0, 4)
            U.cx(4, 0)
        if barrier: U.barrier()
        # 2: 16 -> 11
        if 2 <= r - trnc_lv:
            U.cx( 0 , 1 )
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
        if barrier: U.barrier()
        # 3: 11 -> 1
        if 3 <= r - trnc_lv:
            U.ccx( 3 , 4 , 0 )
            U.ccx( 3 , 4 , 1 )
            #
            U.x( 1 )
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 4: 4 -> 29
        if 4 <= r - trnc_lv:
            U.x( 1 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 3 )
            U.ccx( 1 , 2 , 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 5: 29 -> 9
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.x( 3 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.x( 2 )
            U.x( 1 )
        if barrier: U.barrier()
        # 6: 9 -> 4
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 2 )
            #
            U.x( 0 )
            U.ccx( 0 , 3 , 2 )
            U.ccx( 0 , 3 , 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 2 , 3 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U1_N35_a4(U, u_ver, trnc_lv,  barrier=False):
    """U1 Modular Exponentiation Operator for N=35 a=4 r=6"""        
    a = 4
    r = 6
    # 1 -> 4 -> 16 -> 29 -> 11 -> 9 -> 1
    if u_ver == 0 or u_ver == 1:
        if barrier: U.barrier()
        # 1 -> 4            
        U.swap(0, 2)
        if barrier: U.barrier()        
        # 4 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()                
        # 16 -> 29
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()                
        # 29 -> 11
        U.x(4)
        U.ccx(0, 4, 1)
        U.ccx(0, 4, 3)
        U.x(4)
        if barrier: U.barrier()                
        # 11 -> 9
        U.x(4)
        U.mct([4, 3, 0], 1)
        U.mct([4, 3, 1], 0)
        U.mct([4, 3, 0], 1)
        U.x(4)
        U.x(4)
        U.x(1)
        U.mct([4, 1, 0], 2)
        U.x(4)
        U.x(1)
        if barrier: U.barrier()                
        # 9 -> 1
        U.x(4)
        U.mct([4, 3, 2], 0)
        U.mct([4, 3, 2], 1)        
        U.x(4)        
        U.mct([0, 1, 2], 3)
        U.x(3)
        U.mct([0, 1, 3], 2)
        U.x(3)
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        if barrier: U.barrier()                
    if u_ver == 2:
        if barrier: U.barrier()
        # 1: 1 -> 4
        if 1 <= r - trnc_lv:
            #U.swap(0, 2)
            U.cx(0, 2)
            U.cx(2, 0)
            U.cx(0, 2)
        if barrier: U.barrier()        
        # 2: 4 -> 16
        if 2 <= r - trnc_lv:
            U.x( 2 )
            U.cx( 2 , 0 )
            U.cx( 2 , 4 )
            U.x( 2 )
        if barrier: U.barrier()
        # 3: 16 -> 29
        if 3 <= r - trnc_lv:
            U.cx( 0 , 2 )
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
        if barrier: U.barrier()
        # 4: 29 -> 11
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
            U.x( 2 )
        if barrier: U.barrier()
        # 5: 11 -> 9
        if 5 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 4] , 2 )
            U.x( 4 )
            U.x( 1 )
        if barrier: U.barrier()
        # 6: 9 -> 1
        if 6 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 3 )
            U.x( 4 )
            #
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 3] , 2 )
            U.x( 3 )
            U.x( 1 )
        if barrier: U.barrier()
    return U
