######### Modular Exponentiation Operators (MEO's) ######### 

# N=33 a=7 r=10 m=6 => U32, U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U32_N33_a7(U, u_ver, trnc_lv,  barrier=False):
    """U32 for N=33 a=7 r=10."""
    a = 7
    r = 10
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N33_a7(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U32 same as U2        
        # cycle-1 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        # 2: 16 -> 25
        if barrier: U.barrier()
        U.cx(0, 3)
        U.cx(0, 4)
        # 3: 25 -> 4
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        # 4: 4 -> 31
        if barrier: U.barrier()
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 5: 31 -> 1
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        # cycle-2 7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 6: 7 -> 13
        if barrier: U.barrier()
        # automatic
        # 7: 13 -> 10
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 4 )
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.x( 4 )
        # 8: 10 -> 28
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.x( 0 )
        # 9: 28 -> 19
        if barrier: U.barrier()
        # automatic
        # 10: 19 -> 7
        if barrier: U.barrier()
        # automatic
        if barrier: U.barrier()
    elif u_ver == 2:
        # U32 same as U2        
        # cycle-1 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.swap(0, 4)
        # 2: 16 -> 25
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx(0, 3)
            U.cx(0, 4)
        # 3: 25 -> 4
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 2)
            U.x(3)
            U.cx(2, 0)
        # 4: 4 -> 31
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx(0, 2, 1)
            U.ccx(0, 2, 3)
            U.ccx(0, 2, 4)
        # 5: 31 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 1)
            U.x(3)
        # cycle-2 7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 6: 7 -> 13
        if barrier: U.barrier()
        if 6 <= r - trnc_lv: pass
        # automatic
        # 7: 13 -> 10
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 4 )
            U.ccx( 1 , 4 , 0 )
            U.ccx( 1 , 4 , 2 )
            U.ccx( 1 , 4 , 3 )
            U.x( 4 )
        # 8: 10 -> 28
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 2, 3, 4] , 0 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.x( 0 )
        # 9: 28 -> 19
        if barrier: U.barrier()
        if 9 <= r - trnc_lv: pass
        # automatic
        # 10: 19 -> 7
        if barrier: U.barrier()
        if 10 <= r - trnc_lv: pass
        # automatic
        if barrier: U.barrier()
    return U

def U16_N33_a7(U, u_ver, trnc_lv,  barrier=False):
    """U16 for N=33 a=7 r=10."""
    a = 7
    r = 10
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N33_a7(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U16
        # cycle-1 1 -> 4 -> 16 -> 31 -> 25 -> 1
        # 1: 1 -> 4
        if barrier: U.barrier()
        U.swap(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        # 3: 16 -> 31
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        # 4: 31 -> 25
        if barrier: U.barrier()
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 3)        
        U.x(1)
        # 5: 25 -> 1
        if barrier: U.barrier()
        U.x(2)
        U.x(3)
        U.mct([0,2, 3], 1)
        U.mct([0,2, 3], 4)        
        U.x(2)
        U.x(3)
        # cycle-2 7 -> 28 -> 13 -> 19 -> 10 -> 7
        # 6: 7 -> 28
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 0 )
        # 7: 28 -> 13
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 4 )
        # 8: 13 -> 19
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        # 9: 19 -> 10
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        # 10: 10 -> 7
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U16
        # cycle-1 1 -> 4 -> 16 -> 31 -> 25 -> 1
        # 1: 1 -> 4
        if barrier: U.barrier()
        if 1 <= r - trnc_lv: 
            U.swap(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.swap(0, 4)
        # 3: 16 -> 31
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(0, 4)
        # 4: 31 -> 25
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(1)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 3)        
            U.x(1)
        # 5: 25 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(2)
            U.x(3)
            U.mct([0,2, 3], 1)
            U.mct([0,2, 3], 4)        
            U.x(2)
            U.x(3)
        # cycle-2 7 -> 28 -> 13 -> 19 -> 10 -> 7
        # 6: 7 -> 28
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 3 )
            U.x( 0 )
        # 7: 28 -> 13
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 3 )
            U.x( 4 )
        # 8: 13 -> 19
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 1 , 3 , 0 )
            U.ccx( 1 , 3 , 2 )
            U.x( 3 )
        # 9: 19 -> 10
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 4 )
            U.x( 0 )
        # 10: 10 -> 7
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.x( 3 )
        if barrier: U.barrier()
    return U

def U8_N33_a7(U, u_ver, trnc_lv,  barrier=False): #
    """U8 for N=33 a=7 r=10."""    
    a = 7
    r = 10
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N33_a7(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U8
        # cycle-1 1 -> 31 -> 4 -> 25 -> 16 -> 1
        # 1: 1 -> 31
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        # 2: 31 -> 4
        if barrier: U.barrier()
        U.x(4)
        U.cswap(4, 0, 2)
        U.x(4)
        # 3: 4 -> 25
        if barrier: U.barrier()
        U.x(1)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)        
        U.x(1)
        # 4: 25 -> 16
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 1)
        U.ccx(0, 3, 2)        
        U.x(3)
        #
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        # 5: 16 -> 1
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 4)
        U.x(3)
        # cycle-2 7 -> 19 -> 28 -> 10 -> 13 -> 7
        # 6: 7 -> 19
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        # 7: 19 -> 28
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 0 )
        # 8: 28 -> 10
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        # 9: 10 -> 13
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 3 )
        #
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        # 10: 13-> 7
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U8
        # cycle-1 1 -> 31 -> 4 -> 25 -> 16 -> 1
        # 1: 1 -> 31
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(0, 4)
        # 2: 31 -> 4
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(4)
            U.cswap(4, 0, 2)
            U.x(4)
        # 3: 4 -> 25
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(1)
            U.ccx(0, 1, 3)
            U.ccx(0, 1, 4)        
            U.x(1)
        # 4: 25 -> 16
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 4)
            U.ccx(0, 3, 1)
            U.ccx(0, 3, 2)        
            U.x(3)
            #
            U.x(3)
            U.ccx(4, 3, 0)
            U.x(3)
        # 5: 16 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 4)
            U.x(3)
        # cycle-2 7 -> 19 -> 28 -> 10 -> 13 -> 7
        # 6: 7 -> 19
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 1 , 3 , 0 )
            U.ccx( 1 , 3 , 2 )
            U.x( 3 )
        # 7: 19 -> 28
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 3 )
            U.x( 0 )
        # 8: 28 -> 10
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 4 )
            U.x( 0 )
        # 9: 10 -> 13
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 3 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 4 )
            U.x( 1 )
        # 10: 13-> 7
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.x( 3 )
        if barrier: U.barrier()
    return U

def U4_N33_a7(U, u_ver, trnc_lv,  barrier=False):
    """U4 for N=33 a=7 r=10."""        
    a = 7
    r = 10
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N33_a7(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U4
        # cycle-1 1 -> 25 -> 31 -> 16 -> 4 -> 1
        # 1: -> 25
        if barrier: U.barrier()
        U.cx(0, 3)
        U.cx(0, 4)
        # 2: 25 -> 31
        if barrier: U.barrier()
        U.x(4)
        U.ccx(0, 4, 1)
        U.ccx(0, 4, 2)
        U.ccx(0, 4, 3)        
        U.x(4)
        #
        U.ccx(0, 1, 4)
        # 3: 31 -> 16
        if barrier: U.barrier()
        U.cswap(0, 3, 4)
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        # 4: 16 -> 4
        if barrier: U.barrier()
        U.x(3)
        U.mct([0, 3, 4], 2)
        U.x(3)
        #
        U.x(1)
        U.ccx(1, 2, 0)
        U.ccx(1, 2, 4)        
        U.x(1)
        # 5: 4 -> 1
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 2)
        U.ccx(0, 3, 4)        
        U.x(3)
        # cycle-2 7 -> 10 -> 19 -> 13 -> 28 -> 7
        # 6: 7 -> 10
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        # 7: 10 -> 19
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        # 8: 19 -> 13
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        #
        U.x( 1 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        # 9: 13 -> 28
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        # 10: 28 -> 7
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 3 )
        #
        U.x( 3 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U4
        # cycle-1 1 -> 25 -> 31 -> 16 -> 4 -> 1
        # 1: -> 25
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 3)
            U.cx(0, 4)
        # 2: 25 -> 31
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(4)
            U.ccx(0, 4, 1)
            U.ccx(0, 4, 2)
            U.ccx(0, 4, 3)        
            U.x(4)
            #
            U.ccx(0, 1, 4)
        # 3: 31 -> 16
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.cswap(0, 3, 4)
            U.x(3)
            U.ccx(4, 3, 0)
            U.x(3)
        # 4: 16 -> 4
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(3)
            U.mct([0, 3, 4], 2)
            U.x(3)
            #
            U.x(1)
            U.ccx(1, 2, 0)
            U.ccx(1, 2, 4)        
            U.x(1)
        # 5: 4 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 2)
            U.ccx(0, 3, 4)        
            U.x(3)
        # cycle-2 7 -> 10 -> 19 -> 13 -> 28 -> 7
        # 6: 7 -> 10
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 4 )
            U.x( 0 )
        # 7: 10 -> 19
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 1 , 3 , 0 )
            U.ccx( 1 , 3 , 2 )
            U.x( 3 )
        # 8: 19 -> 13
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2] , 4 )
            U.x( 1 )
        # 9: 13 -> 28
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 1 )
        # 10: 28 -> 7
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 3 )
            #
            U.x( 3 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.x( 3 )
        if barrier: U.barrier()
    return U

def U2_N33_a7(U, u_ver, trnc_lv,  barrier=False):
    """U2 for N=33 a=7 r=10."""        
    a = 7
    r = 10
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N33_a7(U, u_ver, trnc_lv,  barrier)
    if u_ver == 1: # 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # cycle-1 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        # 2: 16 -> 25
        if barrier: U.barrier()
        U.cx(0, 3)
        U.cx(0, 4)
        # 3: 25 -> 4
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        # 4: 4 -> 31
        if barrier: U.barrier()
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 5: 31 -> 1
        if barrier: U.barrier()
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        # cycle-2 7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 6: 7 -> 13
        if barrier: U.barrier()
        # automatic
        # 7: 13 -> 10
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 4 )
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.x( 4 )
        # 8: 10 -> 28
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.x( 0 )
        # 9: 28 -> 19
        if barrier: U.barrier()
        # automatic
        # 10: 19 -> 7
        if barrier: U.barrier()
        # automatic
        if barrier: U.barrier()
    if u_ver == 2:
        # cycle-1 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.swap(0, 4)
        # 2: 16 -> 25
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx(0, 3)
            U.cx(0, 4)
        # 3: 25 -> 4
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 2)
            U.x(3)
            U.cx(2, 0)
        # 4: 4 -> 31
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx(0, 2, 1)
            U.ccx(0, 2, 3)
            U.ccx(0, 2, 4)
        # 5: 31 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 1)
            U.x(3)
        # cycle-2 7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 6: 7 -> 13
        if barrier: U.barrier()
        if 6 <= r - trnc_lv: pass
        # automatic
        # 7: 13 -> 10
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 4 )
            U.ccx( 1 , 4 , 0 )
            U.ccx( 1 , 4 , 2 )
            U.ccx( 1 , 4 , 3 )
            U.x( 4 )
        # 8: 10 -> 28
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 2, 3, 4] , 0 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.x( 0 )
        # 9: 28 -> 19
        if barrier: U.barrier()
        if 9 <= r - trnc_lv: pass
        # automatic
        # 10: 19 -> 7
        if barrier: U.barrier()
        if 10 <= r - trnc_lv: pass
        # automatic
        if barrier: U.barrier()
    return U

def U1_N33_a7(U, u_ver, trnc_lv,  barrier=False):
    """U1 Modular Exponentiation Operator for N=33 a=7 r=10."""        
    a = 7
    r = 10
    if u_ver == 0 or u_ver == 1:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1 -> 7
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        if barrier: U.barrier()
        # 7 -> 16
        U.x( 1 )
        U.cx( 1 , 0 )
        U.cx( 1 , 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 16 -> 13
        U.x( 1 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 13 -> 25
        U.x( 2 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.x( 2 )
        if barrier: U.barrier()
        # 25 -> 10
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.ccx( 1 , 3 , 4 )
        #if barrier: U.barrier()
        U.ccx( 2 , 4 , 0 )
        U.ccx( 2 , 4 , 1 )
        U.ccx( 2 , 4 , 3 )
        if barrier: U.barrier()
        # 10 -> 4
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 4 -> 28
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 28 -> 31
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        if barrier: U.barrier()
        # 31 -> 19
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # 19 -> 1
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1: 1 -> 7
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
        # 2: 7 -> 16
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 1 )
            U.cx( 1 , 0 )
            U.cx( 1 , 4 )
            U.x( 1 )
        # 3: 16 -> 13
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 1 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.x( 1 )
        # 4: 13 -> 25
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 4 )
            U.x( 2 )
        # 5: 25 -> 10
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx( 1 , 3 , 0 )
            U.ccx( 1 , 3 , 2 )
            U.ccx( 1 , 3 , 4 )
            #
            U.ccx( 2 , 4 , 0 )
            U.ccx( 2 , 4 , 1 )
            U.ccx( 2 , 4 , 3 )
        # 6: 10 -> 4
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 4 )
            U.x( 1 )
            U.x( 0 )
        # 7: 4 -> 28
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 1 )
        # 8: 28 -> 31
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
        # 9: 31 -> 19
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 4 )
            U.x( 3 )
            U.x( 2 )
        # 10: 19 -> 1
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 1 )
            #
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 3 )
            U.x( 1 )
        if barrier: U.barrier()
    return U

