######### Modular Exponentiation Operators (MEO's) ######### 

# N=247 a=2 r=36 m=8 => U128, U64, U32, U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U512_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """ U512 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 512
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U8 cycle-1
        # [1, 9, 81, 235, 139, 16, 144, 61, 55]
        # 1: 1 -> 9
        if barrier: U.barrier()
        U.cx(0, 3) # by hand
        # 2: 9 -> 81
        if barrier: U.barrier()
        U.x( 3 )
        U.cx( 3 , 4 )
        U.cx( 3 , 6 )
        U.x( 3 )
        # 3: 81 -> 235
        if barrier: U.barrier()
        U.ccx( 3 , 6 , 1 )
        U.ccx( 3 , 6 , 4 )
        U.ccx( 3 , 6 , 5 )
        U.ccx( 3 , 6 , 7 )
        # 4: 235 -> 139
        if barrier: U.barrier()
        U.x( 6 )
        U.ccx( 1 , 6 , 3 )
        U.ccx( 1 , 6 , 4 )
        U.ccx( 1 , 6 , 5 )
        U.x( 6 )
        # 5: 139 -> 16
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 3 , 7 , 0 )
        U.ccx( 3 , 7 , 1 )
        U.ccx( 3 , 7 , 6 )
        U.x( 3 )
        #
        U.x( 0 )
        U.cx( 0 , 7 )
        U.x( 0 )
        # 6: 16 -> 144
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        U.x( 0 )
        # 7: 144 -> 61
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.mct( [0, 3, 6, 7] , 1 )
        U.mct( [0, 3, 6, 7] , 2 )
        U.mct( [0, 3, 6, 7] , 4 )
        U.mct( [0, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 3 )
        #
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        # 8: 61 -> 55
        if barrier: U.barrier()
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 6 )
        #
        U.mct( [0, 1, 2] , 7 )
        # 9: 55 -> 1
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        # cycle-2
        # [2, 18, 162, 223, 31, 32, 41, 122, 110]
        # 10: 2 -> 18
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 4 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        # 11: 18 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        # 12: 162 -> 223
        if barrier: U.barrier()
        U.x( 5 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.x( 5 )
        # 13: 223 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [0, 1, 6, 7] , 2 )
        U.mct( [0, 1, 6, 7] , 3 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 7 )
        #
        U.x( 7 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 7 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6] , 0 )
        U.mct( [1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 14: 31 -> 32
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 15: 32 -> 41
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 7] , 0 )
        U.mct( [1, 2, 4, 5, 7] , 3 )
        U.mct( [1, 2, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 16: 41 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 4, 5] , 0 )
        U.mct( [2, 4, 5] , 1 )
        U.mct( [2, 4, 5] , 3 )
        U.x( 2 )
        # 17: 122 -> 110
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.x( 4 )
        U.x( 0 )
        # 18: 110 -> 2
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6, 7] , 1 )
        U.mct( [0, 5, 6, 7] , 2 )
        U.mct( [0, 5, 6, 7] , 3 )
        U.mct( [0, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # cycle-3
        # [4, 36, 77, 199, 62, 64, 82, 244, 220]
        # 19: 4 -> 36
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 20: 36 -> 77
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.mct( [1, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        # 21: 77 -> 199
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.mct( [0, 4, 5, 6, 7] , 1 )
        U.mct( [0, 4, 5, 6, 7] , 2 )
        U.mct( [0, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        # 22: 199 -> 62
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 0 )
        # 23: 62 -> 64
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 2 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.mct( [0, 4, 5, 7] , 6 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6] , 4 )
        U.mct( [0, 1, 2, 6] , 5 )
        U.mct( [0, 1, 2, 6] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 24: 64 -> 82
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 1, 5, 6] , 2 )
        U.mct( [0, 1, 5, 6] , 3 )
        U.mct( [0, 1, 5, 6] , 4 )
        U.mct( [0, 1, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        # 25: 82 -> 244
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 7 )
        U.x( 3 )
        U.x( 1 )
        # 26: 244 -> 220
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.mct( [1, 2, 3, 4, 7] , 5 )
        U.mct( [1, 2, 3, 4, 7] , 6 )
        U.x( 1 )
        # 27: 220 -> 4
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # cycle-4
        # [8, 72, 154, 151, 124, 128, 164, 241, 193]
        # 28: 8 -> 72
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 29: 72 -> 154
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6, 7] , 3 )
        U.mct( [0, 1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 30: 154 -> 151
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        # 31: 151 -> 124
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 1 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 32: 124 -> 128
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5, 7] , 1 )
        U.mct( [0, 2, 4, 5, 7] , 3 )
        U.mct( [0, 2, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        # 33: 128 -> 164
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 34: 164 -> 241
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [0, 3, 5, 7] , 1 )
        U.mct( [0, 3, 5, 7] , 2 )
        U.mct( [0, 3, 5, 7] , 4 )
        U.mct( [0, 3, 5, 7] , 6 )
        U.x( 3 )
        # 35: 241 -> 193
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 3 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.mct( [0, 1, 2, 3, 4, 6] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 36: 193 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.mct( [0, 1, 2, 3, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U8 cycle-1
        # [1, 9, 81, 235, 139, 16, 144, 61, 55]
        # 1: 1 -> 9
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 3) # by hand
        # 2: 9 -> 81
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 3 )
            U.cx( 3 , 4 )
            U.cx( 3 , 6 )
            U.x( 3 )
        # 3: 81 -> 235
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 3 , 6 , 1 )
            U.ccx( 3 , 6 , 4 )
            U.ccx( 3 , 6 , 5 )
            U.ccx( 3 , 6 , 7 )
        # 4: 235 -> 139
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 6 )
            U.ccx( 1 , 6 , 3 )
            U.ccx( 1 , 6 , 4 )
            U.ccx( 1 , 6 , 5 )
            U.x( 6 )
        # 5: 139 -> 16
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 3 , 7 , 0 )
            U.ccx( 3 , 7 , 1 )
            U.ccx( 3 , 7 , 6 )
            U.x( 3 )
            #
            U.x( 0 )
            U.cx( 0 , 7 )
            U.x( 0 )
        # 6: 16 -> 144
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 7 , 4 )
            U.ccx( 0 , 7 , 6 )
            U.x( 0 )
        # 7: 144 -> 61
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.mct( [0, 3, 6, 7] , 1 )
            U.mct( [0, 3, 6, 7] , 2 )
            U.mct( [0, 3, 6, 7] , 4 )
            U.mct( [0, 3, 6, 7] , 5 )
            U.x( 6 )
            U.x( 3 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
        # 8: 61 -> 55
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.mct( [0, 2, 7] , 1 )
            U.mct( [0, 2, 7] , 3 )
            U.mct( [0, 2, 7] , 4 )
            U.mct( [0, 2, 7] , 6 )
            #
            U.mct( [0, 1, 2] , 7 )
        # 9: 55 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
        # cycle-2
        # [2, 18, 162, 223, 31, 32, 41, 122, 110]
        # 10: 2 -> 18
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 4 )
            U.ccx( 0 , 1 , 7 )
            U.x( 0 )
        # 11: 18 -> 162
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 7 )
            U.x( 4 )
            U.x( 0 )
        # 12: 162 -> 223
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 5 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.x( 5 )
        # 13: 223 -> 31
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 7 )
            U.mct( [0, 1, 6, 7] , 2 )
            U.mct( [0, 1, 6, 7] , 3 )
            U.mct( [0, 1, 6, 7] , 4 )
            U.mct( [0, 1, 6, 7] , 5 )
            U.x( 7 )
            #
            U.x( 7 )
            U.mct( [0, 1, 2, 3, 7] , 6 )
            U.x( 7 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 6] , 0 )
            U.mct( [1, 2, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 14: 31 -> 32
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 15: 32 -> 41
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5, 7] , 0 )
            U.mct( [1, 2, 4, 5, 7] , 3 )
            U.mct( [1, 2, 4, 5, 7] , 6 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 16: 41 -> 122
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 4, 5] , 0 )
            U.mct( [2, 4, 5] , 1 )
            U.mct( [2, 4, 5] , 3 )
            U.x( 2 )
        # 17: 122 -> 110
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
            U.x( 4 )
            U.x( 0 )
        # 18: 110 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 5, 6, 7] , 1 )
            U.mct( [0, 5, 6, 7] , 2 )
            U.mct( [0, 5, 6, 7] , 3 )
            U.mct( [0, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # cycle-3
        # [4, 36, 77, 199, 62, 64, 82, 244, 220]
        # 19: 4 -> 36
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 20: 36 -> 77
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5] , 0 )
            U.mct( [1, 2, 4, 5] , 3 )
            U.mct( [1, 2, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
        # 21: 77 -> 199
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.mct( [0, 4, 5, 6, 7] , 1 )
            U.mct( [0, 4, 5, 6, 7] , 2 )
            U.mct( [0, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
        # 22: 199 -> 62
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 0 )
        # 23: 62 -> 64
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 4, 5, 7] , 1 )
            U.mct( [0, 4, 5, 7] , 2 )
            U.mct( [0, 4, 5, 7] , 3 )
            U.mct( [0, 4, 5, 7] , 6 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 6] , 4 )
            U.mct( [0, 1, 2, 6] , 5 )
            U.mct( [0, 1, 2, 6] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 24: 64 -> 82
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 1, 5, 6] , 2 )
            U.mct( [0, 1, 5, 6] , 3 )
            U.mct( [0, 1, 5, 6] , 4 )
            U.mct( [0, 1, 5, 6] , 7 )
            U.x( 5 )
            U.x( 0 )
        # 25: 82 -> 244
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 3, 4, 5] , 0 )
            U.mct( [1, 3, 4, 5] , 2 )
            U.mct( [1, 3, 4, 5] , 7 )
            U.x( 3 )
            U.x( 1 )
        # 26: 244 -> 220
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 7] , 0 )
            U.mct( [1, 2, 3, 4, 7] , 5 )
            U.mct( [1, 2, 3, 4, 7] , 6 )
            U.x( 1 )
        # 27: 220 -> 4
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4, 5, 6, 7] , 2 )
            U.mct( [0, 1, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # cycle-4
        # [8, 72, 154, 151, 124, 128, 164, 241, 193]
        # 28: 8 -> 72
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 29: 72 -> 154
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5, 6, 7] , 3 )
            U.mct( [0, 1, 2, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 30: 154 -> 151
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 1, 4, 5, 6, 7] , 2 )
            U.mct( [0, 1, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
        # 31: 151 -> 124
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6, 7] , 0 )
            U.mct( [1, 2, 3, 6, 7] , 4 )
            U.mct( [1, 2, 3, 6, 7] , 5 )
            U.x( 6 )
            U.x( 1 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 32: 124 -> 128
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 4, 5, 7] , 1 )
            U.mct( [0, 2, 4, 5, 7] , 3 )
            U.mct( [0, 2, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
        # 33: 128 -> 164
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.mct( [1, 2, 3, 4, 5] , 7 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 34: 164 -> 241
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 3, 5, 7] , 1 )
            U.mct( [0, 3, 5, 7] , 2 )
            U.mct( [0, 3, 5, 7] , 4 )
            U.mct( [0, 3, 5, 7] , 6 )
            U.x( 3 )
        # 35: 241 -> 193
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 7 )
            U.x( 3 )
            U.mct( [0, 3, 5, 6, 7] , 1 )
            U.mct( [0, 3, 5, 6, 7] , 2 )
            U.mct( [0, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 3 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.mct( [0, 1, 2, 3, 4, 6] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 36: 193 -> 8
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 5, 6, 7] , 0 )
            U.mct( [1, 2, 5, 6, 7] , 3 )
            U.mct( [1, 2, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.mct( [0, 1, 2, 3, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U256_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """ U256 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 256
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U4 cycle-1
        # [1, 16, 9, 144, 81, 61, 235, 55, 139]
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.cx(0, 4) # by hand
        U.cx(4, 0)
        # 2: 16 -> 9
        if barrier: U.barrier()
        U.cx( 0 , 3 )
        U.cx( 0 , 4 )
        # 3: 9 -> 144
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 3 , 7 )
        U.x( 0 )
        #
        U.x( 0 )
        U.ccx( 0 , 7 , 3 )
        U.x( 0 )
        # 4: 144 -> 81
        if barrier: U.barrier()
        U.ccx( 0 , 7 , 3 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        #
        U.x( 3 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        # 5: 81 -> 61
        if barrier: U.barrier()
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        # 6: 61 -> 235
        if barrier: U.barrier()
        U.mct( [0, 5, 7] , 1 )
        U.mct( [0, 5, 7] , 2 )
        U.mct( [0, 5, 7] , 3 )
        U.mct( [0, 5, 7] , 4 )
        U.mct( [0, 5, 7] , 6 )
        # 7: 235 -> 55
        if barrier: U.barrier()
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.ccx( 1 , 4 , 6 )
        # 8: 55 -> 139
        if barrier: U.barrier()
        U.x( 5 )
        U.ccx( 1 , 5 , 0 )
        U.ccx( 1 , 5 , 2 )
        U.ccx( 1 , 5 , 3 )
        U.ccx( 1 , 5 , 4 )
        U.ccx( 1 , 5 , 7 )
        U.x( 5 )
        # 9: 139 -> 1
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # cycle-2
        # [2, 32, 18, 41, 162, 122, 223, 110, 31]
        # 10: 2 -> 32
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [3, 4, 6, 7] , 0 )
        U.mct( [3, 4, 6, 7] , 1 )
        U.mct( [3, 4, 6, 7] , 2 )
        U.mct( [3, 4, 6, 7] , 5 )
        U.x( 6 )
        #
        U.x( 0 )
        U.ccx( 0 , 5 , 3 )
        U.ccx( 0 , 5 , 4 )
        U.ccx( 0 , 5 , 7 )
        U.x( 0 )
        # 11: 32 -> 18
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.x( 0 )
        #
        U.x( 0 )
        U.ccx( 0 , 1 , 5 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        # 12: 18 -> 41
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.x( 2 )
        U.x( 1 )
        # 13: 41 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 3 )
        U.x( 4 )
        U.x( 0 )
        # 14: 162 -> 122
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 0 )
        # 15: 122 -> 223
        if barrier: U.barrier()
        U.mct( [1, 3, 4, 7] , 0 )
        U.mct( [1, 3, 4, 7] , 2 )
        U.mct( [1, 3, 4, 7] , 5 )
        U.mct( [1, 3, 4, 7] , 6 )
        # 16: 223 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 3 )
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 6 )
        U.ccx( 0 , 2 , 7 )
        U.x( 0 )
        # 17: 110 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        #
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 2, 3, 5, 7] , 1 )
        U.mct( [0, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        # 18: 31 -> 2
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 19: 4 -> 64
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6] , 1 )
        U.mct( [0, 5, 6] , 2 )
        U.mct( [0, 5, 6] , 3 )
        U.mct( [0, 5, 6] , 4 )
        U.mct( [0, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        # 20: 64 -> 36
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 5 )
        U.mct( [0, 2, 7] , 6 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 21: 36 -> 82
        if barrier: U.barrier()
        # automatic
        # 22: 82 -> 77
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [2, 3, 5, 6] , 0 )
        U.mct( [2, 3, 5, 6] , 1 )
        U.mct( [2, 3, 5, 6] , 4 )
        U.mct( [2, 3, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        # 23: 77 -> 244
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 5, 6] , 1 )
        U.mct( [0, 2, 5, 6] , 3 )
        U.mct( [0, 2, 5, 6] , 4 )
        U.mct( [0, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 24: 244 -> 199
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        # 25: 199 -> 220
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5] , 1 )
        U.mct( [0, 2, 4, 5] , 3 )
        U.mct( [0, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 0 )
        # 26: 220 -> 62
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 6 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        # 27: 62 -> 4
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6, 7] , 4 )
        U.mct( [0, 1, 2, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 28: 8 -> 128
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 29: 128 -> 72
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 30: 72 -> 164
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 5 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.mct( [0, 1, 2, 4, 7] , 5 )
        U.mct( [0, 1, 2, 4, 7] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 31: 164 -> 154
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.mct( [0, 1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        # 32: 154 -> 241
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 33: 241 -> 151
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 6] , 1 )
        U.mct( [0, 2, 3, 4, 6] , 5 )
        U.mct( [0, 2, 3, 4, 6] , 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 3, 4, 5] , 2 )
        U.x( 5 )
        U.x( 3 )
        # 34: 151 -> 193
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.mct( [0, 3, 4, 5, 6, 7] , 1 )
        U.mct( [0, 3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5, 7] , 3 )
        U.mct( [0, 1, 2, 5, 7] , 4 )
        U.mct( [0, 1, 2, 5, 7] , 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        # 35: 193 -> 124
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [1, 2, 4, 5, 6, 7] , 0 )
        U.mct( [1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5, 6] , 1 )
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 36: 124 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 6] , 2 )
        U.mct( [0, 1, 3, 6] , 4 )
        U.mct( [0, 1, 3, 6] , 5 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle-1
        # [1, 16, 9, 144, 81, 61, 235, 55, 139]
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 4) # by hand
            U.cx(4, 0)
        # 2: 16 -> 9
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
        # 3: 9 -> 144
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 3 , 7 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 7 , 3 )
            U.x( 0 )
        # 4: 144 -> 81
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx( 0 , 7 , 3 )
            U.ccx( 0 , 7 , 4 )
            U.ccx( 0 , 7 , 6 )
            #
            U.x( 3 )
            U.ccx( 0 , 3 , 7 )
            U.x( 3 )
        # 5: 81 -> 61
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
        # 6: 61 -> 235
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.mct( [0, 5, 7] , 1 )
            U.mct( [0, 5, 7] , 2 )
            U.mct( [0, 5, 7] , 3 )
            U.mct( [0, 5, 7] , 4 )
            U.mct( [0, 5, 7] , 6 )
        # 7: 235 -> 55
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.ccx( 1 , 4 , 0 )
            U.ccx( 1 , 4 , 2 )
            U.ccx( 1 , 4 , 3 )
            U.ccx( 1 , 4 , 6 )
        # 8: 55 -> 139
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 5 )
            U.ccx( 1 , 5 , 0 )
            U.ccx( 1 , 5 , 2 )
            U.ccx( 1 , 5 , 3 )
            U.ccx( 1 , 5 , 4 )
            U.ccx( 1 , 5 , 7 )
            U.x( 5 )
        # 9: 139 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6, 7] , 0 )
            U.mct( [2, 4, 5, 6, 7] , 1 )
            U.mct( [2, 4, 5, 6, 7] , 3 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # cycle-2
        # [2, 32, 18, 41, 162, 122, 223, 110, 31]
        # 10: 2 -> 32
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [3, 4, 6, 7] , 0 )
            U.mct( [3, 4, 6, 7] , 1 )
            U.mct( [3, 4, 6, 7] , 2 )
            U.mct( [3, 4, 6, 7] , 5 )
            U.x( 6 )
            #
            U.x( 0 )
            U.ccx( 0 , 5 , 3 )
            U.ccx( 0 , 5 , 4 )
            U.ccx( 0 , 5 , 7 )
            U.x( 0 )
        # 11: 32 -> 18
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 4, 5, 7] , 1 )
            U.mct( [0, 4, 5, 7] , 3 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 1 , 5 )
            U.ccx( 0 , 1 , 7 )
            U.x( 0 )
        # 12: 18 -> 41
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5] , 0 )
            U.mct( [1, 2, 4, 5] , 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.x( 2 )
            U.x( 1 )
        # 13: 41 -> 162
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 3 )
            U.x( 4 )
            U.x( 0 )
        # 14: 162 -> 122
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 1, 4, 7] , 3 )
            U.mct( [0, 1, 4, 7] , 5 )
            U.mct( [0, 1, 4, 7] , 6 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 0 )
        # 15: 122 -> 223
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.mct( [1, 3, 4, 7] , 0 )
            U.mct( [1, 3, 4, 7] , 2 )
            U.mct( [1, 3, 4, 7] , 5 )
            U.mct( [1, 3, 4, 7] , 6 )
        # 16: 223 -> 110
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
            U.ccx( 0 , 2 , 4 )
            U.ccx( 0 , 2 , 6 )
            U.ccx( 0 , 2 , 7 )
            U.x( 0 )
        # 17: 110 -> 31
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 7 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6, 7] , 0 )
            U.mct( [1, 2, 3, 6, 7] , 4 )
            U.mct( [1, 2, 3, 6, 7] , 5 )
            U.x( 7 )
            U.x( 1 )
            #
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 2, 3, 5, 7] , 1 )
            U.mct( [0, 2, 3, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
        # 18: 31 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 3, 4, 5] , 0 )
            U.mct( [1, 3, 4, 5] , 2 )
            U.mct( [1, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 19: 4 -> 64
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 5, 6] , 1 )
            U.mct( [0, 5, 6] , 2 )
            U.mct( [0, 5, 6] , 3 )
            U.mct( [0, 5, 6] , 4 )
            U.mct( [0, 5, 6] , 7 )
            U.x( 5 )
            U.x( 0 )
        # 20: 64 -> 36
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 7] , 1 )
            U.mct( [0, 2, 7] , 3 )
            U.mct( [0, 2, 7] , 4 )
            U.mct( [0, 2, 7] , 5 )
            U.mct( [0, 2, 7] , 6 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 21: 36 -> 82
        if barrier: U.barrier()
        if 21 <= r - trnc_lv: pass
        # automatic
        # 22: 82 -> 77
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.mct( [2, 3, 5, 6] , 0 )
            U.mct( [2, 3, 5, 6] , 1 )
            U.mct( [2, 3, 5, 6] , 4 )
            U.mct( [2, 3, 5, 6] , 7 )
            U.x( 5 )
            U.x( 3 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
        # 23: 77 -> 244
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 2, 5, 6] , 1 )
            U.mct( [0, 2, 5, 6] , 3 )
            U.mct( [0, 2, 5, 6] , 4 )
            U.mct( [0, 2, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 24: 244 -> 199
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.x( 4 )
            U.x( 3 )
        # 25: 199 -> 220
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 2, 4, 5] , 1 )
            U.mct( [0, 2, 4, 5] , 3 )
            U.mct( [0, 2, 4, 5] , 6 )
            U.x( 5 )
            U.x( 0 )
        # 26: 220 -> 62
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [2, 5, 6, 7] , 0 )
            U.mct( [2, 5, 6, 7] , 1 )
            U.mct( [2, 5, 6, 7] , 3 )
            U.mct( [2, 5, 6, 7] , 4 )
            U.x( 6 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 0 )
        # 27: 62 -> 4
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6, 7] , 4 )
            U.mct( [0, 1, 2, 3, 6, 7] , 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5, 7] , 2 )
            U.mct( [0, 1, 3, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 28: 8 -> 128
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5, 7] , 2 )
            U.mct( [0, 1, 3, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 29: 128 -> 72
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 30: 72 -> 164
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 5 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 7] , 3 )
            U.mct( [0, 1, 2, 4, 7] , 5 )
            U.mct( [0, 1, 2, 4, 7] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 31: 164 -> 154
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 6] , 3 )
            U.mct( [0, 1, 2, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
        # 32: 154 -> 241
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 33: 241 -> 151
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3, 4, 6] , 1 )
            U.mct( [0, 2, 3, 4, 6] , 5 )
            U.mct( [0, 2, 3, 4, 6] , 7 )
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 3, 4, 5] , 2 )
            U.x( 5 )
            U.x( 3 )
        # 34: 151 -> 193
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.mct( [0, 3, 4, 5, 6, 7] , 1 )
            U.mct( [0, 3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 5, 7] , 3 )
            U.mct( [0, 1, 2, 5, 7] , 4 )
            U.mct( [0, 1, 2, 5, 7] , 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
        # 35: 193 -> 124
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.mct( [1, 2, 4, 5, 6, 7] , 0 )
            U.mct( [1, 2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 6 )
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5, 6] , 1 )
            U.x( 6 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 36: 124 -> 8
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 6] , 2 )
            U.mct( [0, 1, 3, 6] , 4 )
            U.mct( [0, 1, 3, 6] , 5 )
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U128_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """ U128 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 128
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle-1 [1, 61, 16, 235, 9, 55, 144, 139, 81]
        # 1: 1 -> 61
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 5)
        # 2: 61 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        # 3: 16 -> 235
        if barrier: U.barrier()
        U.x(4)
        U.cx(4, 7)
        U.cx(4, 6)
        U.cx(4, 3)
        U.cx(4, 1)
        U.x(4)
        if barrier: U.barrier()
        U.ccx(0, 1, 5)
        # 4: 235 -> 9
        U.mct([7, 6, 4], 5)
        U.mct([7, 6, 4], 3)
        U.mct([7, 6, 4], 2)
        U.mct([7, 6, 4], 1)
        #
        U.x(5)
        U.mct([0, 5], 7)
        U.mct([0, 5], 6)
        U.mct([0, 5], 4)
        U.x(5)
        # 5: 9 -> 55
        if barrier: U.barrier()
        U.x(3)
        U.mct([3, 2, 0], 1)
        U.x(3)
        # 6: 55 -> 144
        if barrier: U.barrier()
        U.x(5)
        U.mct([5, 4, 1], 7)
        U.mct([5, 4, 1], 3)            
        U.x(5)
        #
        U.x(0)
        U.ccx(0, 3, 1)
        U.x(0)
        #
        U.x(0)
        U.ccx(0, 7, 1)
        U.x(0)
        # 7: 144 -> 139
        if barrier: U.barrier()
        U.x(4)
        U.x(7)
        U.mct([7, 4, 1, 0], 6)
        U.mct([7, 4, 1, 0], 5)
        U.x(4)
        U.x(7)
        #
        U.x(2)
        U.x(5)
        U.mct([1, 2, 3, 5], 7)
        U.x(2)
        U.x(5)
        # 8: 139 -> 81
        if barrier: U.barrier()
        U.x(7)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 2)
        U.x(7)
        # 9: 81 -> 1
        if barrier: U.barrier()
        U.x(7)
        U.x(4)
        U.x(2)
        U.mct([7, 6, 4, 2], 5)
        U.mct([7, 6, 4, 2], 3)
        U.mct([7, 6, 4, 2], 1)
        U.mct([7, 6, 4, 2], 0)
        U.x(7)
        U.x(4)
        U.x(2)
        #
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4], 6)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        # cycle-2 [2, 122, 32, 223, 18, 110, 41, 31, 162]
        # 10: 2 -> 122
        if barrier: U.barrier()        
        U.x( 0 )
        U.mct( [0, 3] , 1 )
        U.mct( [0, 3] , 4 )
        U.mct( [0, 3] , 5 )
        U.mct( [0, 3] , 7 )
        U.x( 0 )
        # 11: 122 -> 32
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 12: 32 -> 223
        if barrier: U.barrier()
        U.x( 5 )
        U.mct( [3, 4, 5] , 0 )
        U.mct( [3, 4, 5] , 1 )
        U.mct( [3, 4, 5] , 2 )
        U.mct( [3, 4, 5] , 7 )
        U.x( 5 )
        #
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 6 )
        U.x( 4 )
        U.x( 0 )
        # 13: 223 -> 18
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        U.x( 0 )
        # 14: 18 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 0 )
        # 15: 110 -> 41
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 7] , 5 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 16: 41 -> 31
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.mct( [0, 1, 2, 4, 5] , 3 )
        U.mct( [0, 1, 2, 4, 5] , 6 )
        U.mct( [0, 1, 2, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        #
        U.x( 6 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 6 )
        # 17: 31 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 18: 162 -> 2
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 4, 5] , 1 )
        U.mct( [0, 4, 5] , 2 )
        U.mct( [0, 4, 5] , 3 )
        U.mct( [0, 4, 5] , 6 )
        U.mct( [0, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        # cycle-3
        # [8, 241, 128, 151, 72, 193, 164, 124, 154]
        # 19: 8 -> 241
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        #
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.mct( [0, 1, 2, 3, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        #
        U.x( 1 )
        U.mct( [0, 1, 4, 7] , 2 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 1 )
        # 20: 241 -> 128
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 21: 128 -> 151
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [1, 3, 4, 5, 7] , 0 )
        U.mct( [1, 3, 4, 5, 7] , 2 )
        U.x( 5 )
        U.x( 3 )
        # 22: 151 -> 72
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 4, 5, 6] , 1 )
        U.mct( [0, 4, 5, 6] , 2 )
        U.mct( [0, 4, 5, 6] , 3 )
        U.mct( [0, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        # 23: 72 -> 193
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5, 6] , 0 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 24: 193 -> 164
        if barrier: U.barrier()        
        U.x( 3 )
        U.mct( [2, 3, 5, 6] , 0 )
        U.mct( [2, 3, 5, 6] , 1 )
        U.mct( [2, 3, 5, 6] , 4 )
        U.mct( [2, 3, 5, 6] , 7 )
        U.x( 3 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 25: 164 -> 124
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 5, 6] , 1 )
        U.mct( [0, 2, 5, 6] , 3 )
        U.mct( [0, 2, 5, 6] , 4 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 1 )
        U.x( 0 )
        # 26: 124 -> 154
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 27: 154 -> 8
        if barrier: U.barrier()        
        U.x( 1 )
        U.mct( [1, 3, 7] , 0 )
        U.mct( [1, 3, 7] , 2 )
        U.mct( [1, 3, 7] , 4 )
        U.mct( [1, 3, 7] , 5 )
        U.mct( [1, 3, 7] , 6 )
        U.x( 1 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # cycle-4
        # [4, 244, 64, 199, 36, 220, 82, 62, 77]
        # 28: 4 -> 244
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6] , 3 )
        U.mct( [0, 1, 2, 4, 6] , 5 )
        U.mct( [0, 1, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 29: 244 -> 64
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 30: 64 -> 199
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 4 )
        # 31: 199 -> 36
        if barrier: U.barrier()
        # automatic
        # 32: 36 -> 220
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6] , 0 )
        U.mct( [2, 3, 4, 5, 6] , 1 )
        U.x( 5 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5] , 2 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        # 33: 220 -> 82
        if barrier: U.barrier()        
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [1, 4, 5, 6, 7] , 0 )
        U.mct( [1, 4, 5, 6, 7] , 2 )
        U.mct( [1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 7] , 4 )
        U.mct( [0, 1, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 34: 82 -> 62
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 0 )
        # 35: 62 -> 77
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 3, 5, 6, 7] , 0 )
        U.mct( [1, 3, 5, 6, 7] , 2 )
        U.mct( [1, 3, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 4 )
        U.x( 1 )
        # 36: 77 -> 4
        if barrier: U.barrier()        
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.mct( [0, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle-1 [1, 61, 16, 235, 9, 55, 144, 139, 81]
        # 1: 1 -> 61
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(0, 4)
            U.cx(0, 5)
        # 2: 61 -> 16
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.swap(0, 4)
        # 3: 16 -> 235
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(4)
            U.cx(4, 7)
            U.cx(4, 6)
            U.cx(4, 3)
            U.cx(4, 1)
            U.x(4)
            #
            U.ccx(0, 1, 5)
        # 4: 235 -> 9
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.mct([7, 6, 4], 5)
            U.mct([7, 6, 4], 3)
            U.mct([7, 6, 4], 2)
            U.mct([7, 6, 4], 1)
            #
            U.x(5)
            U.mct([0, 5], 7)
            U.mct([0, 5], 6)
            U.mct([0, 5], 4)
            U.x(5)
        # 5: 9 -> 55
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(3)
            U.mct([3, 2, 0], 1)
            U.x(3)
        # 6: 55 -> 144
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x(5)
            U.mct([5, 4, 1], 7)
            U.mct([5, 4, 1], 3)            
            U.x(5)
            #
            U.x(0)
            U.ccx(0, 3, 1)
            U.x(0)
            #
            U.x(0)
            U.ccx(0, 7, 1)
            U.x(0)
        # 7: 144 -> 139
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x(4)
            U.x(7)
            U.mct([7, 4, 1, 0], 6)
            U.mct([7, 4, 1, 0], 5)
            U.x(4)
            U.x(7)
            #
            U.x(2)
            U.x(5)
            U.mct([1, 2, 3, 5], 7)
            U.x(2)
            U.x(5)
        # 8: 139 -> 81
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x(7)
            U.ccx(7, 6, 4)
            U.ccx(7, 6, 2)
            U.x(7)
        # 9: 81 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(7)
            U.x(4)
            U.x(2)
            U.mct([7, 6, 4, 2], 5)
            U.mct([7, 6, 4, 2], 3)
            U.mct([7, 6, 4, 2], 1)
            U.mct([7, 6, 4, 2], 0)
            U.x(7)
            U.x(4)
            U.x(2)
            #
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
            U.mct([0, 1, 2, 3, 4], 6)
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
        # cycle-2 [2, 122, 32, 223, 18, 110, 41, 31, 162]
        # 10: 2 -> 122
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 3] , 1 )
            U.mct( [0, 3] , 4 )
            U.mct( [0, 3] , 5 )
            U.mct( [0, 3] , 7 )
            U.x( 0 )
        # 11: 122 -> 32
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.mct( [1, 2, 3, 4, 5] , 6 )
            U.mct( [1, 2, 3, 4, 5] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 12: 32 -> 223
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 5 )
            U.mct( [3, 4, 5] , 0 )
            U.mct( [3, 4, 5] , 1 )
            U.mct( [3, 4, 5] , 2 )
            U.mct( [3, 4, 5] , 7 )
            U.x( 5 )
            #
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 0 )
        # 13: 223 -> 18
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3] , 4 )
            U.x( 3 )
            U.x( 0 )
        # 14: 18 -> 110
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 1, 2] , 4 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 0 )
        # 15: 110 -> 41
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 7] , 5 )
            U.mct( [0, 1, 2, 3, 7] , 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 16: 41 -> 31
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.mct( [0, 1, 2, 4, 5] , 3 )
            U.mct( [0, 1, 2, 4, 5] , 6 )
            U.mct( [0, 1, 2, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            #
            U.x( 6 )
            U.mct( [0, 1, 2, 3, 6] , 4 )
            U.x( 6 )
        # 17: 31 -> 162
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 18: 162 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 4, 5] , 1 )
            U.mct( [0, 4, 5] , 2 )
            U.mct( [0, 4, 5] , 3 )
            U.mct( [0, 4, 5] , 6 )
            U.mct( [0, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
        # cycle-3
        # [8, 241, 128, 151, 72, 193, 164, 124, 154]
        # 19: 8 -> 241
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            #
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5, 6] , 4 )
            U.mct( [0, 1, 2, 3, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 4, 7] , 2 )
            U.mct( [0, 1, 4, 7] , 3 )
            U.mct( [0, 1, 4, 7] , 5 )
            U.mct( [0, 1, 4, 7] , 6 )
            U.x( 1 )
        # 20: 241 -> 128
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 6, 7] , 4 )
            U.mct( [0, 1, 6, 7] , 5 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 21: 128 -> 151
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.mct( [1, 3, 4, 5, 7] , 0 )
            U.mct( [1, 3, 4, 5, 7] , 2 )
            U.x( 5 )
            U.x( 3 )
        # 22: 151 -> 72
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            U.mct( [0, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
        # 23: 72 -> 193
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 5, 6] , 0 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 24: 193 -> 164
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [2, 3, 5, 6] , 0 )
            U.mct( [2, 3, 5, 6] , 1 )
            U.mct( [2, 3, 5, 6] , 4 )
            U.mct( [2, 3, 5, 6] , 7 )
            U.x( 3 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 25: 164 -> 124
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 2, 5, 6] , 1 )
            U.mct( [0, 2, 5, 6] , 3 )
            U.mct( [0, 2, 5, 6] , 4 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 1 )
            U.x( 0 )
        # 26: 124 -> 154
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [1, 3, 4, 5, 6, 7] , 0 )
            U.mct( [1, 3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 27: 154 -> 8
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 3, 7] , 0 )
            U.mct( [1, 3, 7] , 2 )
            U.mct( [1, 3, 7] , 4 )
            U.mct( [1, 3, 7] , 5 )
            U.mct( [1, 3, 7] , 6 )
            U.x( 1 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # cycle-4
        # [4, 244, 64, 199, 36, 220, 82, 62, 77]
        # 28: 4 -> 244
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 6] , 3 )
            U.mct( [0, 1, 2, 4, 6] , 5 )
            U.mct( [0, 1, 2, 4, 6] , 7 )
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 29: 244 -> 64
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [1, 3, 4, 5, 6, 7] , 0 )
            U.mct( [1, 3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 6] , 3 )
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5, 6] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 30: 64 -> 199
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 3 )
            U.x( 4 )
        # 31: 199 -> 36
        if barrier: U.barrier()
        if 31 <= r - trnc_lv: pass
        # automatic
        # 32: 36 -> 220
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 5 )
            U.x( 2 )
            U.mct( [2, 3, 4, 5, 6] , 0 )
            U.mct( [2, 3, 4, 5, 6] , 1 )
            U.x( 5 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5] , 2 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
        # 33: 220 -> 82
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.mct( [1, 4, 5, 6, 7] , 0 )
            U.mct( [1, 4, 5, 6, 7] , 2 )
            U.mct( [1, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5, 7] , 4 )
            U.mct( [0, 1, 2, 3, 5, 7] , 6 )
            U.x( 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 34: 82 -> 62
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [1, 2, 5, 6, 7] , 0 )
            U.mct( [1, 2, 5, 6, 7] , 3 )
            U.mct( [1, 2, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.x( 0 )
        # 35: 62 -> 77
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [1, 3, 5, 6, 7] , 0 )
            U.mct( [1, 3, 5, 6, 7] , 2 )
            U.mct( [1, 3, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
        # 36: 77 -> 4
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.mct( [0, 2, 3, 5] , 4 )
            U.mct( [0, 2, 3, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
        if barrier: U.barrier()        
    return U

def U64_N247_a2(U, u_ver, trnc_lv,  barrier=False): 
    """ U64 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 64
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U64 cycle-1
        # [1, 55, 61, 144, 16, 139, 235, 81, 9]
        # 1: 1 -> 55
        if barrier: U.barrier()
        U.cx(0, 1) # by hand
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        # 2: 55 -> 61
        if barrier: U.barrier()
        U.x( 1 )
        U.cx( 1 , 2 )
        U.cx( 1 , 3 )
        U.cx( 1 , 4 )
        U.cx( 1 , 5 )
        U.x( 1 )
        # 3: 61 -> 144
        if barrier: U.barrier()
        U.x( 2 )
        U.cx( 2 , 0 )
        U.cx( 2 , 1 )
        U.cx( 2 , 3 )
        U.cx( 2 , 4 )
        U.cx( 2 , 7 )
        U.x( 2 )
        # 4: 144 -> 16
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 5 , 2 )
        U.ccx( 0 , 5 , 3 )
        U.ccx( 0 , 5 , 4 )
        U.ccx( 0 , 5 , 7 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 5 )
        U.x( 7 )
        U.x( 0 )
        # 5: 16 -> 139
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 5, 7] , 0 )
        U.mct( [2, 5, 7] , 1 )
        U.mct( [2, 5, 7] , 3 )
        U.mct( [2, 5, 7] , 4 )
        U.x( 2 )
        #
        U.x( 2 )
        U.mct( [0, 1, 2] , 5 )
        U.x( 2 )
        # 6: 235 -> 235
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [1, 2, 5] , 0 )
        U.mct( [1, 2, 5] , 4 )
        U.mct( [1, 2, 5] , 6 )
        U.mct( [1, 2, 5] , 7 )
        U.x( 2 )
        # 7: 235 -> 81
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 3 , 6 , 0 )
        U.ccx( 3 , 6 , 1 )
        U.ccx( 3 , 6 , 2 )
        U.ccx( 3 , 6 , 4 )
        U.ccx( 3 , 6 , 5 )
        U.ccx( 3 , 6 , 7 )
        U.x( 3 )
        # 8: 81 -> 9
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 6, 7] , 0 )
        U.mct( [1, 2, 6, 7] , 3 )
        U.mct( [1, 2, 6, 7] , 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 9: 9 -> 1
        if barrier: U.barrier()        
        U.x( 7 )
        U.x( 6 )
        U.mct( [0, 1, 3, 5, 6, 7] , 2 )
        U.mct( [0, 1, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        #
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [0, 2, 4, 5, 6, 7] , 1 )
        U.mct( [0, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # U64 cycle-2
        # [2, 110, 122, 41, 32, 31, 223, 162, 18]
        # 10: 2 -> 110
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [3, 6, 7] , 0 )
        U.mct( [3, 6, 7] , 1 )
        U.mct( [3, 6, 7] , 2 )
        U.mct( [3, 6, 7] , 4 )
        U.mct( [3, 6, 7] , 5 )
        U.x( 7 )
        # 11: 110 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 5] , 1 )
        U.mct( [0, 2, 5] , 3 )
        U.mct( [0, 2, 5] , 7 )
        U.x( 2 )
        U.x( 0 )
        # 12: 122 -> 41
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 6 )
        #
        U.x( 6 )
        U.x( 2 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.x( 6 )
        U.x( 2 )
        # 13: 41 -> 32
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        #
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 7] , 4 )
        U.mct( [0, 1, 3, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 14: 32 -> 31
        if barrier: U.barrier()        
        U.x( 5 )
        U.ccx( 2 , 5 , 0 )
        U.ccx( 2 , 5 , 1 )
        U.ccx( 2 , 5 , 3 )
        U.ccx( 2 , 5 , 4 )
        U.x( 5 )
        # 15: 31 -> 223
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        #
        U.mct( [0, 1, 2, 3, 6] , 4 )
        # 16: 223 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 7] , 1 )
        U.mct( [0, 2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 17: 162 -> 18
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 4, 6, 7] , 0 )
        U.mct( [2, 4, 6, 7] , 1 )
        U.mct( [2, 4, 6, 7] , 3 )
        U.mct( [2, 4, 6, 7] , 5 )
        U.x( 2 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 18: 18 -> 2
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6, 7] , 3 )
        U.mct( [0, 1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # U64 cycle-3
        # [8, 193, 241, 164, 128, 124, 151, 154, 72]
        # 19: 8 -> 193
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 7] , 1 )
        U.mct( [0, 2, 3, 7] , 4 )
        U.mct( [0, 2, 3, 7] , 6 )
        U.x( 3 )
        U.x( 2 )
        # 20: 193 -> 241
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 6, 7] , 0 )
        U.mct( [1, 2, 4, 6, 7] , 3 )
        U.mct( [1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 21: 241 -> 164
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.x( 1 )
        U.x( 0 )
        # 22: 164 -> 128
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 6, 7] , 1 )
        U.mct( [0, 3, 6, 7] , 2 )
        U.mct( [0, 3, 6, 7] , 4 )
        U.mct( [0, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5] , 6 )
        U.mct( [0, 1, 2, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 23: 128 -> 124
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.mct( [0, 1, 3] , 5 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 24: 124 -> 151
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 6] , 0 )
        U.mct( [1, 2, 4, 5, 6] , 3 )
        U.mct( [1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.x( 5 )
        U.x( 3 )
        # 25: 151 -> 154
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 5, 6, 7] , 1 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 26: 154 -> 72
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 27: 72 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # U64 cycle-4
        # [4, 220, 244, 82, 64, 62, 199, 77, 36]
        # 28: 4 -> 220
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 4, 6, 7] , 1 )
        U.mct( [0, 4, 6, 7] , 2 )
        U.mct( [0, 4, 6, 7] , 3 )
        U.mct( [0, 4, 6, 7] , 5 )
        U.x( 0 )
        # 29: 220 -> 224
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6] , 0 )
        U.mct( [1, 2, 3, 6] , 4 )
        U.mct( [1, 2, 3, 6] , 5 )
        U.mct( [1, 2, 3, 6] , 7 )
        U.x( 3 )
        U.x( 1 )
        # 30: 224 -> 82
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 0 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.mct( [0, 1, 2, 4, 5, 7] , 6 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.mct( [0, 1, 2, 3, 4, 6] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 31: 82 -> 64
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 2 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6, 7] , 3 )
        U.mct( [0, 1, 2, 6, 7] , 4 )
        U.mct( [0, 1, 2, 6, 7] , 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 32: 64 -> 62
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        # 33: 62 -> 199
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.mct( [0, 1, 2, 3, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        #
        U.x( 6 )
        U.x( 4 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        # 34: 199 -> 77
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        # 35: 77 -> 36
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 36: 36 -> 4
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U64 cycle-1
        # [1, 55, 61, 144, 16, 139, 235, 81, 9]
        # 1: 1 -> 55
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1) # by hand
            U.cx(0, 2)
            U.cx(0, 4)
            U.cx(0, 5)
        # 2: 55 -> 61
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 1 )
            U.cx( 1 , 2 )
            U.cx( 1 , 3 )
            U.cx( 1 , 4 )
            U.cx( 1 , 5 )
            U.x( 1 )
        # 3: 61 -> 144
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 2 )
            U.cx( 2 , 0 )
            U.cx( 2 , 1 )
            U.cx( 2 , 3 )
            U.cx( 2 , 4 )
            U.cx( 2 , 7 )
            U.x( 2 )
        # 4: 144 -> 16
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 5 , 2 )
            U.ccx( 0 , 5 , 3 )
            U.ccx( 0 , 5 , 4 )
            U.ccx( 0 , 5 , 7 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 0 )
            U.ccx( 0 , 7 , 5 )
            U.x( 7 )
            U.x( 0 )
        # 5: 16 -> 139
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 5, 7] , 0 )
            U.mct( [2, 5, 7] , 1 )
            U.mct( [2, 5, 7] , 3 )
            U.mct( [2, 5, 7] , 4 )
            U.x( 2 )
            #
            U.x( 2 )
            U.mct( [0, 1, 2] , 5 )
            U.x( 2 )
        # 6: 235 -> 235
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [1, 2, 5] , 0 )
            U.mct( [1, 2, 5] , 4 )
            U.mct( [1, 2, 5] , 6 )
            U.mct( [1, 2, 5] , 7 )
            U.x( 2 )
        # 7: 235 -> 81
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 3 , 6 , 0 )
            U.ccx( 3 , 6 , 1 )
            U.ccx( 3 , 6 , 2 )
            U.ccx( 3 , 6 , 4 )
            U.ccx( 3 , 6 , 5 )
            U.ccx( 3 , 6 , 7 )
            U.x( 3 )
        # 8: 81 -> 9
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 6, 7] , 0 )
            U.mct( [1, 2, 6, 7] , 3 )
            U.mct( [1, 2, 6, 7] , 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 9: 9 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.mct( [0, 1, 3, 5, 6, 7] , 2 )
            U.mct( [0, 1, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 6 )
            #
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [0, 2, 4, 5, 6, 7] , 1 )
            U.mct( [0, 2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # U64 cycle-2
        # [2, 110, 122, 41, 32, 31, 223, 162, 18]
        # 10: 2 -> 110
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 7 )
            U.mct( [3, 6, 7] , 0 )
            U.mct( [3, 6, 7] , 1 )
            U.mct( [3, 6, 7] , 2 )
            U.mct( [3, 6, 7] , 4 )
            U.mct( [3, 6, 7] , 5 )
            U.x( 7 )
        # 11: 110 -> 122
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 5] , 1 )
            U.mct( [0, 2, 5] , 3 )
            U.mct( [0, 2, 5] , 7 )
            U.x( 2 )
            U.x( 0 )
        # 12: 122 -> 41
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [0, 1, 3, 5, 6] , 2 )
            U.mct( [0, 1, 3, 5, 6] , 4 )
            U.x( 6 )
            #
            U.x( 6 )
            U.x( 2 )
            U.mct( [0, 2, 3, 5, 6] , 1 )
            U.x( 6 )
            U.x( 2 )
        # 13: 41 -> 32
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            #
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 7] , 4 )
            U.mct( [0, 1, 3, 7] , 5 )
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 14: 32 -> 31
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 5 )
            U.ccx( 2 , 5 , 0 )
            U.ccx( 2 , 5 , 1 )
            U.ccx( 2 , 5 , 3 )
            U.ccx( 2 , 5 , 4 )
            U.x( 5 )
        # 15: 31 -> 223
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.mct( [1, 2, 3, 4, 5] , 6 )
            U.mct( [1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            #
            U.mct( [0, 1, 2, 3, 6] , 4 )
        # 16: 223 -> 162
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 7] , 1 )
            U.mct( [0, 2, 3, 4, 7] , 6 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 17: 162 -> 18
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 4, 6, 7] , 0 )
            U.mct( [2, 4, 6, 7] , 1 )
            U.mct( [2, 4, 6, 7] , 3 )
            U.mct( [2, 4, 6, 7] , 5 )
            U.x( 2 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 18: 18 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 7 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 6, 7] , 3 )
            U.mct( [0, 1, 2, 4, 6, 7] , 5 )
            U.x( 7 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3, 5, 6] , 2 )
            U.mct( [0, 1, 3, 5, 6] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # U64 cycle-3
        # [8, 193, 241, 164, 128, 124, 151, 154, 72]
        # 19: 8 -> 193
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3, 7] , 1 )
            U.mct( [0, 2, 3, 7] , 4 )
            U.mct( [0, 2, 3, 7] , 6 )
            U.x( 3 )
            U.x( 2 )
        # 20: 193 -> 241
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 6, 7] , 0 )
            U.mct( [1, 2, 4, 6, 7] , 3 )
            U.mct( [1, 2, 4, 6, 7] , 5 )
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 21: 241 -> 164
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.x( 1 )
            U.x( 0 )
        # 22: 164 -> 128
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 7 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 6, 7] , 1 )
            U.mct( [0, 3, 6, 7] , 2 )
            U.mct( [0, 3, 6, 7] , 4 )
            U.mct( [0, 3, 6, 7] , 5 )
            U.x( 7 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5] , 6 )
            U.mct( [0, 1, 2, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 23: 128 -> 124
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.mct( [0, 1, 3] , 5 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 24: 124 -> 151
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5, 6] , 0 )
            U.mct( [1, 2, 4, 5, 6] , 3 )
            U.mct( [1, 2, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.x( 5 )
            U.x( 3 )
        # 25: 151 -> 154
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3, 4, 5, 6, 7] , 1 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [1, 2, 3, 5, 7] , 0 )
            U.mct( [1, 2, 3, 5, 7] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 26: 154 -> 72
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 5, 6, 7] , 0 )
            U.mct( [1, 2, 5, 6, 7] , 3 )
            U.mct( [1, 2, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 27: 72 -> 8
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # U64 cycle-4
        # [4, 220, 244, 82, 64, 62, 199, 77, 36]
        # 28: 4 -> 220
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 4, 6, 7] , 1 )
            U.mct( [0, 4, 6, 7] , 2 )
            U.mct( [0, 4, 6, 7] , 3 )
            U.mct( [0, 4, 6, 7] , 5 )
            U.x( 0 )
        # 29: 220 -> 224
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6] , 0 )
            U.mct( [1, 2, 3, 6] , 4 )
            U.mct( [1, 2, 3, 6] , 5 )
            U.mct( [1, 2, 3, 6] , 7 )
            U.x( 3 )
            U.x( 1 )
        # 30: 224 -> 82
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 6 )
            U.x( 0 )
            U.mct( [0, 3, 5, 6, 7] , 1 )
            U.mct( [0, 3, 5, 6, 7] , 2 )
            U.mct( [0, 3, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.mct( [0, 1, 2, 4, 5, 7] , 6 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.mct( [0, 1, 2, 3, 4, 6] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 31: 82 -> 64
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 6, 7] , 3 )
            U.mct( [0, 1, 2, 6, 7] , 4 )
            U.mct( [0, 1, 2, 6, 7] , 5 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 32: 64 -> 62
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 0 )
        # 33: 62 -> 199
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 5, 6] , 4 )
            U.mct( [0, 1, 2, 3, 5, 6] , 7 )
            U.x( 5 )
            U.x( 3 )
            #
            U.x( 6 )
            U.x( 4 )
            U.mct( [0, 2, 4, 6] , 1 )
            U.mct( [0, 2, 4, 6] , 3 )
            U.mct( [0, 2, 4, 6] , 7 )
            U.x( 6 )
            U.x( 4 )
        # 34: 199 -> 77
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [0, 2, 4, 6] , 1 )
            U.mct( [0, 2, 4, 6] , 3 )
            U.mct( [0, 2, 4, 6] , 7 )
            U.x( 6 )
            U.x( 4 )
        # 35: 77 -> 36
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [0, 2, 4, 6] , 1 )
            U.mct( [0, 2, 4, 6] , 3 )
            U.mct( [0, 2, 4, 6] , 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6, 7] , 0 )
            U.mct( [2, 4, 5, 6, 7] , 1 )
            U.mct( [2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 7] , 6 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 36: 36 -> 4
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4, 5, 6, 7] , 2 )
            U.mct( [0, 1, 4, 5, 6, 7] , 3 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U


def U32_N247_a2(U, u_ver, trnc_lv,  barrier=False): 
    """U32 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U32 cycle-1
        # [1, 139, 55, 235, 61, 81, 144, 9, 16]
        # 1: 1 -> 139
        if barrier: U.barrier()
        U.cx(0, 1) # by hand
        U.cx(0, 3)
        U.cx(0, 7)
        # 2: 139 -> 55
        if barrier: U.barrier()
        U.x( 3 )
        U.cx( 3 , 1 )
        U.cx( 3 , 2 )
        U.cx( 3 , 4 )
        U.cx( 3 , 5 )
        U.x( 3 )
        # 3: 55 -> 235
        if barrier: U.barrier()
        U.ccx( 3 , 5 , 1 )
        U.ccx( 3 , 5 , 2 )
        U.ccx( 3 , 5 , 4 )
        U.ccx( 3 , 5 , 6 )
        # 4: 235 -> 61
        if barrier: U.barrier()
        U.ccx( 2 , 6 , 1 )
        U.ccx( 2 , 6 , 3 )
        U.ccx( 2 , 6 , 5 )
        #
        U.x( 1 )
        U.cx( 1 , 6 )
        U.x( 1 )
        # 5: 61 -> 81
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.ccx( 1 , 2 , 4 )
        U.ccx( 1 , 2 , 7 )
        U.x( 2 )
        U.x( 1 )
        # 6: 81 -> 144
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 4, 7] , 0 )
        U.mct( [2, 4, 7] , 1 )
        U.mct( [2, 4, 7] , 3 )
        U.mct( [2, 4, 7] , 6 )
        U.x( 2 )
        # 7: 144 -> 9
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [4, 5, 6] , 0 )
        U.mct( [4, 5, 6] , 1 )
        U.mct( [4, 5, 6] , 2 )
        U.mct( [4, 5, 6] , 3 )
        U.mct( [4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        # 8: 9 -> 16
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 6, 7] , 0 )
        U.mct( [1, 3, 6, 7] , 2 )
        U.mct( [1, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 0 )
        U.ccx( 0 , 6 , 7 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 6 )
        U.x( 7 )
        U.x( 0 )
        # 9: 16 -> 1
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # cycle-2
        # [2, 31, 110, 223, 122, 162, 41, 18, 32]
        # 10: 2 -> 31
        if barrier: U.barrier()
        U.ccx( 2 , 7 , 0 )
        U.ccx( 2 , 7 , 1 )
        U.ccx( 2 , 7 , 3 )
        U.ccx( 2 , 7 , 5 )
        U.ccx( 2 , 7 , 6 )
        #
        U.mct( [0, 1, 2, 3] , 7 )
        # 11: 31 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.x( 0 )
        # 12: 110 -> 223
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        #
        U.mct( [0, 1, 2, 3, 6] , 5 )
        # 13: 223 -> 122
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 2 )
        U.mct( [1, 2, 5, 7] , 0 )
        U.mct( [1, 2, 5, 7] , 3 )
        U.mct( [1, 2, 5, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        # 14: 122 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 3, 4] , 0 )
        U.mct( [1, 3, 4] , 2 )
        U.mct( [1, 3, 4] , 5 )
        U.x( 4 )
        U.x( 3 )
        # 15: 162 -> 41
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5] , 3 )
        U.mct( [0, 1, 2, 5] , 4 )
        U.mct( [0, 1, 2, 5] , 6 )
        U.mct( [0, 1, 2, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 16: 41 -> 18
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5, 7] , 1 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # 17: 18 -> 32
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 18: 32 -> 2
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # U32 cycle-3
        # [8, 124, 193, 151, 241, 154, 164, 72, 128]
        # 19: 8 -> 124
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [1, 4, 6, 7] , 0 )
        U.mct( [1, 4, 6, 7] , 2 )
        U.mct( [1, 4, 6, 7] , 3 )
        U.mct( [1, 4, 6, 7] , 5 )
        U.x( 6 )
        #
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 6 )
        U.mct( [0, 2, 4] , 7 )
        U.x( 0 )
        # 20: 124 -> 193
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6] , 0 )
        U.mct( [1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 21: 193 -> 151
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 5, 6, 7] , 2 )
        U.mct( [0, 1, 5, 6, 7] , 3 )
        U.mct( [0, 1, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        # 22: 151 -> 241
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 3, 4, 6] , 2 )
        U.mct( [0, 1, 3, 4, 6] , 5 )
        U.mct( [0, 1, 3, 4, 6] , 7 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5] , 3 )
        U.x( 2 )
        U.x( 1 )
        # 23: 241 -> 154
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 3, 4, 6, 7] , 0 )
        U.mct( [1, 3, 4, 6, 7] , 2 )
        U.mct( [1, 3, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.mct( [0, 2, 3, 5] , 6 )
        U.mct( [0, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 24: 154 -> 164
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 25: 164 -> 72
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 6, 7] , 0 )
        U.mct( [1, 2, 4, 6, 7] , 3 )
        U.mct( [1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        # 26: 72 -> 128
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 27: 128 -> 8
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # U32 cycle-4
        # [4, 62, 220, 199, 244, 77, 82, 36, 64]
        # 28: 4 -> 62
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 7] , 0 )
        U.mct( [1, 2, 3, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 6 )
        U.x( 0 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 6 )
        U.x( 0 )
        # 29: 62 -> 220
        if barrier: U.barrier()
        U.mct( [1, 4, 5, 6, 7] , 0 )
        U.mct( [1, 4, 5, 6, 7] , 2 )
        U.mct( [1, 4, 5, 6, 7] , 3 )
        #
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 6, 7] , 1 )
        U.mct( [0, 2, 3, 4, 6, 7] , 5 )
        U.x( 0 )
        # 30: 220 -> 199
        if barrier: U.barrier()
        U.mct( [0, 1, 4, 5, 6] , 2 )
        U.mct( [0, 1, 4, 5, 6] , 3 )
        #
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 3 )
        # 31: 199 -> 244
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 6 )
        U.x( 3 )
        U.x( 0 )
        # 32: 244-> 77
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.mct( [0, 2, 4, 7] , 1 )
        U.mct( [0, 2, 4, 7] , 3 )
        U.mct( [0, 2, 4, 7] , 5 )
        U.mct( [0, 2, 4, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        # 33: 77 -> 82
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 6, 7] , 0 )
        U.mct( [1, 2, 3, 5, 6, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.mct( [0, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        # 34: 82 -> 36
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        # 35: 36 -> 64
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.mct( [0, 2, 3, 5, 6] , 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 36: 64 -> 4
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6] , 3 )
        U.mct( [0, 1, 2, 5, 6] , 4 )
        U.mct( [0, 1, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U32 cycle-1
        # [1, 139, 55, 235, 61, 81, 144, 9, 16]
        # 1: 1 -> 139
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1) # by hand
            U.cx(0, 3)
            U.cx(0, 7)
        # 2: 139 -> 55
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 3 )
            U.cx( 3 , 1 )
            U.cx( 3 , 2 )
            U.cx( 3 , 4 )
            U.cx( 3 , 5 )
            U.x( 3 )
        # 3: 55 -> 235
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 3 , 5 , 1 )
            U.ccx( 3 , 5 , 2 )
            U.ccx( 3 , 5 , 4 )
            U.ccx( 3 , 5 , 6 )
        # 4: 235 -> 61
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx( 2 , 6 , 1 )
            U.ccx( 2 , 6 , 3 )
            U.ccx( 2 , 6 , 5 )
            #
            U.x( 1 )
            U.cx( 1 , 6 )
            U.x( 1 )
        # 5: 61 -> 81
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.ccx( 1 , 2 , 4 )
            U.ccx( 1 , 2 , 7 )
            U.x( 2 )
            U.x( 1 )
        # 6: 81 -> 144
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 4, 7] , 0 )
            U.mct( [2, 4, 7] , 1 )
            U.mct( [2, 4, 7] , 3 )
            U.mct( [2, 4, 7] , 6 )
            U.x( 2 )
        # 7: 144 -> 9
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [4, 5, 6] , 0 )
            U.mct( [4, 5, 6] , 1 )
            U.mct( [4, 5, 6] , 2 )
            U.mct( [4, 5, 6] , 3 )
            U.mct( [4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 2 )
            U.x( 1 )
        # 8: 9 -> 16
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 3, 6, 7] , 0 )
            U.mct( [1, 3, 6, 7] , 2 )
            U.mct( [1, 3, 6, 7] , 5 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 0 )
            U.ccx( 0 , 6 , 7 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 0 )
            U.ccx( 0 , 7 , 6 )
            U.x( 7 )
            U.x( 0 )
        # 9: 16 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 7] , 3 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # cycle-2
        # [2, 31, 110, 223, 122, 162, 41, 18, 32]
        # 10: 2 -> 31
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.ccx( 2 , 7 , 0 )
            U.ccx( 2 , 7 , 1 )
            U.ccx( 2 , 7 , 3 )
            U.ccx( 2 , 7 , 5 )
            U.ccx( 2 , 7 , 6 )
            #
            U.mct( [0, 1, 2, 3] , 7 )
        # 11: 31 -> 110
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.x( 0 )
        # 12: 110 -> 223
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            #
            U.mct( [0, 1, 2, 3, 6] , 5 )
        # 13: 223 -> 122
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 7 )
            U.x( 2 )
            U.mct( [1, 2, 5, 7] , 0 )
            U.mct( [1, 2, 5, 7] , 3 )
            U.mct( [1, 2, 5, 7] , 4 )
            U.x( 7 )
            U.x( 2 )
        # 14: 122 -> 162
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 3, 4] , 0 )
            U.mct( [1, 3, 4] , 2 )
            U.mct( [1, 3, 4] , 5 )
            U.x( 4 )
            U.x( 3 )
        # 15: 162 -> 41
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 5] , 3 )
            U.mct( [0, 1, 2, 5] , 4 )
            U.mct( [0, 1, 2, 5] , 6 )
            U.mct( [0, 1, 2, 5] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 16: 41 -> 18
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5, 7] , 1 )
            U.x( 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 17: 18 -> 32
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
            U.mct( [0, 1, 4] , 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 18: 32 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 5, 6, 7] , 1 )
            U.mct( [0, 3, 5, 6, 7] , 2 )
            U.mct( [0, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # U32 cycle-3
        # [8, 124, 193, 151, 241, 154, 164, 72, 128]
        # 19: 8 -> 124
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [1, 4, 6, 7] , 0 )
            U.mct( [1, 4, 6, 7] , 2 )
            U.mct( [1, 4, 6, 7] , 3 )
            U.mct( [1, 4, 6, 7] , 5 )
            U.x( 6 )
            #
            U.x( 0 )
            U.mct( [0, 2, 4] , 1 )
            U.mct( [0, 2, 4] , 6 )
            U.mct( [0, 2, 4] , 7 )
            U.x( 0 )
        # 20: 124 -> 193
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 6] , 0 )
            U.mct( [1, 2, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 21: 193 -> 151
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 1, 5, 6, 7] , 2 )
            U.mct( [0, 1, 5, 6, 7] , 3 )
            U.mct( [0, 1, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
        # 22: 151 -> 241
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [0, 1, 3, 4, 6] , 2 )
            U.mct( [0, 1, 3, 4, 6] , 5 )
            U.mct( [0, 1, 3, 4, 6] , 7 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5] , 3 )
            U.x( 2 )
            U.x( 1 )
        # 23: 241 -> 154
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 3, 4, 6, 7] , 0 )
            U.mct( [1, 3, 4, 6, 7] , 2 )
            U.mct( [1, 3, 4, 6, 7] , 5 )
            U.x( 7 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.mct( [0, 2, 3, 5] , 4 )
            U.mct( [0, 2, 3, 5] , 6 )
            U.mct( [0, 2, 3, 5] , 7 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 24: 154 -> 164
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 25: 164 -> 72
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 6, 7] , 0 )
            U.mct( [1, 2, 4, 6, 7] , 3 )
            U.mct( [1, 2, 4, 6, 7] , 5 )
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
        # 26: 72 -> 128
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 27: 128 -> 8
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 7 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 5, 6, 7] , 0 )
            U.mct( [1, 2, 5, 6, 7] , 3 )
            U.mct( [1, 2, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # U32 cycle-4
        # [4, 62, 220, 199, 244, 77, 82, 36, 64]
        # 28: 4 -> 62
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [1, 2, 3, 4, 5, 7] , 0 )
            U.mct( [1, 2, 3, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 6 )
            U.x( 0 )
            U.mct( [0, 1, 3, 5, 6] , 2 )
            U.mct( [0, 1, 3, 5, 6] , 4 )
            U.x( 6 )
            U.x( 0 )
        # 29: 62 -> 220
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.mct( [1, 4, 5, 6, 7] , 0 )
            U.mct( [1, 4, 5, 6, 7] , 2 )
            U.mct( [1, 4, 5, 6, 7] , 3 )
            #
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 6, 7] , 1 )
            U.mct( [0, 2, 3, 4, 6, 7] , 5 )
            U.x( 0 )
        # 30: 220 -> 199
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.mct( [0, 1, 4, 5, 6] , 2 )
            U.mct( [0, 1, 4, 5, 6] , 3 )
            #
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 6] , 4 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.x( 3 )
        # 31: 199 -> 244
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.mct( [0, 2, 3, 4] , 5 )
            U.mct( [0, 2, 3, 4] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 32: 244-> 77
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.mct( [0, 2, 4, 7] , 1 )
            U.mct( [0, 2, 4, 7] , 3 )
            U.mct( [0, 2, 4, 7] , 5 )
            U.mct( [0, 2, 4, 7] , 6 )
            U.x( 7 )
            U.x( 4 )
        # 33: 77 -> 82
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 6, 7] , 0 )
            U.mct( [1, 2, 3, 5, 6, 7] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.mct( [0, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
        # 34: 82 -> 36
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 7] , 0 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
        # 35: 36 -> 64
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 5, 6] , 1 )
            U.mct( [0, 2, 3, 5, 6] , 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 36: 64 -> 4
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5, 6] , 3 )
            U.mct( [0, 1, 2, 5, 6] , 4 )
            U.mct( [0, 1, 2, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U16_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """U16 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U16 cycle-1
        # [1, 81, 139, 144, 55, 9, 235, 16, 61]
        # 1: 1 -> 81
        if barrier: U.barrier()
        U.cx(0, 4) # by hand
        U.cx(0, 6)
        # 2: 81 -> 139
        if barrier: U.barrier()
        U.x( 4 )
        U.cx( 4 , 1 )
        U.cx( 4 , 3 )
        U.cx( 4 , 7 )
        U.x( 4 )
        # 3: 139 -> 144
        if barrier: U.barrier()
        U.ccx( 4 , 7 , 0 )
        U.ccx( 4 , 7 , 1 )
        U.ccx( 4 , 7 , 3 )
        U.ccx( 4 , 7 , 6 )
        # 4: 144 -> 55
        if barrier: U.barrier()
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 6 )
        U.mct( [0, 1, 4] , 7 )
        # 5: 55 -> 9
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 5 )
        U.mct( [0, 1, 3] , 6 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 1 )
        # 6: 9 -> 235
        if barrier: U.barrier()
        U.mct( [0, 3, 5] , 1 )
        U.mct( [0, 3, 5] , 2 )
        U.mct( [0, 3, 5] , 4 )
        U.mct( [0, 3, 5] , 6 )
        # 7: 235 -> 16
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 6 , 5 )
        U.ccx( 0 , 6 , 7 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 6 )
        U.x( 7 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 6, 7] , 2 )
        U.mct( [0, 1, 4, 6, 7] , 3 )
        U.mct( [0, 1, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        # 8: 16 -> 61
        if barrier: U.barrier()
        U.x( 1 )
        U.ccx( 1 , 2 , 0 )
        U.ccx( 1 , 2 , 6 )
        U.x( 1 )
        # 9: 61 -> 1
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        # U16 cycle-2
        # [2, 162, 31, 41, 110, 18, 223, 32, 122]
        # 10: 2 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.ccx( 0 , 4 , 1 )
        U.ccx( 0 , 4 , 3 )
        U.ccx( 0 , 4 , 5 )
        U.x( 4 )
        U.x( 0 )
        # 11: 162 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 5, 7] , 0 )
        U.mct( [1, 5, 7] , 2 )
        U.mct( [1, 5, 7] , 3 )
        U.mct( [1, 5, 7] , 4 )
        U.mct( [1, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        # 12: 31 -> 41
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6] , 0 )
        U.mct( [3, 4, 5, 6] , 1 )
        U.mct( [3, 4, 5, 6] , 2 )
        U.mct( [3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        # 13: 41 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 5 )
        U.ccx( 0 , 2 , 7 )
        U.x( 0 )
        # 14: 110 -> 18
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 3 )
        U.x( 2 )
        # 15: 18 -> 223
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        #
        U.mct( [0, 1, 2, 3, 6] , 4 )
        # 16: 223 -> 32
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 6, 7] , 2 )
        U.mct( [0, 1, 6, 7] , 3 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 6 )
        U.mct( [0, 1, 4] , 7 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 17: 32 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 6] , 1 )
        U.mct( [0, 2, 6] , 3 )
        U.mct( [0, 2, 6] , 4 )
        U.mct( [0, 2, 6] , 5 )
        U.x( 2 )
        U.x( 0 )
        # 18: 122 -> 2
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 6, 7] , 1 )
        U.mct( [0, 2, 3, 4, 6, 7] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # U16 cycle-3
        # [4, 77, 62, 82, 220, 36, 199, 64, 244]        
        # 19: 4 -> 77
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.mct( [2, 3, 5, 7] , 0 )
        U.mct( [2, 3, 5, 7] , 1 )
        U.mct( [2, 3, 5, 7] , 4 )
        U.mct( [2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        # 20: 77 -> 62
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 4, 7] , 2 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        # 21: 62 -> 82
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6] , 3 )
        U.mct( [0, 1, 2, 5, 6] , 4 )
        U.mct( [0, 1, 2, 5, 6] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 22: 82 -> 220
        if barrier: U.barrier()
        U.mct( [4, 5, 6, 7] , 0 )
        U.mct( [4, 5, 6, 7] , 1 )
        U.mct( [4, 5, 6, 7] , 2 )
        U.mct( [4, 5, 6, 7] , 3 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.x( 1 )
        U.x( 0 )
        # 23: 220 -> 36
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        #
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 5, 6, 7] , 2 )
        U.mct( [0, 1, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 24: 36 -> 199
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [1, 2, 3, 7] , 0 )
        U.mct( [1, 2, 3, 7] , 4 )
        U.mct( [1, 2, 3, 7] , 5 )
        U.mct( [1, 2, 3, 7] , 6 )
        U.x( 3 )
        # 25: 199 -> 64
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 1 )
        U.mct( [1, 5, 6, 7] , 0 )
        U.mct( [1, 5, 6, 7] , 2 )
        U.mct( [1, 5, 6, 7] , 3 )
        U.mct( [1, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6] , 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 26: 64 -> 244
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 6 )
        U.mct( [0, 2, 3, 4] , 7 )
        U.x( 3 )
        U.x( 0 )
        # 27: 244 -> 4
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6] , 3 )
        U.mct( [0, 1, 2, 5, 6] , 4 )
        U.mct( [0, 1, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        # U16: cycle-4
        # [8, 154, 124, 164, 193, 72, 151, 128, 241]        
        # 28: 8 -> 154
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 6, 7] , 1 )
        U.mct( [0, 2, 4, 6, 7] , 3 )
        U.mct( [0, 2, 4, 6, 7] , 5 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 29: 154 -> 124
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.mct( [0, 1, 2, 4, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        # 30: 124 -> 164
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 2, 6, 7] , 0 )
        U.mct( [1, 2, 6, 7] , 3 )
        U.mct( [1, 2, 6, 7] , 4 )
        U.mct( [1, 2, 6, 7] , 5 )
        U.x( 6 )
        U.x( 1 )
        # 31: 164 -> 193
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 5 )
        U.x( 2 )
        # 32: 193 -> 72
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 6, 7] , 1 )
        U.mct( [0, 2, 3, 6, 7] , 4 )
        U.mct( [0, 2, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 33: 72 -> 151
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.mct( [0, 1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.x( 5 )
        U.x( 3 )
        # 34: 151 -> 128
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 6, 7] , 2 )
        U.mct( [0, 1, 3, 4, 6, 7] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 35: 128 -> 241
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.mct( [1, 2, 3, 5, 7] , 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 36: 241 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.mct( [0, 3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )        
    elif u_ver == 2:
        # U16 cycle-1
        # [1, 81, 139, 144, 55, 9, 235, 16, 61]
        # 1: 1 -> 81
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 4) # by hand
            U.cx(0, 6)
        # 2: 81 -> 139
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 1 )
            U.cx( 4 , 3 )
            U.cx( 4 , 7 )
            U.x( 4 )
        # 3: 139 -> 144
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 4 , 7 , 0 )
            U.ccx( 4 , 7 , 1 )
            U.ccx( 4 , 7 , 3 )
            U.ccx( 4 , 7 , 6 )
        # 4: 144 -> 55
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.mct( [0, 1, 4] , 2 )
            U.mct( [0, 1, 4] , 3 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.mct( [0, 1, 4] , 7 )
        # 5: 55 -> 9
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 5 )
            U.mct( [0, 1, 3] , 6 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 1 )
        # 6: 9 -> 235
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.mct( [0, 3, 5] , 1 )
            U.mct( [0, 3, 5] , 2 )
            U.mct( [0, 3, 5] , 4 )
            U.mct( [0, 3, 5] , 6 )
        # 7: 235 -> 16
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 6 , 5 )
            U.ccx( 0 , 6 , 7 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 0 )
            U.ccx( 0 , 7 , 6 )
            U.x( 7 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4, 6, 7] , 2 )
            U.mct( [0, 1, 4, 6, 7] , 3 )
            U.mct( [0, 1, 4, 6, 7] , 5 )
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
        # 8: 16 -> 61
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 1 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 6 )
            U.x( 1 )
        # 9: 61 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
        # cycle-2
        # [2, 162, 31, 41, 110, 18, 223, 32, 122]
        # 10: 2 -> 162
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.ccx( 0 , 4 , 1 )
            U.ccx( 0 , 4 , 3 )
            U.ccx( 0 , 4 , 5 )
            U.x( 4 )
            U.x( 0 )
        # 11: 162 -> 31
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [1, 5, 7] , 0 )
            U.mct( [1, 5, 7] , 2 )
            U.mct( [1, 5, 7] , 3 )
            U.mct( [1, 5, 7] , 4 )
            U.mct( [1, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
        # 12: 31 -> 41
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6] , 0 )
            U.mct( [3, 4, 5, 6] , 1 )
            U.mct( [3, 4, 5, 6] , 2 )
            U.mct( [3, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 4 )
        # 13: 41 -> 110
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 4 )
            U.ccx( 0 , 2 , 5 )
            U.ccx( 0 , 2 , 7 )
            U.x( 0 )
        # 14: 110 -> 18
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 3 )
            U.x( 2 )
            U.mct( [1, 2, 3, 4] , 0 )
            U.x( 3 )
            U.x( 2 )
        # 15: 18 -> 223
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            #
            U.mct( [0, 1, 2, 3, 6] , 4 )
        # 16: 223 -> 32
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 6, 7] , 2 )
            U.mct( [0, 1, 6, 7] , 3 )
            U.mct( [0, 1, 6, 7] , 4 )
            U.mct( [0, 1, 6, 7] , 5 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 6 )
            U.mct( [0, 1, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 17: 32 -> 122
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 6] , 1 )
            U.mct( [0, 2, 6] , 3 )
            U.mct( [0, 2, 6] , 4 )
            U.mct( [0, 2, 6] , 5 )
            U.x( 2 )
            U.x( 0 )
        # 18: 122 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 6, 7] , 1 )
            U.mct( [0, 2, 3, 4, 6, 7] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # U16 cycle-3
        # [4, 77, 62, 82, 220, 36, 199, 64, 244]        
        # 19: 4 -> 77
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 3 )
            U.mct( [2, 3, 5, 7] , 0 )
            U.mct( [2, 3, 5, 7] , 1 )
            U.mct( [2, 3, 5, 7] , 4 )
            U.mct( [2, 3, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
            U.x( 3 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
        # 20: 77 -> 62
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 1, 4, 7] , 2 )
            U.mct( [0, 1, 4, 7] , 3 )
            U.mct( [0, 1, 4, 7] , 5 )
            U.mct( [0, 1, 4, 7] , 6 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 0 )
        # 21: 62 -> 82
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5, 6] , 3 )
            U.mct( [0, 1, 2, 5, 6] , 4 )
            U.mct( [0, 1, 2, 5, 6] , 7 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 22: 82 -> 220
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.mct( [4, 5, 6, 7] , 0 )
            U.mct( [4, 5, 6, 7] , 1 )
            U.mct( [4, 5, 6, 7] , 2 )
            U.mct( [4, 5, 6, 7] , 3 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.x( 1 )
            U.x( 0 )
        # 23: 220 -> 36
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.mct( [2, 3, 4, 5, 6, 7] , 0 )
            U.mct( [2, 3, 4, 5, 6, 7] , 1 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            #
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 5, 6, 7] , 2 )
            U.mct( [0, 1, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 24: 36 -> 199
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [1, 2, 3, 7] , 0 )
            U.mct( [1, 2, 3, 7] , 4 )
            U.mct( [1, 2, 3, 7] , 5 )
            U.mct( [1, 2, 3, 7] , 6 )
            U.x( 3 )
        # 25: 199 -> 64
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 7 )
            U.x( 1 )
            U.mct( [1, 5, 6, 7] , 0 )
            U.mct( [1, 5, 6, 7] , 2 )
            U.mct( [1, 5, 6, 7] , 3 )
            U.mct( [1, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 6] , 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 26: 64 -> 244
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.mct( [0, 2, 3, 4] , 5 )
            U.mct( [0, 2, 3, 4] , 6 )
            U.mct( [0, 2, 3, 4] , 7 )
            U.x( 3 )
            U.x( 0 )
        # 27: 244 -> 4
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5, 6] , 3 )
            U.mct( [0, 1, 2, 5, 6] , 4 )
            U.mct( [0, 1, 2, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
        # U16: cycle-4
        # [8, 154, 124, 164, 193, 72, 151, 128, 241]        
        # 28: 8 -> 154
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 4, 6, 7] , 1 )
            U.mct( [0, 2, 4, 6, 7] , 3 )
            U.mct( [0, 2, 4, 6, 7] , 5 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 29: 154 -> 124
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 3, 4, 5, 6, 7] , 0 )
            U.mct( [1, 3, 4, 5, 6, 7] , 2 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 7] , 3 )
            U.mct( [0, 1, 2, 4, 7] , 5 )
            U.x( 7 )
            U.x( 1 )
            U.x( 0 )
        # 30: 124 -> 164
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.mct( [1, 2, 6, 7] , 0 )
            U.mct( [1, 2, 6, 7] , 3 )
            U.mct( [1, 2, 6, 7] , 4 )
            U.mct( [1, 2, 6, 7] , 5 )
            U.x( 6 )
            U.x( 1 )
        # 31: 164 -> 193
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 5 )
            U.x( 2 )
            U.mct( [2, 5, 6, 7] , 0 )
            U.mct( [2, 5, 6, 7] , 1 )
            U.mct( [2, 5, 6, 7] , 3 )
            U.mct( [2, 5, 6, 7] , 4 )
            U.x( 5 )
            U.x( 2 )
        # 32: 193 -> 72
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 6, 7] , 1 )
            U.mct( [0, 2, 3, 6, 7] , 4 )
            U.mct( [0, 2, 3, 6, 7] , 5 )
            U.x( 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 33: 72 -> 151
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 6] , 3 )
            U.mct( [0, 1, 2, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.x( 5 )
            U.x( 3 )
        # 34: 151 -> 128
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [2, 4, 5, 6, 7] , 0 )
            U.mct( [2, 4, 5, 6, 7] , 1 )
            U.mct( [2, 4, 5, 6, 7] , 3 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 6, 7] , 2 )
            U.mct( [0, 1, 3, 4, 6, 7] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 35: 128 -> 241
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 7] , 0 )
            U.mct( [1, 2, 3, 5, 7] , 4 )
            U.mct( [1, 2, 3, 5, 7] , 6 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 36: 241 -> 8
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:        
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.mct( [0, 3, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 0 )
        if barrier: U.barrier()            
    return U

def U8_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """U8 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U8 cycle-1
        # [1, 9, 81, 235, 139, 16, 144, 61, 55]
        # 1: 1 -> 9
        if barrier: U.barrier()
        U.cx(0, 3) # by hand
        # 2: 9 -> 81
        if barrier: U.barrier()
        U.x( 3 )
        U.cx( 3 , 4 )
        U.cx( 3 , 6 )
        U.x( 3 )
        # 3: 81 -> 235
        if barrier: U.barrier()
        U.ccx( 3 , 6 , 1 )
        U.ccx( 3 , 6 , 4 )
        U.ccx( 3 , 6 , 5 )
        U.ccx( 3 , 6 , 7 )
        # 4: 235 -> 139
        if barrier: U.barrier()
        U.x( 6 )
        U.ccx( 1 , 6 , 3 )
        U.ccx( 1 , 6 , 4 )
        U.ccx( 1 , 6 , 5 )
        U.x( 6 )
        # 5: 139 -> 16
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 3 , 7 , 0 )
        U.ccx( 3 , 7 , 1 )
        U.ccx( 3 , 7 , 6 )
        U.x( 3 )
        #
        U.x( 0 )
        U.cx( 0 , 7 )
        U.x( 0 )
        # 6: 16 -> 144
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        U.x( 0 )
        # 7: 144 -> 61
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.mct( [0, 3, 6, 7] , 1 )
        U.mct( [0, 3, 6, 7] , 2 )
        U.mct( [0, 3, 6, 7] , 4 )
        U.mct( [0, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 3 )
        #
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        # 8: 61 -> 55
        if barrier: U.barrier()
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 6 )
        #
        U.mct( [0, 1, 2] , 7 )
        # 9: 55 -> 1
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        # cycle-2
        # [2, 18, 162, 223, 31, 32, 41, 122, 110]
        # 10: 2 -> 18
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 4 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        # 11: 18 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        # 12: 162 -> 223
        if barrier: U.barrier()
        U.x( 5 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.x( 5 )
        # 13: 223 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [0, 1, 6, 7] , 2 )
        U.mct( [0, 1, 6, 7] , 3 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 7 )
        #
        U.x( 7 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 7 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6] , 0 )
        U.mct( [1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 14: 31 -> 32
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 15: 32 -> 41
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 7] , 0 )
        U.mct( [1, 2, 4, 5, 7] , 3 )
        U.mct( [1, 2, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 16: 41 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 4, 5] , 0 )
        U.mct( [2, 4, 5] , 1 )
        U.mct( [2, 4, 5] , 3 )
        U.x( 2 )
        # 17: 122 -> 110
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.x( 4 )
        U.x( 0 )
        # 18: 110 -> 2
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6, 7] , 1 )
        U.mct( [0, 5, 6, 7] , 2 )
        U.mct( [0, 5, 6, 7] , 3 )
        U.mct( [0, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        # cycle-3
        # [4, 36, 77, 199, 62, 64, 82, 244, 220]
        # 19: 4 -> 36
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 20: 36 -> 77
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.mct( [1, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        # 21: 77 -> 199
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.mct( [0, 4, 5, 6, 7] , 1 )
        U.mct( [0, 4, 5, 6, 7] , 2 )
        U.mct( [0, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        # 22: 199 -> 62
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 0 )
        # 23: 62 -> 64
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 2 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.mct( [0, 4, 5, 7] , 6 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6] , 4 )
        U.mct( [0, 1, 2, 6] , 5 )
        U.mct( [0, 1, 2, 6] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 24: 64 -> 82
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 1, 5, 6] , 2 )
        U.mct( [0, 1, 5, 6] , 3 )
        U.mct( [0, 1, 5, 6] , 4 )
        U.mct( [0, 1, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        # 25: 82 -> 244
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 7 )
        U.x( 3 )
        U.x( 1 )
        # 26: 244 -> 220
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.mct( [1, 2, 3, 4, 7] , 5 )
        U.mct( [1, 2, 3, 4, 7] , 6 )
        U.x( 1 )
        # 27: 220 -> 4
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # cycle-4
        # [8, 72, 154, 151, 124, 128, 164, 241, 193]
        # 28: 8 -> 72
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 29: 72 -> 154
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        #
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6, 7] , 3 )
        U.mct( [0, 1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        # 30: 154 -> 151
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        # 31: 151 -> 124
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 1 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 32: 124 -> 128
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5, 7] , 1 )
        U.mct( [0, 2, 4, 5, 7] , 3 )
        U.mct( [0, 2, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        # 33: 128 -> 164
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 34: 164 -> 241
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [0, 3, 5, 7] , 1 )
        U.mct( [0, 3, 5, 7] , 2 )
        U.mct( [0, 3, 5, 7] , 4 )
        U.mct( [0, 3, 5, 7] , 6 )
        U.x( 3 )
        # 35: 241 -> 193
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 3 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.mct( [0, 1, 2, 3, 4, 6] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 36: 193 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.mct( [0, 1, 2, 3, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U8 cycle-1
        # [1, 9, 81, 235, 139, 16, 144, 61, 55]
        # 1: 1 -> 9
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 3) # by hand
        # 2: 9 -> 81
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 3 )
            U.cx( 3 , 4 )
            U.cx( 3 , 6 )
            U.x( 3 )
        # 3: 81 -> 235
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 3 , 6 , 1 )
            U.ccx( 3 , 6 , 4 )
            U.ccx( 3 , 6 , 5 )
            U.ccx( 3 , 6 , 7 )
        # 4: 235 -> 139
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 6 )
            U.ccx( 1 , 6 , 3 )
            U.ccx( 1 , 6 , 4 )
            U.ccx( 1 , 6 , 5 )
            U.x( 6 )
        # 5: 139 -> 16
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 3 )
            U.ccx( 3 , 7 , 0 )
            U.ccx( 3 , 7 , 1 )
            U.ccx( 3 , 7 , 6 )
            U.x( 3 )
            #
            U.x( 0 )
            U.cx( 0 , 7 )
            U.x( 0 )
        # 6: 16 -> 144
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 7 , 4 )
            U.ccx( 0 , 7 , 6 )
            U.x( 0 )
        # 7: 144 -> 61
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.mct( [0, 3, 6, 7] , 1 )
            U.mct( [0, 3, 6, 7] , 2 )
            U.mct( [0, 3, 6, 7] , 4 )
            U.mct( [0, 3, 6, 7] , 5 )
            U.x( 6 )
            U.x( 3 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
        # 8: 61 -> 55
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.mct( [0, 2, 7] , 1 )
            U.mct( [0, 2, 7] , 3 )
            U.mct( [0, 2, 7] , 4 )
            U.mct( [0, 2, 7] , 6 )
            #
            U.mct( [0, 1, 2] , 7 )
        # 9: 55 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
        # cycle-2
        # [2, 18, 162, 223, 31, 32, 41, 122, 110]
        # 10: 2 -> 18
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 4 )
            U.ccx( 0 , 1 , 7 )
            U.x( 0 )
        # 11: 18 -> 162
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 7 )
            U.x( 4 )
            U.x( 0 )
        # 12: 162 -> 223
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 5 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.x( 5 )
        # 13: 223 -> 31
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 7 )
            U.mct( [0, 1, 6, 7] , 2 )
            U.mct( [0, 1, 6, 7] , 3 )
            U.mct( [0, 1, 6, 7] , 4 )
            U.mct( [0, 1, 6, 7] , 5 )
            U.x( 7 )
            #
            U.x( 7 )
            U.mct( [0, 1, 2, 3, 7] , 6 )
            U.x( 7 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 6] , 0 )
            U.mct( [1, 2, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 14: 31 -> 32
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 15: 32 -> 41
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5, 7] , 0 )
            U.mct( [1, 2, 4, 5, 7] , 3 )
            U.mct( [1, 2, 4, 5, 7] , 6 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 16: 41 -> 122
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 4, 5] , 0 )
            U.mct( [2, 4, 5] , 1 )
            U.mct( [2, 4, 5] , 3 )
            U.x( 2 )
        # 17: 122 -> 110
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
            U.x( 4 )
            U.x( 0 )
        # 18: 110 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 5, 6, 7] , 1 )
            U.mct( [0, 5, 6, 7] , 2 )
            U.mct( [0, 5, 6, 7] , 3 )
            U.mct( [0, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # cycle-3
        # [4, 36, 77, 199, 62, 64, 82, 244, 220]
        # 19: 4 -> 36
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 20: 36 -> 77
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5] , 0 )
            U.mct( [1, 2, 4, 5] , 3 )
            U.mct( [1, 2, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
        # 21: 77 -> 199
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.mct( [0, 4, 5, 6, 7] , 1 )
            U.mct( [0, 4, 5, 6, 7] , 2 )
            U.mct( [0, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
        # 22: 199 -> 62
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 7 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 0 )
        # 23: 62 -> 64
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 4, 5, 7] , 1 )
            U.mct( [0, 4, 5, 7] , 2 )
            U.mct( [0, 4, 5, 7] , 3 )
            U.mct( [0, 4, 5, 7] , 6 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 6] , 4 )
            U.mct( [0, 1, 2, 6] , 5 )
            U.mct( [0, 1, 2, 6] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 24: 64 -> 82
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 1, 5, 6] , 2 )
            U.mct( [0, 1, 5, 6] , 3 )
            U.mct( [0, 1, 5, 6] , 4 )
            U.mct( [0, 1, 5, 6] , 7 )
            U.x( 5 )
            U.x( 0 )
        # 25: 82 -> 244
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 3, 4, 5] , 0 )
            U.mct( [1, 3, 4, 5] , 2 )
            U.mct( [1, 3, 4, 5] , 7 )
            U.x( 3 )
            U.x( 1 )
        # 26: 244 -> 220
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 7] , 0 )
            U.mct( [1, 2, 3, 4, 7] , 5 )
            U.mct( [1, 2, 3, 4, 7] , 6 )
            U.x( 1 )
        # 27: 220 -> 4
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4, 5, 6, 7] , 2 )
            U.mct( [0, 1, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # cycle-4
        # [8, 72, 154, 151, 124, 128, 164, 241, 193]
        # 28: 8 -> 72
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 29: 72 -> 154
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            #
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5, 6, 7] , 3 )
            U.mct( [0, 1, 2, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 30: 154 -> 151
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 1, 4, 5, 6, 7] , 2 )
            U.mct( [0, 1, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
        # 31: 151 -> 124
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6, 7] , 0 )
            U.mct( [1, 2, 3, 6, 7] , 4 )
            U.mct( [1, 2, 3, 6, 7] , 5 )
            U.x( 6 )
            U.x( 1 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 32: 124 -> 128
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 4, 5, 7] , 1 )
            U.mct( [0, 2, 4, 5, 7] , 3 )
            U.mct( [0, 2, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.x( 0 )
        # 33: 128 -> 164
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.mct( [1, 2, 3, 4, 5] , 7 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 34: 164 -> 241
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 3, 5, 7] , 1 )
            U.mct( [0, 3, 5, 7] , 2 )
            U.mct( [0, 3, 5, 7] , 4 )
            U.mct( [0, 3, 5, 7] , 6 )
            U.x( 3 )
        # 35: 241 -> 193
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 7 )
            U.x( 3 )
            U.mct( [0, 3, 5, 6, 7] , 1 )
            U.mct( [0, 3, 5, 6, 7] , 2 )
            U.mct( [0, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 3 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.mct( [0, 1, 2, 3, 4, 6] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 36: 193 -> 8
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 5, 6, 7] , 0 )
            U.mct( [1, 2, 5, 6, 7] , 3 )
            U.mct( [1, 2, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.mct( [0, 1, 2, 3, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U


def U4_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """U4 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U4 cycle-1
        # [1, 16, 9, 144, 81, 61, 235, 55, 139]
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.cx(0, 4) # by hand
        U.cx(4, 0)
        # 2: 16 -> 9
        if barrier: U.barrier()
        U.cx( 0 , 3 )
        U.cx( 0 , 4 )
        # 3: 9 -> 144
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 3 , 7 )
        U.x( 0 )
        #
        U.x( 0 )
        U.ccx( 0 , 7 , 3 )
        U.x( 0 )
        # 4: 144 -> 81
        if barrier: U.barrier()
        U.ccx( 0 , 7 , 3 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        #
        U.x( 3 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        # 5: 81 -> 61
        if barrier: U.barrier()
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        # 6: 61 -> 235
        if barrier: U.barrier()
        U.mct( [0, 5, 7] , 1 )
        U.mct( [0, 5, 7] , 2 )
        U.mct( [0, 5, 7] , 3 )
        U.mct( [0, 5, 7] , 4 )
        U.mct( [0, 5, 7] , 6 )
        # 7: 235 -> 55
        if barrier: U.barrier()
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.ccx( 1 , 4 , 6 )
        # 8: 55 -> 139
        if barrier: U.barrier()
        U.x( 5 )
        U.ccx( 1 , 5 , 0 )
        U.ccx( 1 , 5 , 2 )
        U.ccx( 1 , 5 , 3 )
        U.ccx( 1 , 5 , 4 )
        U.ccx( 1 , 5 , 7 )
        U.x( 5 )
        # 9: 139 -> 1
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # cycle-2
        # [2, 32, 18, 41, 162, 122, 223, 110, 31]
        # 10: 2 -> 32
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [3, 4, 6, 7] , 0 )
        U.mct( [3, 4, 6, 7] , 1 )
        U.mct( [3, 4, 6, 7] , 2 )
        U.mct( [3, 4, 6, 7] , 5 )
        U.x( 6 )
        #
        U.x( 0 )
        U.ccx( 0 , 5 , 3 )
        U.ccx( 0 , 5 , 4 )
        U.ccx( 0 , 5 , 7 )
        U.x( 0 )
        # 11: 32 -> 18
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.x( 0 )
        #
        U.x( 0 )
        U.ccx( 0 , 1 , 5 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        # 12: 18 -> 41
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.x( 2 )
        U.x( 1 )
        # 13: 41 -> 162
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 3 )
        U.x( 4 )
        U.x( 0 )
        # 14: 162 -> 122
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 0 )
        # 15: 122 -> 223
        if barrier: U.barrier()
        U.mct( [1, 3, 4, 7] , 0 )
        U.mct( [1, 3, 4, 7] , 2 )
        U.mct( [1, 3, 4, 7] , 5 )
        U.mct( [1, 3, 4, 7] , 6 )
        # 16: 223 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 3 )
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 6 )
        U.ccx( 0 , 2 , 7 )
        U.x( 0 )
        # 17: 110 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        #
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 2, 3, 5, 7] , 1 )
        U.mct( [0, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        # 18: 31 -> 2
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 19: 4 -> 64
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6] , 1 )
        U.mct( [0, 5, 6] , 2 )
        U.mct( [0, 5, 6] , 3 )
        U.mct( [0, 5, 6] , 4 )
        U.mct( [0, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        # 20: 64 -> 36
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 5 )
        U.mct( [0, 2, 7] , 6 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 21: 36 -> 82
        if barrier: U.barrier()
        # automatic
        # 22: 82 -> 77
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [2, 3, 5, 6] , 0 )
        U.mct( [2, 3, 5, 6] , 1 )
        U.mct( [2, 3, 5, 6] , 4 )
        U.mct( [2, 3, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        # 23: 77 -> 244
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 5, 6] , 1 )
        U.mct( [0, 2, 5, 6] , 3 )
        U.mct( [0, 2, 5, 6] , 4 )
        U.mct( [0, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 24: 244 -> 199
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        # 25: 199 -> 220
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5] , 1 )
        U.mct( [0, 2, 4, 5] , 3 )
        U.mct( [0, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 0 )
        # 26: 220 -> 62
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 6 )
        #
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        # 27: 62 -> 4
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6, 7] , 4 )
        U.mct( [0, 1, 2, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 28: 8 -> 128
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 29: 128 -> 72
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 30: 72 -> 164
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 5 )
        U.x( 4 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.mct( [0, 1, 2, 4, 7] , 5 )
        U.mct( [0, 1, 2, 4, 7] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 31: 164 -> 154
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.mct( [0, 1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        # 32: 154 -> 241
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 33: 241 -> 151
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 6] , 1 )
        U.mct( [0, 2, 3, 4, 6] , 5 )
        U.mct( [0, 2, 3, 4, 6] , 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 3, 4, 5] , 2 )
        U.x( 5 )
        U.x( 3 )
        # 34: 151 -> 193
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.mct( [0, 3, 4, 5, 6, 7] , 1 )
        U.mct( [0, 3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5, 7] , 3 )
        U.mct( [0, 1, 2, 5, 7] , 4 )
        U.mct( [0, 1, 2, 5, 7] , 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        # 35: 193 -> 124
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [1, 2, 4, 5, 6, 7] , 0 )
        U.mct( [1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        #
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5, 6] , 1 )
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 36: 124 -> 8
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 6] , 2 )
        U.mct( [0, 1, 3, 6] , 4 )
        U.mct( [0, 1, 3, 6] , 5 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle-1
        # [1, 16, 9, 144, 81, 61, 235, 55, 139]
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 4) # by hand
            U.cx(4, 0)
        # 2: 16 -> 9
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
        # 3: 9 -> 144
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 3 , 7 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 7 , 3 )
            U.x( 0 )
        # 4: 144 -> 81
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx( 0 , 7 , 3 )
            U.ccx( 0 , 7 , 4 )
            U.ccx( 0 , 7 , 6 )
            #
            U.x( 3 )
            U.ccx( 0 , 3 , 7 )
            U.x( 3 )
        # 5: 81 -> 61
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
        # 6: 61 -> 235
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.mct( [0, 5, 7] , 1 )
            U.mct( [0, 5, 7] , 2 )
            U.mct( [0, 5, 7] , 3 )
            U.mct( [0, 5, 7] , 4 )
            U.mct( [0, 5, 7] , 6 )
        # 7: 235 -> 55
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.ccx( 1 , 4 , 0 )
            U.ccx( 1 , 4 , 2 )
            U.ccx( 1 , 4 , 3 )
            U.ccx( 1 , 4 , 6 )
        # 8: 55 -> 139
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 5 )
            U.ccx( 1 , 5 , 0 )
            U.ccx( 1 , 5 , 2 )
            U.ccx( 1 , 5 , 3 )
            U.ccx( 1 , 5 , 4 )
            U.ccx( 1 , 5 , 7 )
            U.x( 5 )
        # 9: 139 -> 1
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6, 7] , 0 )
            U.mct( [2, 4, 5, 6, 7] , 1 )
            U.mct( [2, 4, 5, 6, 7] , 3 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # cycle-2
        # [2, 32, 18, 41, 162, 122, 223, 110, 31]
        # 10: 2 -> 32
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [3, 4, 6, 7] , 0 )
            U.mct( [3, 4, 6, 7] , 1 )
            U.mct( [3, 4, 6, 7] , 2 )
            U.mct( [3, 4, 6, 7] , 5 )
            U.x( 6 )
            #
            U.x( 0 )
            U.ccx( 0 , 5 , 3 )
            U.ccx( 0 , 5 , 4 )
            U.ccx( 0 , 5 , 7 )
            U.x( 0 )
        # 11: 32 -> 18
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 4, 5, 7] , 1 )
            U.mct( [0, 4, 5, 7] , 3 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 1 , 5 )
            U.ccx( 0 , 1 , 7 )
            U.x( 0 )
        # 12: 18 -> 41
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5] , 0 )
            U.mct( [1, 2, 4, 5] , 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.x( 2 )
            U.x( 1 )
        # 13: 41 -> 162
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 3 )
            U.x( 4 )
            U.x( 0 )
        # 14: 162 -> 122
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 1, 4, 7] , 3 )
            U.mct( [0, 1, 4, 7] , 5 )
            U.mct( [0, 1, 4, 7] , 6 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 0 )
        # 15: 122 -> 223
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.mct( [1, 3, 4, 7] , 0 )
            U.mct( [1, 3, 4, 7] , 2 )
            U.mct( [1, 3, 4, 7] , 5 )
            U.mct( [1, 3, 4, 7] , 6 )
        # 16: 223 -> 110
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
            U.ccx( 0 , 2 , 4 )
            U.ccx( 0 , 2 , 6 )
            U.ccx( 0 , 2 , 7 )
            U.x( 0 )
        # 17: 110 -> 31
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 7 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6, 7] , 0 )
            U.mct( [1, 2, 3, 6, 7] , 4 )
            U.mct( [1, 2, 3, 6, 7] , 5 )
            U.x( 7 )
            U.x( 1 )
            #
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 2, 3, 5, 7] , 1 )
            U.mct( [0, 2, 3, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
        # 18: 31 -> 2
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [1, 3, 4, 5] , 0 )
            U.mct( [1, 3, 4, 5] , 2 )
            U.mct( [1, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 19: 4 -> 64
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 5, 6] , 1 )
            U.mct( [0, 5, 6] , 2 )
            U.mct( [0, 5, 6] , 3 )
            U.mct( [0, 5, 6] , 4 )
            U.mct( [0, 5, 6] , 7 )
            U.x( 5 )
            U.x( 0 )
        # 20: 64 -> 36
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 7] , 1 )
            U.mct( [0, 2, 7] , 3 )
            U.mct( [0, 2, 7] , 4 )
            U.mct( [0, 2, 7] , 5 )
            U.mct( [0, 2, 7] , 6 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 21: 36 -> 82
        if barrier: U.barrier()
        if 21 <= r - trnc_lv: pass
        # automatic
        # 22: 82 -> 77
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.mct( [2, 3, 5, 6] , 0 )
            U.mct( [2, 3, 5, 6] , 1 )
            U.mct( [2, 3, 5, 6] , 4 )
            U.mct( [2, 3, 5, 6] , 7 )
            U.x( 5 )
            U.x( 3 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
        # 23: 77 -> 244
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 2, 5, 6] , 1 )
            U.mct( [0, 2, 5, 6] , 3 )
            U.mct( [0, 2, 5, 6] , 4 )
            U.mct( [0, 2, 5, 6] , 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 24: 244 -> 199
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.x( 4 )
            U.x( 3 )
        # 25: 199 -> 220
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 5 )
            U.x( 0 )
            U.mct( [0, 2, 4, 5] , 1 )
            U.mct( [0, 2, 4, 5] , 3 )
            U.mct( [0, 2, 4, 5] , 6 )
            U.x( 5 )
            U.x( 0 )
        # 26: 220 -> 62
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [2, 5, 6, 7] , 0 )
            U.mct( [2, 5, 6, 7] , 1 )
            U.mct( [2, 5, 6, 7] , 3 )
            U.mct( [2, 5, 6, 7] , 4 )
            U.x( 6 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 0 )
        # 27: 62 -> 4
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6, 7] , 4 )
            U.mct( [0, 1, 2, 3, 6, 7] , 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5, 7] , 2 )
            U.mct( [0, 1, 3, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 28: 8 -> 128
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5, 7] , 2 )
            U.mct( [0, 1, 3, 4, 5, 7] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 29: 128 -> 72
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 30: 72 -> 164
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.mct( [3, 4, 5, 6, 7] , 0 )
            U.mct( [3, 4, 5, 6, 7] , 1 )
            U.mct( [3, 4, 5, 6, 7] , 2 )
            U.x( 5 )
            U.x( 4 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 7] , 3 )
            U.mct( [0, 1, 2, 4, 7] , 5 )
            U.mct( [0, 1, 2, 4, 7] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 31: 164 -> 154
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5, 6] , 3 )
            U.mct( [0, 1, 2, 4, 5, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 5 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
        # 32: 154 -> 241
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 33: 241 -> 151
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3, 4, 6] , 1 )
            U.mct( [0, 2, 3, 4, 6] , 5 )
            U.mct( [0, 2, 3, 4, 6] , 7 )
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 3, 4, 5] , 2 )
            U.x( 5 )
            U.x( 3 )
        # 34: 151 -> 193
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.mct( [0, 3, 4, 5, 6, 7] , 1 )
            U.mct( [0, 3, 4, 5, 6, 7] , 2 )
            U.x( 6 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 5, 7] , 3 )
            U.mct( [0, 1, 2, 5, 7] , 4 )
            U.mct( [0, 1, 2, 5, 7] , 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
        # 35: 193 -> 124
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.mct( [1, 2, 4, 5, 6, 7] , 0 )
            U.mct( [1, 2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            #
            U.x( 6 )
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5, 6] , 1 )
            U.x( 6 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 36: 124 -> 8
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 6] , 2 )
            U.mct( [0, 1, 3, 6] , 4 )
            U.mct( [0, 1, 3, 6] , 5 )
            U.x( 6 )
            U.x( 1 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U2_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """U2 for N=247 a=2 r=36."""
    a = 2
    r = 36
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N247_a2(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # U2 cycle-1
        # [1, 4, 16, 64, 9, 36, 144, 82, 81, 77, 61, 244,
        # 235, 199, 55, 220, 139, 62]
        # 1: 1 -> 4 # by hand
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(2, 0)
        # 2: 4 -> 16 # by hand
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(4, 0)
        # 3: 16-> 64
        if barrier: U.barrier()
        U.x( 2 )
        U.ccx(0, 2 , 4 )
        U.ccx(0, 2 , 6 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 2 )
        U.ccx(2, 4 , 0 )
        U.x( 4 )
        U.x( 2 )
        # 4: 64 -> 9
        if barrier: U.barrier()        
        U.cx( 0 , 3 )
        U.cx( 0 , 6 )
        # 5: 9 -> 36
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3] , 5 )
        U.x( 0 )
        #
        U.x( 0 )
        U.mct( [0, 2, 5] , 3 )
        U.x( 0 )
        # 6: 36 -> 144
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5] , 7 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 7] , 5 )
        U.x( 2 )
        U.x( 0 )
        # 7: 144 -> 82
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 6, 7] , 1 )
        U.mct( [0, 2, 6, 7] , 4 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 0 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        # 8: 82 -> 81
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 4, 7] , 0 )
        U.mct( [2, 3, 4, 7] , 1 )
        U.mct( [2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 3 )
        U.ccx( 0 , 3 , 4 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        # 9: 81 -> 77
        if barrier: U.barrier()
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 6 )
        # 10: 77 -> 61
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.mct( [1, 2, 4] , 6 )
        U.x( 1 )
        # 11: 61 -> 244
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.mct( [1, 2, 3, 5, 7] , 6 )
        U.x( 3 )
        U.x( 1 )
        # 12: 244 -> 235
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.x( 2 )
        # 13: 235 -> 199
        if barrier: U.barrier()
        U.ccx( 1 , 2 , 0 )
        U.ccx( 1 , 2 , 3 )
        U.ccx( 1 , 2 , 7 )
        # 14: 199 -> 55
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 4] , 3 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.mct( [0, 1, 2, 4] , 7 )
        # 15: 55 -> 220
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 0 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 5 )
        U.x( 6 )
        U.x( 0 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 1 )
        U.x( 0 )
        # 16: 220 -> 139
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [0, 2, 4, 5, 6] , 1 )
        U.mct( [0, 2, 4, 5, 6] , 3 )
        U.mct( [0, 2, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 5 )
        U.x( 2 )
        U.mct( [0, 1, 2, 5] , 6 )
        U.x( 5 )
        U.x( 2 )
        # 17: 139 -> 62
        if barrier: U.barrier()
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.mct( [1, 2, 3] , 7 )
        # 18: 62 -> 1
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        # cycle-2
        # [2, 8, 32, 128, 18, 72, 41, 164, 162, 154, 122,
        # 241, 223, 151, 110, 193, 31, 124]
        # 19: 2 -> 8
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 20: 8 -> 32
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 21: 32 -> 128
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 2 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 7] , 5 )
        U.mct( [0, 1, 2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 22: 128 -> 18
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 5, 6, 7] , 0 )
        U.mct( [2, 3, 5, 6, 7] , 1 )
        U.mct( [2, 3, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        #
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6] , 5 )
        U.mct( [0, 1, 2, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        # 23: 18 -> 72
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.mct( [1, 2, 3, 4] , 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 24: 72 -> 41
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 6, 7] , 3 )
        U.mct( [0, 1, 2, 6, 7] , 4 )
        U.mct( [0, 1, 2, 6, 7] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        # 25: 41 -> 164
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6] , 3 )
        U.mct( [0, 1, 2, 4, 6] , 5 )
        U.mct( [0, 1, 2, 4, 6] , 7 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        # 26: 164 -> 162
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5] , 1 )
        U.mct( [0, 2, 3, 4, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5] , 4 )
        U.x( 2 )
        U.x( 0 )
        # 27: 162 -> 154
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.x( 2 )
        U.x( 0 )
        # 28: 154 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [2, 3, 4, 5] , 0 )
        U.mct( [2, 3, 4, 5] , 1 )
        U.x( 2 )
        # 29: 122 -> 241
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 6, 7] , 0 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        #
        U.x( 6 )
        U.x( 2 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 5 )
        U.mct( [0, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        #
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 30: 241 -> 223
        if barrier: U.barrier()
        U.mct( [0, 2, 3, 6, 7] , 1 )
        U.mct( [0, 2, 3, 6, 7] , 4 )
        U.mct( [0, 2, 3, 6, 7] , 5 )
        # 31: 223 -> 151
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.mct( [0, 1, 2, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        #
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        # 32: 151 -> 110
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.mct( [0, 2, 3, 5, 6] , 4 )
        U.x( 0 )
        # 33: 110 -> 193
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 7] , 0 )
        U.mct( [1, 2, 4, 5, 7] , 3 )
        U.mct( [1, 2, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        # 34: 193 -> 31
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [1, 2, 3, 4, 6, 7] , 0 )
        U.mct( [1, 2, 3, 4, 6, 7] , 5 )
        U.x( 7 )
        #
        U.x( 7 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 7 )
        # 35: 31 -> 124
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [2, 3, 4, 6, 7] , 0 )
        U.mct( [2, 3, 4, 6, 7] , 1 )
        U.mct( [2, 3, 4, 6, 7] , 5 )
        U.x( 6 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 36: 124 -> 2
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U2 cycle-1
        # [1, 4, 16, 64, 9, 36, 144, 82, 81, 77, 61, 244,
        # 235, 199, 55, 220, 139, 62]
        # 1: 1 -> 4 # by hand
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(2, 0)
        # 2: 4 -> 16 # by hand
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 4)
            U.cx(4, 0)
        # 3: 16-> 64
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 2 )
            U.ccx(0, 2 , 4 )
            U.ccx(0, 2 , 6 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 2 )
            U.ccx(2, 4 , 0 )
            U.x( 4 )
            U.x( 2 )
        # 4: 64 -> 9
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.cx( 0 , 3 )
            U.cx( 0 , 6 )
        # 5: 9 -> 36
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 3] , 5 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 2, 5] , 3 )
            U.x( 0 )
        # 6: 36 -> 144
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 4, 5] , 7 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 4, 7] , 5 )
            U.x( 2 )
            U.x( 0 )
        # 7: 144 -> 82
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 6, 7] , 1 )
            U.mct( [0, 2, 6, 7] , 4 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 0 )
            U.ccx( 0 , 1 , 7 )
            U.x( 0 )
        # 8: 82 -> 81
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [2, 3, 4, 7] , 0 )
            U.mct( [2, 3, 4, 7] , 1 )
            U.mct( [2, 3, 4, 7] , 6 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 3 )
            U.ccx( 0 , 3 , 4 )
            U.ccx( 0 , 3 , 7 )
            U.x( 3 )
        # 9: 81 -> 77
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.ccx( 0 , 2 , 4 )
            U.ccx( 0 , 2 , 6 )
        # 10: 77 -> 61
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.mct( [1, 2, 4] , 6 )
            U.x( 1 )
        # 11: 61 -> 244
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 7] , 0 )
            U.mct( [1, 2, 3, 5, 7] , 4 )
            U.mct( [1, 2, 3, 5, 7] , 6 )
            U.x( 3 )
            U.x( 1 )
        # 12: 244 -> 235
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.mct( [0, 2, 3, 5] , 4 )
            U.x( 2 )
        # 13: 235 -> 199
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 3 )
            U.ccx( 1 , 2 , 7 )
        # 14: 199 -> 55
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.mct( [0, 1, 2, 4] , 3 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.mct( [0, 1, 2, 4] , 7 )
        # 15: 55 -> 220
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 6 )
            U.x( 0 )
            U.mct( [0, 2, 4, 6] , 1 )
            U.mct( [0, 2, 4, 6] , 3 )
            U.mct( [0, 2, 4, 6] , 5 )
            U.x( 6 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 16: 220 -> 139
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [0, 2, 4, 5, 6] , 1 )
            U.mct( [0, 2, 4, 5, 6] , 3 )
            U.mct( [0, 2, 4, 5, 6] , 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 5 )
            U.x( 2 )
            U.mct( [0, 1, 2, 5] , 6 )
            U.x( 5 )
            U.x( 2 )
        # 17: 139 -> 62
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.mct( [1, 2, 3] , 7 )
        # 18: 62 -> 1
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.mct( [0, 2, 3, 4] , 5 )
            U.mct( [0, 2, 3, 4] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
        # cycle-2
        # [2, 8, 32, 128, 18, 72, 41, 164, 162, 154, 122,
        # 241, 223, 151, 110, 193, 31, 124]
        # 19: 2 -> 8
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6, 7] , 0 )
            U.mct( [2, 4, 5, 6, 7] , 1 )
            U.mct( [2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 20: 8 -> 32
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 6, 7] , 0 )
            U.mct( [1, 2, 3, 6, 7] , 4 )
            U.mct( [1, 2, 3, 6, 7] , 5 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 21: 32 -> 128
        if barrier: U.barrier()
        if 21 <= r - trnc_lv:
            U.x( 7 )
            U.x( 2 )
            U.mct( [2, 5, 6, 7] , 0 )
            U.mct( [2, 5, 6, 7] , 1 )
            U.mct( [2, 5, 6, 7] , 3 )
            U.mct( [2, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 7] , 5 )
            U.mct( [0, 1, 2, 3, 4, 7] , 6 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 22: 128 -> 18
        if barrier: U.barrier()
        if 22 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [2, 3, 5, 6, 7] , 0 )
            U.mct( [2, 3, 5, 6, 7] , 1 )
            U.mct( [2, 3, 5, 6, 7] , 4 )
            U.x( 6 )
            U.x( 3 )
            U.x( 2 )
            #
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 6] , 5 )
            U.mct( [0, 1, 2, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
        # 23: 18 -> 72
        if barrier: U.barrier()
        if 23 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3, 4] , 0 )
            U.mct( [1, 2, 3, 4] , 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 6] , 4 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 24: 72 -> 41
        if barrier: U.barrier()
        if 24 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 6, 7] , 3 )
            U.mct( [0, 1, 2, 6, 7] , 4 )
            U.mct( [0, 1, 2, 6, 7] , 5 )
            U.x( 6 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 2 )
            U.x( 1 )
        # 25: 41 -> 164
        if barrier: U.barrier()
        if 25 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 6] , 3 )
            U.mct( [0, 1, 2, 4, 6] , 5 )
            U.mct( [0, 1, 2, 4, 6] , 7 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
            U.x( 4 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 26: 164 -> 162
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5] , 1 )
            U.mct( [0, 2, 3, 4, 5] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5] , 4 )
            U.x( 2 )
            U.x( 0 )
        # 27: 162 -> 154
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.mct( [0, 2, 3, 4] , 5 )
            U.x( 2 )
            U.x( 0 )
        # 28: 154 -> 122
        if barrier: U.barrier()
        if 28 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [2, 3, 4, 5] , 0 )
            U.mct( [2, 3, 4, 5] , 1 )
            U.x( 2 )
        # 29: 122 -> 241
        if barrier: U.barrier()
        if 29 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [1, 2, 3, 4, 5, 6, 7] , 0 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 6 )
            U.x( 5 )
            U.x( 2 )
            #
            U.x( 6 )
            U.x( 2 )
            U.mct( [0, 2, 4, 6] , 1 )
            U.mct( [0, 2, 4, 6] , 3 )
            U.mct( [0, 2, 4, 6] , 5 )
            U.mct( [0, 2, 4, 6] , 7 )
            U.x( 6 )
            U.x( 2 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4, 5] , 6 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 30: 241 -> 223
        if barrier: U.barrier()
        if 30 <= r - trnc_lv:
            U.mct( [0, 2, 3, 6, 7] , 1 )
            U.mct( [0, 2, 3, 6, 7] , 4 )
            U.mct( [0, 2, 3, 6, 7] , 5 )
        # 31: 223 -> 151
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.mct( [0, 1, 2, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 5 )
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 4, 5] , 7 )
            U.x( 5 )
            U.x( 3 )
        # 32: 151 -> 110
        if barrier: U.barrier()
        if 32 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 3, 5, 6] , 1 )
            U.mct( [0, 2, 3, 5, 6] , 4 )
            U.x( 0 )
        # 33: 110 -> 193
        if barrier: U.barrier()
        if 33 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5, 7] , 0 )
            U.mct( [1, 2, 4, 5, 7] , 3 )
            U.mct( [1, 2, 4, 5, 7] , 6 )
            U.x( 4 )
            U.x( 2 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.x( 1 )
        # 34: 193 -> 31
        if barrier: U.barrier()
        if 34 <= r - trnc_lv:
            U.x( 7 )
            U.mct( [1, 2, 3, 4, 6, 7] , 0 )
            U.mct( [1, 2, 3, 4, 6, 7] , 5 )
            U.x( 7 )
            #
            U.x( 7 )
            U.mct( [0, 1, 2, 3, 7] , 6 )
            U.x( 7 )
        # 35: 31 -> 124
        if barrier: U.barrier()
        if 35 <= r - trnc_lv:
            U.x( 6 )
            U.mct( [2, 3, 4, 6, 7] , 0 )
            U.mct( [2, 3, 4, 6, 7] , 1 )
            U.mct( [2, 3, 4, 6, 7] , 5 )
            U.x( 6 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.mct( [0, 1, 2, 3, 5] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 36: 124 -> 2
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
            U.mct( [1, 2, 3, 4, 5] , 0 )
            U.mct( [1, 2, 3, 4, 5] , 6 )
            U.x( 5 )
            U.x( 4 )
            U.x( 3 )
            U.x( 2 )
        if barrier: U.barrier()
    return U

def U1_N247_a2(U, u_ver, trnc_lv,  barrier=False):
    """U1 Modular Exponentiation Operator for N=247 a=2 r=36."""        
    a = 2
    r = 36
    if u_ver == 0 or u_ver == 1:
        # r=36
        # 1 -> 2 -> 4 -> 8 -> 16 -> 32 -> 64 -> 128 -> 9 ->
        # 18 -> 36 -> 72 -> 144 -> 41 -> 82 -> 164 -> 81 ->
        # 162 -> 77 -> 154 -> 61 -> 122 -> 244 -> 241 -> 235 ->
        # 223 [truncation] -> 199 -> 151 -> 55 -> 110 -> 220 ->
        # 193 -> 139 -> 31 ->  62-> 124 -> 1
        #
        # U1 r=36
        # 1: 1 -> 2
        if barrier: U.barrier()
        U.swap(0,1)
        # 2: 2 -> 4
        if barrier: U.barrier()
        U.swap(0,2)
        # 3: 4 -> 8
        if barrier: U.barrier()
        U.swap(0,3)
        # 4: 8 -> 16
        if barrier: U.barrier()
        U.swap(0,4)
        # 5: 16 -> 32
        if barrier: U.barrier()
        U.swap(0,5)
        # 6: 32 -> 64
        if barrier: U.barrier()
        U.swap(0,6)
        # 7: 64 -> 28
        # automatic
        if barrier: U.barrier()
        # 8: 128 -> 9
        if barrier: U.barrier()
        U.swap(0,7)
        #
        U.cx(0,3)
        # 9: 9 -> 18
        # automatic
        if barrier: U.barrier()
        # 10: 18 -> 36
        # automatic        
        if barrier: U.barrier()
        # 11: 36 -> 72
        # automatic        
        if barrier: U.barrier()
        # 12: 72 -> 144
        # automatic        
        if barrier: U.barrier()
        # 13: 144 -> 41
        # automatic        
        if barrier: U.barrier()
        # 14: 41 -> 82
        # automatic        
        if barrier: U.barrier()
        # 15: 82 -> 164
        if barrier: U.barrier()
        U.x(1)
        U.mct([0, 1, 6], 4)
        U.x(1)
        # 16: 164 -> 81
        # automatic 
        if barrier: U.barrier()
        # 17: 81 -> 162
        # automatic 
        if barrier: U.barrier()
        # 18: 162 -> 77
        if barrier: U.barrier()
        U.x(1)
        U.mct([0, 1, 2], 4)
        U.x(1)
        # 19: 77 -> 154
        # automatic 
        if barrier: U.barrier()
        # 20: 154 -> 61
        if barrier: U.barrier()
        U.x(1)
        U.mct([0, 1, 2, 5], 4)
        U.x(1)
        # 21: 61 -> 122
        # automatic 
        if barrier: U.barrier()
        # 22: 122 -> 244
        # automatic 
        if barrier: U.barrier()
        # 23: 244 -> 241
        # automatic 
        if barrier: U.barrier()
        # 24: 241 -> 235
        # automatic 
        if barrier: U.barrier()
        # 25: 235 -> 223
        # automatic 
        if barrier: U.barrier()
        # 26: 223 -> 199 # **xx ??
        if barrier: U.barrier()
        U.x(3)
        U.mct([0, 1, 2, 3], 6)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 4)
        U.x(3)
        # 27: 199 -> 151
        if barrier: U.barrier()
        U.x(3)
        U.mct([0, 1, 2, 3, 4], 6)
        U.mct([0, 1, 2, 3, 4], 5)
        U.x(3)
        # 28: 151 -> 55
        # automatic
        if barrier: U.barrier()
        # 29: 55 -> 110
        # automatic
        if barrier: U.barrier()
        # 30: 110 -> 220
        # automatic
        if barrier: U.barrier()
        # 31: 220 -> 193
        if barrier: U.barrier()
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6, 7], 5)
        U.mct([0, 1, 6, 7], 4)
        U.x(1)
        U.x(6)
        #
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4, 7], 6)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        # 32: 193 -> 139
        # automatic        
        if barrier: U.barrier()
        # 33: 139 -> 31
        # automatic        
        if barrier: U.barrier()
        # 34: 31 -> 62
        # automatic        
        if barrier: U.barrier()
        # 35: 62 -> 124
        # automatic        
        if barrier: U.barrier()
        # 36: 124 -> 1
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3, 7], 4)
        U.mct([0, 1, 2, 3, 7], 5)
        U.mct([0, 1, 2, 3, 7], 6)
        U.x(0)
        U.x(1)
        U.x(2)
        #
        U.x(1)
        U.x(2)
        U.x(4)
        U.x(6)
        U.mct([1, 2, 3, 4, 6, 7], 0)
        U.x(1)
        U.x(2)
        U.x(4)
        U.x(6)
        #
        U.x(1)
        U.x(2)
        U.x(6)
        U.mct([0, 1, 2, 6, 7], 3)
        U.x(1)
        U.x(2)
        U.x(6)
        #
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        U.mct([0, 1, 2, 3, 4, 5, 6], 7)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U1 r=36
        # 1: 1 -> 2
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.swap(0,1)
        # 2: 2 -> 4
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.swap(0,2)
        # 3: 4 -> 8
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.swap(0,3)
        # 4: 8 -> 16
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.swap(0,4)
        # 5: 16 -> 32
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.swap(0,5)
        # 6: 32 -> 64
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.swap(0,6)
        # 7: 64 -> 28
        # automatic
        if barrier: U.barrier()
        if 7 <= r - trnc_lv: pass
        # 8: 128 -> 9
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.swap(0,7)
            #
            U.cx(0,3)
        # 9: 9 -> 18
        # automatic
        if barrier: U.barrier()
        if 9 <= r - trnc_lv: pass
        # 10: 18 -> 36
        # automatic        
        if barrier: U.barrier()
        if 10 <= r - trnc_lv: pass
        # 11: 36 -> 72
        # automatic        
        if barrier: U.barrier()
        if 11 <= r - trnc_lv: pass
        # 12: 72 -> 144
        # automatic        
        if barrier: U.barrier()
        if 12 <= r - trnc_lv: pass
        # 13: 144 -> 41
        # automatic        
        if barrier: U.barrier()
        if 13 <= r - trnc_lv: pass
        # 14: 41 -> 82
        # automatic        
        if barrier: U.barrier()
        if 14 <= r - trnc_lv: pass
        # 15: 82 -> 164
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x(1)
            U.mct([0, 1, 6], 4)
            U.x(1)
        # 16: 164 -> 81
        # automatic 
        if barrier: U.barrier()
        if 16 <= r - trnc_lv: pass
        # 17: 81 -> 162
        # automatic 
        if barrier: U.barrier()
        if 17 <= r - trnc_lv: pass
        # 18: 162 -> 77
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x(1)
            U.mct([0, 1, 2], 4)
            U.x(1)
        # 19: 77 -> 154
        # automatic 
        if barrier: U.barrier()
        if 19 <= r - trnc_lv: pass
        # 20: 154 -> 61
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x(1)
            U.mct([0, 1, 2, 5], 4)
            U.x(1)
        # 21: 61 -> 122
        # automatic 
        if barrier: U.barrier()
        if 21 <= r - trnc_lv: pass
        # 22: 122 -> 244
        # automatic 
        if barrier: U.barrier()
        if 22 <= r - trnc_lv: pass
        # 23: 244 -> 241
        # automatic 
        if barrier: U.barrier()
        if 23 <= r - trnc_lv: pass
        # 24: 241 -> 235
        # automatic 
        if barrier: U.barrier()
        if 24 <= r - trnc_lv: pass
        # 25: 235 -> 223
        # automatic 
        if barrier: U.barrier()
        if 25 <= r - trnc_lv: pass
        # 26: 223 -> 199
        if barrier: U.barrier()
        if 26 <= r - trnc_lv:
            U.x(3)
            U.mct([0, 1, 2, 3], 6)
            U.mct([0, 1, 2, 3], 5)
            U.mct([0, 1, 2, 3], 4)
            U.x(3)
        # 27: 199 -> 151
        if barrier: U.barrier()
        if 27 <= r - trnc_lv:
            U.x(3)
            U.mct([0, 1, 2, 3, 4], 6)
            U.mct([0, 1, 2, 3, 4], 5)
            U.x(3)
        # 28: 151 -> 55
        # automatic
        if barrier: U.barrier()
        if 28 <= r - trnc_lv: pass
        # 29: 55 -> 110
        # automatic
        if barrier: U.barrier()
        if 29 <= r - trnc_lv: pass
        # 30: 110 -> 220
        # automatic
        if barrier: U.barrier()
        if 30 <= r - trnc_lv: pass
        # 31: 220 -> 193
        if barrier: U.barrier()
        if 31 <= r - trnc_lv:
            U.x(1)
            U.x(6)
            U.mct([0, 1, 6, 7], 5)
            U.mct([0, 1, 6, 7], 4)
            U.x(1)
            U.x(6)
            #
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
            U.mct([0, 1, 2, 3, 4, 7], 6)
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
        # 32: 193 -> 139
        # automatic        
        if barrier: U.barrier()
        if 32 <= r - trnc_lv: pass
        # 33: 139 -> 31
        # automatic        
        if barrier: U.barrier()
        if 33 <= r - trnc_lv: pass
        # 34: 31 -> 62
        # automatic        
        if barrier: U.barrier()
        if 34 <= r - trnc_lv: pass
        # 35: 62 -> 124
        # automatic        
        if barrier: U.barrier()
        if 35 <= r - trnc_lv: pass
        # 36: 124 -> 1
        if barrier: U.barrier()
        if 36 <= r - trnc_lv:
            U.x(0)
            U.x(1)
            U.x(2)
            U.mct([0, 1, 2, 3, 7], 4)
            U.mct([0, 1, 2, 3, 7], 5)
            U.mct([0, 1, 2, 3, 7], 6)
            U.x(0)
            U.x(1)
            U.x(2)
            #
            U.x(1)
            U.x(2)
            U.x(4)
            U.x(6)
            U.mct([1, 2, 3, 4, 6, 7], 0)
            U.x(1)
            U.x(2)
            U.x(4)
            U.x(6)
            #
            U.x(1)
            U.x(2)
            U.x(6)
            U.mct([0, 1, 2, 6, 7], 3)
            U.x(1)
            U.x(2)
            U.x(6)
            #
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
            U.x(5)
            U.x(6)
            U.mct([0, 1, 2, 3, 4, 5, 6], 7)
            U.x(1)
            U.x(2)
            U.x(3)
            U.x(4)
            U.x(5)
            U.x(6)
        if barrier: U.barrier()
    return U
