######### Modular Exponentiation Operators (MEO's) ######### 

# N=35 a=2 r=6 m=5 => U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U32_N21_a2(U, u_ver, trnc_lv, barrier=False): # same as U4
    """U32 for N=21 a=2 r=6."""
    a = 2
    r = 6    
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    return U

def U16_N21_a2(U, u_ver, trnc_lv, barrier=False): # same as U4
    """U16 for N=21 a=2 r=6."""
    a = 2
    r = 6
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N21_a2(U, u_ver, trnc_lv, barrier)
    elif u_ver == 1:
        # U16 same as U4
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.cx(0, 4)
        U.cx(4, 0)
        U.cx(0, 4)
        # 2: 16 -> 4
        if barrier: U.barrier()        
        U.x( 4 )
        U.cx( 4 , 0 )
        U.cx( 4 , 2 )
        U.x( 4 )
        # 3: 4 -> 1
        if barrier: U.barrier()
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        # 4: 2 -> 11
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 2 )
        U.x( 0 )
        # 5: 11 -> 8
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 4 )
        # 6: 8 -> 2
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U16 same as U4
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 4)
            U.cx(4, 0)
            U.cx(0, 4)
        # 2: 16 -> 4
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 0 )
            U.cx( 4 , 2 )
            U.x( 4 )
        # 3: 4 -> 1
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
        # 4: 2 -> 11
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 4 )
            U.x( 2 )
            U.x( 0 )
        # 5: 11 -> 8
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 4 )
        # 6: 8 -> 2
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U8_N21_a2(U, u_ver, trnc_lv, barrier=False): # same as U2
    """U8 for N=21 a=2 r=6."""
    a = 2
    r = 6
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N21_a2(U, u_ver, trnc_lv, barrier)
    elif u_ver ==1:
        # U8 same as U2
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 4
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(2, 0)
        U.cx(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()        
        U.x( 2 )
        U.cx( 2 , 0 )
        U.cx( 2 , 4 )
        U.x( 2 )
        # 3: 16 -> 1
        if barrier: U.barrier()        
        # automatic
        # 4: 2 -> 8
        if barrier: U.barrier()        
        U.x( 2 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 2 )
        #
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 2 )
        U.x( 0 )
        # 5: 8 -> 11
        if barrier: U.barrier()
        U.ccx( 0 , 3 , 1 )
        U.ccx( 0 , 3 , 4 )
        # 6: 11 -> 2
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 0 )
        if barrier: U.barrier()        
    elif u_ver ==2:
        # U8 same as U2
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 4
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:                
            U.cx(0, 2)
            U.cx(2, 0)
            U.cx(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()        
        if 2 <= r - trnc_lv:
            U.x( 2 )
            U.cx( 2 , 0 )
            U.cx( 2 , 4 )
            U.x( 2 )
        # 3: 16 -> 1
        if barrier: U.barrier()
        # automatic
        if 3 <= r - trnc_lv: pass
        # 4: 2 -> 8
        if barrier: U.barrier()        
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 4 )
            U.x( 2 )
            U.x( 0 )
        # 5: 8 -> 11
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx( 0 , 3 , 1 )
            U.ccx( 0 , 3 , 4 )
        # 6: 11 -> 2
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.x( 0 )
        if barrier: U.barrier()        
    return U

def U4_N21_a2(U, u_ver, trnc_lv, barrier=False):
    """U4 for N=21 a=2 r=6."""        
    a = 2
    r = 6
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N21_a2(U, u_ver, trnc_lv, barrier)
    elif u_ver == 1:
        # U4 same as U16
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 16
        if barrier: U.barrier()
        U.cx(0, 4)
        U.cx(4, 0)
        U.cx(0, 4)
        # 2: 16 -> 4
        if barrier: U.barrier()        
        U.x( 4 )
        U.cx( 4 , 0 )
        U.cx( 4 , 2 )
        U.x( 4 )
        # 3: 4 -> 1
        if barrier: U.barrier()
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        # 4: 2 -> 11
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 2 )
        U.x( 0 )
        # 5: 11 -> 8
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 4 )
        # 6: 8 -> 2
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 0 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # U4 same as U16
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 16
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 4)
            U.cx(4, 0)
            U.cx(0, 4)
        # 2: 16 -> 4
        if barrier: U.barrier()        
        if 2 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 0 )
            U.cx( 4 , 2 )
            U.x( 4 )
        # 3: 4 -> 1
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
        # 4: 2 -> 11
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 4 )
            U.x( 2 )
            U.x( 0 )
        # 5: 11 -> 8
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [2, 3, 4] , 0 )
            U.mct( [2, 3, 4] , 1 )
            U.x( 4 )
        # 6: 8 -> 2
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.x( 0 )
        if barrier: U.barrier()
    return U

def U2_N21_a2(U, u_ver, trnc_lv, barrier=False):
    """U2 for N=21 a=2 r=6."""        
    a = 2
    r = 6
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N21_a2(U, u_ver, trnc_lv, barrier)
    if u_ver == 1:
        # U2 same as U8
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 4
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(2, 0)
        U.cx(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()        
        U.x( 2 )
        U.cx( 2 , 0 )
        U.cx( 2 , 4 )
        U.x( 2 )
        # 3: 16 -> 1
        # automatic        
        if barrier: U.barrier()
        # 4: 2 -> 8
        if barrier: U.barrier()        
        U.x( 2 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 2 )
        #
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 2 )
        U.x( 0 )
        # 5: 8 -> 11
        if barrier: U.barrier()
        U.ccx( 0 , 3 , 1 )
        U.ccx( 0 , 3 , 4 )
        # 6: 11 -> 2
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 0 )
        if barrier: U.barrier()        
    if u_ver == 2:
        # U2 same as U8
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2 x
        # 1: 1 -> 4
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:                
            #U.swap(0, 2)
            U.cx(0, 2)
            U.cx(2, 0)
            U.cx(0, 2)
        # 2: 4 -> 16
        if barrier: U.barrier()        
        if 2 <= r - trnc_lv:
            U.x( 2 )
            U.cx( 2 , 0 )
            U.cx( 2 , 4 )
            U.x( 2 )
        # 3: 16 -> 1
        # automatic        
        if barrier: U.barrier()
        if 3 <= r - trnc_lv: pass
        # 4: 2 -> 8
        if barrier: U.barrier()        
        if 4 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [1, 2, 4] , 0 )
            U.mct( [1, 2, 4] , 3 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 4 )
            U.x( 2 )
            U.x( 0 )
        # 5: 8 -> 11
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx( 0 , 3 , 1 )
            U.ccx( 0 , 3 , 4 )
        # 6: 11 -> 2
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 0 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 3 )
            U.x( 0 )
        if barrier: U.barrier()        
    return U

def U1_N21_a2(U, u_ver, trnc_lv, barrier=False):
    """U1 Modular Exponentiation Operator for N=21 a=2 r=6."""        
    # 1 ->  2 -> 4 -> 8 -> 16 -> 11 -> 1
    a = 2
    r = 6
    if u_ver == 0 or u_ver == 1:
        if barrier: U.barrier()
        # 1: 1 -> 2
        U.swap(0, 1)
        if barrier: U.barrier()
        # 2: 2 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()
        # 3: 2 -> 8
        U.swap(0, 3)
        if barrier: U.barrier()
        # 4: 8 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()
        # 5: 16 -> 11
        U.ccx(0, 1, 3)
        U.x(4)
        U.ccx(0, 4, 1)
        U.x(4)
        U.ccx(0, 1, 3)
        if barrier: U.barrier()
        # 6: 11 -> 1
        U.x(3)
        U.mct([1,2,3,4], 0)
        U.x(3)
        #
        U.mct([0,1,2], 4)
        #
        U.x(4)
        U.x(3)
        U.mct([0,3,4],2)
        U.mct([0,3,4],1)    
        U.x(4)
        U.x(3)
        if barrier: U.barrier()            
    elif u_ver == 2:
        if barrier: U.barrier()
        # 1: 1 -> 2
        if 1 <= r - trnc_lv:        
            U.swap(0, 1)
        if barrier: U.barrier()
        # 2: 2 -> 4
        if 2 <= r - trnc_lv:
            U.swap(0, 2)
        if barrier: U.barrier()
        # 3: 2 -> 8
        if 3 <= r - trnc_lv:
            U.swap(0, 3)
        if barrier: U.barrier()
        # 4: 8 -> 16
        if 4 <= r - trnc_lv:
            U.swap(0, 4)
        if barrier: U.barrier()
        # 5: 16 -> 11
        if 5 <= r - trnc_lv:
            U.ccx(0, 1, 3)
            U.x(4)
            U.ccx(0, 4, 1)
            U.x(4)
            U.ccx(0, 1, 3)
        if barrier: U.barrier()
        # 6: 11 -> 1
        if 6 <= r - trnc_lv:
            U.x(3)
            U.mct([1,2,3,4], 0)
            U.x(3)
            #
            U.mct([0,1,2], 4)
            #
            U.x(4)
            U.x(3)
            U.mct([0,3,4],2)
            U.mct([0,3,4],1)    
            U.x(4)
            U.x(3)
        if barrier: U.barrier()            
    return U
