######### Modular Exponentiation Operators (MEO's) ######### 

# N=143 a=5 r=20 m=8 => U128, U64, U32, U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U512_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """ U128 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 512
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1: 1 -> 14
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(1, 0)
        # 2: 14 -> 53
        if barrier: U.barrier()
        U.cx( 0 , 1 )
        U.cx( 0 , 3 )
        U.cx( 0 , 4 )
        U.cx( 0 , 5 )
        # 3: 53 -> 27
        if barrier: U.barrier()
        U.x( 2 )
        U.ccx( 1 , 2 , 0 )
        U.ccx( 1 , 2 , 5 )
        U.x( 2 )
        # 4: 27 -> 92
        if barrier: U.barrier()
        U.mct( [2, 3, 5] , 0 )
        U.mct( [2, 3, 5] , 1 )
        U.mct( [2, 3, 5] , 4 )
        U.mct( [2, 3, 5] , 6 )
        #
        U.x( 1 )
        U.x( 0 )
        U.ccx( 0 , 1 , 5 )
        U.x( 1 )
        U.x( 0 )
        # 5: 92 -> 1
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 5, 6] , 0 )
        U.mct( [1, 5, 6] , 2 )
        U.mct( [1, 5, 6] , 3 )
        U.mct( [1, 5, 6] , 4 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 2 )
        U.x( 1 )
        # cycle 2
        # 6: 5 -> 70
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [1, 4, 5] , 0 )
        U.mct( [1, 4, 5] , 2 )
        U.mct( [1, 4, 5] , 3 )
        U.mct( [1, 4, 5] , 6 )
        U.x( 4 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 3] , 5 )
        U.x( 3 )
        U.x( 0 )
        # 7: 70 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [1, 2, 5] , 0 )
        U.mct( [1, 2, 5] , 3 )
        U.mct( [1, 2, 5] , 4 )
        U.x( 2 )
        # 8: 122 -> 135
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4, 5] , 1 )
        U.mct( [0, 3, 4, 5] , 2 )
        U.mct( [0, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        #
        U.mct( [0, 1, 2] , 5 )
        # 9: 135 -> 31
        if barrier: U.barrier()
        U.mct( [0, 1, 3, 7] , 2 )
        U.mct( [0, 1, 3, 7] , 4 )
        U.mct( [0, 1, 3, 7] , 5 )
        #
        U.mct( [0, 1, 2, 3] , 7 )
        # 10: 31 -> 5
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 3, 4, 6, 7] , 0 )
        U.mct( [2, 3, 4, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 3, 4] , 2 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        # cycle 3
        # 11: 25 -> 64
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 6] , 1 )
        U.mct( [0, 3, 6] , 2 )
        U.mct( [0, 3, 6] , 4 )
        U.mct( [0, 3, 6] , 5 )
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 12: 64 -> 38
        if barrier: U.barrier()
        U.mct( [2, 5, 6] , 0 )
        U.mct( [2, 5, 6] , 1 )
        U.mct( [2, 5, 6] , 3 )
        U.mct( [2, 5, 6] , 4 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 3 )
        U.x( 0 )
        # 13: 38 -> 103
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.mct( [0, 1, 2, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        #
        U.x( 3 )
        U.mct( [0, 2, 3, 6] , 1 )
        U.mct( [0, 2, 3, 6] , 4 )
        U.mct( [0, 2, 3, 6] , 5 )
        U.x( 3 )
        # 14: 103 -> 12
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 15: 12 -> 25
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 4, 5, 6] , 0 )
        U.mct( [1, 4, 5, 6] , 2 )
        U.mct( [1, 4, 5, 6] , 3 )
        U.x( 6 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        # cycle 4
        # 16: 125 -> 34
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.mct( [1, 2, 3] , 5 )
        U.mct( [1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 2 )
        # 17: 34 -> 47
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.x( 4 )
        # 18: 47 -> 86
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 7] , 1 )
        U.mct( [0, 3, 7] , 2 )
        U.mct( [0, 3, 7] , 4 )
        U.mct( [0, 3, 7] , 5 )
        U.mct( [0, 3, 7] , 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 3 )
        U.x( 0 )
        # 19: 86 -> 60
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5] , 1 )
        U.x( 0 )
        # 20: 60 -> 125
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 6] , 0 )
        U.mct( [1, 2, 3, 5, 6] , 4 )
        U.x( 1 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle 1
        # 1: 1 -> 14
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(1, 0)
        # 2: 14 -> 53
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.cx( 0 , 1 )
            U.cx( 0 , 3 )
            U.cx( 0 , 4 )
            U.cx( 0 , 5 )
        # 3: 53 -> 27
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 2 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 5 )
            U.x( 2 )
        # 4: 27 -> 92
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.mct( [2, 3, 5] , 0 )
            U.mct( [2, 3, 5] , 1 )
            U.mct( [2, 3, 5] , 4 )
            U.mct( [2, 3, 5] , 6 )
            #
            U.x( 1 )
            U.x( 0 )
            U.ccx( 0 , 1 , 5 )
            U.x( 1 )
            U.x( 0 )
        # 5: 92 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 5, 6] , 0 )
            U.mct( [1, 5, 6] , 2 )
            U.mct( [1, 5, 6] , 3 )
            U.mct( [1, 5, 6] , 4 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 2
        # 6: 5 -> 70
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [1, 4, 5] , 0 )
            U.mct( [1, 4, 5] , 2 )
            U.mct( [1, 4, 5] , 3 )
            U.mct( [1, 4, 5] , 6 )
            U.x( 4 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3] , 5 )
            U.x( 3 )
            U.x( 0 )
        # 7: 70 -> 122
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 2 )
            U.mct( [1, 2, 5] , 0 )
            U.mct( [1, 2, 5] , 3 )
            U.mct( [1, 2, 5] , 4 )
            U.x( 2 )
        # 8: 122 -> 135
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 3, 4, 5] , 1 )
            U.mct( [0, 3, 4, 5] , 2 )
            U.mct( [0, 3, 4, 5] , 7 )
            U.x( 4 )
            U.x( 3 )
            #
            U.mct( [0, 1, 2] , 5 )
        # 9: 135 -> 31
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.mct( [0, 1, 3, 7] , 2 )
            U.mct( [0, 1, 3, 7] , 4 )
            U.mct( [0, 1, 3, 7] , 5 )
            #
            U.mct( [0, 1, 2, 3] , 7 )
        # 10: 31 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 3, 4, 6, 7] , 0 )
            U.mct( [2, 3, 4, 6, 7] , 1 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 3, 4] , 2 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
        # cycle 3
        # 11: 25 -> 64
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 6] , 1 )
            U.mct( [0, 3, 6] , 2 )
            U.mct( [0, 3, 6] , 4 )
            U.mct( [0, 3, 6] , 5 )
            U.x( 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 12: 64 -> 38
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.mct( [2, 5, 6] , 0 )
            U.mct( [2, 5, 6] , 1 )
            U.mct( [2, 5, 6] , 3 )
            U.mct( [2, 5, 6] , 4 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 13: 38 -> 103
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.mct( [0, 1, 2, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 3 )
            U.mct( [0, 2, 3, 6] , 1 )
            U.mct( [0, 2, 3, 6] , 4 )
            U.mct( [0, 2, 3, 6] , 5 )
            U.x( 3 )
        # 14: 103 -> 12
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 15: 12 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 4, 5, 6] , 0 )
            U.mct( [1, 4, 5, 6] , 2 )
            U.mct( [1, 4, 5, 6] , 3 )
            U.x( 6 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 34
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.mct( [1, 2, 3] , 5 )
            U.mct( [1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 2 )
        # 17: 34 -> 47
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 6 )
            U.x( 4 )
        # 18: 47 -> 86
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 7] , 1 )
            U.mct( [0, 3, 7] , 2 )
            U.mct( [0, 3, 7] , 4 )
            U.mct( [0, 3, 7] , 5 )
            U.mct( [0, 3, 7] , 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 3 )
            U.x( 0 )
        # 19: 86 -> 60
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5] , 1 )
            U.x( 0 )
        # 20: 60 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 6] , 0 )
            U.mct( [1, 2, 3, 5, 6] , 4 )
            U.x( 1 )
        if barrier: U.barrier()        
    return U

def U256_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """ U128 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 256
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1: 1 -> 27
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 3)
        U.cx(0, 4)
        # 2: 27 -> 14
        if barrier: U.barrier()
        U.x( 4 )
        U.cx( 4 , 0 )
        U.cx( 4 , 1 )
        U.cx( 4 , 2 )
        U.cx( 4 , 3 )
        U.x( 4 )
        # 3: 14 -> 92
        if barrier: U.barrier()
        U.x( 1 )
        U.cx( 1 , 0 )
        U.cx( 1 , 2 )
        U.cx( 1 , 3 )
        U.cx( 1 , 4 )
        U.cx( 1 , 6 )
        U.x( 1 )
        # 4: 92 -> 53
        if barrier: U.barrier()
        U.x( 1 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 4 )
        U.ccx( 0 , 1 , 5 )
        U.x( 1 )
        # 5: 53 -> 1
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 2 )
        U.x( 1 )
        # cycle 2
        # 6: 5 -> 135
        if barrier: U.barrier()
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.mct( [0, 1, 2] , 7 )
        # 7: 135 -> 70
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.ccx( 0 , 3 , 1 )
        U.ccx( 0 , 3 , 2 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        U.x( 0 )
        # 8: 70 -> 31
        if barrier: U.barrier()
        U.mct( [1, 4, 7] , 0 )
        U.mct( [1, 4, 7] , 2 )
        U.mct( [1, 4, 7] , 3 )
        #
        U.mct( [0, 1, 2, 3] , 7 )
        # 9: 31 -> 122
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 2 )
        U.x( 0 )
        # 10: 122 -> 5
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 3, 4, 6, 7] , 0 )
        U.mct( [2, 3, 4, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 3, 4] , 2 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        # cycle 3
        # 11: 25 -> 103
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 2, 4, 5] , 1 )
        U.mct( [0, 2, 4, 5] , 3 )
        U.x( 4 )
        # 12: 103 -> 64
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 7] , 1 )
        U.mct( [0, 3, 7] , 2 )
        U.mct( [0, 3, 7] , 5 )
        U.mct( [0, 3, 7] , 6 )
        U.x( 3 )
        U.x( 0 )
        #
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        # 13: 64 -> 12
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4, 7] , 1 )
        U.mct( [0, 3, 4, 7] , 2 )
        U.mct( [0, 3, 4, 7] , 5 )
        U.x( 4 )
        U.x( 0 )
        #
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        # 14: 12 -> 38
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 3 )
        U.mct( [1, 3, 6, 7] , 0 )
        U.mct( [1, 3, 6, 7] , 2 )
        U.mct( [1, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 6 )
        U.x( 3 )
        # 15: 38 -> 25
        if barrier: U.barrier()
        U.mct( [0, 3, 6] , 1 )
        U.mct( [0, 3, 6] , 2 )
        U.mct( [0, 3, 6] , 5 )
        #
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 2 )
        U.x( 1 )
        # cycle 4
        # 16: 125 -> 86
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 6] , 0 )
        U.mct( [1, 2, 3, 5, 6] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        #
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 3 )
        U.x( 0 )
        # 17: 86 -> 34
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 5, 7] , 1 )
        U.mct( [0, 3, 5, 7] , 2 )
        U.mct( [0, 3, 5, 7] , 4 )
        U.x( 3 )
        U.x( 0 )
        # 18: 34 -> 60
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        #
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.mct( [1, 2, 3, 4, 7] , 5 )
        U.mct( [1, 2, 3, 4, 7] , 6 )
        U.x( 1 )
        #
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        # 19: 60 -> 47
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 6, 7] , 0 )
        U.mct( [1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        #
        U.x( 4 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 6 )
        U.x( 4 )
        # 20: 47 -> 125
        if barrier: U.barrier()
        U.mct( [2, 3, 6, 7] , 0 )
        U.mct( [2, 3, 6, 7] , 1 )
        U.mct( [2, 3, 6, 7] , 4 )
        U.mct( [2, 3, 6, 7] , 5 )
        #
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 1 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # cycle 1
        # 1: 1 -> 27
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 3)
            U.cx(0, 4)
        # 2: 27 -> 14
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 0 )
            U.cx( 4 , 1 )
            U.cx( 4 , 2 )
            U.cx( 4 , 3 )
            U.x( 4 )
        # 3: 14 -> 92
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 1 )
            U.cx( 1 , 0 )
            U.cx( 1 , 2 )
            U.cx( 1 , 3 )
            U.cx( 1 , 4 )
            U.cx( 1 , 6 )
            U.x( 1 )
        # 4: 92 -> 53
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x( 1 )
            U.ccx( 0 , 1 , 2 )
            U.ccx( 0 , 1 , 4 )
            U.ccx( 0 , 1 , 5 )
            U.x( 1 )
        # 5: 53 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 2
        # 6: 5 -> 135
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.mct( [0, 1, 2] , 3 )
            U.mct( [0, 1, 2] , 4 )
            U.mct( [0, 1, 2] , 7 )
        # 7: 135 -> 70
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.ccx( 0 , 3 , 1 )
            U.ccx( 0 , 3 , 2 )
            U.ccx( 0 , 3 , 7 )
            U.x( 3 )
            U.x( 0 )
        # 8: 70 -> 31
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.mct( [1, 4, 7] , 0 )
            U.mct( [1, 4, 7] , 2 )
            U.mct( [1, 4, 7] , 3 )
            #
            U.mct( [0, 1, 2, 3] , 7 )
        # 9: 31 -> 122
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 4 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 0 )
        # 10: 122 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 3, 4, 6, 7] , 0 )
            U.mct( [2, 3, 4, 6, 7] , 1 )
            U.x( 7 )
            U.x( 6 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 3, 4] , 2 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
        # cycle 3
        # 11: 25 -> 103
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 2, 4, 5] , 1 )
            U.mct( [0, 2, 4, 5] , 3 )
            U.x( 4 )
        # 12: 103 -> 64
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 7] , 1 )
            U.mct( [0, 3, 7] , 2 )
            U.mct( [0, 3, 7] , 5 )
            U.mct( [0, 3, 7] , 6 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 7 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 13: 64 -> 12
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4, 7] , 1 )
            U.mct( [0, 3, 4, 7] , 2 )
            U.mct( [0, 3, 4, 7] , 5 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 14: 12 -> 38
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 7 )
            U.x( 6 )
            U.x( 3 )
            U.mct( [1, 3, 6, 7] , 0 )
            U.mct( [1, 3, 6, 7] , 2 )
            U.mct( [1, 3, 6, 7] , 5 )
            U.x( 7 )
            U.x( 6 )
            U.x( 3 )
        # 15: 38 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.mct( [0, 3, 6] , 1 )
            U.mct( [0, 3, 6] , 2 )
            U.mct( [0, 3, 6] , 5 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 86
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 6] , 0 )
            U.mct( [1, 2, 3, 5, 6] , 4 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.x( 3 )
            U.x( 0 )
        # 17: 86 -> 34
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 5, 7] , 1 )
            U.mct( [0, 3, 5, 7] , 2 )
            U.mct( [0, 3, 5, 7] , 4 )
            U.x( 3 )
            U.x( 0 )
        # 18: 34 -> 60
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            #
            U.x( 1 )
            U.mct( [1, 2, 3, 4, 7] , 0 )
            U.mct( [1, 2, 3, 4, 7] , 5 )
            U.mct( [1, 2, 3, 4, 7] , 6 )
            U.x( 1 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5] , 7 )
            U.x( 1 )
            U.x( 0 )
        # 19: 60 -> 47
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 4, 5, 6, 7] , 0 )
            U.mct( [1, 2, 4, 5, 6, 7] , 3 )
            U.x( 7 )
            U.x( 5 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.mct( [0, 2, 3, 4] , 1 )
            U.mct( [0, 2, 3, 4] , 5 )
            U.mct( [0, 2, 3, 4] , 6 )
            U.x( 4 )
        # 20: 47 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.mct( [2, 3, 6, 7] , 0 )
            U.mct( [2, 3, 6, 7] , 1 )
            U.mct( [2, 3, 6, 7] , 4 )
            U.mct( [2, 3, 6, 7] , 5 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 1 )
        if barrier: U.barrier()
    return U

def U128_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """ U128 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 128
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1 same as U8
        # 1 -> 92 -> 27 -> 14 -> 1
        if barrier: U.barrier()
        # 1 -> 92
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 6)
        U.cx(2, 0)
        if barrier:  U.barrier()
        # 92 -> 27
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 6)
        if barrier: U.barrier()
        # 27 -> 53
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)            
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()
        # 53 -> 14
        U.x(4)
        U.cx(4, 1)
        U.cx(4, 5)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 1
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 3)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 5)
        U.mct([0, 1, 2], 6)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2 same as U8
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 5 -> 31
        # automatic
        # 31 -> 135
        U.x(6)
        U.mct([1, 5, 6], 7)
        U.x(6)
        U.cx(7, 5)
        if barrier: U.barrier()
        # 135 -> 122
        U.ccx(7, 5, 2)
        U.ccx(7, 5, 1)
        U.ccx(7, 5, 0)
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 70
        U.x(4)
        U.x(6)
        U.mct([4, 5, 6], 3)
        U.mct([4, 5, 6], 2)
        U.mct([4, 5, 6], 1)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 5
        U.cswap(7, 2, 1)
        U.x(1)
        U.x(4)
        U.mct([0,1, 2, 4], 7)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U128
        # cycle 1 same as U8
        # 1 -> 92 -> 27 -> 14 -> 1
        # 1: 1 -> 92
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(0, 4)
            U.cx(0, 6)
            U.cx(2, 0)
        # 2: 92 -> 27
        if barrier:  U.barrier()
        if 2 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 6)
        # 3: 27 -> 53
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(0)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 5)
            U.ccx(0, 1, 6)            
            U.x(0)
            U.cx(5, 0)
            U.cx(5, 1)
        # 4: 53 -> 14
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(4)
            U.cx(4, 1)
            U.cx(4, 5)
            U.x(4)
        # 5: 14 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx(5, 6, 1)
            U.ccx(5, 6, 3)
            U.x(1)
            U.x(2)
            U.mct([0, 1, 2], 5)
            U.mct([0, 1, 2], 6)
            U.x(1)
            U.x(2)
        # cycle 2 same as U8
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 6: 5 -> 31
        if barrier: U.barrier()        
        # automatic
        if 6 <= r - trnc_lv: pass
        # 7: 31 -> 135
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x(6)
            U.mct([1, 5, 6], 7)
            U.x(6)
            U.cx(7, 5)
        # 8: 135 -> 122
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.ccx(7, 5, 2)
            U.ccx(7, 5, 1)
            U.ccx(7, 5, 0)
            U.x(0)
            U.x(2)
            U.mct([0, 1, 2, 3], 7)
            U.mct([0, 1, 2, 3], 6)
            U.x(0)
            U.x(2)
        # 9: 122 -> 70
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(4)
            U.x(6)
            U.mct([4, 5, 6], 3)
            U.mct([4, 5, 6], 2)
            U.mct([4, 5, 6], 1)
            U.x(4)
            U.x(6)
            #
            U.x(0)
            U.x(3)
            U.mct([0, 1, 2, 3], 5)
            U.mct([0, 1, 2, 3], 6)
            U.x(0)
            U.x(3)
        # 10: 70 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.cswap(7, 2, 1)
            U.x(1)
            U.x(4)
            U.mct([0,1, 2, 4], 7)
            U.x(1)
            U.x(4)
        # cycle 3
        # 11: 25 -> 12
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 12: 12 -> 103
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3, 5] , 2 )
            U.x( 3 )
        # 13: 103 -> 38
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.mct( [0, 2, 3, 5] , 4 )
            U.mct( [0, 2, 3, 5] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 14: 38 -> 64
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 15: 64 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.mct( [1, 2, 3] , 5 )
            U.mct( [1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 60
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:        
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5] , 3 )
            U.mct( [0, 1, 2, 4, 5] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 17: 60 -> 86
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4] , 2 )
            U.mct( [0, 1, 3, 4] , 5 )
            U.x( 3 )
            U.x( 0 )
        # 18: 86 -> 47
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            #
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
        # 19: 47 -> 34
        if barrier: U.barrier()
        if 19<= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 7] , 1 )
            U.mct( [0, 3, 4, 5, 7] , 2 )
            U.x( 4 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 20: 34 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.mct( [2, 4, 5, 6] , 0 )
            U.mct( [2, 4, 5, 6] , 1 )
            U.mct( [2, 4, 5, 6] , 3 )
        if barrier: U.barrier()
    return U

def U64_N143_a5(U, u_ver, trnc_lv,  barrier=False): 
    """ U64 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 64
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        if barrier: U.barrier()
        # 1 -> 53
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        if barrier: U.barrier()
        # 53 -> 92
        U.x(2)
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        U.cx(2, 6)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.cx(0, 2)
        U.x(0)
        if barrier: U.barrier()
        # 92 -> 14
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 4)            
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(4, 3, 2)
        U.ccx(4, 3, 1)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 27
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 4) 
        U.mct([0, 1, 6], 2) 
        U.x(0)
        U.x(1)
        U.x(6)
        if barrier: U.barrier()
        U.x(2)
        U.mct([2, 3, 4], 1)
        U.mct([2, 3, 4], 0)            
        U.x(2)
        if barrier: U.barrier()
        # 27 -> 1
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 122 -> 31 -> 70 -> 135 -> 5
        # 5 -> 122
        #[5, 122, 31, 70, 135] 
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 4)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 31
        U.x(3)
        U.mct([0, 1, 3], 2)
        U.mct([0, 1, 3], 4)
        U.mct([0, 1, 3], 5)
        U.x(3)
        U.mct([0, 1, 2], 3)
        if barrier: U.barrier()
        # 31 -> 70
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 4)
        U.mct([0, 1, 2, 3], 5)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 135
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 7)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        U.cx(7, 6)
        U.cx(7, 4)
        if barrier: U.barrier()
        # 135 -> 5
        U.x(0)
        U.ccx(0, 7, 5)
        U.ccx(0, 7, 4)
        U.ccx(0, 7, 3)
        U.ccx(0, 7, 2)
        U.x(0)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(6)
        U.mct([1, 2, 3, 6], 7)
        U.mct([1, 2, 3, 6], 0)            
        U.x(1)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U64
        # cycle 1
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        # 1: 1 -> 53
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 4)
            U.cx(0, 5)
        # 2: 53 -> 92
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 5 )
            U.cx( 5 , 0 )
            U.cx( 5 , 2 )
            U.cx( 5 , 3 )
            U.cx( 5 , 4 )
            U.cx( 5 , 6 )
            U.x( 5 )
        # 3: 92 -> 14
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 0 )
            U.cx( 4 , 1 )
            U.cx( 4 , 2 )
            U.cx( 4 , 3 )
            U.x( 4 )
        # 4: 14 -> 27
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 6 )
        # 5: 27 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 5 )
            U.x( 2 )
            U.x( 1 )
        # # cycle 2
        # 6: 5 -> 122
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
            U.ccx( 0 , 2 , 5 )
            U.ccx( 0 , 2 , 6 )
            U.x( 2 )
            U.x( 0 )
        # 7: 122 -> 31
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6] , 0 )
            U.mct( [3, 4, 5, 6] , 1 )
            U.mct( [3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            #
            U.mct( [0, 1, 2] , 3 )
        # 8: 31 -> 70
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 5 )
            U.mct( [0, 2, 3] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 9: 70 -> 135
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.mct( [0, 1, 3] , 6 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 3 )
        # 10: 135 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.mct( [0, 6, 7] , 1 )
            U.mct( [0, 6, 7] , 2 )
            U.mct( [0, 6, 7] , 3 )
            U.mct( [0, 6, 7] , 4 )
            U.mct( [0, 6, 7] , 5 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
        if barrier: U.barrier()  
        # # cycle 3
        # 11: 25 -> 38
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4, 6] , 1 )
            U.mct( [0, 3, 4, 6] , 2 )
            U.mct( [0, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 5] , 3 )
            U.mct( [0, 1, 2, 5] , 6 )
            U.x( 0 )
        # 12: 38 -> 12
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 13: 12 -> 64
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 5] , 1 )
            U.mct( [0, 2, 5] , 3 )
            U.mct( [0, 2, 5] , 4 )
            U.mct( [0, 2, 5] , 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 14: 64 -> 103
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.mct( [0, 1, 2, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 3 )
            U.mct( [0, 2, 3, 6] , 1 )
            U.mct( [0, 2, 3, 6] , 4 )
            U.mct( [0, 2, 3, 6] , 5 )
            U.x( 3 )
        # 15: 103 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6] , 0 )
            U.mct( [2, 4, 5, 6] , 1 )
            U.mct( [2, 4, 5, 6] , 3 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 47
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
        # 17: 47 -> 60
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5] , 2 )
            U.x( 1 )
            U.x( 0 )
        # 18: 60 -> 34
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 5, 6] , 1 )
            U.mct( [0, 2, 5, 6] , 3 )
            U.mct( [0, 2, 5, 6] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
        # 19: 34 -> 86
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 5 )
            U.mct( [1, 3, 5, 6] , 0 )
            U.mct( [1, 3, 5, 6] , 2 )
            U.mct( [1, 3, 5, 6] , 4 )
            U.x( 5 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 0 )
        # 20: 86 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5] , 1 )
            U.mct( [0, 2, 3, 4, 5] , 6 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 6] , 0 )
            U.mct( [1, 2, 3, 5, 6] , 4 )
            U.x( 1 )
        if barrier: U.barrier()  
    return U


def U32_N143_a5(U, u_ver, trnc_lv,  barrier=False): 
    """U32 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 14 -> 53 -> 27 -> 92
        if barrier: U.barrier()
        # 1 -> 14
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(1, 0)
        if barrier: U.barrier()
        # 14 -> 53
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        if barrier: U.barrier()            
        U.x(3)
        U.cx(3, 1)
        U.x(3)
        if barrier: U.barrier()            
        # 53 -> 27
        U.ccx(3, 4, 5)
        U.ccx(3, 4, 0)
        if barrier: U.barrier()            
        # 27 -> 92
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 3)
        U.cx(6, 0)
        U.cx(6, 1)
        if barrier: U.barrier()            
        # 91 -> 1
        U.ccx(5, 6, 0)
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 2)
        U.ccx(5, 6, 3)
        U.ccx(5, 6, 4)            
        if barrier: U.barrier()            
        U.x(1)
        U.x(2)
        U.ccx(1, 2, 5)
        U.ccx(1, 2, 6)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 70 -> 122 -> 135 -> 31 -> 5
        # 5 -> 70
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.x(5)
        U.mct([4, 5, 6], 2)
        U.x(4)
        U.x(5)
        if barrier: U.barrier()
        # 70 -> 122
        U.ccx(0, 6, 2)
        U.ccx(0, 6, 1)
        U.x(2)
        U.mct([1, 2, 6], 5)
        U.mct([1, 2, 6], 0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 135
        U.x(0)
        U.x(2)
        U.x(6)
        U.mct([0, 2, 6], 7)
        U.x(0)
        U.x(2)
        U.x(6)
        U.cx(7, 0)
        U.cx(7, 2)
        U.cx(7, 3)
        if barrier: U.barrier()
        # 135 -> 31
        U.ccx(7, 6, 5)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 3)
        U.ccx(7, 6, 2)
        U.ccx(7, 6, 0)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        if barrier: U.barrier()
        # 31 -> 5
        U.x(3)
        U.x(5)
        U.x(6)
        U.x(7)
        U.mct([7, 6, 5, 3, 1, 0], 4)
        U.mct([7, 6, 5, 3, 1, 0], 2)
        U.x(3)
        U.x(5)
        U.x(6)
        U.x(7)
        if barrier: U.barrier()
        U.x(7)
        U.x(4)
        U.mct([7, 4, 2, 0], 1)
        U.x(7)
        U.x(4)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U32
        # cycle 1
        # 1 -> 14 -> 53 -> 27 -> 92
        # 1: 1 -> 14
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(1, 0)
        # 2: 14 -> 53
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.ccx(0, 1, 3)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 5)
            #
            U.x(3)
            U.cx(3, 1)
            U.x(3)
        # 3: 53 -> 27
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.ccx(3, 4, 5)
            U.ccx(3, 4, 0)
        # 4: 27 -> 92
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.mct([0, 1, 2], 6)
            U.mct([0, 1, 2], 3)
            U.cx(6, 0)
            U.cx(6, 1)
        # 5: 91 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx(5, 6, 0)
            U.ccx(5, 6, 1)
            U.ccx(5, 6, 2)
            U.ccx(5, 6, 3)
            U.ccx(5, 6, 4)            
            #
            U.x(1)
            U.x(2)
            U.ccx(1, 2, 5)
            U.ccx(1, 2, 6)            
            U.x(1)
            U.x(2)
        # cycle 2
        # 5 -> 70 -> 122 -> 135 -> 31 -> 5
        # 6: 5 -> 70
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x(0)
            U.x(2)
            U.mct([0, 1, 2], 3)
            U.mct([0, 1, 2], 6)
            U.x(0)
            U.x(2)
            #
            U.x(4)
            U.x(5)
            U.mct([4, 5, 6], 2)
            U.x(4)
            U.x(5)
        # 7: 70 -> 122
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.ccx(0, 6, 2)
            U.ccx(0, 6, 1)
            U.x(2)
            U.mct([1, 2, 6], 5)
            U.mct([1, 2, 6], 0)
            U.x(2)
        # 8: 122 -> 135
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x(0)
            U.x(2)
            U.x(6)
            U.mct([0, 2, 6], 7)
            U.x(0)
            U.x(2)
            U.x(6)
            U.cx(7, 0)
            U.cx(7, 2)
            U.cx(7, 3)
        # 9: 135 -> 31
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.ccx(7, 6, 5)
            U.ccx(7, 6, 4)
            U.ccx(7, 6, 3)
            U.ccx(7, 6, 2)
            U.ccx(7, 6, 0)
            U.mct([0, 1, 2, 3], 7)
            U.mct([0, 1, 2, 3], 6)
        # 10: 31 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x(3)
            U.x(5)
            U.x(6)
            U.x(7)
            U.mct([7, 6, 5, 3, 1, 0], 4)
            U.mct([7, 6, 5, 3, 1, 0], 2)
            U.x(3)
            U.x(5)
            U.x(6)
            U.x(7)
            #
            U.x(7)
            U.x(4)
            U.mct([7, 4, 2, 0], 1)
            U.x(7)
            U.x(4)
        # cycle 3
        # 11: 25 -> 64
        if barrier: U.barrier()        
        if 11 <= r - trnc_lv:
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.mct( [0, 1, 3] , 6 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
        # 12: 64 -> 38
        if barrier: U.barrier()        
        if 12 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5] , 0 )
            U.mct( [3, 4, 5] , 1 )
            U.mct( [3, 4, 5] , 2 )
            U.x( 4 )
            U.x( 3 )
        # 13: 38 -> 103
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.mct( [1, 2, 4, 5] , 0 )
            U.mct( [1, 2, 4, 5] , 3 )
            U.mct( [1, 2, 4, 5] , 6 )
            #
            U.x( 3 )
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.x( 3 )
        # 14: 103 -> 12
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 6] , 1 )
            U.mct( [0, 3, 4, 5, 6] , 2 )
            U.x( 5 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 15: 12 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 5, 6] , 4 )
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [1, 4, 5, 6] , 0 )
            U.mct( [1, 4, 5, 6] , 2 )
            U.mct( [1, 4, 5, 6] , 3 )
            U.x( 6 )
            U.x( 5 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 34
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 5, 6] , 1 )
            U.mct( [0, 3, 5, 6] , 2 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 17: 34 -> 47
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.mct( [0, 1, 5, 6, 7] , 2 )
            U.mct( [0, 1, 5, 6, 7] , 3 )
            U.mct( [0, 1, 5, 6, 7] , 4 )
            U.x( 7 )
            U.x( 5 )
            #
            U.x( 4 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.x( 4 )
        # 18: 47 -> 86
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4] , 2 )
            U.mct( [0, 1, 3, 4] , 5 )
            U.mct( [0, 1, 3, 4] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 19: 86 -> 60
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 5] , 4 )
            U.mct( [0, 1, 2, 5] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 20: 60 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            U.mct( [1, 3, 4, 5, 6] , 0 )
            U.mct( [1, 3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.x( 1 )
            #
            U.x( 5 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5] , 3 )
            U.mct( [0, 1, 2, 4, 5] , 6 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.x( 1 )
        if barrier: U.barrier()
    return U

def U16_N143_a5(U, u_ver, trnc_lv,  barrier=False): # same as U4
    """U16 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 27 -> 14 -> 92 -> 53 -> 1
        if barrier: U.barrier()            
        # 1 -> 27 
        U.cx(0, 1)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()            
        # 27 -> 14
        U.x(1)
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.x(1)
        U.cx(2, 0)
        U.cx(2, 1)
        if barrier: U.barrier()            
        # 14 -> 92
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 6)
        U.x(1)
        U.cx(6, 0)
        if barrier: U.barrier()            
        # 92 -> 53
        U.x(0)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 5)
        U.mct([0, 1, 4], 3)
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()            
        # 53 -> 1
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)
        U.x(3)
        U.x(4)
        U.mct([0, 3, 4], 2)
        U.mct([0, 3, 4], 1)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 135 -> 70 -> 31 -> 122 -> 5
        # 5 -> 135
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 7)
        U.mct([0, 1, 6], 4)
        U.mct([0, 1, 6], 3)
        U.x(0)
        U.x(1)
        U.x(6)
        U.cx(7, 0)
        U.cx(7, 1)
        if barrier: U.barrier()            
        # 135 -> 70
        U.ccx(7, 6, 0)
        U.ccx(7, 6, 2)
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 7)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 31
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([3, 4, 5, 6], 1)
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([0, 1, 2, 4], 3)
        if barrier: U.barrier()
        # 31 -> 122
        U.x(2)
        U.ccx(2, 6, 5)
        U.ccx(2, 6, 1)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 5
        U.x(5)
        U.mct([1, 4, 5, 6], 7)            
        U.x(5)
        if barrier: U.barrier()
        U.x(5)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 3)
        U.ccx(7, 6, 2)
        U.ccx(7, 6, 1)
        U.ccx(7, 6, 0)
        U.x(5)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4], 6)
        U.mct([0, 1, 2, 3, 4], 7)
        U.x(1)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U16
        # cycle 1
        # 1 -> 27 -> 14 -> 92 -> 53 -> 1
        # 1: 1 -> 27
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 3)
            U.cx(0, 4)
        # 2: 27 -> 14
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(1)
            U.ccx(0, 1, 2)
            U.ccx(0, 1, 3)
            U.x(1)
            U.cx(2, 0)
            U.cx(2, 1)
        # 3: 14 -> 92
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(1)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 6)
            U.x(1)
            U.cx(6, 0)
        # 4: 92 -> 53
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(0)
            U.mct([0, 1, 4], 6)
            U.mct([0, 1, 4], 5)
            U.mct([0, 1, 4], 3)
            U.x(0)
            U.cx(5, 0)
            U.cx(5, 1)
        # 5: 53 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.mct([0, 1, 2], 3)
            U.mct([0, 1, 2], 5)
            U.x(3)
            U.x(4)
            U.mct([0, 3, 4], 2)
            U.mct([0, 3, 4], 1)
            U.x(3)
            U.x(4)
        # cycle 2
        # 5 -> 135 -> 70 -> 31 -> 122 -> 5
        # 6: 5 -> 135
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x(0)
            U.x(1)
            U.x(6)
            U.mct([0, 1, 6], 7)
            U.mct([0, 1, 6], 4)
            U.mct([0, 1, 6], 3)
            U.x(0)
            U.x(1)
            U.x(6)
            U.cx(7, 0)
            U.cx(7, 1)
        # 7: 135 -> 70
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.ccx(7, 6, 0)
            U.ccx(7, 6, 2)
            U.x(0)
            U.x(3)
            U.mct([0, 1, 2, 3], 7)
            U.x(0)
            U.x(3)
        # 8: 70 -> 31
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x(3)
            U.x(5)
            U.x(6)
            U.mct([3, 4, 5, 6], 1)
            U.x(3)
            U.x(5)
            U.x(6)
            U.mct([0, 1, 2, 4], 3)
        # 9: 31 -> 122
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(2)
            U.ccx(2, 6, 5)
            U.ccx(2, 6, 1)
            U.x(2)
        # 10: 122 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x(5)
            U.mct([1, 4, 5, 6], 7)            
            U.x(5)
            #
            U.x(5)
            U.ccx(7, 6, 4)
            U.ccx(7, 6, 3)
            U.ccx(7, 6, 2)
            U.ccx(7, 6, 1)
            U.ccx(7, 6, 0)
            U.x(5)
            #
            U.x(1)
            U.x(3)
            U.x(4)
            U.mct([0, 1, 2, 3, 4], 6)
            U.mct([0, 1, 2, 3, 4], 7)
            U.x(1)
            U.x(3)
            U.x(4)
        # cycle 3
        # 11: 25 -> 103
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.mct( [0, 2, 3, 4, 6] , 1 )
            U.mct( [0, 2, 3, 4, 6] , 5 )
            U.mct( [0, 2, 3, 4, 6] , 7 )
            U.x( 4 )
            U.x( 3 )
        # 12: 103 -> 64
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 5 )
            U.mct( [0, 2, 3] , 6 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 13: 64 -> 12
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.mct( [1, 2, 4, 7] , 0 )
            U.mct( [1, 2, 4, 7] , 3 )
            U.mct( [1, 2, 4, 7] , 5 )
            U.mct( [1, 2, 4, 7] , 6 )
            U.x( 4 )
            U.x( 1 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 14: 12 -> 38
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 6 )
            U.x( 4 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6] , 0 )
            U.mct( [3, 4, 5, 6] , 1 )
            U.mct( [3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 4 )
            U.x( 3 )
        # 15: 38 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.mct( [1, 2, 3] , 6 )
            U.mct( [1, 2, 3] , 7 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 86
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 6 )
            U.x( 0 )
            U.mct( [0, 3, 5, 6] , 1 )
            U.mct( [0, 3, 5, 6] , 2 )
            U.mct( [0, 3, 5, 6] , 4 )
            U.x( 6 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.mct( [0, 1, 2, 4] , 5 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.x( 0 )
        # 17: 86 -> 34
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 3 )
            U.x( 2 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 5 )
            U.x( 3 )
            U.x( 2 )
        # 18: 34 -> 60
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 5] , 2 )
            U.mct( [0, 1, 5] , 3 )
            U.mct( [0, 1, 5] , 4 )
            U.x( 1 )
            U.x( 0 )
        # 19: 60 -> 47
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.mct( [2, 3, 5, 7] , 0 )
            U.mct( [2, 3, 5, 7] , 1 )
            U.mct( [2, 3, 5, 7] , 4 )
            #
            U.x( 4 )
            U.mct( [0, 1, 2, 3, 4] , 7 )
            U.x( 4 )
        # 20: 47 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 1 )
            U.mct( [1, 3, 4, 7] , 0 )
            U.mct( [1, 3, 4, 7] , 2 )
            U.mct( [1, 3, 4, 7] , 5 )
            U.mct( [1, 3, 4, 7] , 6 )
            U.x( 1 )
            #
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 1 )
        if barrier: U.barrier()
    return U

def U8_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """U8 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1 U8 = U128
        # 1 -> 92 -> 27 -> 14 -> 1
        if barrier: U.barrier()
        # 1 -> 92
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 6)
        U.cx(2, 0)
        if barrier:  U.barrier()
        # 92 -> 27
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 6)
        if barrier: U.barrier()
        # 27 -> 53
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)            
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()
        # 53 -> 14
        U.x(4)
        U.cx(4, 1)
        U.cx(4, 5)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 1
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 3)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 5)
        U.mct([0, 1, 2], 6)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 5 -> 31
        # automatic
        # 31 -> 135
        U.x(6)
        U.mct([1, 5, 6], 7)
        U.x(6)
        U.cx(7, 5)
        if barrier: U.barrier()
        # 135 -> 122
        U.ccx(7, 5, 2)
        U.ccx(7, 5, 1)
        U.ccx(7, 5, 0)
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 70
        U.x(4)
        U.x(6)
        U.mct([4, 5, 6], 3)
        U.mct([4, 5, 6], 2)
        U.mct([4, 5, 6], 1)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 5
        U.cswap(7, 2, 1)
        U.x(1)
        U.x(4)
        U.mct([0,1, 2, 4], 7)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U8
        # cycle 1 U8 = U128
        # 1 -> 92 -> 27 -> 14 -> 1
        # 1: 1 -> 92
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 3)
            U.cx(0, 4)
            U.cx(0, 6)
            U.cx(2, 0)
        # 2: 92 -> 27
        if barrier:  U.barrier()
        if 2 <= r - trnc_lv:
            U.cx(0, 1)
            U.cx(0, 2)
            U.cx(0, 6)
        # 3: 27 -> 53
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(0)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 5)
            U.ccx(0, 1, 6)            
            U.x(0)
            U.cx(5, 0)
            U.cx(5, 1)
        # 4: 53 -> 14
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(4)
            U.cx(4, 1)
            U.cx(4, 5)
            U.x(4)
        # 5: 14 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.ccx(5, 6, 1)
            U.ccx(5, 6, 3)
            U.x(1)
            U.x(2)
            U.mct([0, 1, 2], 5)
            U.mct([0, 1, 2], 6)
            U.x(1)
            U.x(2)
        # cycle 2
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 6: 5 -> 31
        if barrier: U.barrier()
        if 6 <= r - trnc_lv: pass
        # automatic
        # 7: 31 -> 135
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x(6)
            U.mct([1, 5, 6], 7)
            U.x(6)
            U.cx(7, 5)
        # 8: 135 -> 122
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.ccx(7, 5, 2)
            U.ccx(7, 5, 1)
            U.ccx(7, 5, 0)
            U.x(0)
            U.x(2)
            U.mct([0, 1, 2, 3], 7)
            U.mct([0, 1, 2, 3], 6)
            U.x(0)
            U.x(2)
        # 9: 122 -> 70
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(4)
            U.x(6)
            U.mct([4, 5, 6], 3)
            U.mct([4, 5, 6], 2)
            U.mct([4, 5, 6], 1)
            U.x(4)
            U.x(6)
            #
            U.x(0)
            U.x(3)
            U.mct([0, 1, 2, 3], 5)
            U.mct([0, 1, 2, 3], 6)
            U.x(0)
            U.x(3)
        # 10: 70 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.cswap(7, 2, 1)
            U.x(1)
            U.x(4)
            U.mct([0,1, 2, 4], 7)
            U.x(1)
            U.x(4)
        # cycle 3
        # 11: 25 -> 12
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 12: 12 -> 103
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3, 5] , 2 )
            U.x( 3 )
        # 13: 103 -> 38
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3, 5] , 1 )
            U.mct( [0, 2, 3, 5] , 4 )
            U.mct( [0, 2, 3, 5] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 14: 38 -> 64
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2] , 5 )
            U.mct( [0, 1, 2] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
        # 15: 64 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.mct( [1, 2, 3] , 0 )
            U.mct( [1, 2, 3] , 4 )
            U.mct( [1, 2, 3] , 5 )
            U.mct( [1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 60
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:        
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 4, 5] , 3 )
            U.mct( [0, 1, 2, 4, 5] , 6 )
            U.x( 1 )
            U.x( 0 )
        # 17: 60 -> 86
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4] , 2 )
            U.mct( [0, 1, 3, 4] , 5 )
            U.x( 3 )
            U.x( 0 )
        # 18: 86 -> 47
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            #
            U.mct( [0, 1, 2, 3, 5] , 4 )
            U.mct( [0, 1, 2, 3, 5] , 6 )
        # 19: 47 -> 34
        if barrier: U.barrier()
        if 19<= r - trnc_lv:
            U.x( 4 )
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 3, 4, 5, 7] , 1 )
            U.mct( [0, 3, 4, 5, 7] , 2 )
            U.x( 4 )
            U.x( 3 )
            U.x( 0 )
            #
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3] , 7 )
            U.x( 3 )
            U.x( 2 )
            U.x( 0 )
        # 20: 34 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.mct( [2, 4, 5, 6] , 0 )
            U.mct( [2, 4, 5, 6] , 1 )
            U.mct( [2, 4, 5, 6] , 3 )
        if barrier: U.barrier()
    return U


def U4_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """U4 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1: U4 = U64
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        if barrier: U.barrier()
        # 1 -> 53
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        if barrier: U.barrier()
        # 53 -> 92
        U.x(2)
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        U.cx(2, 6)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.cx(0, 2)
        U.x(0)
        if barrier: U.barrier()
        # 92 -> 14
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 4)            
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(4, 3, 2)
        U.ccx(4, 3, 1)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 27
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 4) 
        U.mct([0, 1, 6], 2) 
        U.x(0)
        U.x(1)
        U.x(6)
        if barrier: U.barrier()
        U.x(2)
        U.mct([2, 3, 4], 1)
        U.mct([2, 3, 4], 0)            
        U.x(2)
        if barrier: U.barrier()
        # 27 -> 1
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 122 -> 31 -> 70 -> 135 -> 5
        # 5 -> 122
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 4)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 31
        U.x(3)
        U.mct([0, 1, 3], 2)
        U.mct([0, 1, 3], 4)
        U.mct([0, 1, 3], 5)
        U.x(3)
        U.mct([0, 1, 2], 3)
        if barrier: U.barrier()
        # 31 -> 70
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 4)
        U.mct([0, 1, 2, 3], 5)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 135
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 7)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        U.cx(7, 6)
        U.cx(7, 4)
        if barrier: U.barrier()
        # 135 -> 5
        U.x(0)
        U.ccx(0, 7, 5)
        U.ccx(0, 7, 4)
        U.ccx(0, 7, 3)
        U.ccx(0, 7, 2)
        U.x(0)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(6)
        U.mct([1, 2, 3, 6], 7)
        U.mct([1, 2, 3, 6], 0)            
        U.x(1)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U4
        # cycle 1
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        # 1: 1 -> 53
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 2)
            U.cx(0, 4)
            U.cx(0, 5)
        # 2: 53 -> 92
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x( 5 )
            U.cx( 5 , 0 )
            U.cx( 5 , 2 )
            U.cx( 5 , 3 )
            U.cx( 5 , 4 )
            U.cx( 5 , 6 )
            U.x( 5 )
        # 3: 92 -> 14
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x( 4 )
            U.cx( 4 , 0 )
            U.cx( 4 , 1 )
            U.cx( 4 , 2 )
            U.cx( 4 , 3 )
            U.x( 4 )
        # 4: 14 -> 27
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.ccx( 0 , 1 , 3 )
            U.ccx( 0 , 1 , 6 )
        # 5: 27 -> 1
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.ccx( 1 , 2 , 0 )
            U.ccx( 1 , 2 , 5 )
            U.x( 2 )
            U.x( 1 )
        # # cycle 2
        # 6: 5 -> 122
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x( 2 )
            U.x( 0 )
            U.ccx( 0 , 2 , 1 )
            U.ccx( 0 , 2 , 3 )
            U.ccx( 0 , 2 , 5 )
            U.ccx( 0 , 2 , 6 )
            U.x( 2 )
            U.x( 0 )
        # 7: 122 -> 31
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            U.mct( [3, 4, 5, 6] , 0 )
            U.mct( [3, 4, 5, 6] , 1 )
            U.mct( [3, 4, 5, 6] , 2 )
            U.x( 6 )
            U.x( 5 )
            U.x( 3 )
            #
            U.mct( [0, 1, 2] , 3 )
        # 8: 31 -> 70
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.x( 3 )
            U.x( 0 )
            U.mct( [0, 2, 3] , 1 )
            U.mct( [0, 2, 3] , 5 )
            U.mct( [0, 2, 3] , 6 )
            U.x( 3 )
            U.x( 0 )
        # 9: 70 -> 135
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x( 3 )
            U.mct( [0, 1, 3] , 2 )
            U.mct( [0, 1, 3] , 4 )
            U.mct( [0, 1, 3] , 6 )
            U.mct( [0, 1, 3] , 7 )
            U.x( 3 )
        # 10: 135 -> 5
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.mct( [0, 6, 7] , 1 )
            U.mct( [0, 6, 7] , 2 )
            U.mct( [0, 6, 7] , 3 )
            U.mct( [0, 6, 7] , 4 )
            U.mct( [0, 6, 7] , 5 )
            #
            U.x( 4 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4] , 6 )
            U.mct( [0, 1, 2, 4] , 7 )
            U.x( 4 )
            U.x( 1 )
        if barrier: U.barrier()  
        # # cycle 3
        # 11: 25 -> 38
        if 11 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 3, 4, 6] , 1 )
            U.mct( [0, 3, 4, 6] , 2 )
            U.mct( [0, 3, 4, 6] , 5 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 5] , 3 )
            U.mct( [0, 1, 2, 5] , 6 )
            U.x( 0 )
        # 12: 38 -> 12
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 4, 5, 6] , 1 )
            U.mct( [0, 4, 5, 6] , 2 )
            U.mct( [0, 4, 5, 6] , 3 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 4] , 5 )
            U.mct( [0, 1, 4] , 6 )
            U.x( 4 )
            U.x( 1 )
            U.x( 0 )
        # 13: 12 -> 64
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 5] , 1 )
            U.mct( [0, 2, 5] , 3 )
            U.mct( [0, 2, 5] , 4 )
            U.mct( [0, 2, 5] , 6 )
            U.x( 5 )
            U.x( 2 )
            U.x( 0 )
        # 14: 64 -> 103
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            U.mct( [0, 1, 2, 4, 5, 7] , 3 )
            U.mct( [0, 1, 2, 4, 5, 7] , 6 )
            U.x( 7 )
            U.x( 5 )
            U.x( 1 )
            #
            U.x( 3 )
            U.mct( [0, 2, 3, 6] , 1 )
            U.mct( [0, 2, 3, 6] , 4 )
            U.mct( [0, 2, 3, 6] , 5 )
            U.x( 3 )
        # 15: 103 -> 25
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x( 4 )
            U.x( 2 )
            U.mct( [2, 4, 5, 6] , 0 )
            U.mct( [2, 4, 5, 6] , 1 )
            U.mct( [2, 4, 5, 6] , 3 )
            U.x( 4 )
            U.x( 2 )
            #
            U.x( 2 )
            U.x( 1 )
            U.mct( [0, 1, 2, 3] , 4 )
            U.mct( [0, 1, 2, 3] , 5 )
            U.mct( [0, 1, 2, 3] , 6 )
            U.x( 2 )
            U.x( 1 )
        # cycle 4
        # 16: 125 -> 47
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x( 4 )
            U.mct( [0, 3, 4] , 1 )
            U.mct( [0, 3, 4] , 2 )
            U.mct( [0, 3, 4] , 5 )
            U.mct( [0, 3, 4] , 7 )
            U.x( 4 )
        # 17: 47 -> 60
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 2, 3, 4] , 5 )
            U.mct( [0, 1, 2, 3, 4] , 6 )
            U.x( 2 )
            U.x( 1 )
            U.x( 0 )
            #
            U.x( 1 )
            U.x( 0 )
            U.mct( [0, 1, 3, 4, 5] , 2 )
            U.x( 1 )
            U.x( 0 )
        # 18: 60 -> 34
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
            U.mct( [0, 2, 5, 6] , 1 )
            U.mct( [0, 2, 5, 6] , 3 )
            U.mct( [0, 2, 5, 6] , 4 )
            U.x( 6 )
            U.x( 2 )
            U.x( 0 )
        # 19: 34 -> 86
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x( 5 )
            U.mct( [1, 3, 5, 6] , 0 )
            U.mct( [1, 3, 5, 6] , 2 )
            U.mct( [1, 3, 5, 6] , 4 )
            U.x( 5 )
            #
            U.x( 0 )
            U.mct( [0, 1, 2, 4] , 3 )
            U.x( 0 )
        # 20: 86 -> 125
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x( 4 )
            U.x( 0 )
            U.mct( [0, 2, 3, 4, 5] , 1 )
            U.mct( [0, 2, 3, 4, 5] , 6 )
            U.x( 4 )
            U.x( 0 )
            #
            U.x( 1 )
            U.mct( [1, 2, 3, 5, 6] , 0 )
            U.mct( [1, 2, 3, 5, 6] , 4 )
            U.x( 1 )
        if barrier: U.barrier()  
    return U

def U2_N143_a5(U, u_ver, trnc_lv,  barrier=False):
    """U2 for N143 a=5 r=20."""
    a = 5
    r = 20
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N143_a5(U, u_ver, trnc_lv,  barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 25 -> 53 -> 38 -> 92 ->
        # 12 -> 14 -> 64 -> 27 -> 103 -> 1
        if barrier: U.barrier()            
        # 1 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 53
        U.x(3)
        U.ccx(0, 3, 2)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 5)
        U.x(3)
        if barrier: U.barrier()
        # 53 -> 38
        U.x(4)
        U.cx(4, 3)
        U.cx(4, 1)
        U.cx(4, 0)
        U.x(4)
        if barrier: U.barrier()
        # 38 -> 92
        U.x(4)
        U.mct([5, 4, 3], 6)
        U.mct([5, 4, 3], 0)
        U.x(4)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        # 92 -> 12
        U.x(0)
        U.x(1)
        U.x(4)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 5)
        U.x(0)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
        # 12 -> 14
        U.ccx(0, 1, 3)
        U.mct([1, 2, 3], 0)
        if barrier: U.barrier()
        # 14 -> 64
        U.x(4)
        U.ccx(0, 4, 2)
        U.ccx(0, 4, 6)
        U.x(4)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(6, 4, 0)
        U.x(4)
        if barrier: U.barrier()
        # 64 -> 27
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        if barrier: U.barrier()
        # 27 -> 103
        U.x(0)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 3)
        U.x(0)
        U.ccx(6, 5, 4)
        U.ccx(6, 5, 0)
        if barrier: U.barrier()
        # 103 -> 1
        U.mct([6, 5, 4], 3)
        U.mct([6, 5, 4], 2)
        U.mct([6, 5, 4], 1)
        U.mct([6, 5, 4], 0)
        if barrier: U.barrier()            
        U.x(1)
        U.mct([0, 1, 6], 5)
        U.mct([0, 1, 6], 4)
        U.mct([0, 1, 6], 2)
        U.x(1)
        if barrier: U.barrier()
        U.x(1)
        U.x(4)
        U.mct([0, 1, 4], 6)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 125 -> 122 -> 47 -> 31 -> 
        # 60 ->70 -> 34 -> 135 -> 86 -> 5
        # 5 -> 125
        U.x(1)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(1)
        if barrier: U.barrier()
        # 125 -> 122
        U.x(6)
        U.x(4)
        U.mct([6, 5, 4, 0], 2)
        U.mct([6, 5, 4, 0], 1)
        U.mct([6, 5, 4, 0], 7)
        U.x(6)
        U.x(4)
        if barrier: U.barrier()
        U.cx(7, 0)
        U.cx(7, 3)
        U.cx(7, 4)
        U.cx(7, 6)
        if barrier: U.barrier()
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 7)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 47
        U.cx(7, 0)
        U.cx(7, 2)
        U.cx(7, 3)
        U.cx(7, 4)
        U.x(4)
        U.x(6)
        U.mct([3,  4, 5, 6], 7)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        # 47 -> 31
        U.x(6)
        U.x(7)
        U.mct([3, 4, 5, 6, 7], 2)
        U.mct([3, 4, 5, 6, 7], 1)
        U.mct([3, 4, 5, 6, 7], 0)
        U.x(6)
        U.x(7)
        U.mct([0, 1, 2, 3, 4], 5)
        if barrier: U.barrier()
        # 31 -> 60
        U.cx(7, 6)
        U.cx(7, 4)
        U.cx(7, 3)
        U.cx(7, 0)
        U.x(6)
        U.mct([3, 4, 5, 6], 7)
        U.x(6)
        if barrier: U.barrier()
        # 60 -> 70
        U.x(3)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3, 6], 5)
        U.mct([0, 1, 2, 3, 6], 4)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 34
        U.x(4)
        U.x(2)
        U.mct([4, 3, 2], 0)
        U.mct([4, 3, 2], 1)
        U.mct([4, 3, 2], 5)
        U.mct([4, 3, 2], 6)
        U.x(4)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.x(2)
        U.x(4)
        U.mct([0, 1, 2, 4], 3)
        U.x(0)
        U.x(2)
        U.x(4)
        if barrier: U.barrier()
        # 34 -> 135
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.mct([0, 1, 2, 3], 4)
        U.x(0)
        U.x(1)
        U.x(2)
        U.cx(7, 0)
        U.cx(7, 1)
        U.cx(7, 2)
        U.cx(7, 3)
        if barrier: U.barrier()
        # 135 -> 86
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 2)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        # 86 -> 5
        U.x(0)
        U.x(6)
        U.mct([0, 1, 2, 4, 6], 3)
        U.x(0)
        U.x(6)
        if barrier: U.barrier()
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([3, 4, 5, 6], 1)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
        U.x(1)
        U.x(5)
        U.mct([0, 1, 2, 5], 4)
        U.x(1)
        U.x(5)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U2
        # cycle 1
        # 1 -> 25 -> 53 -> 38 -> 92 ->
        # 12 -> 14 -> 64 -> 27 -> 103 -> 1
        # 1: 1 -> 25
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.cx(0, 3)
            U.cx(0, 4)
        # 2: 25 -> 53
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(3)
            U.ccx(0, 3, 2)
            U.ccx(0, 3, 4)
            U.ccx(0, 3, 5)
            U.x(3)
        # 3: 53 -> 38
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(4)
            U.cx(4, 3)
            U.cx(4, 1)
            U.cx(4, 0)
            U.x(4)
        # 4: 38 -> 92
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(4)
            U.mct([5, 4, 3], 6)
            U.mct([5, 4, 3], 0)
            U.x(4)
            #
            U.x(0)
            U.x(1)
            U.ccx(0, 1, 4)
            U.ccx(0, 1, 5)
            U.x(0)
            U.x(1)
        # 5: 92 -> 12
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(0)
            U.x(1)
            U.x(4)
            U.mct([0, 1, 4], 6)
            U.mct([0, 1, 4], 5)
            U.x(0)
            U.x(1)
            U.x(4)
        # 6: 12 -> 14
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:        
            U.ccx(0, 1, 3)
            U.mct([1, 2, 3], 0)
        # 7: 14 -> 64
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x(4)
            U.ccx(0, 4, 2)
            U.ccx(0, 4, 6)
            U.x(4)
            #
            U.x(4)
            U.ccx(6, 4, 0)
            U.x(4)
        # 8: 64 -> 27
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:
            U.ccx(0, 1, 2)
            U.ccx(0, 1, 3)
            U.ccx(0, 1, 4)
        # 9: 27 -> 103
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(0)
            U.mct([0, 1, 4], 6)
            U.mct([0, 1, 4], 3)
            U.x(0)
            U.ccx(6, 5, 4)
            U.ccx(6, 5, 0)
        # 10: 103 -> 1
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.mct([6, 5, 4], 3)
            U.mct([6, 5, 4], 2)
            U.mct([6, 5, 4], 1)
            U.mct([6, 5, 4], 0)
            #
            U.x(1)
            U.mct([0, 1, 6], 5)
            U.mct([0, 1, 6], 4)
            U.mct([0, 1, 6], 2)
            U.x(1)
            #
            U.x(1)
            U.x(4)
            U.mct([0, 1, 4], 6)
            U.x(1)
            U.x(4)
        # cycle 2
        # 5 -> 125 -> 122 -> 47 -> 31 -> 
        # 60 ->70 -> 34 -> 135 -> 86 -> 5
        # 11: 5 -> 125
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x(1)
            U.mct([0, 1, 2, 3], 5)
            U.mct([0, 1, 2, 3], 6)
            U.x(1)
        # 12: 125 -> 122
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x(6)
            U.x(4)
            U.mct([6, 5, 4, 0], 2)
            U.mct([6, 5, 4, 0], 1)
            U.mct([6, 5, 4, 0], 7)
            U.x(6)
            U.x(4)
            #
            U.cx(7, 0)
            U.cx(7, 3)
            U.cx(7, 4)
            U.cx(7, 6)
            #
            U.x(0)
            U.x(2)
            U.mct([0, 1, 2], 7)
            U.x(0)
            U.x(2)
        # 13: 122 -> 47
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.cx(7, 0)
            U.cx(7, 2)
            U.cx(7, 3)
            U.cx(7, 4)
            U.x(4)
            U.x(6)
            U.mct([3,  4, 5, 6], 7)
            U.x(4)
            U.x(6)
        # 14: 47 -> 31
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x(6)
            U.x(7)
            U.mct([3, 4, 5, 6, 7], 2)
            U.mct([3, 4, 5, 6, 7], 1)
            U.mct([3, 4, 5, 6, 7], 0)
            U.x(6)
            U.x(7)
            U.mct([0, 1, 2, 3, 4], 5)
        # 15: 31 -> 60
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.cx(7, 6)
            U.cx(7, 4)
            U.cx(7, 3)
            U.cx(7, 0)
            U.x(6)
            U.mct([3, 4, 5, 6], 7)
            U.x(6)
        # 16: 60 -> 70
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x(3)
            U.mct([3, 4, 5, 6], 2)
            U.mct([3, 4, 5, 6], 0)
            U.x(3)
            #
            U.x(0)
            U.x(3)
            U.mct([0, 1, 2, 3, 6], 5)
            U.mct([0, 1, 2, 3, 6], 4)
            U.x(0)
            U.x(3)
        # 17: 70 -> 34
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:        
            U.x(4)
            U.x(2)
            U.mct([4, 3, 2], 0)
            U.mct([4, 3, 2], 1)
            U.mct([4, 3, 2], 5)
            U.mct([4, 3, 2], 6)
            U.x(4)
            U.x(2)
            #
            U.x(0)
            U.x(2)
            U.x(4)
            U.mct([0, 1, 2, 4], 3)
            U.x(0)
            U.x(2)
            U.x(4)
        # 18: 34 -> 135
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.x(0)
            U.x(1)
            U.x(2)
            U.mct([0, 1, 2, 3], 7)
            U.mct([0, 1, 2, 3], 6)
            U.mct([0, 1, 2, 3], 4)
            U.x(0)
            U.x(1)
            U.x(2)
            U.cx(7, 0)
            U.cx(7, 1)
            U.cx(7, 2)
            U.cx(7, 3)
        # 19: 135 -> 86
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.x(3)
            U.x(5)
            U.mct([3, 4, 5, 6], 2)
            U.x(3)
            U.x(5)
        # 20: 86 -> 5
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x(0)
            U.x(6)
            U.mct([0, 1, 2, 4, 6], 3)
            U.x(0)
            U.x(6)
            #
            U.x(3)
            U.x(5)
            U.x(6)
            U.mct([3, 4, 5, 6], 1)
            U.mct([3, 4, 5, 6], 0)
            U.x(3)
            U.x(5)
            U.x(6)
            #
            U.x(1)
            U.x(5)
            U.mct([0, 1, 2, 5], 4)
            U.x(1)
            U.x(5)
        if barrier: U.barrier()
    return U

def U1_N143_a5(U, u_ver, trnc_lv, barrier=False):
    """U1 Modular Exponentiation Operator for N=128 a=5 r=20"""        
    a = 5
    r = 20
    if u_ver == 0 or u_ver == 1:
        # r=20
        # 1 -> 5 -> 25 -> 125 -> 53 -> 122 ->
        # 38 -> 47 -> 92 -> 31 -> 12 -> 60 ->
        # 14 -> 70 -> 64 -> 34 -> 27 -> 135 ->
        # 103 -> 86 -> 1
        # 1: 1 -> 5 
        if barrier: U.barrier()
        U.x(1)
        U.ccx(0, 1, 2)        
        U.x(1)
        # 2: 5 -> 25 
        if barrier: U.barrier()
        U.x(2)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)        
        U.x(2)
        # 3: 25 -> 125 
        if barrier: U.barrier()        
        U.x(1)
        U.mct([3, 2, 1, 0], 5)
        U.mct([3, 2, 1, 0], 6)        
        U.x(1)
        # 4: 125 -> 53 
        if barrier: U.barrier()
        U.x(4)
        U.mct([6, 5, 4], 2)
        U.x(4)
        #
        U.x(1)
        U.x(3)
        U.mct([5, 3, 2, 1, 0], 4)
        U.mct([5, 3, 2, 1, 0], 6)        
        U.x(1)
        U.x(3)
        # 5: 53 -> 122
        if barrier: U.barrier()
        U.x(6)
        U.mct([6, 5, 3], 4)
        U.mct([6, 5, 3], 1)
        U.mct([6, 5, 3], 0)        
        U.x(6)
        #
        U.x(0)
        U.ccx(0, 1, 6)
        U.x(0)
        # 6: 122 -> 38
        if barrier: U.barrier()
        U.x(6)
        U.mct([6, 5, 1], 4)
        U.mct([6, 5, 1], 3)
        U.mct([6, 5, 1], 2)        
        U.x(6)
        # 7: 38 -> 47
        if barrier: U.barrier()
        U.x(4)
        U.ccx(6, 4, 3)
        U.ccx(6, 4, 0)        
        U.x(4)
        #
        U.ccx(0, 1, 6)
        # 8: 47 -> 92
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)        
        U.x(0)
        U.x(1)
        # 9: 92 -> 31
        if barrier: U.barrier()
        U.x(6)
        U.mct([6, 4, 3, 2], 5)
        U.mct([6, 4, 3, 2], 1)
        U.mct([6, 4, 3, 2], 0)        
        U.x(6)
        # 10: 31 -> 12
        if barrier: U.barrier()
        U.x(5)
        U.mct([6, 5, 0], 1)
        U.mct([6, 5, 0], 4)        
        U.x(5)
        #
        U.x(5)
        U.x(4)
        U.mct([5, 4, 3, 2], 6)
        U.mct([5, 4, 3, 2], 0)        
        U.x(5)
        U.x(4)
        # 11: 12 -> 60
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.mct([5, 1, 0], 6)
        U.mct([5, 1, 0], 4)        
        U.x(0)
        U.x(1)
        # 12: 60 -> 14
        if barrier: U.barrier()
        U.x(2)
        U.mct([2, 1, 0], 3) 
        U.mct([2, 1, 0], 4)
        U.mct([2, 1, 0], 5)
        U.mct([2, 1, 0], 6)
        U.x(2)
        #
        U.x(6)
        U.x(5)
        U.x(4)
        U.mct([6, 5, 4, 1], 0)
        U.mct([6, 5, 4, 1], 2)        
        U.x(6)
        U.x(5)
        U.x(4)
        # 13: 14 -> 70
        if barrier: U.barrier()
        U.x(0)
        U.x(2)
        U.x(3)
        U.mct([3, 2, 1, 0], 6)
        U.x(0)
        U.x(2)
        U.x(3)
        #
        U.x(5)
        U.mct([6, 5, 1], 2)
        U.x(5)
        # 14: 70 -> 64
        if barrier: U.barrier()
        U.x(7)
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([7, 6, 5, 4, 3, 2], 0)
        U.mct([7, 6, 5, 4, 3, 2], 1)        
        U.x(7)
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        #
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.x(0)
        U.x(1)
        U.x(2)
        # 15: 64 -> 34
        if barrier: U.barrier()
        U.x(6)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([6, 5, 4, 3, 2], 0)
        U.x(6)
        U.x(4)
        U.x(3)
        U.x(2)
        # 16: 34 -> 27
        if barrier: U.barrier()
        U.x(3)
        U.mct([3, 2, 1, 0], 6)
        U.x(3) 
        #
        U.x(5)
        U.mct([5, 4, 1, 0, 3], 2)
        U.mct([5, 4, 1, 0, 2], 3)        
        U.mct([5, 4, 1, 0, 3], 2)        
        U.x(5)
        # 17: 27 -> 135
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(3)
        U.mct([3, 2, 1, 0], 7)
        U.mct([3, 2, 1, 0], 6)        
        U.x(1)
        U.x(2)
        U.x(3)
        #
        U.cx(7, 4)
        U.cx(7, 2)
        U.cx(7, 1)
        # 18: 135 -> 103
        if barrier: U.barrier()        
        U.mct([7, 6], 5)
        U.mct([7, 6], 2)
        #
        U.x(4)
        U.mct([6, 5, 4], 7)
        U.x(4)
        # 19: 103 -> 86
        if barrier: U.barrier()
        U.mct([7, 6], 5)
        U.mct([7, 6], 2)
        U.mct([7, 6], 3)
        U.mct([7, 6], 4)
        #
        U.x(5)
        U.x(3)
        U.mct([6, 5, 4, 3], 7)
        U.x(3)
        U.x(5)
        # 20: 86 ->  1        
        if barrier: U.barrier()
        U.x(6)
        U.x(5)
        U.x(3)
        U.mct([6, 5, 4, 3], 7)
        U.x(6)
        U.x(5)
        U.x(3)
        #
        U.x(0)
        U.ccx(0, 7, 1)
        U.ccx(0, 7, 2)
        U.ccx(0, 7, 4)
        U.x(0)
        #
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([6, 5, 4, 3, 2], 0)
        U.mct([6, 5, 4, 3, 2], 7)            
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        if barrier: U.barrier()
    elif u_ver == 2:
        # U1
        # r=20
        # 1 -> 5 -> 25 -> 125 -> 53 -> 122 ->
        # 38 -> 47 -> 92 -> 31 -> 12 -> 60 ->
        # 14 -> 70 -> 64 -> 34 -> 27 -> 135 ->
        # 103 -> 86 -> 1
        # 1: 1 -> 5 
        if barrier: U.barrier()
        if 1 <= r - trnc_lv:
            U.x(1)
            U.ccx(0, 1, 2)        
            U.x(1)
        # 2: 5 -> 25 
        if barrier: U.barrier()
        if 2 <= r - trnc_lv:
            U.x(2)
            U.ccx(0, 2, 3)
            U.ccx(0, 2, 4)        
            U.x(2)
        # 3: 25 -> 125 
        if barrier: U.barrier()
        if 3 <= r - trnc_lv:
            U.x(1)
            U.mct([3, 2, 1, 0], 5)
            U.mct([3, 2, 1, 0], 6)        
            U.x(1)
        # 4: 125 -> 53 
        if barrier: U.barrier()
        if 4 <= r - trnc_lv:
            U.x(4)
            U.mct([6, 5, 4], 2)
            U.x(4)
            #
            U.x(1)
            U.x(3)
            U.mct([5, 3, 2, 1, 0], 4)
            U.mct([5, 3, 2, 1, 0], 6)        
            U.x(1)
            U.x(3)
        # 5: 53 -> 122
        if barrier: U.barrier()
        if 5 <= r - trnc_lv:
            U.x(6)
            U.mct([6, 5, 3], 4)
            U.mct([6, 5, 3], 1)
            U.mct([6, 5, 3], 0)        
            U.x(6)
            #
            U.x(0)
            U.ccx(0, 1, 6)
            U.x(0)
        # 6: 122 -> 38
        if barrier: U.barrier()
        if 6 <= r - trnc_lv:
            U.x(6)
            U.mct([6, 5, 1], 4)
            U.mct([6, 5, 1], 3)
            U.mct([6, 5, 1], 2)        
            U.x(6)
        # 7: 38 -> 47
        if barrier: U.barrier()
        if 7 <= r - trnc_lv:
            U.x(4)
            U.ccx(6, 4, 3)
            U.ccx(6, 4, 0)        
            U.x(4)
            #
            U.ccx(0, 1, 6)
        # 8: 47 -> 92
        if barrier: U.barrier()
        if 8 <= r - trnc_lv:        
            U.x(0)
            U.x(1)
            U.ccx(0, 1, 5)
            U.ccx(0, 1, 6)        
            U.x(0)
            U.x(1)
        # 9: 92 -> 31
        if barrier: U.barrier()
        if 9 <= r - trnc_lv:
            U.x(6)
            U.mct([6, 4, 3, 2], 5)
            U.mct([6, 4, 3, 2], 1)
            U.mct([6, 4, 3, 2], 0)        
            U.x(6)
        # 10: 31 -> 12
        if barrier: U.barrier()
        if 10 <= r - trnc_lv:
            U.x(5)
            U.mct([6, 5, 0], 1)
            U.mct([6, 5, 0], 4)        
            U.x(5)
            #
            U.x(5)
            U.x(4)
            U.mct([5, 4, 3, 2], 6)
            U.mct([5, 4, 3, 2], 0)        
            U.x(5)
            U.x(4)
        # 11: 12 -> 60
        if barrier: U.barrier()
        if 11 <= r - trnc_lv:
            U.x(0)
            U.x(1)
            U.mct([5, 1, 0], 6)
            U.mct([5, 1, 0], 4)        
            U.x(0)
            U.x(1)
        # 12: 60 -> 14
        if barrier: U.barrier()
        if 12 <= r - trnc_lv:
            U.x(2)
            U.mct([2, 1, 0], 3) 
            U.mct([2, 1, 0], 4)
            U.mct([2, 1, 0], 5)
            U.mct([2, 1, 0], 6)
            U.x(2)
            #
            U.x(6)
            U.x(5)
            U.x(4)
            U.mct([6, 5, 4, 1], 0)
            U.mct([6, 5, 4, 1], 2)        
            U.x(6)
            U.x(5)
            U.x(4)
        # 13: 14 -> 70
        if barrier: U.barrier()
        if 13 <= r - trnc_lv:
            U.x(0)
            U.x(2)
            U.x(3)
            U.mct([3, 2, 1, 0], 6)
            U.x(0)
            U.x(2)
            U.x(3)
            #
            U.x(5)
            U.mct([6, 5, 1], 2)
            U.x(5)
        # 14: 70 -> 64
        if barrier: U.barrier()
        if 14 <= r - trnc_lv:
            U.x(7)
            U.x(6)
            U.x(5)
            U.x(4)
            U.x(3)
            U.x(2)
            U.mct([7, 6, 5, 4, 3, 2], 0)
            U.mct([7, 6, 5, 4, 3, 2], 1)        
            U.x(7)
            U.x(6)
            U.x(5)
            U.x(4)
            U.x(3)
            U.x(2)
            #
            U.x(0)
            U.x(1)
            U.x(2)
            U.mct([0, 1, 2], 6)
            U.x(0)
            U.x(1)
            U.x(2)
        # 15: 64 -> 34
        if barrier: U.barrier()
        if 15 <= r - trnc_lv:
            U.x(6)
            U.x(4)
            U.x(3)
            U.x(2)
            U.mct([6, 5, 4, 3, 2], 0)
            U.x(6)
            U.x(4)
            U.x(3)
            U.x(2)
        # 16: 34 -> 27
        if barrier: U.barrier()
        if 16 <= r - trnc_lv:
            U.x(3)
            U.mct([3, 2, 1, 0], 6)
            U.x(3) 
            #
            U.x(5)
            U.mct([5, 4, 1, 0, 3], 2)
            U.mct([5, 4, 1, 0, 2], 3)        
            U.mct([5, 4, 1, 0, 3], 2)        
            U.x(5)
        # 17: 27 -> 135
        if barrier: U.barrier()
        if 17 <= r - trnc_lv:
            U.x(1)
            U.x(2)
            U.x(3)
            U.mct([3, 2, 1, 0], 7)
            U.mct([3, 2, 1, 0], 6)        
            U.x(1)
            U.x(2)
            U.x(3)
            #
            U.cx(7, 4)
            U.cx(7, 2)
            U.cx(7, 1)
        # 18: 135 -> 103
        if barrier: U.barrier()
        if 18 <= r - trnc_lv:
            U.mct([7, 6], 5)
            U.mct([7, 6], 2)
            #
            U.x(4)
            U.mct([6, 5, 4], 7)
            U.x(4)
        # 19: 103 -> 86
        if barrier: U.barrier()
        if 19 <= r - trnc_lv:
            U.mct([7, 6], 5)
            U.mct([7, 6], 2)
            U.mct([7, 6], 3)
            U.mct([7, 6], 4)
            #
            U.x(5)
            U.x(3)
            U.mct([6, 5, 4, 3], 7)
            U.x(3)
            U.x(5)
        # 20: 86 ->  1        
        if barrier: U.barrier()
        if 20 <= r - trnc_lv:
            U.x(6)
            U.x(5)
            U.x(3)
            U.mct([6, 5, 4, 3], 7)
            U.x(6)
            U.x(5)
            U.x(3)
            #
            U.x(0)
            U.ccx(0, 7, 1)
            U.ccx(0, 7, 2)
            U.ccx(0, 7, 4)
            U.x(0)
            #
            U.x(6)
            U.x(5)
            U.x(4)
            U.x(3)
            U.x(2)
            U.mct([6, 5, 4, 3, 2], 0)
            U.mct([6, 5, 4, 3, 2], 7)            
            U.x(6)
            U.x(5)
            U.x(4)
            U.x(3)
            U.x(2)
        if barrier: U.barrier()
    return U
