# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np

# shor local
from shor_util import run_meo_sequence, run_shor

######### parameters #########

# set version
ver = 6

# construct MEO's
verbose = False
very_quiet = False

# set parameters
N = 33
a = 7 # r=10

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 6 # control register: ideally 2*L+1

# MEO version
# full agreement between versions 0 and 1
#u_ver = 0 # U^p is a strict concatenation of U1's
#u_ver = 1 # U^p gates 2-cycles
u_ver = 2 # truncation
trnc_lv = 6 # truncation level: 0, 1, ..., r-1; 0=no truncation
if u_ver != 2: trnc_lv = -1

#check_quantum = False # use this first to construct x_list sequence f(0),f(1),...
check_quantum = True # then use this to construct the ME gates

# parameters for run_meo_sequence
# set powers: U^power
powers = [2**q for q in range(M)]
#power = 32
#power = 16
#power = 8
#power = 4
#power = 2
power = 1

# set x_list = a^x mod N vs x
x_list = [1]
if a == 7:
    if power == 1:
        x_list = [1, 7, 16, 13, 25, 10, 4, 28, 31, 19]
    elif power == 2:
        x_list1 = [1, 16, 25, 4, 31]
        x_list2 = [7, 13, 10, 28, 19]
        x_list = x_list1 + x_list2
    elif power == 4:
        x_list1 = [1, 25, 31, 16, 4]
        x_list2 = [7, 10, 19, 13, 28]
        x_list = x_list1 + x_list2
    elif power == 8:
        x_list1 = [1, 31, 4, 25, 16]
        x_list2 = [7, 19, 28, 10, 13]
        x_list = x_list1 + x_list2
    elif power == 16:
        x_list1 = [1, 4, 16, 31, 25]
        x_list2 = [7, 28, 13, 19, 10]
        x_list = x_list1 + x_list2
    elif power == 32:
        x_list1 = [1, 16, 25, 4, 31]
        x_list2 = [7, 13, 10, 28, 19]
        x_list = x_list1 + x_list2

# set filename prefix
if trnc_lv == -1:
    filename = "03_shor_v{2}_N{0}_a{1}_m{4}_uver{3}".format(N, a, ver, u_ver, M)
else:
    filename = "03_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}".format(N, a, ver, u_ver, trnc_lv, M)

# print parameters
print("** N, a, L, M, u_ver, trnc_lv:", N, a, L, M, u_ver, trnc_lv)
print("** power, powers", power, powers)

######### start calculation ##########

run_meo_sequence(N, a, L, M, power, x_list, filename, u_ver,
                 trnc_lv, check_quantum, verbose, very_quiet)
