# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np

# shor local
from shor_util import run_meo_sequence, run_shor, run_con_U

######### parameters #########

# set version
ver = 6

# construct MEO's
verbose = False
very_quiet = False

# set parameters
N = 247 # 13 x 19
a = 2 # r=36

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
#M = 8 # use 8, 9 or 10: ideally 2*L+1
#M = 9 # higher resolution
M = 10 # highest resolution

# MEO version
# full agreement between versions 0 and 1.
u_ver = 0 # U^p is a strict concatenation of U1's
#u_ver = 1 # U^p gates 4-cycles
#u_ver = 2
#trnc_lv = 0 # truncation level: 0, 1, ..., r-1; 0=no truncation
if u_ver != 2: trnc_lv = -1

# parameters for run_meo_sequence
# set powers array
powers = [2**q for q in range(M)]
#power = 512 # m=10 same as m=8
#power = 256 # m=9
#power = 128 # m=8
#power = 64
#power = 32
#power = 16
#power = 8
#power = 4
#power = 2
power = 1

#check_quantum = False # 1. construct x_list sequence f(0),f(1),...
check_quantum = True # 2. use this to construct the ME gates

# set x_list = a^x mod N vs x
x_list = [1]
if a == 2:  # N=247 a=2 r=36
    if power == 1:
        x_list = [1, 2, 4, 8, 16, 32, 64, 128, 9, 18, 36,
                  72, 144, 41, 82, 164, 81, 162, 77, 154,
                  61, 122, 244, 241, 235, 223, 199, 151,
                  55, 110, 220, 193, 139, 31, 62, 124]
    elif power == 2:
        # 36 / 18 = 2 cycles
        x_list1 = [1, 4, 16, 64, 9, 36, 144, 82, 81, 77, 61, 244,
                   235, 199, 55, 220, 139, 62]
        x_list2 = [2, 8, 32, 128, 18, 72, 41, 164, 162, 154, 122,
                   241, 223, 151, 110, 193, 31, 124]
        x_list = x_list1 + x_list2
    elif power == 4:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 16, 9, 144, 81, 61, 235, 55, 139]
        x_list2 = [2, 32, 18, 41, 162, 122, 223, 110, 31]
        x_list3 = [4, 64, 36, 82, 77, 244, 199, 220, 62]
        x_list4 = [8, 128, 72, 164, 154, 241, 151, 193, 124]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 8:
        # 36 / 9 = 4 cycles        
        x_list1 = [1, 9, 81, 235, 139, 16, 144, 61, 55]
        x_list2 = [2, 18, 162, 223, 31, 32, 41, 122, 110]
        x_list3 = [4, 36, 77, 199, 62, 64, 82, 244, 220]
        x_list4 = [8, 72, 154, 151, 124, 128, 164, 241, 193]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 16:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 81, 139, 144, 55, 9, 235, 16, 61]
        x_list2 = [2, 162, 31, 41, 110, 18, 223, 32, 122]
        x_list3 = [4, 77, 62, 82, 220, 36, 199, 64, 244]        
        x_list4 = [8, 154, 124, 164, 193, 72, 151, 128, 241]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 32:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 139, 55, 235, 61, 81, 144, 9, 16]
        x_list2 = [2, 31, 110, 223, 122, 162, 41, 18, 32]
        x_list3 = [8, 124, 193, 151, 241, 154, 164, 72, 128]        
        x_list4 = [4, 62, 220, 199, 244, 77, 82, 36, 64]        
        x_list =  x_list1 + x_list2 + x_list3 + x_list4
    elif power == 64:
        x_list1 = [1, 55, 61, 144, 16, 139, 235, 81, 9]
        x_list2 = [2, 110, 122, 41, 32, 31, 223, 162, 18]
        x_list3 = [8, 193, 241, 164, 128, 124, 151, 154, 72]
        x_list4 = [4, 220, 244, 82, 64, 62, 199, 77, 36] # Mathematica
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 128:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 61, 16, 235, 9, 55, 144, 139, 81]
        x_list2 = [2, 122, 32, 223, 18, 110, 41, 31, 162]
        x_list3 = [4, 244, 64, 199, 36, 220, 82, 62, 77]        
        x_list4 = [8, 241, 128, 151, 72, 193, 164, 124, 154]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 256:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 16, 9, 144, 81, 61, 235, 55, 139]
        x_list2 = [2, 32, 18, 41, 162, 122, 223, 110, 31]
        x_list3 = [4, 64, 36, 82, 77, 244, 199, 220, 62]
        x_list4 = [8, 128, 72, 164, 154, 241, 151, 193, 124]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 512:
        # 36 / 9 = 4 cycles
        x_list1 = [1, 9, 81, 235, 139, 16, 144, 61, 55]
        x_list2 = [2, 18, 162, 223, 31, 32, 41, 122, 110]
        x_list3 = [4, 36, 77, 199, 62, 64, 82, 244, 220]
        x_list4 = [8, 72, 154, 151, 124, 128, 164, 241, 193]
        x_list = x_list1 + x_list2 + x_list3 + x_list4

# set filename prefix
if trnc_lv == -1:
    filename = "03_shor_v{2}_N{0}_a{1}_m{4}_uver{3}".format(N, a, ver, u_ver, M)
else:
    filename = "03_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}".format(N, a, ver, u_ver, trnc_lv, M)

# print parameters
print("** N, a, L, M, u_ver, trnc_lv:", N, a, L, M, u_ver, trnc_lv)
print("** power, powers", power, powers)

######### start calculation ##########

run_meo_sequence(N, a, L, M, power, x_list, filename, u_ver,
                 trnc_lv, check_quantum, verbose, very_quiet)
