# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np

# shor local
from shor_util import run_shor_hist

######### parameters #########

# set version
ver = 6

# run factoring circuit
verbose = True
very_quiet = False

# set parameters
N = 21
a = 2 # r=6

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 5 # control register: ideally 2*L+1
      # m=5 => power_max=16

# MEO version
# full agreement between versions 0 and 1.
#u_ver = 0 # U^p is a strict concatenation of U1's
#u_ver = 1 # U^p gates 2-cycles
u_ver = 2 # truncation
trnc_lv = 0 # truncation level: 0, 1, ..., r-1; 0=no truncation

# set filename prefix
if u_ver != 2: trnc_lv = "x"
filename = "03_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}".format(N, a, ver, u_ver, trnc_lv, M)

# print parameters
print("** N, a, L, M, u_ver, trnc_lv:", N, a, L, M, u_ver, trnc_lv)

######### start calculation ##########

run_shor_hist(N, a, L, M, filename, u_ver, trnc_lv, verbose, very_quiet)
