# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np

# shor local
from shor_util import run_shor_hist

######### parameters #########

# set version
ver = 6

# run factoring circuit
verbose = True
very_quiet = False

# set parameters
N = 15 # a=2,4,7,8,11,13
a = 2 # r=2, 4

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 5 # control register: ideally 2*L+1

# MEO version
# full agreement between versions 0 and 1.
u_ver = 0 # U^p is a strict concatenation of U1's

if u_ver != 2: trnc_lv = "x"
filename = "03_shor_v{2}_N{0}_a{1}_m{4}_uver{3}".format(N, a, ver, u_ver, M)

# print parameters
print("** N, a, L, M, u_ver:", N, a, L, M, u_ver)

######### start calculation ##########

run_shor_hist(N, a, L, M, filename, u_ver, trnc_lv, verbose, very_quiet)
