import matplotlib.pyplot as plt
import numpy as np

max_it1 = 50
max_it2 = 50
max_it3 = 50

N = 33
a = 7
r = 10
trnc_max = r-1 # r=6

filename = "tries_N{0}_a{1}_trnc_max{2}".format(N, a, trnc_max)

trnc_lvs = np.arange(trnc_max+1)  # 0, 1, ..., r-1
                          #0x  #1x    #2x   #3x   #4x   #5x
num_tries_av1 = np.array([3.5, 4.22, 4.7, 6.12, 5.1, 4.7, 9.96,
                          12.46, 26.3, 48.14])
num_tries_av2 = np.array([3.38, 3.8, 4.74, 5.6, 5.32, 4.92, 9.1,
                          11.88, 21.46, 68.26])
num_tries_av3 = np.array([3.28, 3.7, 5.04, 5.34, 5.64, 4.92, 6.38,
                          13.84, 26.64, 50.82])

print("max_trnc:", len(trnc_lvs), len(num_tries_av1))

max_it = max_it1 + max_it2 + max_it3
r1 = float(max_it1)/float(max_it)
r2 = float(max_it2)/float(max_it)
r3 = float(max_it3)/float(max_it)
num_tries_av = r1 * num_tries_av1 + r2 * num_tries_av2 + r3 * num_tries_av3

fig, ax = plt.subplots()
xticks = trnc_lvs
yticks = range(60)[::5]
plt.xticks(xticks)
plt.yticks(yticks)
plt.ylim(0.0, 60.0)
#plt.yscale("log")

av = 5.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 10.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 15.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

ax.plot(trnc_lvs, num_tries_av, 'bo-', linewidth=1, linestyle='dotted', marker='x')
ax.set(xlabel='trncation level', ylabel='average number of tries', 
       title="N = {0}  a = {1} r = {2} max_it = {3}".format(N, a, r, max_it))
plt.tight_layout()
plt.savefig(filename+".jpg")
plt.show()
