import matplotlib.pyplot as plt
import numpy as np

max_it1 = 10
max_it2 = 10
max_it3 = 10

N = 247
a = 2
r = 36
trnc_max = r-1 # r=36

filename = "tries_N{0}_a{1}_trnc_max{2}".format(N, a, trnc_max)

trnc_lvs = np.arange(trnc_max+1)  # 0, 1, ..., r-1
                          #0x   #1x   #2x    #3x    #4x    #5x    #6x    #7x    #8x    #9x
num_tries_av1 = np.array([5.20, 3.70, 5.90 , 5.60 , 6.80 , 4.30 , 8.50 , 8.80 , 7.0  , 8.90,
                          #10x  #11x  #12x   #13x  #14x    #15x   #16x   #17x   #18x   #19x
                          8.90, 10.7, 6.30 , 5.10 , 5.50 , 6.60 , 4.30 , 6.30 , 6.90 , 6.30,
                          #20x  #21x  #22x   #23x  #24x    #25x   #26x   #27x   #28x   #29x
                          9.60, 19.1, 15.7 , 12.7 , 10.9 , 15.1 , 11.2 , 11.3 , 16.7 , 48.4,
                          #30x  #31x  #32x   #33x  #34x    #35x
                          23.4, 31.4, 97.3 , 40.1 , 157.0, 491.4])

                          #0x   #1x   #2x    #3x    #4x    #5x    #6x    #7x    #8x    #9x 
num_tries_av2 = np.array([5.10, 3.50, 2.60,  2.80 , 4.00 , 7.10 , 7.50 , 6.30 , 5.20 , 8.50,
                          #10x  #11x  #12x   #13x   #14x   #15x   #16x   #17x   #18x   #19x
                          4.70, 3.60, 7.40 , 6.70 , 4.90 , 6.60 , 9.60 , 9.20 , 5.60 , 8.40,
                          #20x  #21x  #22x   #23x   #24x   #25x   #26x   #27x   #28x   #29x 
                          11.0, 13.8, 11.1 , 6.60 , 6.60 , 10.8 , 13.0 , 18.1 , 32.1 , 31.8,
                          #30x  #31x  #32x   #33x   #34x   #35x                           
                          32.0, 66.5, 38.2 , 33.1,  158.5, 409.0])

                          #0x   #1x   #2x   #3x   #4x   #5x   #6x   #7x   #8x   #9x 
num_tries_av3 = np.array([3.20, 4.10, 7.20, 7.00, 7.70, 8.10, 6.10, 5.50, 9.20, 8.3,
                          #10x  #11x  #12x  #13x  #14x  #15x  #16x  #17x  #18x  #19x
                          11.1, 8.7,  6.1,  10.0, 9.5,  10.9, 6.1,  5.3,  5.2,  10.4,
                          #20x  #21x  #22x  #23x  #24x  #25x  #26x  #27x  #28x  #29x 
                          9.3,  17.5, 7.5,  18.0, 19.2, 16.6, 5.7,  12.0, 15.7, 23.0,
                          #30x  #31x  #32x   #33x   #34x   #35x                           
                          14.8, 51.3, 38.6, 75.8, 197.2, 298.8])

print("max_trnc:", len(trnc_lvs), len(num_tries_av1))

max_it = max_it1 + max_it2 + max_it3
r1 = float(max_it1)/float(max_it)
r2 = float(max_it2)/float(max_it)
r3 = float(max_it3)/float(max_it)
num_tries_av = r1 * num_tries_av1 + r2 * num_tries_av2 + r3 * num_tries_av3

fig, ax = plt.subplots()
xticks = trnc_lvs[::2]
yticks = range(500)[::10]
plt.xticks(xticks)
plt.yticks(yticks)
plt.ylim(0.0, 80.0)
#plt.yscale("log")

av = 5.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 10.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 15.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 20.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')


ax.plot(trnc_lvs, num_tries_av, 'bo-', linewidth=1, linestyle='dotted', marker='x')
ax.set(xlabel='trncation level', ylabel='average number of tries', 
       title="N = {0}  a = {1} r = {2} max_it = {3}".format(N, a, r, max_it))
plt.tight_layout()
plt.savefig(filename+".jpg")
plt.show()
