import matplotlib.pyplot as plt
import numpy as np

max_it1 = 50
max_it2 = 50
max_it3 = 50

N = 21
a = 2
r = 6
trnc_max = r-1 # r=6

filename = "tries_N{0}_a{1}_trnc_max{2}".format(N, a, trnc_max)

trnc_lvs = np.arange(trnc_max+1)  # 0, 1, ..., r-1
                          #0x  #1x    #2x   #3x   #4x   #5x
num_tries_av1 = np.array([3.8 , 6.0 , 7.4 , 3.5 , 7.5 , 41.4])
num_tries_av2 = np.array([5.8 , 2.6 , 8.6 , 8.1 , 7.8 , 87.0])
num_tries_av3 = np.array([4.8 , 4.3 , 9.1 , 6.6 , 6.7 , 112.3])

print("max_trnc:", len(trnc_lvs), len(num_tries_av1))

max_it = max_it1 + max_it2 + max_it3
r1 = float(max_it1)/float(max_it)
r2 = float(max_it2)/float(max_it)
r3 = float(max_it3)/float(max_it)
num_tries_av = r1 * num_tries_av1 + r2 * num_tries_av2 + r3 * num_tries_av3

fig, ax = plt.subplots()
xticks = trnc_lvs
yticks = range(85)[::5]
plt.xticks(xticks)
plt.yticks(yticks)
plt.ylim(0.0, 85.0)
#plt.yscale("log")

# M = 6
# av = 10**M/1.0
# x_list = [0, r-1]
# y_list = [av, av]
# ax.plot(x_list, y_list, 'go-', linewidth=1, linestyle='dotted', marker='.')
# print("**xx random:", av)

av = 5.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 10.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

ax.plot(trnc_lvs, num_tries_av, 'bo-', linewidth=1, linestyle='dotted', marker='x')
ax.set(xlabel='trncation level', ylabel='average number of tries', 
       title="N = {0}  a = {1} r = {2} max_it = {3}".format(N, a, r, max_it))

plt.tight_layout()
plt.savefig(filename+".jpg")
plt.show()
