import matplotlib.pyplot as plt
import numpy as np

max_it1 = 50
max_it2 = 50

N = 143
a = 5
r = 20
trnc_max = r-1 # r=20

filename = "tries_N{0}_a{1}_trnc_max{2}".format(N, a, trnc_max)

trnc_lvs = np.arange(trnc_max+1)  # 0, 1, ..., r-1
                          #0    #1    #2    #3    #4    #5    #6    #7    #8   #9    #10
num_tries_av1 = np.array([2.88, 3.04, 3.32, 3.46, 3.98, 3.18, 4.54, 5.02, 6.3, 6.32, 5.08,
                 4.78, 7.68, 7.26, 7.9, 8.4, 16.42, 25.84, 23.02, 24.8])
                 #11   #12   #13   #14  #15  #16    #17    #18    #19

                          #0    #1    #2    #3    #4-   #5x   #6x   #7x   #8x   #9x   #10x
num_tries_av2 = np.array([2.88, 3.04, 3.32, 3.46, 3.24, 2.96, 4.34, 5.08, 5.08, 4.84, 4.92,
                 5.56, 6.85, 7.52, 7.94, 7.10, 15.6, 19.74, 18.98, 28.72])
                 #11x  #12x  #13-  #14x  #15x  #16x  #17x   #18x   #19x

max_it = max_it1 + max_it2                 
r1 = float(max_it1)/float(max_it)
r2 = float(max_it2)/float(max_it)
num_tries_av = r1 * num_tries_av1 + r2 * num_tries_av2 # numpy arrays add pairwise

fig, ax = plt.subplots()
plt.xticks(trnc_lvs)
#plt.xlim(-0.02, 0.05)
#plt.ylim(-0.04, 0.04)

av = 5.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')

av = 10.0
x_list = [0, r-1]
y_list = [av, av]
ax.plot(x_list, y_list, 'ro-', linewidth=1, linestyle='dotted', marker='.')


ax.plot(trnc_lvs, num_tries_av, 'bo-', linewidth=1, linestyle='dotted', marker='x')
ax.set(xlabel='trncation level', ylabel='average number of tries', 
       title="N = {0}  a = {1} r = {2} max_it = {3}".format(N, a, r, max_it))
plt.tight_layout()
plt.savefig(filename+".jpg")
plt.show()
