# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np
import matplotlib.pyplot as plt

# shor local
from shor_util import run_shor_tries

######### parameters #########

# set version
ver = 5

# run factoring circuit
verbose = False
very_quiet = False

# set parameters

num_it = 50

# set parameters
N = 33
a = 7 # r=10
r = 10

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 6 # control register: ideally 2*L+1

# MEO version
# full agreement between versions 0 and 1.
#u_ver = 0 # U^p is a strict concatenation of U1's
#u_ver = 1 # U^p gates 2-cycles
u_ver = 2 # truncation
trnc_lv = 0 # truncation level: 0, 1, ..., r-1; 0=no truncation

# set filename prefix
if u_ver != 2: trnc_lv = "x"

trnc_lv_min = 0
trnc_lv_max = r-1
levels = range(trnc_lv_min, trnc_lv_max+1)
tries_lv = []
for trnc_lv in levels:
    ######### start calculation ##########        
    filename = "03_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}_it{6}".format(N, a, ver, u_ver, trnc_lv, M, num_it)

    print("** N, a, L, M, u_ver, trnc_lv num_it:", N, a, L, M, u_ver, trnc_lv, num_it)
    print("** run_shor_tries ...")
    num_try_av, num_try_sd = run_shor_tries(N, a, L, M, filename, u_ver, trnc_lv, num_it)
    tries_lv.append(num_try_av)

print()
print("**xx levels  :", list(levels))
print("**xx tries_lv:", tries_lv)    
    
