# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries
#
# v6
# qubit recycle
#
# vv1
# This is version vv1 of qubit recycling code. I am
# keeping the routine run_shor_recycle() local to
# this file. Eventually it will be placed in shor_util.py.
#
# vv1
# constructed circuit by hand. 
# does not work (doe not select the proper phases).
#
# vv2
# second attempt. still not working. 
#
# vv3
# generalize circuit. still does not work.
#
# vv4
# uses c_if(cl, 1) for feed-forward of phase operators.
# still does not select the proper phases.

# functionality
import numpy as np
import matplotlib.pyplot as plt

from shor_util import c_U1, check_solution, plot_phase_hist

# importing Qiskit
from qiskit import IBMQ, Aer, transpile, assemble
from qiskit import QuantumCircuit, ClassicalRegister, QuantumRegister

# import basic plot tools and circuits
from qiskit.visualization import plot_histogram
import matplotlib.pyplot as plt

# shor local
#from shor_util import run_shor_recycle

# qubit recycling
def run_shor_recycle(N, a, L, M, filename, u_ver, trnc_lv, shots, verbose=False): 

    print("** run_shor_recycle ...")
    print("** trnc_lv:", trnc_lv)
    n_control = 1    
    n_work = L

    # Quantum circuit
    m = QuantumRegister(n_control, name='m')
    w = QuantumRegister(n_work, name='w')

    # classical registers
    cl_reg = list(range(M))
    for c in range(M):
        cl_name = 'cl' + str(c)
        cl_reg[c] = ClassicalRegister(1, name=cl_name)
    qc = QuantumCircuit(m, w, cl_reg[0],  cl_reg[1], cl_reg[2], cl_reg[3], cl_reg[4])

    # Work register in state |1>
    qc.x(1)

    # increment counter    
    for cnt in range(M):
            
        # initialize control register to 0
        qc.initialize([1, 0], m)

        # Apply H to control register
        qc.h(0)
        
        # apply ME operator
        power = 2**(M-cnt-1)    
        qc.append(c_U1(N, a, n_work, power, u_ver, trnc_lv, barrier=False), 
                      [0] + [i+n_control for i in range(n_work)])

        # decorate control register using feed-forward phase operators
        qc.h(0)
        for myn in range(cnt):
            qc.p(np.pi/2**(cnt-myn), 0).c_if(cl_reg[myn], 1)

        # measure control register
        qc.measure(m, cl_reg[cnt])
        qc.barrier()

    # draw circuit
    qc.draw(fold=50)
    plt.savefig(filename+'_circ.jpg')
    plt.show()

    # run  circuit
    aer_sim = Aer.get_backend('aer_simulator')
    t_qc = transpile(qc, aer_sim)
    obj = assemble(t_qc)
    results = aer_sim.run(obj, shots=shots).result()
    counts_sp = results.get_counts()

    # remove spaces from keys
    counts = {}
    for l_bin in counts_sp.keys():
        l_bin_nosp = l_bin.replace(" ", "")
        counts[l_bin_nosp] = counts_sp[l_bin]

    # plot phase histogram
    width = 0.1 # nomial values 0.1-0.2
    if N > 100: # use 0.2 for larger N
        width = 0.2
    plot_phase_hist(counts, N, a, u_ver, trnc_lv, width, filename, verbose)
    plt.savefig(filename+'_hist.jpg')
    plt.show()

######### parameters #########

# set version
ver = 6

# run factoring circuit
verbose = False
very_quiet = False

# set parameters

shots = 4096
#shots = 16384

N = 21
a = 2 # r=6
r = 6

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 5 # iterations for control register
      # m=5 => power_max=16

# MEO version
# full agreement between versions 0 and 1.
#u_ver = 0 # U^p is a strict concatenation of U1's
u_ver = 1 # U^p gates 2-cycles
#u_ver = 2 # truncation
trnc_lv = 0 # truncation level: 0, 1, ..., r-1; 0=no truncation

# set filename prefix
if u_ver != 2: trnc_lv = "x"

######### start calculation ##########        
filename = "08_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}_shots{6}_recycle".format(N, a, ver, u_ver,
                                                                          trnc_lv, M, shots)
print("** N, a, L, M, u_ver, trnc_lv shots:", N, a, L, M, u_ver, trnc_lv, shots)
run_shor_recycle(N, a, L, M, filename, u_ver, trnc_lv, shots, verbose)

    
