# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package
#
# v4
# truncation
#
# v5
# tries

# functionality
import numpy as np

# shor local
from shor_util import run_meo_sequence, run_shor, run_con_U

######### parameters #########

# set version
ver = 5

# construct MEO's
verbose = False
very_quiet = False

# set parameters
N = 143
a = 5 # r=20

# set register sizes
L = int(np.ceil(np.log2(N))) # working qubits
M = 8 # use 8, 9 or 10: ideally 2*L+1
#M = 9 # higher resolution
#M = 10 # highest resolution

# MEO version
# full agreement between versions 0 and 1.
u_ver = 0 # U^p is a strict concatenation of U1's
#u_ver = 1 # U^p gates 4-cycles
#u_ver = 2
trnc_lv = 0 # truncation level: 0, 1, ..., r-1; 0=no truncation
if u_ver != 2: trnc_lv = -1

# parameters for run_meo_sequence
# set powers array
powers = [2**q for q in range(M)]
#power = 512 # m=10
#power = 256 # m=9
#power = 128 # m=8
#power = 64
#power = 32
#power = 16
#power = 8
#power = 4
#power = 2
power = 1

#check_quantum = False # 1. construct x_list sequence f(0),f(1),...
check_quantum = True # 2. use this to construct the ME gates

# set x_list = a^x mod N vs x
x_list = [1]
if a == 5: # N=143 a=5 r=20
    if power == 1:
        x_list = [1, 5, 25, 125, 53, 122, 38, 47, 92, 31, 12, 60, 14, 70, 64,
              34, 27, 135, 103, 86]
    elif power == 2:
        x_list1 = [1, 25, 53, 38, 92, 12, 14, 64, 27, 103]   # cycle 1
        x_list2 = [5, 125, 122, 47, 31, 60, 70, 34, 135, 86] # cycle 2
        x_list = x_list1 + x_list2
    elif power == 4:
        x_list1 = [1, 53, 92, 14, 27]   # cycle 1 - same as 64
        x_list2 = [5, 122, 31, 70, 135] # cycle 2 - same as 64
        x_list3 = [25, 38, 12, 64, 103] # cycle 3 - same as 64
        x_list4 = [125, 47, 60, 34, 86] # cycle 4 - same as 64
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 8:
        x_list1 = [1, 92, 27, 53, 14]   # cycle 1 - same as 128
        x_list2 = [5, 31, 135, 122, 70] # cycle 2 - same as 128
        x_list3 = [25, 12, 103, 38, 64] # cycle 3 - same as 128
        x_list4 = [125, 60, 86, 47, 34] # cycle 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 16:
        x_list1 = [1, 27, 14, 92, 53]   # cycle 1
        x_list2 = [5, 135, 70, 31, 122] # cycle 2
        x_list3 = [25, 103, 64, 12, 38] # cycle 3
        x_list4 = [125, 86, 34, 60, 47] # cycle 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 32:
        x_list1 = [1, 14, 53, 27, 92]   # cycle 1
        x_list2 = [5, 70, 122, 135, 31] # cycle 2
        x_list3 = [25, 64, 38, 103, 12] # cycle 3
        x_list4 = [125, 34, 47, 86, 60] # cycle 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 64:
        x_list1 = [1, 53, 92, 14, 27]   # cycle 1 - same as 4
        x_list2 = [5, 122, 31, 70, 135] # cycle 2 - same as 4
        x_list3 = [25, 38, 12, 64, 103] # cycle 3 - same as 4
        x_list4 = [125, 47, 60, 34, 86] # cycle 4 - same as 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 128:
        x_list1 = [1, 92, 27, 53, 14]   # cycle 1 - same as 8
        x_list2 = [5, 31, 135, 122, 70] # cycle 2 - same as 8
        x_list3 = [25, 12, 103, 38, 64] # cycle 3 - same as 8
        x_list4 = [125, 60, 86, 47, 34] # cycle 4 - same as 8
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 256:
        x_list1 = [1, 27, 14, 92, 53]
        x_list2 = [5, 135, 70, 31, 122]
        x_list3 = [25, 103, 64, 12, 38]
        x_list4 = [125, 86, 34, 60, 47]
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 512:
        x_list1 = [1, 14, 53, 27, 92]
        x_list2 = [5, 70, 122, 135, 31]
        x_list3 = [25, 64, 38, 103, 12]
        x_list4 = [125, 34, 47, 86, 60]
        x_list = x_list1 + x_list2 + x_list3 + x_list4

# set filename prefix
if trnc_lv == -1:
    filename = "03_shor_v{2}_N{0}_a{1}_m{4}_uver{3}".format(N, a, ver, u_ver, M)
else:
    filename = "03_shor_v{2}_N{0}_a{1}_m{5}_uver{3}_{4}".format(N, a, ver, u_ver, trnc_lv, M)

# print parameters
print("** N, a, L, M, u_ver, trnc_lv:", N, a, L, M, u_ver, trnc_lv)
print("** power, powers", power, powers)

######### start calculation ##########

run_meo_sequence(N, a, L, M, power, x_list, filename, u_ver,
                 trnc_lv, check_quantum, verbose, very_quiet)
