######### Modular Exponentiation Operators (MEO's) ######### 
# currently not using a=4 N=247

# N=247 a=4 r=18 m=8 => U128, U64, U32, U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}

def U256_N247_a4(U, u_ver, barrier=False):
    """ U256 for N=247 a=2 r=36."""
    if u_ver not in [0, 1, 2]:
        raise ValueError("u_ver must be 0, 1")    
    if u_ver == 0 or u_ver == 1:
        power = 256
        for iteration in range(power):
            U1_N247_a4(U, u_ver, barrier)
    return U

def U128_N247_a4(U, u_ver, barrier=False):
    """ U128 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")    
    if u_ver == 0:                    
        power = 128
        U1_N247_a4(U, u_ver, barrier)
    return U

def U64_N247_a4(U, u_ver, barrier=False):
    """ U64 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")    
    if u_ver == 0:        
        power = 64
        U1_N247_a4(U, u_ver, barrier)
    return U

def U32_N247_a4(U, u_ver, barrier=False):
    """ U32 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")        
    if u_ver == 0:
        power = 32
        U1_N247_a4(U, u_ver, barrier)
    return U

def U16_N247_a4(U, u_ver, barrier=False): # same as U4
    """U16 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")     
    if u_ver == 0:
        power = 16
        U1_N247_a4(U, u_ver, barrier)
    return U

def U8_N247_a4(U, u_ver, barrier=False):
    """U8 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")     
    if u_ver == 0:
        power = 8
        U1_N247_a4(U, u_ver, barrier)
    else:
        pass
    return U

def U4_N247_a4(U, u_ver, barrier=False):
    """U4"""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")        
    if u_ver == 0:
        power = 4
        U1_N247_a4(U, u_ver, barrier)
    return U

def U2_N247_a4(U, u_ver, barrier=False):
    """U2 for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")    
    if u_ver == 0:
        power = 2
        U1_N247_a4(U, u_ver, barrier)
    return U

def U1_N247_a4(U, u_ver, barrier=False):
    """ U1 Modular Exponentiation Operator for N=247 a=4 r=18."""
    if u_ver not in [0]:
        raise ValueError("u_ver must be 0, 1")    
    if u_ver == 0:
        # r=18
        # 1, 4, 16, 64, 9, 36, 144, 82, 81, 77, 61, 244,
        # 235, 199, 55, 220, 139, 62
        # 1 -> 4
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(4, 0)
        U.cx(2, 4)
        if barrier: U.barrier()
        # 4 -> 16
        U.cx(4, 2)
        if barrier: U.barrier()
        # 16 -> 64
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 6)
        U.cx(6, 0)
        if barrier: U.barrier()
        # 64 -> 9
        U.cx(0, 3)
        U.cx(0, 6)
        # 9 -> 36
        if barrier: U.barrier()
        U.x(0)
        U.x(4)
        U.x(6)
        U.mct([0, 2, 3, 4, 6], 5)
        U.x(0)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(6)
        U.ccx(6, 5, 3)
        U.x(6)
        if barrier: U.barrier()
        # 36 -> 144
        U.x(6)
        U.mct([3, 4, 6], 7)
        U.mct([3, 4, 6], 5)
        U.x(6)
        U.cx(7, 3)
        if barrier: U.barrier()
        # 144 -> 82
        U.ccx(3, 6, 7)
        U.ccx(3, 6, 4)
        U.ccx(3, 6, 1)
        U.ccx(6, 4, 3)
        if barrier: U.barrier()
        # 82 -> 81
        U.ccx(0, 6, 7)
        if barrier: U.barrier()
        # 81 -> 77        
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        if barrier: U.barrier()
        # 77 -> 61
        U.mct([0, 1, 2], 4)
        U.mct([0, 1, 2], 5)
        U.mct([0, 2, 4], 1)        
        if barrier: U.barrier()        
        # 61 -> 244
        U.x(0)
        U.mct([0, 2, 3], 1)
        U.mct([0, 2, 3], 4)
        U.x(0)
        if barrier: U.barrier()
        U.ccx(7, 6, 3)
        if barrier: U.barrier()
        # 244 -> 235
        U.x(2)
        U.mct([2, 5, 6], 1)
        U.mct([2, 5, 6], 4)
        U.mct([2, 5, 6], 7)
        U.x(2)
        if barrier: U.barrier()
        # * two phases yield factors upon truncation here
        #   the signal is weak but detectable
        # 235 -> 199
        U.mct([1, 2, 3, 7], 6)
        U.mct([1, 2, 3, 7], 5)
        U.mct([1, 2, 3, 7], 4)
        U.mct([1, 2], 3)
        if barrier: U.barrier()
        # 199 -> 55
        U.x(3)
        U.mct([0, 2, 3, 5], 1)
        U.mct([0, 2, 3, 5], 4)
        U.x(3)
        if barrier: U.barrier()
        # 55 -> 220
        U.x(0)
        U.mct([0, 2, 3], 7)
        U.mct([0, 2, 3], 5)
        U.mct([0, 2, 3], 4)
        U.x(0)
        if barrier: U.barrier()
        # 220 -> 139        
        U.x(2)
        U.x(5)
        U.mct([0, 1, 2, 5], 3)
        U.mct([0, 1, 2, 5], 6)
        U.x(2)
        U.x(5)
        if barrier: U.barrier()
        # 139 -> 62
        U.x(0)
        U.x(6)
        U.mct([0, 2, 3, 6], 1)
        U.mct([0, 2, 3, 6], 4)
        U.mct([0, 2, 3, 6], 5)
        U.x(0)
        U.x(6)
        if barrier: U.barrier()
        # 62 -> 1
        U.x(2)
        U.x(3)
        U.x(7)
        U.mct([1, 2, 3, 5, 7], 0)
        U.mct([1, 2, 3, 5, 7], 4)
        U.mct([1, 2, 3, 5, 7], 6)
        U.x(2)
        U.x(3)
        U.x(7)
        if barrier: U.barrier()
        U.x(2)
        U.x(3)
        U.x(6)
        U.mct([0, 2, 3, 6], 1)
        U.mct([0, 2, 3, 6], 5)
        U.x(2)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
    return U

