# Robert Singleton
# 3/16/2023
#
# v2
# - python package
#
# v3
# - python package

# functionality
import numpy as np
from random import randint

# shor local
from shor_util import run_meo_sequence, run_shor

######### parameters #########

# set version
ver = 3

# analysis modes: meo exploration and shor factoring
do_meo = False
do_shor = True

verbose = False
very_quiet = True

# set parameters
# parameters
N = 15 # a=2,4,7,8,11,13
L = int(np.ceil(np.log2(N)))
a = 2 # r=2,4

# # chose random guess a
# # random integer in [2,N-2] with gcd(a,N)=1
# print("** choose random base a")
# n = 0
# while n == 0:
#     a = randint(2, N-2)
#     if np.gcd(a, N) == 1: n = 1
#     print("** a, N gcd", a, N, np.gcd(a, N))

# set size of control register
M = 5 # ideally 2*L+1

# MEO version
u_ver = 0 # U^p is a strict concatenation of U1's

# parameters for run_meo_sequence
# set powers array
powers = [2**q for q in range(M)] 
#power = 16
#power = 8
#power = 4
power = 2
#power = 1

# set x_list = a^x mod N vs x
x_list = [1]
if a == 2:
    if power == 16:
        x_list1 = [1] # 1 -> 1
        x_list2 = [2] # 2 -> 2
        x_list3 = [4] # 3 -> 3
        x_list4 = [8] # 4 -> 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4        
    elif power == 8:
        x_list1 = [1] # 1 -> 1
        x_list2 = [2] # 2 -> 2
        x_list3 = [4] # 3 -> 3
        x_list4 = [8] # 4 -> 4
        x_list = x_list1 + x_list2 + x_list3 + x_list4        
    elif power == 4:
        x_list1 = [1] # 1 -> 1
        x_list2 = [2] # 2 -> 2
        x_list3 = [4] # 4 -> 4
        x_list4 = [8] # 8 -> 8
        x_list = x_list1 + x_list2 + x_list3 + x_list4
    elif power == 2:
        x_list1 = [1, 4] # 1 -> 4 -> 1
        x_list2 = [2, 8] # 2 -> 8 -> 2
        x_list = x_list1 + x_list2
    elif power == 1:
        x_list = [1, 2, 4, 8] # 1 -> 2 -> 4 -> 8 -> 1


# set filename prefix
filename = "14_shor_v{2}_N{0}_a{1}_uver{3}".format(N, a, ver, u_ver)

# print parameters
print("** N, a, L, M, u_ver:", N, a, L, M, u_ver)
print("** power, powers", power, powers)


######### start calculation ##########

if do_meo:
    run_meo_sequence(N, a, L, M, power, x_list, filename, u_ver, verbose, very_quiet)

if do_shor:
    run_shor(N, a, L, M, filename, u_ver, verbose, very_quiet)

