import matplotlib.pyplot as plt
import numpy as np

max_it1 = 50 # todo: increase this to 100
trnc_max = 20 # r=20
N = 143
a = 5

filename = "tries_N{0}_a{1}_trnc_max{2}".format(N, a, trnc_max)

trnc_lvs = np.arange(trnc_max)  # 0, 1, ..., r-1
num_tries_av = [2.88, 3.04, 3.32, 3.46, 3.98, 3.18, 4.54, 5.02, 6.3, 6.32, 5.08, 4.78, 7.68, 7.26,
                7.9, 8.4, 16.42, 25.84, 23.02, 24.8]

fig, ax = plt.subplots() 
ax.plot(trnc_lvs, num_tries_av, linewidth=1, linestyle='dotted', marker='x')
ax.set(xlabel='trncation level', ylabel='average number of tries', 
       title="truncation study: N = {0}  a = {1} max_it = {2}".format(N, a, max_it))
plt.tight_layout()
plt.savefig(filename+".jpg")
plt.show()
