######### Modular Exponentiation Operators (MEO's) ######### 

def U32_N33_a7(U, u_ver, barrier=False):
    """U32 for N=33 a=7 r=10."""
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N33_a7(U, u_ver, barrier)
    elif u_ver == 2:
        # same as U2
        # 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 4
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        if barrier: U.barrier()
        # 4 -> 31
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 31 -> 1
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        if barrier: U.barrier()
    elif u_ver == 1:
        # cycle-1  1 -> 4 -> 16 -> 31 -> 25 -> 1
        # 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 4
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        if barrier: U.barrier()
        # 4 -> 31
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 31 -> 1
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        if barrier: U.barrier()
        # cycle-2  7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 7 -> 13
        # automatic
        # 13-> 10
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 4 )
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.x( 4 )
        if barrier: U.barrier()
        # 10 -> 28
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 0 )
        #if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 28 -> 19
        # automatic
        # 19 -> 7
        # automatic

    return U

def U16_N33_a7(U, u_ver, barrier=False): # same as U4
    """U16 for N=33 a=7 r=10."""
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N33_a7(U, u_ver, barrier)
    elif u_ver == 2: # 1 -> 4 -> 16 -> 31 -> 25 -> 1
        # 1 -> 4
        if barrier: U.barrier()
        U.swap(0, 2)
        if barrier: U.barrier()
        # 4 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 31
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 31 -> 25
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 3)        
        U.x(1)
        if barrier: U.barrier()
        # 25 -> 1
        U.x(2)
        U.x(3)
        U.mct([0,2, 3], 1)
        U.mct([0,2, 3], 4)        
        U.x(2)
        U.x(3)
        if barrier: U.barrier()
    elif u_ver == 1: #
        # cycle-1 1 -> 4 -> 16 -> 31 -> 25 -> 1
        # 1 -> 4
        if barrier: U.barrier()
        U.swap(0, 2)
        if barrier: U.barrier()
        # 4 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 31
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 31 -> 25
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 3)        
        U.x(1)
        if barrier: U.barrier()
        # 25 -> 1
        U.x(2)
        U.x(3)
        U.mct([0,2, 3], 1)
        U.mct([0,2, 3], 4)        
        U.x(2)
        U.x(3)
        if barrier: U.barrier()
        # cycle-2 7 -> 28 -> 13 -> 19 -> 10 -> 7
        # 7 -> 28
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 28 -> 13
        U.x( 4 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 4 )
        if barrier: U.barrier()
        # 13 -> 19
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        if barrier: U.barrier()
        # 19 -> 10
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 10 -> 7
        U.x( 3 )
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    return U

def U8_N33_a7(U, u_ver, barrier=False): #
    """U8 for N=33 a=7 r=10."""    
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N33_a7(U, u_ver, barrier)
    elif u_ver ==2: # 1 -> 31 -> 4 -> 25 -> 16 -> 1
        if barrier: U.barrier()
        # 1 -> 31
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 31 -> 4
        U.x(4)
        U.cswap(4, 0, 2)
        U.x(4)
        if barrier: U.barrier()
        # 4 -> 25
        U.x(1)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)        
        U.x(1)
        # 25 -> 16
        U.x(3)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 1)
        U.ccx(0, 3, 2)        
        U.x(3)
        if barrier: U.barrier()
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        # 16 -> 1
        U.x(3)
        U.ccx(0, 3, 4)
        U.x(3)
        if barrier: U.barrier()            
    elif u_ver == 1:
        # cycle-1 1 -> 31 -> 4 -> 25 -> 16 -> 1
        if barrier: U.barrier()
        # 1 -> 31
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 31 -> 4
        U.x(4)
        U.cswap(4, 0, 2)
        U.x(4)
        if barrier: U.barrier()
        # 4 -> 25
        U.x(1)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)        
        U.x(1)
        # 25 -> 16
        U.x(3)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 1)
        U.ccx(0, 3, 2)        
        U.x(3)
        if barrier: U.barrier()
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        # 16 -> 1
        U.x(3)
        U.ccx(0, 3, 4)
        U.x(3)
        if barrier: U.barrier()
        # cycle-2 7 -> 19 -> 28 -> 10 -> 13 -> 7
        # 7 -> 19
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        if barrier: U.barrier()
        # 19 -> 28
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 28 -> 10
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 10 -> 13
        U.x( 3 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 13-> 7
        U.x( 3 )
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    return U

def U4_N33_a7(U, u_ver, barrier=False):
    """U4 for N=33 a=7 r=10."""        
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N33_a7(U, u_ver, barrier)
    elif u_ver == 2: # 1 -> 25 -> 31 -> 16 -> 4 -> 1
        # 1 -> 25
        if barrier: U.barrier()
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 31
        U.x(4)
        U.ccx(0, 4, 1)
        U.ccx(0, 4, 2)
        U.ccx(0, 4, 3)        
        U.x(4)
        if barrier: U.barrier()
        U.ccx(0, 1, 4)
        # 31 -> 16
        U.cswap(0, 3, 4)
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        if barrier: U.barrier()
        # 16 -> 4
        U.x(3)
        U.mct([0, 3, 4], 2)
        U.x(3)
        if barrier: U.barrier()
        U.x(1)
        U.ccx(1, 2, 0)
        U.ccx(1, 2, 4)        
        U.x(1)
        if barrier: U.barrier()
        # 4 -> 1
        U.x(3)
        U.ccx(0, 3, 2)
        U.ccx(0, 3, 4)        
        U.x(3)
        if barrier: U.barrier()            
    elif u_ver == 1:
        # cycle-1 1 -> 25 -> 31 -> 16 -> 4 -> 1
        # 1 -> 25
        if barrier: U.barrier()
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 31
        U.x(4)
        U.ccx(0, 4, 1)
        U.ccx(0, 4, 2)
        U.ccx(0, 4, 3)        
        U.x(4)
        if barrier: U.barrier()
        U.ccx(0, 1, 4)
        # 31 -> 16
        U.cswap(0, 3, 4)
        U.x(3)
        U.ccx(4, 3, 0)
        U.x(3)
        if barrier: U.barrier()
        # 16 -> 4
        U.x(3)
        U.mct([0, 3, 4], 2)
        U.x(3)
        if barrier: U.barrier()
        U.x(1)
        U.ccx(1, 2, 0)
        U.ccx(1, 2, 4)        
        U.x(1)
        if barrier: U.barrier()
        # 4 -> 1
        U.x(3)
        U.ccx(0, 3, 2)
        U.ccx(0, 3, 4)        
        U.x(3)
        if barrier: U.barrier()
        # cycle-2 7 -> 10 -> 19 -> 13 -> 28 -> 7
        # 7 -> 10
        U.x( 0 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.ccx( 0 , 1 , 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 10 -> 19
        U.x( 3 )
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.x( 3 )
        if barrier: U.barrier()
        # 19 -> 13
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 13 -> 28
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.x( 3 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 28 -> 7
        U.x( 3 )
        U.mct( [2, 3, 4] , 0 )
        U.mct( [2, 3, 4] , 1 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 3 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.x( 3 )
        if barrier: U.barrier()
    return U

def U2_N33_a7(U, u_ver, barrier=False):
    """U2 for N=33 a=7 r=10."""        
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N33_a7(U, u_ver, barrier)
    if u_ver == 2: # 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 4
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        if barrier: U.barrier()
        # 4 -> 31
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 31 -> 1
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        if barrier: U.barrier()            
    if u_ver == 1:
        # cycle-1 1 -> 16 -> 25 -> 4 -> 31 -> 1
        # 1 -> 16
        if barrier: U.barrier()
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 4
        U.x(3)
        U.ccx(0, 3, 2)
        U.x(3)
        U.cx(2, 0)
        if barrier: U.barrier()
        # 4 -> 31
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)
        # 31 -> 1
        U.x(3)
        U.ccx(0, 3, 1)
        U.x(3)
        if barrier: U.barrier()
        # cycle-2 7 -> 13 -> 10 -> 28 -> 19 -> 7
        # 7 -> 13
        # automatic
        # 13 -> 10
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 4 )
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.x( 4 )
        if barrier: U.barrier()
        # 10 -> 28
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 4 )
        U.x( 3 )
        #if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 0 )
        #if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3] , 1 )
        U.x( 0 )
        #if barrier: U.barrier()
        # 28 -> 19
        # automatic
        # 19 -> 7
        # automatic
        if barrier: U.barrier()
    return U

def U1_N33_a7(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=33 a=7 r=10."""        
    if u_ver == 0 or u_ver == 1:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1 -> 7
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        if barrier: U.barrier()
        # 7 -> 16
        U.x( 1 )
        U.cx( 1 , 0 )
        U.cx( 1 , 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 16 -> 13
        U.x( 1 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 13 -> 25
        U.x( 2 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.x( 2 )
        if barrier: U.barrier()
        # 25 -> 10
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.ccx( 1 , 3 , 4 )
        #if barrier: U.barrier()
        U.ccx( 2 , 4 , 0 )
        U.ccx( 2 , 4 , 1 )
        U.ccx( 2 , 4 , 3 )
        if barrier: U.barrier()
        # 10 -> 4
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 4 -> 28
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 28 -> 31
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        if barrier: U.barrier()
        # 31 -> 19
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3] , 1 )
        U.mct( [0, 2, 3] , 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # 19 -> 1
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 1 )
        #if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
    elif u_ver == 2:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1 -> 7
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        if barrier: U.barrier()
        # 7 -> 16
        U.x( 1 )
        U.cx( 1 , 0 )
        U.cx( 1 , 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 16 -> 13
        U.x( 1 )
        U.ccx( 0 , 1 , 2 )
        U.ccx( 0 , 1 , 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 13 -> 25
        U.x( 2 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.x( 2 )
        if barrier: U.barrier()
        # 25 -> 10
        U.ccx( 1 , 3 , 0 )
        U.ccx( 1 , 3 , 2 )
        U.ccx( 1 , 3 , 4 )
        #if barrier: U.barrier()
        U.ccx( 2 , 4 , 0 )
        U.ccx( 2 , 4 , 1 )
        U.ccx( 2 , 4 , 3 )
        if barrier: U.barrier()
        # 10 -> 4
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # # 4 -> 28
        # U.x( 1 )
        # U.mct( [1, 2, 4] , 0 )
        # U.mct( [1, 2, 4] , 3 )
        # U.x( 1 )
        if barrier: U.barrier()
        # # 28 -> 31
        # U.mct( [0, 1, 4] , 2 )
        # U.mct( [0, 1, 4] , 3 )
        if barrier: U.barrier()
        # # 31 -> 19
        # U.x( 4 )
        # U.x( 2 )
        # U.x( 1 )
        # U.mct( [1, 2, 4] , 0 )
        # U.mct( [1, 2, 4] , 3 )
        # U.x( 4 )
        # U.x( 2 )
        # U.x( 1 )
        # #if barrier: U.barrier()
        # U.x( 3 )
        # U.x( 2 )
        # U.mct( [0, 2, 3] , 1 )
        # U.mct( [0, 2, 3] , 4 )
        # U.x( 3 )
        # U.x( 2 )
        if barrier: U.barrier()
        # # 19 -> 1
        # U.x( 1 )
        # U.mct( [0, 1, 2, 4] , 3 )
        # U.x( 1 )
        # #if barrier: U.barrier()
        # U.x( 3 )
        # U.x( 1 )
        # U.mct( [0, 1, 3] , 2 )
        # U.mct( [0, 1, 3] , 4 )
        # U.x( 3 )
        # U.x( 1 )
        if barrier: U.barrier()
    return U


def U1_N33_a7_orig(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=33 a=7 r=10."""        
    if u_ver == 0 or u_ver == 1:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1 -> 7
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        if barrier: U.barrier()
        # 7 -> 16
        U.x(1)
        U.x(2)
        U.ccx(1, 2, 0)
        U.ccx(1, 2, 4)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # 16 -> 13
        U.x(1)
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.x(1)
        if barrier: U.barrier()
        # 13 -> 25
        U.x(2)
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 4)
        U.x(2)
        if barrier: U.barrier()
        # 25 -> 10
        U.ccx(1, 3, 0)
        U.ccx(1, 3, 2)
        U.ccx(1, 3, 4)
        if barrier: U.barrier()
        # 10 -> 4
        U.mct([2, 3, 4], 0)
        U.mct([2, 3, 4], 1)
        if barrier: U.barrier()        
        U.x(0)
        U.x(1)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 4)        
        U.x(1)
        U.x(0)
        if barrier: U.barrier()        
        # 4 -> 28 -> 31 -> 19
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3], 4)
        U.x(2)
        U.x(1)
        U.x(0)
        if barrier: U.barrier()        
        #
        U.x(1)
        U.x(2)
        U.mct([1, 2, 4, 3], 0)
        U.mct([1, 2, 4, 0], 3)
        U.mct([1, 2, 4, 3], 0)        
        U.x(2)
        U.x(1)
        if barrier: U.barrier()        
        #
        U.x(3)
        U.mct([4, 3, 0], 1)
        U.x(3)
        if barrier: U.barrier()        
        # 19 -> 1
        U.mct([4, 3, 0, 2], 1)
        U.mct([4, 3, 0, 1], 2)
        U.mct([4, 3, 0, 2], 1)
        if barrier: U.barrier()        
        #
        U.x(2)
        U.mct([0, 1, 2, 3], 4)        
        U.x(2)
        if barrier: U.barrier()        
        #
        U.x(2)
        U.x(4)
        U.mct([0, 2, 4], 1)
        U.mct([0, 2, 4], 3)        
        U.x(4)
        U.x(2)
        if barrier: U.barrier()        
    if u_ver == 2:
        # r=10
        # 1 -> 7 -> 16 -> 13 -> 25 -> 10 -> 4 -> 28 -> 31 -> 19 -> 1
        # 1 -> 7
        if barrier: U.barrier()
        U.cx(0, 1)
        U.cx(0, 2)
        if barrier: U.barrier()
        # 7 -> 16
        U.x(1)
        U.x(2)
        U.ccx(1, 2, 0)
        U.ccx(1, 2, 4)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # 16 -> 13
        U.x(1)
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.x(1)
        if barrier: U.barrier()
        # 13 -> 25
        U.x(2)
        U.ccx(0, 2, 1)
        U.ccx(0, 2, 4)
        U.x(2)
        if barrier: U.barrier()
        # 25 -> 10
        U.ccx(1, 3, 0)
        U.ccx(1, 3, 2)
        U.ccx(1, 3, 4)
        if barrier: U.barrier()
        # 10 -> 4
        U.mct([2, 3, 4], 0)
        U.mct([2, 3, 4], 1)
        if barrier: U.barrier()        
        U.x(0)
        U.x(1)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 4)        
        U.x(1)
        U.x(0)
        if barrier: U.barrier()        
        # 4 -> 28 -> 31 -> 19
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3], 4)
        U.x(2)
        U.x(1)
        U.x(0)
        if barrier: U.barrier()        
        #
        U.x(1)
        U.x(2)
        U.mct([1, 2, 4, 3], 0)
        U.mct([1, 2, 4, 0], 3)
        U.mct([1, 2, 4, 3], 0)        
        U.x(2)
        U.x(1)
        if barrier: U.barrier()        
        #
        U.x(3)
        U.mct([4, 3, 0], 1)
        U.x(3)
        if barrier: U.barrier()        
        # 19 -> 1
        U.mct([4, 3, 0, 2], 1)
        U.mct([4, 3, 0, 1], 2)
        U.mct([4, 3, 0, 2], 1)
        if barrier: U.barrier()        
        #
        U.x(2)
        U.mct([0, 1, 2, 3], 4)        
        U.x(2)
        if barrier: U.barrier()        
        #
        U.x(2)
        U.x(4)
        U.mct([0, 2, 4], 1)
        U.mct([0, 2, 4], 3)        
        U.x(4)
        U.x(2)
        if barrier: U.barrier()        
    return U
