######### Modular Exponentiation Operators (MEO's) ######### 

def U512_N247_a2(U, u_ver, barrier=False):
    """ U512 for N=247 a=2 r=36."""
    if u_ver == 0 or u_ver == 1 or u_ver == 2:
        power = 512
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    return U

def U256_N247_a2(U, u_ver, barrier=False):
    """ U256 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 256
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle-1
        # 1 -> 16 -> 9 -> 144 -> 81 -> 61 -> 235 -> 55 -> 139 -> 1
        # 1 -> 16
        U.cx(0, 4)
        U.cx(4, 0)
        if barrier: U.barrier()
        # 16 -> 9
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 9 -> 144
        U.ccx(3, 4, 7)
        U.x(0)
        U.ccx(0, 7, 3)
        U.x(0)
        if barrier: U.barrier()
        # 144 -> 81        
        U.ccx(0, 7, 3)
        U.ccx(0, 7, 4)
        U.ccx(0, 7, 6)
        U.ccx(0, 4, 7)
        if barrier: U.barrier()
        # 81 -> 61
        U.x(3)
        U.x(6)
        U.mct([0, 3, 6], 2)
        U.mct([0, 3, 6], 4)
        U.mct([0, 3, 6], 5)
        U.mct([0, 3, 6], 7)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
        U.ccx(0, 5, 3)
        if barrier: U.barrier()
        # 61 -> 235        
        U.x(3)
        U.x(4)
        U.mct([0, 3, 4], 1)
        U.mct([0, 3, 4], 5)
        U.mct([0, 3, 4], 6)
        U.mct([0, 3, 4], 7)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()        
        U.ccx(0, 1, 3)
        if barrier: U.barrier()
        # 235 -> 55
        U.ccx(1, 4, 0)
        U.ccx(1, 4, 2)
        U.ccx(1, 4, 3)
        U.ccx(1, 4, 6)
        if barrier: U.barrier()
        # 55 -> 139
        U.mct([0, 1, 2, 7], 3)
        U.mct([0, 1, 2, 7], 5)
        U.mct([0, 1, 2, 7], 6)
        U.x(5)
        U.mct([0, 1, 5], 2)
        U.x(5)
        if barrier: U.barrier()        
        # 139 -> 1
        U.x(2)
        U.x(3)
        U.x(7)
        U.mct([0, 1, 2, 3, 7], 4)
        U.mct([0, 1, 2, 3, 7], 6)
        U.x(2)
        U.x(3)
        U.x(7)
        if barrier: U.barrier()
        U.x(2)
        U.x(3)
        U.x(6)
        U.mct([0, 2, 3, 6], 1)
        U.x(2)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
        # cycle-2
        # 2 -> 32 -> 18 -> 41 -> 162 -> 122 -> 223 -> 110 -> 31 -> 1
        # 2 -> 32        
        U.x(0)
        U.x(4)
        U.mct([0, 4], 1)
        U.mct([0, 4], 5)
        U.x(0)
        U.x(4)
        if barrier: U.barrier()
        # 32 -> 18
        U.x(0)
        U.ccx(0, 1, 4)
        U.x(0)
        if barrier: U.barrier()
        # 18 -> 41
        U.x(7)
        U.x(4)
        U.mct([0, 1, 4, 7], 2)
        U.mct([0, 1, 4, 7], 3)
        U.mct([0, 1, 4, 7], 5)
        U.x(7)
        U.x(4)
        if barrier: U.barrier()
        U.x(2)
        U.x(6)
        U.mct([0, 2, 3,  5, 6], 1)
        U.x(2)
        U.x(6)
        if barrier: U.barrier()        
        # 41 -> 162
        U.x(0)
        U.mct([0, 5, 7], 1)
        U.mct([0, 5, 7], 4)
        U.x(0)
        if barrier: U.barrier()        
        # 162 -> 122
        U.x(0)
        U.ccx(0, 3, 1)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 5)
        U.ccx(0, 3, 6)
        U.ccx(0, 3, 7)
        U.x(0)
        if barrier: U.barrier()        
        # 122 -> 223
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 4, 5], 3)
        U.mct([0, 1, 2, 4, 5], 6)
        U.mct([0, 1, 2, 4, 5], 7)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()        
        U.mct([0, 3, 4, 6], 1)
        U.mct([0, 3, 4, 6], 2)
        U.mct([0, 3, 4, 6], 5)
        if barrier: U.barrier()        
        # 223 -> 110
        U.x(4)
        U.mct([1, 2, 3, 4], 0)
        U.mct([1, 2, 3, 4], 7)
        U.x(4)
        if barrier: U.barrier()        
        # 110 -> 31
        U.x(6)
        U.mct([1, 2, 3, 6], 0)
        U.mct([1, 2, 3, 6], 5)
        U.mct([1, 2, 3, 6], 7)
        U.x(6)
        if barrier: U.barrier()        
        # 32 -> 1
        U.x(2)
        U.x(3)
        U.x(7)
        U.mct([1, 2, 3, 6, 7], 0)
        U.mct([1, 2, 3, 6, 7], 4)
        U.mct([1, 2, 3, 6, 7], 5)
        U.x(2)
        U.x(3)
        U.x(7)
        if barrier: U.barrier()                
        U.x(0)
        U.x(4)
        U.x(5)
        U.mct([0, 1, 4, 5], 6)
        U.x(0)
        U.x(4)
        U.x(5)
        if barrier: U.barrier()
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 4 -> 64
        U.x(0)
        U.x(3)
        U.x(7)
        U.mct([0, 3,  4, 5, 7], 1)
        U.mct([0, 3,  4, 5, 7], 2)
        U.mct([0, 3,  4, 5, 7], 6)
        U.x(0)
        U.x(3)
        U.x(7)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.x(7)
        U.mct([0, 1, 6, 7], 4)
        U.mct([0, 1, 6, 7], 5)
        U.x(0)
        U.x(1)
        U.x(7)
        if barrier: U.barrier()
        # 64 -> 36
        U.x(3)
        U.x(4)
        U.x(7)
        U.mct([0, 3, 4, 6, 7], 1)
        U.mct([0, 3, 4, 6, 7], 2)
        U.mct([0, 3, 4, 6, 7], 5)
        U.x(3)
        U.x(4)
        U.x(7)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.mct([1, 2, 3], 0)
        U.mct([1, 2, 3], 6)
        U.x(1)
        U.x(3)
        # 36 -> 82        
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1,  2, 3, 4], 6)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 3, 4, 6], 2)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 82 -> 77
        U.x(4)
        U.x(7)
        U.mct([0, 3, 4, 6, 7], 1)
        U.mct([0, 3, 4, 6, 7], 2)
        U.mct([0, 3, 4, 6, 7], 5)
        U.x(4)
        U.x(7)
        if barrier: U.barrier()
        # 77 -> 244
        U.x(1)
        U.x(3)
        U.mct([1, 2, 3, 4], 0)
        U.mct([1, 2, 3, 4], 5)
        U.mct([1, 2, 3, 4], 6)
        U.x(1)
        U.x(3)
        if barrier: U.barrier()
        # 244 -> 199
        U.x(3)
        U.x(4)
        U.mct([0, 3, 4, 6], 1)
        U.mct([0, 3, 4, 6], 2)
        U.mct([0, 3, 4, 6], 5)
        U.mct([0, 3, 4, 6], 7)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
        # 199 -> 220
        U.x(5)
        U.x(6)
        U.mct([2, 4, 5, 6, 7], 0)
        U.mct([2, 4, 5, 6, 7], 1)
        U.mct([2, 4, 5, 6, 7], 3)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        # 220 -> 62
        U.x(1)
        U.x(5)
        U.x(6)
        U.mct([1, 2, 3, 4, 5, 6], 0)
        U.x(1)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(6)
        U.mct([0, 2, 3, 4, 6], 1)
        U.mct([0, 2, 3, 4, 6], 5)
        U.x(0)
        U.x(6)
        if barrier: U.barrier()        
        # 62 -> 4
        U.x(0)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        U.mct( [0, 2, 3, 4, 5, 6] , 1 )
        U.mct( [0, 2, 3, 4, 5, 6] , 7 )
        U.x(0)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 8 -> 128
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.mct( [0, 1, 2, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 72
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 164
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 6, 7] , 2 )
        U.mct( [0, 1, 3, 4, 6, 7] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 154
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6] , 0 )
        U.mct( [1, 3, 4, 5, 6] , 2 )
        U.mct( [1, 3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5] , 1 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 241
        U.x( 6 )
        U.mct( [2, 3, 4, 6, 7] , 0 )
        U.mct( [2, 3, 4, 6, 7] , 1 )
        U.mct( [2, 3, 4, 6, 7] , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 4, 5, 7] , 2 )
        U.mct( [0, 1, 4, 5, 7] , 3 )
        U.mct( [0, 1, 4, 5, 7] , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 151
        U.x( 6 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 5, 6] , 1 )
        U.mct( [0, 2, 3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [0, 1, 4, 6, 7] , 2 )
        U.mct( [0, 1, 4, 6, 7] , 3 )
        U.mct( [0, 1, 4, 6, 7] , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        # 151 -> 193
        U.x( 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 6, 7] , 0 )
        U.mct( [1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 124
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 8
        U.x( 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 6, 7] , 0 )
        U.x( 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 6] , 1 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()

        
    return U

def U128_N247_a2(U, u_ver, barrier=False):
    """ U128 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 128
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle-1 [1, 61, 16, 235, 9, 55, 144, 139, 81]
        # 1 -> 61
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 5)
        if barrier: U.barrier()
        # 61 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 235
        if barrier: U.barrier()
        U.x(4)
        U.cx(4, 7)
        U.cx(4, 6)
        U.cx(4, 3)
        U.cx(4, 1)
        U.x(4)
        if barrier: U.barrier()
        U.ccx(0, 1, 5)
        # 235 -> 9
        U.mct([7, 6, 4], 5)
        U.mct([7, 6, 4], 3)
        U.mct([7, 6, 4], 2)
        U.mct([7, 6, 4], 1)
        if barrier: U.barrier()
        U.x(5)
        U.mct([0, 5], 7)
        U.mct([0, 5], 6)
        U.mct([0, 5], 4)
        U.x(5)
        if barrier: U.barrier()
        # 9 -> 55
        U.x(3)
        U.mct([3, 2, 0], 1)
        U.x(3)
        if barrier: U.barrier()
        # 55 -> 144
        U.x(5)
        U.mct([5, 4, 1], 7)
        U.mct([5, 4, 1], 3)            
        U.x(5)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 3, 1)
        U.x(0)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 7, 1)
        U.x(0)
        if barrier: U.barrier()
        # 144 -> 139
        U.x(4)
        U.x(7)
        U.mct([7, 4, 1, 0], 6)
        U.mct([7, 4, 1, 0], 5)
        U.x(4)
        U.x(7)
        if barrier: U.barrier()
        U.x(2)
        U.x(5)
        U.mct([1, 2, 3, 5], 7)
        U.x(2)
        U.x(5)
        if barrier: U.barrier()
        # 139 -> 81
        U.x(7)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 2)
        U.x(7)
        # 81 -> 1
        if barrier: U.barrier()
        U.x(7)
        U.x(4)
        U.x(2)
        U.mct([7, 6, 4, 2], 5)
        U.mct([7, 6, 4, 2], 3)
        U.mct([7, 6, 4, 2], 1)
        U.mct([7, 6, 4, 2], 0)
        U.x(7)
        U.x(4)
        U.x(2)
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4], 6)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
        # cycle-2 [2, 122, 32, 223, 18, 110, 41, 31, 162]
        # 2 -> 122
        U.x( 0 )
        U.mct( [0, 3] , 1 )
        U.mct( [0, 3] , 4 )
        U.mct( [0, 3] , 5 )
        U.mct( [0, 3] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 122 -> 32
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 32 -> 223
        U.x( 5 )
        U.mct( [3, 4, 5] , 0 )
        U.mct( [3, 4, 5] , 1 )
        U.mct( [3, 4, 5] , 2 )
        U.mct( [3, 4, 5] , 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 6 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 223 -> 18
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 3] , 4 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 110
        U.x( 0 )
        U.mct( [0, 1, 2] , 4 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 41
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 7] , 5 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 41 -> 31
        U.x( 5 )
        U.x( 4 )
        U.mct( [0, 1, 2, 4, 5] , 3 )
        U.mct( [0, 1, 2, 4, 5] , 6 )
        U.mct( [0, 1, 2, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 6 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 6 )
        if barrier: U.barrier()
        # 31 -> 162
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 2
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 4, 5] , 1 )
        U.mct( [0, 4, 5] , 2 )
        U.mct( [0, 4, 5] , 3 )
        U.mct( [0, 4, 5] , 6 )
        U.mct( [0, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-3
        # [8, 241, 128, 151, 72, 193, 164, 124, 154]
        # 8 -> 241
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.mct( [0, 1, 2, 3, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 4, 7] , 2 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 128
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 151
        U.x( 5 )
        U.x( 3 )
        U.mct( [1, 3, 4, 5, 7] , 0 )
        U.mct( [1, 3, 4, 5, 7] , 2 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 72
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 4, 5, 6] , 1 )
        U.mct( [0, 4, 5, 6] , 2 )
        U.mct( [0, 4, 5, 6] , 3 )
        U.mct( [0, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 193
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5, 6] , 0 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 164
        U.x( 3 )
        U.mct( [2, 3, 5, 6] , 0 )
        U.mct( [2, 3, 5, 6] , 1 )
        U.mct( [2, 3, 5, 6] , 4 )
        U.mct( [2, 3, 5, 6] , 7 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 124
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 5, 6] , 1 )
        U.mct( [0, 2, 5, 6] , 3 )
        U.mct( [0, 2, 5, 6] , 4 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 154
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 8
        U.x( 1 )
        U.mct( [1, 3, 7] , 0 )
        U.mct( [1, 3, 7] , 2 )
        U.mct( [1, 3, 7] , 4 )
        U.mct( [1, 3, 7] , 5 )
        U.mct( [1, 3, 7] , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-4
        # [4, 244, 64, 199, 36, 220, 82, 62, 77]
        # 4 -> 244
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6] , 3 )
        U.mct( [0, 1, 2, 4, 6] , 5 )
        U.mct( [0, 1, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 244 -> 64
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 64 -> 199
        U.x( 4 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 3 )
        U.x( 4 )
        if barrier: U.barrier()
        # 199 -> 36
        # automatic
        # 36 -> 220
        U.x( 5 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6] , 0 )
        U.mct( [2, 3, 4, 5, 6] , 1 )
        U.x( 5 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5] , 2 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 82
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [1, 4, 5, 6, 7] , 0 )
        U.mct( [1, 4, 5, 6, 7] , 2 )
        U.mct( [1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 7] , 4 )
        U.mct( [0, 1, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 82 -> 62
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        # 62 -> 77
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 3, 5, 6, 7] , 0 )
        U.mct( [1, 3, 5, 6, 7] , 2 )
        U.mct( [1, 3, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 77 -> 4
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.mct( [0, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
    return U

def U64_N247_a2(U, u_ver, barrier=False): 
    """ U64 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 64
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle-1
        # [1, 55, 61, 144, 16, 139, 235, 81, 9]
        # 1 -> 55 
        U.cx(0, 1) # by hand 
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        # 55 -> 61
        U.x( 1 )
        U.cx( 1 , 2 )
        U.cx( 1 , 3 )
        U.cx( 1 , 4 )
        U.cx( 1 , 5 )
        U.x( 1 )
        if barrier: U.barrier()
        # 61 -> 144
        U.x( 2 )
        U.cx( 2 , 0 )
        U.cx( 2 , 1 )
        U.cx( 2 , 3 )
        U.cx( 2 , 4 )
        U.cx( 2 , 7 )
        U.x( 2 )
        if barrier: U.barrier()
        # 144 -> 16
        U.x( 0 )
        U.ccx( 0 , 5 , 2 )
        U.ccx( 0 , 5 , 3 )
        U.ccx( 0 , 5 , 4 )
        U.ccx( 0 , 5 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 5 )
        U.x( 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 16 -> 139
        U.x( 2 )
        U.mct( [2, 5, 7] , 0 )
        U.mct( [2, 5, 7] , 1 )
        U.mct( [2, 5, 7] , 3 )
        U.mct( [2, 5, 7] , 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 2 )
        U.mct( [0, 1, 2] , 5 )
        U.x( 2 )
        if barrier: U.barrier()
        # 235 -> 235
        U.x( 2 )
        U.mct( [1, 2, 5] , 0 )
        U.mct( [1, 2, 5] , 4 )
        U.mct( [1, 2, 5] , 6 )
        U.mct( [1, 2, 5] , 7 )
        U.x( 2 )
        if barrier: U.barrier()
        # 235 -> 81
        U.x( 3 )
        U.ccx( 3 , 6 , 0 )
        U.ccx( 3 , 6 , 1 )
        U.ccx( 3 , 6 , 2 )
        U.ccx( 3 , 6 , 4 )
        U.ccx( 3 , 6 , 5 )
        U.ccx( 3 , 6 , 7 )
        U.x( 3 )
        if barrier: U.barrier()
        # 81 -> 9
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 6, 7] , 0 )
        U.mct( [1, 2, 6, 7] , 3 )
        U.mct( [1, 2, 6, 7] , 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()        
        # 9 -> 1
        U.x( 7 )
        U.x( 6 )
        U.mct( [0, 1, 3, 5, 6, 7] , 2 )
        U.mct( [0, 1, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [0, 2, 4, 5, 6, 7] , 1 )
        U.mct( [0, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 110, 122, 41, 32, 31, 223, 162, 18]
        # 2 -> 110
        U.x( 7 )
        U.mct( [3, 6, 7] , 0 )
        U.mct( [3, 6, 7] , 1 )
        U.mct( [3, 6, 7] , 2 )
        U.mct( [3, 6, 7] , 4 )
        U.mct( [3, 6, 7] , 5 )
        U.x( 7 )
        if barrier: U.barrier()
        # 110 -> 122
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 5] , 1 )
        U.mct( [0, 2, 5] , 3 )
        U.mct( [0, 2, 5] , 7 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 122 -> 41
        U.x( 6 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.x( 6 )
        U.x( 2 )
        if barrier: U.barrier()
        # 41 -> 32
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 7] , 4 )
        U.mct( [0, 1, 3, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 32 -> 31
        U.x( 5 )
        U.ccx( 2 , 5 , 0 )
        U.ccx( 2 , 5 , 1 )
        U.ccx( 2 , 5 , 3 )
        U.ccx( 2 , 5 , 4 )
        U.x( 5 )
        if barrier: U.barrier()
        # 31 -> 223
        U.x( 5 )
        U.x( 4 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 3, 6] , 4 )
        if barrier: U.barrier()
        # 223 -> 162
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 7] , 1 )
        U.mct( [0, 2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 18
        U.x( 2 )
        U.mct( [2, 4, 6, 7] , 0 )
        U.mct( [2, 4, 6, 7] , 1 )
        U.mct( [2, 4, 6, 7] , 3 )
        U.mct( [2, 4, 6, 7] , 5 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 2
        U.x( 7 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6, 7] , 3 )
        U.mct( [0, 1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-3
        # 8 -> 193
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 7] , 1 )
        U.mct( [0, 2, 3, 7] , 4 )
        U.mct( [0, 2, 3, 7] , 6 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # 193 -> 241
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 6, 7] , 0 )
        U.mct( [1, 2, 4, 6, 7] , 3 )
        U.mct( [1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 164
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 128
        U.x( 7 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 6, 7] , 1 )
        U.mct( [0, 3, 6, 7] , 2 )
        U.mct( [0, 3, 6, 7] , 4 )
        U.mct( [0, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5] , 6 )
        U.mct( [0, 1, 2, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 124
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 4 )
        U.mct( [0, 1, 3] , 5 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 151
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 6] , 0 )
        U.mct( [1, 2, 4, 5, 6] , 3 )
        U.mct( [1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 154
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 5, 6, 7] , 1 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 72
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 8
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()        
        # cycle-4
        # [4, 220, 224, 217, 79, 146, 126, 14, 29,
        # 113, 40 -> 220]
        # 4 -> 220        
        U.x( 0 )
        U.mct( [0, 4, 6, 7] , 1 )
        U.mct( [0, 4, 6, 7] , 2 )
        U.mct( [0, 4, 6, 7] , 3 )
        U.mct( [0, 4, 6, 7] , 5 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 224
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6] , 0 )
        U.mct( [1, 2, 3, 6] , 4 )
        U.mct( [1, 2, 3, 6] , 5 )
        U.mct( [1, 2, 3, 6] , 7 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 224 -> 217
        U.x( 7 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 217 -> 79
        U.mct( [0, 1, 2, 3, 5, 6] , 4 )
        U.mct( [0, 1, 2, 3, 5, 6] , 7 )
        if barrier: U.barrier()
        U.x( 4 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 4 )
        if barrier: U.barrier()
        # 79 -> 146
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6, 7] , 4 )
        U.mct( [0, 1, 2, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 7] , 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 146 -> 126
        U.x( 5 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 7] , 4 )
        U.mct( [0, 1, 2, 7] , 5 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 126 -> 14
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5] , 3 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 14 -> 29
        U.x( 6 )
        U.x( 4 )
        U.mct( [2, 3, 4, 5, 6] , 0 )
        U.mct( [2, 3, 4, 5, 6] , 1 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5] , 4 )
        U.x( 5 )
        U.x( 1 )
        if barrier: U.barrier()
        # 29 -> 113
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 113 -> 40
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 6, 7] , 0 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5] , 1 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 40 -> 224
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5, 6, 7] , 0 )
        U.mct( [1, 3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 7] , 5 )
        U.mct( [0, 1, 2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 224 -> 217
        # automatic
    return U


def U32_N247_a2(U, u_ver, barrier=False): 
    """U32 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        pass
        # cycle-1
        # [1, 139, 55, 235, 61, 81, 144, 9, 16]
        # 1 -> 139
        U.cx(0, 1) # by hand
        U.cx(0, 3)
        U.cx(0, 7)
        # 139 -> 55
        U.x( 3 )
        U.cx( 3 , 1 )
        U.cx( 3 , 2 )
        U.cx( 3 , 4 )
        U.cx( 3 , 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 55 -> 235
        U.ccx( 3 , 5 , 1 )
        U.ccx( 3 , 5 , 2 )
        U.ccx( 3 , 5 , 4 )
        U.ccx( 3 , 5 , 6 )
        if barrier: U.barrier()
        # 235 -> 61
        U.ccx( 2 , 6 , 1 )
        U.ccx( 2 , 6 , 3 )
        U.ccx( 2 , 6 , 5 )
        if barrier: U.barrier()
        U.x( 1 )
        U.cx( 1 , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 61 -> 81
        U.x( 2 )
        U.x( 1 )
        U.ccx( 1 , 2 , 4 )
        U.ccx( 1 , 2 , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 81 -> 144
        U.x( 2 )
        U.mct( [2, 4, 7] , 0 )
        U.mct( [2, 4, 7] , 1 )
        U.mct( [2, 4, 7] , 3 )
        U.mct( [2, 4, 7] , 6 )
        U.x( 2 )
        if barrier: U.barrier()
        # 144 -> 9
        U.x( 6 )
        U.x( 4 )
        U.mct( [4, 5, 6] , 0 )
        U.mct( [4, 5, 6] , 1 )
        U.mct( [4, 5, 6] , 2 )
        U.mct( [4, 5, 6] , 3 )
        U.mct( [4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 9 -> 16
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 6, 7] , 0 )
        U.mct( [1, 3, 6, 7] , 2 )
        U.mct( [1, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 6 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 6 )
        U.x( 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 16 -> 1
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 31, 110, 223, 122, 162, 41, 18, 32]
        # 2 -> 31
        U.ccx( 2 , 7 , 0 )
        U.ccx( 2 , 7 , 1 )
        U.ccx( 2 , 7 , 3 )
        U.ccx( 2 , 7 , 5 )
        U.ccx( 2 , 7 , 6 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 3] , 7 )
        if barrier: U.barrier()
        # 31 -> 110
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 223
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 3, 6] , 5 )
        if barrier: U.barrier()
        # 223 -> 122
        U.x( 7 )
        U.x( 2 )
        U.mct( [1, 2, 5, 7] , 0 )
        U.mct( [1, 2, 5, 7] , 3 )
        U.mct( [1, 2, 5, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        if barrier: U.barrier()
        # 122 -> 162
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 3, 4] , 0 )
        U.mct( [1, 3, 4] , 2 )
        U.mct( [1, 3, 4] , 5 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # 162 -> 41
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5] , 3 )
        U.mct( [0, 1, 2, 5] , 4 )
        U.mct( [0, 1, 2, 5] , 6 )
        U.mct( [0, 1, 2, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 41 -> 18
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5, 7] , 1 )
        U.x( 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 32
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 32 -> 2     
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-3
        # [8, 124, 193, 151, 241, 154, 164, 72, 128]
        # 8 -> 124
        U.x( 6 )
        U.mct( [1, 4, 6, 7] , 0 )
        U.mct( [1, 4, 6, 7] , 2 )
        U.mct( [1, 4, 6, 7] , 3 )
        U.mct( [1, 4, 6, 7] , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 4] , 1 )
        U.mct( [0, 2, 4] , 6 )
        U.mct( [0, 2, 4] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 193
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6] , 0 )
        U.mct( [1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 151
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 5, 6, 7] , 2 )
        U.mct( [0, 1, 5, 6, 7] , 3 )
        U.mct( [0, 1, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 241
        U.x( 1 )
        U.mct( [0, 1, 3, 4, 6] , 2 )
        U.mct( [0, 1, 3, 4, 6] , 5 )
        U.mct( [0, 1, 3, 4, 6] , 7 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5] , 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 154
        U.x( 7 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 3, 4, 6, 7] , 0 )
        U.mct( [1, 3, 4, 6, 7] , 2 )
        U.mct( [1, 3, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.mct( [0, 2, 3, 5] , 6 )
        U.mct( [0, 2, 3, 5] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 164
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 72
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 6, 7] , 0 )
        U.mct( [1, 2, 4, 6, 7] , 3 )
        U.mct( [1, 2, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 72 -> 128
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 8        
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-4
        # [4, 62, 220, 199, 244, 77, 82, 36, 64]
        # 4 -> 62
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 7] , 0 )
        U.mct( [1, 2, 3, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 0 )
        U.mct( [0, 1, 3, 5, 6] , 2 )
        U.mct( [0, 1, 3, 5, 6] , 4 )
        U.x( 6 )
        U.x( 0 )
        if barrier: U.barrier()
        # 62 -> 220
        U.mct( [1, 4, 5, 6, 7] , 0 )
        U.mct( [1, 4, 5, 6, 7] , 2 )
        U.mct( [1, 4, 5, 6, 7] , 3 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 6, 7] , 1 )
        U.mct( [0, 2, 3, 4, 6, 7] , 5 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 199
        U.mct( [0, 1, 4, 5, 6] , 2 )
        U.mct( [0, 1, 4, 5, 6] , 3 )
        if barrier: U.barrier()
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 199 -> 244
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 6 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()        
        # 244 -> 77
        U.x( 7 )
        U.x( 4 )
        U.mct( [0, 2, 4, 7] , 1 )
        U.mct( [0, 2, 4, 7] , 3 )
        U.mct( [0, 2, 4, 7] , 5 )
        U.mct( [0, 2, 4, 7] , 6 )
        U.x( 7 )
        U.x( 4 )
        if barrier: U.barrier()
        # 77 -> 82
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 6, 7] , 0 )
        U.mct( [1, 2, 3, 5, 6, 7] , 4 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.mct( [0, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 82 -> 36
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 36 -> 64
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.mct( [0, 2, 3, 5, 6] , 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 64 -> 4
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6] , 3 )
        U.mct( [0, 1, 2, 5, 6] , 4 )
        U.mct( [0, 1, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    return U

def U16_N247_a2(U, u_ver, barrier=False):
    """U16 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        pass
        # cycle-1
        # [1, 81, 139, 144, 55, 9, 235, 16, 61]
        # 1 -> 81
        U.cx(0, 4) # by hand
        U.cx(0, 6)
        # 81 -> 139
        U.x( 4 )
        U.cx( 4 , 1 )
        U.cx( 4 , 3 )
        U.cx( 4 , 7 )
        U.x( 4 )
        if barrier: U.barrier()
        # 139 -> 144
        U.ccx( 4 , 7 , 0 )
        U.ccx( 4 , 7 , 1 )
        U.ccx( 4 , 7 , 3 )
        U.ccx( 4 , 7 , 6 )
        if barrier: U.barrier()
        # 144 -> 55
        U.mct( [0, 1, 4] , 2 )
        U.mct( [0, 1, 4] , 3 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 6 )
        U.mct( [0, 1, 4] , 7 )
        if barrier: U.barrier()
        # 55 -> 9
        U.x( 1 )
        U.mct( [0, 1, 3] , 2 )
        U.mct( [0, 1, 3] , 5 )
        U.mct( [0, 1, 3] , 6 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 1 )
        if barrier: U.barrier()
        # 9 -> 235
        U.mct( [0, 3, 5] , 1 )
        U.mct( [0, 3, 5] , 2 )
        U.mct( [0, 3, 5] , 4 )
        U.mct( [0, 3, 5] , 6 )
        if barrier: U.barrier()
        # 235 -> 16
        U.x( 0 )
        U.ccx( 0 , 6 , 5 )
        U.ccx( 0 , 6 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 0 )
        U.ccx( 0 , 7 , 6 )
        U.x( 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 6, 7] , 2 )
        U.mct( [0, 1, 4, 6, 7] , 3 )
        U.mct( [0, 1, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 16 -> 61
        U.x( 1 )
        U.ccx( 1 , 2 , 0 )
        U.ccx( 1 , 2 , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 61 -> 1      
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 162, 31, 41, 110, 18, 223, 32, 122]
        # 2 -> 162
        U.x( 4 )
        U.x( 0 )
        U.ccx( 0 , 4 , 1 )
        U.ccx( 0 , 4 , 3 )
        U.ccx( 0 , 4 , 5 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 31
        U.x( 7 )
        U.x( 5 )
        U.mct( [1, 5, 7] , 0 )
        U.mct( [1, 5, 7] , 2 )
        U.mct( [1, 5, 7] , 3 )
        U.mct( [1, 5, 7] , 4 )
        U.mct( [1, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        # 31 -> 41
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6] , 0 )
        U.mct( [3, 4, 5, 6] , 1 )
        U.mct( [3, 4, 5, 6] , 2 )
        U.mct( [3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        # 41 -> 110
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 5 )
        U.ccx( 0 , 2 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 18
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # 18 -> 223
        U.x( 4 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2, 3, 6] , 4 )
        if barrier: U.barrier()
        # 223 -> 32
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 6, 7] , 2 )
        U.mct( [0, 1, 6, 7] , 3 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 6 )
        U.mct( [0, 1, 4] , 7 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 32 -> 122
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 6] , 1 )
        U.mct( [0, 2, 6] , 3 )
        U.mct( [0, 2, 6] , 4 )
        U.mct( [0, 2, 6] , 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 122 -> 2      
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 6, 7] , 1 )
        U.mct( [0, 2, 3, 4, 6, 7] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-3
        # [8, 154, 124, 164, 193, 72, 151, 128, 241]
        # 8 -> 154
        U.mct( [1, 3, 4, 5, 7] , 0 )
        U.mct( [1, 3, 4, 5, 7] , 2 )
        U.mct( [1, 3, 4, 5, 7] , 6 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 124
        U.x( 1 )
        U.mct( [1, 4, 6, 7] , 0 )
        U.mct( [1, 4, 6, 7] , 2 )
        U.mct( [1, 4, 6, 7] , 3 )
        U.mct( [1, 4, 6, 7] , 5 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 164
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 2, 6, 7] , 0 )
        U.mct( [1, 2, 6, 7] , 3 )
        U.mct( [1, 2, 6, 7] , 4 )
        U.mct( [1, 2, 6, 7] , 5 )
        U.x( 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 164 -> 193
        U.x( 3 )
        U.mct( [3, 6, 7] , 0 )
        U.mct( [3, 6, 7] , 1 )
        U.mct( [3, 6, 7] , 2 )
        U.mct( [3, 6, 7] , 4 )
        U.mct( [3, 6, 7] , 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 193 -> 72
        U.x( 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 5, 7] , 1 )
        U.mct( [0, 2, 3, 5, 7] , 4 )
        U.mct( [0, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 151
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.mct( [0, 2, 3, 5] , 6 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 128
        U.x( 4 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 6, 7] , 2 )
        U.mct( [0, 1, 3, 4, 6, 7] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128-> 241
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.mct( [1, 2, 3, 5, 7] , 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 8
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.mct( [0, 3, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-4
        # [4, 77, 62, 82, 220, 36, 199, 64, 244]
        # 4 -> 77
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        U.mct( [2, 3, 5, 7] , 0 )
        U.mct( [2, 3, 5, 7] , 1 )
        U.mct( [2, 3, 5, 7] , 4 )
        U.mct( [2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 77 -> 62
        U.x( 0 )
        U.mct( [0, 1, 2, 7] , 4 )
        U.mct( [0, 1, 2, 7] , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 62 -> 82
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6] , 3 )
        U.mct( [0, 1, 2, 5, 6] , 4 )
        U.mct( [0, 1, 2, 5, 6] , 7 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 82 -> 220
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 4, 5, 6, 7] , 0 )
        U.mct( [1, 4, 5, 6, 7] , 2 )
        U.mct( [1, 4, 5, 6, 7] , 3 )
        U.x( 6 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 7] , 5 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 36
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.mct( [2, 3, 4, 5, 6, 7] , 0 )
        U.mct( [2, 3, 4, 5, 6, 7] , 1 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6, 7] , 3 )
        U.mct( [0, 1, 2, 6, 7] , 4 )
        U.mct( [0, 1, 2, 6, 7] , 5 )
        U.x( 7 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 36 -> 199
        U.x( 3 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.mct( [1, 2, 3, 5, 7] , 6 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # 199 -> 64
        U.x( 7 )
        U.x( 1 )
        U.mct( [0, 1, 5, 6, 7] , 2 )
        U.mct( [0, 1, 5, 6, 7] , 3 )
        U.mct( [0, 1, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6, 7] , 0 )
        U.mct( [1, 2, 3, 4, 6, 7] , 5 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 64 -> 244
        U.mct( [2, 4, 5, 7] , 0 )
        U.mct( [2, 4, 5, 7] , 1 )
        U.mct( [2, 4, 5, 7] , 3 )
        U.mct( [2, 4, 5, 7] , 6 )
        if barrier: U.barrier()
        # 244 -> 4
        # automatic
    
    return U

def U8_N247_a2(U, u_ver, barrier=False):
    """U8 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        pass
        # cycle-1
        # [1, 9, 81, 235, 139, 16, 144, 61, 55]
        # 1 -> 9
        U.cx(0, 3) # by hand
        # 9 -> 81
        U.x( 3 )
        U.cx( 3 , 4 )
        U.cx( 3 , 6 )
        U.x( 3 )
        if barrier: U.barrier()
        # 81 -> 235
        U.ccx( 3 , 6 , 1 )
        U.ccx( 3 , 6 , 4 )
        U.ccx( 3 , 6 , 5 )
        U.ccx( 3 , 6 , 7 )
        if barrier: U.barrier()
        # 235 -> 139
        U.x( 6 )
        U.ccx( 1 , 6 , 3 )
        U.ccx( 1 , 6 , 4 )
        U.ccx( 1 , 6 , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        # 139 -> 16
        U.x( 3 )
        U.ccx( 3 , 7 , 0 )
        U.ccx( 3 , 7 , 1 )
        U.ccx( 3 , 7 , 6 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 0 )
        U.cx( 0 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 16 -> 144
        U.x( 0 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        # 144 -> 61
        U.x( 6 )
        U.x( 3 )
        U.mct( [0, 3, 6, 7] , 1 )
        U.mct( [0, 3, 6, 7] , 2 )
        U.mct( [0, 3, 6, 7] , 4 )
        U.mct( [0, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 1 )
        U.mct( [0, 1, 2] , 3 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        if barrier: U.barrier()
        # 61 -> 55
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 6 )
        if barrier: U.barrier()
        U.mct( [0, 1, 2] , 7 )
        if barrier: U.barrier()
        # 55 -> 1
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 18, 162, 223, 31, 32, 41, 122, 110]
        # 2 -> 18
        U.x( 0 )
        U.ccx( 0 , 1 , 4 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 162
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 5 )
        U.mct( [0, 1, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 223
        U.x( 5 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.x( 5 )
        if barrier: U.barrier()
        # 223 -> 31
        U.x( 7 )
        U.mct( [0, 1, 6, 7] , 2 )
        U.mct( [0, 1, 6, 7] , 3 )
        U.mct( [0, 1, 6, 7] , 4 )
        U.mct( [0, 1, 6, 7] , 5 )
        U.x( 7 )
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 7 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 6] , 0 )
        U.mct( [1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 31 -> 32
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()        
        # 32 -> 41
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 7] , 0 )
        U.mct( [1, 2, 4, 5, 7] , 3 )
        U.mct( [1, 2, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 41 -> 122
        U.x( 2 )
        U.mct( [2, 4, 5] , 0 )
        U.mct( [2, 4, 5] , 1 )
        U.mct( [2, 4, 5] , 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # 122 -> 110
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 2        
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6, 7] , 1 )
        U.mct( [0, 5, 6, 7] , 2 )
        U.mct( [0, 5, 6, 7] , 3 )
        U.mct( [0, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-3
        # [4, 36, 77, 199, 62, 64, 82, 244, 220]
        # 4 -> 36
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 5 )
        U.mct( [0, 1, 2] , 6 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 36 -> 77
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.mct( [1, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 77 -> 199
        U.x( 7 )
        U.x( 4 )
        U.mct( [0, 4, 5, 6, 7] , 1 )
        U.mct( [0, 4, 5, 6, 7] , 2 )
        U.mct( [0, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4] , 5 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # 199 -> 62
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 7 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 62 -> 64
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 2 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.mct( [0, 4, 5, 7] , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6] , 4 )
        U.mct( [0, 1, 2, 6] , 5 )
        U.mct( [0, 1, 2, 6] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 64 -> 82
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 1, 5, 6] , 2 )
        U.mct( [0, 1, 5, 6] , 3 )
        U.mct( [0, 1, 5, 6] , 4 )
        U.mct( [0, 1, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        # 82 -> 244
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 7 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 244 -> 220
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 7] , 0 )
        U.mct( [1, 2, 3, 4, 7] , 5 )
        U.mct( [1, 2, 3, 4, 7] , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 220 -> 4
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 5 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-4
        # [8, 72, 154, 151, 124, 128, 164, 241, 193]
        # 8 -> 72
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 154
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5, 6, 7] , 3 )
        U.mct( [0, 1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 151
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 4, 5, 6, 7] , 2 )
        U.mct( [0, 1, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 124
        U.x( 6 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 6 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 128
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5, 7] , 1 )
        U.mct( [0, 2, 4, 5, 7] , 3 )
        U.mct( [0, 2, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 164
        U.x( 4 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 241
        U.x( 3 )
        U.mct( [0, 3, 5, 7] , 1 )
        U.mct( [0, 3, 5, 7] , 2 )
        U.mct( [0, 3, 5, 7] , 4 )
        U.mct( [0, 3, 5, 7] , 6 )
        U.x( 3 )
        if barrier: U.barrier()
        # 241 -> 193
        U.x( 7 )
        U.x( 3 )
        U.mct( [0, 3, 5, 6, 7] , 1 )
        U.mct( [0, 3, 5, 6, 7] , 2 )
        U.mct( [0, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.mct( [0, 1, 2, 3, 4, 6] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 8
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 5, 6, 7] , 0 )
        U.mct( [1, 2, 5, 6, 7] , 3 )
        U.mct( [1, 2, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.mct( [0, 1, 2, 3, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    return U


def U4_N247_a2(U, u_ver, barrier=False):
    """U4 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle-1
        # [1, 16, 9, 144, 81, 61, 235, 55, 139]
        # 1 -> 16
        U.cx(0, 4) # by hand
        U.cx(4, 0)
        # 16 -> 9
        U.cx( 0 , 3 )
        U.cx( 0 , 4 )
        if barrier: U.barrier()
        # 9 -> 144
        U.x( 0 )
        U.ccx( 0 , 3 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 7 , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 144 -> 81
        U.ccx( 0 , 7 , 3 )
        U.ccx( 0 , 7 , 4 )
        U.ccx( 0 , 7 , 6 )
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        if barrier: U.barrier()
        # 81 -> 61
        U.mct( [0, 3, 4] , 2 )
        U.mct( [0, 3, 4] , 5 )
        U.mct( [0, 3, 4] , 6 )
        if barrier: U.barrier()
        # 61 -> 235
        U.mct( [0, 5, 7] , 1 )
        U.mct( [0, 5, 7] , 2 )
        U.mct( [0, 5, 7] , 3 )
        U.mct( [0, 5, 7] , 4 )
        U.mct( [0, 5, 7] , 6 )
        if barrier: U.barrier()
        # 235 -> 55
        U.ccx( 1 , 4 , 0 )
        U.ccx( 1 , 4 , 2 )
        U.ccx( 1 , 4 , 3 )
        U.ccx( 1 , 4 , 6 )
        if barrier: U.barrier()
        # 55 -> 139
        U.x( 5 )
        U.ccx( 1 , 5 , 0 )
        U.ccx( 1 , 5 , 2 )
        U.ccx( 1 , 5 , 3 )
        U.ccx( 1 , 5 , 4 )
        U.ccx( 1 , 5 , 7 )
        U.x( 5 )
        if barrier: U.barrier()
        # 139 -> 1        
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4] , 6 )
        U.mct( [0, 1, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 32, 18, 41, 162, 122, 223, 110, 31]
        # 2 -> 32
        U.x( 6 )
        U.mct( [3, 4, 6, 7] , 0 )
        U.mct( [3, 4, 6, 7] , 1 )
        U.mct( [3, 4, 6, 7] , 2 )
        U.mct( [3, 4, 6, 7] , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 5 , 3 )
        U.ccx( 0 , 5 , 4 )
        U.ccx( 0 , 5 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 32 -> 18
        U.x( 0 )
        U.mct( [0, 4, 5, 7] , 1 )
        U.mct( [0, 4, 5, 7] , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 5 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 41
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        U.mct( [0, 3, 4, 5, 6] , 1 )
        U.mct( [0, 3, 4, 5, 6] , 2 )
        U.x( 6 )
        U.x( 3 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5] , 0 )
        U.mct( [1, 2, 4, 5] , 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 41 -> 162
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 3, 4] , 1 )
        U.mct( [0, 3, 4] , 7 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 1, 4] , 3 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 122
        U.x( 0 )
        U.mct( [0, 1, 4, 7] , 3 )
        U.mct( [0, 1, 4, 7] , 5 )
        U.mct( [0, 1, 4, 7] , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 3] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 122 -> 223
        U.mct( [1, 3, 4, 7] , 0 )
        U.mct( [1, 3, 4, 7] , 2 )
        U.mct( [1, 3, 4, 7] , 5 )
        U.mct( [1, 3, 4, 7] , 6 )
        if barrier: U.barrier()
        # 223 -> 110
        U.x( 0 )
        U.ccx( 0 , 2 , 1 )
        U.ccx( 0 , 2 , 3 )
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 6 )
        U.ccx( 0 , 2 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 31
        U.x( 7 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 7 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 2, 3, 5, 7] , 1 )
        U.mct( [0, 2, 3, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        # 31 -> 2
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.mct( [1, 3, 4, 5] , 0 )
        U.mct( [1, 3, 4, 5] , 2 )
        U.mct( [1, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # cycle-3
        # [4, 64, 36, 82, 77, 244, 199, 220, 62]
        # 4 -> 64
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 5, 6] , 1 )
        U.mct( [0, 5, 6] , 2 )
        U.mct( [0, 5, 6] , 3 )
        U.mct( [0, 5, 6] , 4 )
        U.mct( [0, 5, 6] , 7 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        # 64 -> 36
        U.x( 0 )
        U.mct( [0, 2, 7] , 1 )
        U.mct( [0, 2, 7] , 3 )
        U.mct( [0, 2, 7] , 4 )
        U.mct( [0, 2, 7] , 5 )
        U.mct( [0, 2, 7] , 6 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 36 -> 82
        # automatic
        # 82 -> 77
        U.x( 5 )
        U.x( 3 )
        U.mct( [2, 3, 5, 6] , 0 )
        U.mct( [2, 3, 5, 6] , 1 )
        U.mct( [2, 3, 5, 6] , 4 )
        U.mct( [2, 3, 5, 6] , 7 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4] , 3 )
        U.x( 4 )
        U.x( 1 )
        if barrier: U.barrier()
        # 77 -> 244
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 5, 6] , 1 )
        U.mct( [0, 2, 5, 6] , 3 )
        U.mct( [0, 2, 5, 6] , 4 )
        U.mct( [0, 2, 5, 6] , 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 244 -> 199
        U.x( 3 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3] , 4 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.x( 4 )
        U.x( 3 )
        if barrier: U.barrier()
        # 199 -> 220
        U.x( 5 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5] , 1 )
        U.mct( [0, 2, 4, 5] , 3 )
        U.mct( [0, 2, 4, 5] , 6 )
        U.x( 5 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 62
        U.x( 6 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 1, 2, 4] , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 62 -> 4
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6, 7] , 4 )
        U.mct( [0, 1, 2, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # cycle-4
        # [8, 128, 72, 164, 154, 241, 151, 193, 124]
        # 8 -> 128
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 4, 5, 7] , 2 )
        U.mct( [0, 1, 3, 4, 5, 7] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 72
        U.x( 6 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.mct( [0, 1, 2, 3] , 7 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 164
        U.x( 5 )
        U.x( 4 )
        U.mct( [3, 4, 5, 6, 7] , 0 )
        U.mct( [3, 4, 5, 6, 7] , 1 )
        U.mct( [3, 4, 5, 6, 7] , 2 )
        U.x( 5 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 7] , 3 )
        U.mct( [0, 1, 2, 4, 7] , 5 )
        U.mct( [0, 1, 2, 4, 7] , 6 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 154
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 5, 6] , 3 )
        U.mct( [0, 1, 2, 4, 5, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 241
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 151
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4, 6] , 1 )
        U.mct( [0, 2, 3, 4, 6] , 5 )
        U.mct( [0, 2, 3, 4, 6] , 7 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 3, 4, 5] , 2 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 193
        U.x( 6 )
        U.x( 5 )
        U.mct( [0, 3, 4, 5, 6, 7] , 1 )
        U.mct( [0, 3, 4, 5, 6, 7] , 2 )
        U.x( 6 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 5, 7] , 3 )
        U.mct( [0, 1, 2, 5, 7] , 4 )
        U.mct( [0, 1, 2, 5, 7] , 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 124
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        U.mct( [1, 2, 4, 5, 6, 7] , 0 )
        U.mct( [1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 4 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5, 6] , 1 )
        U.x( 6 )
        U.x( 4 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 4 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 8
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 3, 6] , 2 )
        U.mct( [0, 1, 3, 6] , 4 )
        U.mct( [0, 1, 3, 6] , 5 )
        U.x( 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
    return U

def U2_N247_a2(U, u_ver, barrier=False):
    """U2 for N=247 a=2 r=36."""
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N247_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle-1
        # [1, 4, 16, 64, 9, 36, 144, 82, 81, 77, 61, 244,
        # 235, 199, 55, 220, 139, 62]
        # 1 -> 4 # by hand
        U.cx(0, 2)
        U.cx(2, 0)
        # 4 -> 16 # by hand
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(4, 0)
        # 16-> 64
        U.x( 2 )
        U.ccx(0, 2 , 4 )
        U.ccx(0, 2 , 6 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 2 )
        U.ccx(2, 4 , 0 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        # 64 -> 9
        U.cx( 0 , 3 )
        U.cx( 0 , 6 )
        if barrier: U.barrier()        
        # 9 -> 36
        U.x( 0 )
        U.mct( [0, 2, 3] , 5 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.mct( [0, 2, 5] , 3 )
        U.x( 0 )
        if barrier: U.barrier()
        # 36 -> 144
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 5] , 7 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 4, 7] , 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 144 -> 82
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 6, 7] , 1 )
        U.mct( [0, 2, 6, 7] , 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 0 )
        U.ccx( 0 , 1 , 7 )
        U.x( 0 )
        if barrier: U.barrier()
        # 82 -> 81
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 4, 7] , 0 )
        U.mct( [2, 3, 4, 7] , 1 )
        U.mct( [2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 3 )
        U.ccx( 0 , 3 , 4 )
        U.ccx( 0 , 3 , 7 )
        U.x( 3 )
        if barrier: U.barrier()
        # 81 -> 77
        U.ccx( 0 , 2 , 4 )
        U.ccx( 0 , 2 , 6 )
        if barrier: U.barrier()
        # 77 -> 61
        U.x( 1 )
        U.mct( [1, 2, 4] , 0 )
        U.mct( [1, 2, 4] , 3 )
        U.mct( [1, 2, 4] , 6 )
        U.x( 1 )
        if barrier: U.barrier()
        # 61 -> 244
        U.x( 3 )
        U.x( 1 )
        U.mct( [1, 2, 3, 5, 7] , 0 )
        U.mct( [1, 2, 3, 5, 7] , 4 )
        U.mct( [1, 2, 3, 5, 7] , 6 )
        U.x( 3 )
        U.x( 1 )
        if barrier: U.barrier()
        # 244 -> 235
        U.x( 2 )
        U.mct( [0, 2, 3, 5] , 1 )
        U.mct( [0, 2, 3, 5] , 4 )
        U.x( 2 )
        if barrier: U.barrier()
        # 235 -> 199
        U.ccx( 1 , 2 , 0 )
        U.ccx( 1 , 2 , 3 )
        U.ccx( 1 , 2 , 7 )
        if barrier: U.barrier()
        # 199 -> 55
        U.mct( [0, 1, 2, 4] , 3 )
        U.mct( [0, 1, 2, 4] , 5 )
        U.mct( [0, 1, 2, 4] , 6 )
        U.mct( [0, 1, 2, 4] , 7 )
        if barrier: U.barrier()
        # 55 -> 220
        U.x( 6 )
        U.x( 0 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 5 )
        U.x( 6 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 220 -> 139
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [0, 2, 4, 5, 6] , 1 )
        U.mct( [0, 2, 4, 5, 6] , 3 )
        U.mct( [0, 2, 4, 5, 6] , 7 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 2 )
        U.mct( [0, 1, 2, 5] , 6 )
        U.x( 5 )
        U.x( 2 )
        # 139 -> 62
        if barrier: U.barrier()
        U.mct( [1, 2, 3] , 0 )
        U.mct( [1, 2, 3] , 4 )
        U.mct( [1, 2, 3] , 7 )
        if barrier: U.barrier()        
        # 62 -> 1
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.mct( [0, 2, 3, 4] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        # cycle-2
        # [2, 8, 32, 128, 18, 72, 41, 164, 162, 154, 122,
        # 241, 223, 151, 110, 193, 31, 124]
        # 2 -> 8
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [2, 4, 5, 6, 7] , 0 )
        U.mct( [2, 4, 5, 6, 7] , 1 )
        U.mct( [2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3] , 5 )
        U.mct( [0, 1, 2, 3] , 6 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 8 -> 32
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 6, 7] , 0 )
        U.mct( [1, 2, 3, 6, 7] , 4 )
        U.mct( [1, 2, 3, 6, 7] , 5 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 32 -> 128
        U.x( 7 )
        U.x( 2 )
        U.mct( [2, 5, 6, 7] , 0 )
        U.mct( [2, 5, 6, 7] , 1 )
        U.mct( [2, 5, 6, 7] , 3 )
        U.mct( [2, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 6] , 7 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 7] , 5 )
        U.mct( [0, 1, 2, 3, 4, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 128 -> 18
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [2, 3, 5, 6, 7] , 0 )
        U.mct( [2, 3, 5, 6, 7] , 1 )
        U.mct( [2, 3, 5, 6, 7] , 4 )
        U.x( 6 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 6] , 5 )
        U.mct( [0, 1, 2, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 18 -> 72
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 4, 5, 6, 7] , 3 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 3, 4] , 0 )
        U.mct( [1, 2, 3, 4] , 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 6] , 4 )
        U.x( 2 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 72 -> 41
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 6, 7] , 3 )
        U.mct( [0, 1, 2, 6, 7] , 4 )
        U.mct( [0, 1, 2, 6, 7] , 5 )
        U.x( 6 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 41 -> 164
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 4, 6] , 3 )
        U.mct( [0, 1, 2, 4, 6] , 5 )
        U.mct( [0, 1, 2, 4, 6] , 7 )
        U.x( 4 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 3 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 164 -> 162
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4, 5] , 1 )
        U.mct( [0, 2, 3, 4, 5] , 7 )
        U.x( 3 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 1, 2, 5] , 4 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 162 -> 154
        U.x( 2 )
        U.x( 0 )
        U.mct( [0, 2, 3, 4] , 1 )
        U.mct( [0, 2, 3, 4] , 5 )
        U.x( 2 )
        U.x( 0 )
        if barrier: U.barrier()
        # 154 -> 122
        U.x( 2 )
        U.mct( [2, 3, 4, 5] , 0 )
        U.mct( [2, 3, 4, 5] , 1 )
        U.x( 2 )
        if barrier: U.barrier()
        # 122 -> 241
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5, 6, 7] , 0 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        U.mct( [0, 1, 2, 3, 5, 6, 7] , 4 )
        U.x( 7 )
        U.x( 6 )
        U.x( 5 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 6 )
        U.x( 2 )
        U.mct( [0, 2, 4, 6] , 1 )
        U.mct( [0, 2, 4, 6] , 3 )
        U.mct( [0, 2, 4, 6] , 5 )
        U.mct( [0, 2, 4, 6] , 7 )
        U.x( 6 )
        U.x( 2 )
        if barrier: U.barrier()
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 5] , 6 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 241 -> 223
        U.mct( [0, 2, 3, 6, 7] , 1 )
        U.mct( [0, 2, 3, 6, 7] , 4 )
        U.mct( [0, 2, 3, 6, 7] , 5 )
        if barrier: U.barrier()
        # 223 -> 151
        U.x( 7 )
        U.x( 5 )
        U.mct( [0, 1, 2, 4, 5, 7] , 3 )
        U.mct( [0, 1, 2, 4, 5, 7] , 6 )
        U.x( 7 )
        U.x( 5 )
        if barrier: U.barrier()
        U.x( 5 )
        U.x( 3 )
        U.mct( [0, 1, 2, 3, 4, 5] , 7 )
        U.x( 5 )
        U.x( 3 )
        if barrier: U.barrier()
        # 151 -> 110
        U.x( 0 )
        U.mct( [0, 2, 3, 5, 6] , 1 )
        U.mct( [0, 2, 3, 5, 6] , 4 )
        U.x( 0 )
        if barrier: U.barrier()
        # 110 -> 193
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [1, 2, 4, 5, 7] , 0 )
        U.mct( [1, 2, 4, 5, 7] , 3 )
        U.mct( [1, 2, 4, 5, 7] , 6 )
        U.x( 4 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        U.mct( [0, 1, 2, 3, 4, 6] , 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.x( 1 )
        if barrier: U.barrier()
        # 193 -> 31
        U.x( 7 )
        U.mct( [1, 2, 3, 4, 6, 7] , 0 )
        U.mct( [1, 2, 3, 4, 6, 7] , 5 )
        U.x( 7 )
        if barrier: U.barrier()
        U.x( 7 )
        U.mct( [0, 1, 2, 3, 7] , 6 )
        U.x( 7 )
        if barrier: U.barrier()
        # 31 -> 124
        U.x( 6 )
        U.mct( [2, 3, 4, 6, 7] , 0 )
        U.mct( [2, 3, 4, 6, 7] , 1 )
        U.mct( [2, 3, 4, 6, 7] , 5 )
        U.x( 6 )
        if barrier: U.barrier()
        U.x( 1 )
        U.x( 0 )
        U.mct( [0, 1, 2, 3, 5] , 6 )
        U.mct( [0, 1, 2, 3, 5] , 7 )
        U.x( 1 )
        U.x( 0 )
        if barrier: U.barrier()
        # 124 -> 2
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        U.mct( [1, 2, 3, 4, 5] , 0 )
        U.mct( [1, 2, 3, 4, 5] , 6 )
        U.x( 5 )
        U.x( 4 )
        U.x( 3 )
        U.x( 2 )
        if barrier: U.barrier()
    return U

def U1_N247_a2(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=247 a=2 r=36."""        
    if u_ver == 0 or u_ver == 1:
        # r=36
        # 1 -> 2 -> 4 -> 8 -> 16 -> 32 -> 64 -> 128 -> 9 ->
        # 18 -> 36 -> 72 -> 144 -> 41 -> 82 -> 164 -> 81 ->
        # 162 -> 77 -> 154 -> 61 -> 122 -> 244 -> 241 -> 235 ->
        # 223 [truncation] -> 199 -> 151 -> 55 -> 110 -> 220 ->
        # 193 -> 139 -> 31 ->  62-> 124 -> 1
        #
        # 1 -> 2
        U.swap(0,1)
        if barrier: U.barrier()
        # 2 -> 4
        U.swap(0,2)
        if barrier: U.barrier()
        # 4 -> 8
        U.swap(0,3)
        if barrier: U.barrier()
        # 8 -> 16
        U.swap(0,4)
        if barrier: U.barrier()
        # 16 -> 32
        U.swap(0,5)
        if barrier: U.barrier()
        # 32 -> 64
        U.swap(0,6)
        if barrier: U.barrier()
        # 64 -> 128
        U.swap(0,7)
        if barrier: U.barrier()
        # 128 -> 9
        U.cx(0,3)
        if barrier: U.barrier()
        # 9 -> 18
        # 18 -> 36
        # 36 -> 72
        # 72 -> 144
        # 144 -> 41
        # 41 -> 82
        # 82 -> 164
        # automatic
        U.x(1)
        U.mct([0, 1, 6], 4)
        U.x(1)
        if barrier: U.barrier()
        # 164 -> 81
        # 81 -> 162
        # automatic
        # 162 -> 77
        U.x(1)
        U.mct([0, 1, 2], 4)
        U.x(1)
        if barrier: U.barrier()
        # 77 -> 154
        # automatic
        # 154 -> 61
        U.x(1)
        U.mct([0, 1, 2, 5], 4)
        U.x(1)
        if barrier: U.barrier()
        # 61 -> 122
        # 122 -> 244
        # 244 -> 241
        # 241 -> 235
        # 235 -> 223
        # automatic
        # 223 -> 199
        U.x(3)
        U.mct([0, 1, 2, 3], 6)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 4)
        U.x(3)
        # 199 -> 151
        U.x(3)
        U.mct([0, 1, 2, 3, 4], 6)
        U.mct([0, 1, 2, 3, 4], 5)
        U.x(3)
        if barrier: U.barrier()
        # 151 -> 55
        # 55 -> 110
        # 110 -> 220
        # automatic
        # 220 -> 193
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6, 7], 5)
        U.mct([0, 1, 6, 7], 4)
        U.x(1)
        U.x(6)
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4, 7], 6)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
        # 193 -> 139
        # 139 -> 31
        # 31 -> 62
        # 62 -> 124
        # automatic 
        # 124 -> 1
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3, 7], 4)
        U.mct([0, 1, 2, 3, 7], 5)
        U.mct([0, 1, 2, 3, 7], 6)
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(4)
        U.x(6)
        U.mct([1, 2, 3, 4, 6, 7], 0)
        U.x(1)
        U.x(2)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(6)
        U.mct([0, 1, 2, 6, 7], 3)
        U.x(1)
        U.x(2)
        U.x(6)
        if barrier: U.barrier()
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        U.mct([0, 1, 2, 3, 4, 5, 6], 7)
        U.x(1)
        U.x(2)
        U.x(3)
        U.x(4)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
    return U
