######### Modular Exponentiation Operators (MEO's) ######### 

def U32_N21_a2(U, u_ver, barrier=False):
    """U32 for N=21 a=2 r=6."""
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    return U

def U16_N21_a2(U, u_ver, barrier=False):
    """U16 for N=21 a=2 r=6."""
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # same as U4
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()        
        # 1 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()        
        # 16 -> 4
        U.swap(0, 2)
        # 4 -> 1
        # automatic
        if barrier: U.barrier()
        # 2 -> 11
        U.cx(1, 0)
        U.cx(1, 3)
        if barrier: U.barrier()
        # 11 -> 8
        U.ccx(4, 0, 1)
        U.ccx(4, 0, 3)
        if barrier: U.barrier()
        U.x(2)
        U.x(1)
        U.mct([3, 2, 1], 4)
        U.mct([3, 2, 1], 0)        
        U.x(2)
        U.x(1)
        if barrier: U.barrier()
        # 8 -> 2
        U.ccx(4, 3, 1)
        U.ccx(4, 3, 0)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 3)
        U.x(0)
        if barrier: U.barrier()        
    elif u_ver == 2:
        # same as U4
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()        
        # 1 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()        
        # 16 -> 4
        U.swap(0, 2)
        # 4 -> 1
        # automatic
        if barrier: U.barrier()
        # 2 -> 11
        U.cx(1, 0)
        U.cx(1, 3)
        if barrier: U.barrier()
        # # 11 -> 8
        # U.ccx(4, 0, 1)
        # U.ccx(4, 0, 3)
        # if barrier: U.barrier()
        # U.x(2)
        # U.x(1)
        # U.mct([3, 2, 1], 4)
        # U.mct([3, 2, 1], 0)        
        # U.x(2)
        # U.x(1)
        if barrier: U.barrier()
        # # 8 -> 2
        # U.ccx(4, 3, 1)
        # U.ccx(4, 3, 0)
        # if barrier: U.barrier()
        # U.x(0)
        # U.ccx(0, 1, 4)
        # U.ccx(0, 1, 3)
        # U.x(0)
        if barrier: U.barrier()        
    return U

def U8_N21_a2(U, u_ver, barrier=False):
    """U8 for N=21 a=2 r=6."""    
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    elif u_ver ==1:
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()
        # 1 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()        
        # 4 -> 16
        U.swap(0, 4)
        # 16 -> 1
        # automatic
        if barrier: U.barrier()        
        # 2 -> 8
        U.x(0)
        U.ccx(0, 1, 3)
        U.x(0)
        U.cx(3, 1)
        if barrier: U.barrier()
        # 8 -> 11
        U.ccx(3, 1, 0)
        if barrier: U.barrier()
        # 11 -> 2
        U.x(0)
        U.ccx(0, 1, 2)
        U.x(0)
        if barrier: U.barrier()        
    elif u_ver ==2:
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()
        # 1 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()        
        # 4 -> 16
        U.swap(0, 4)
        # 16 -> 1
        # automatic
        if barrier: U.barrier()        
        # 2 -> 8
        U.x(0)
        U.ccx(0, 1, 3)
        U.x(0)
        U.cx(3, 1)
        if barrier: U.barrier()
        # # 8 -> 11
        # U.ccx(3, 1, 0)
        if barrier: U.barrier()
        # # 11 -> 2
        # U.x(0)
        # U.ccx(0, 1, 2)
        # U.x(0)
        if barrier: U.barrier()        
    return U

def U4_N21_a2(U, u_ver, barrier=False):
    """U4 for N=21 a=2 r=6."""        
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    elif u_ver == 1:
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()        
        # 1 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()        
        # 16 -> 4
        U.swap(0, 2)
        # 4 -> 1
        # automatic
        if barrier: U.barrier()
        # 2 -> 11
        U.cx(1, 0)
        U.cx(1, 3)
        if barrier: U.barrier()
        # 11 -> 8
        U.ccx(4, 0, 1)
        U.ccx(4, 0, 3)
        if barrier: U.barrier()
        U.x(2)
        U.x(1)
        U.mct([3, 2, 1], 4)
        U.mct([3, 2, 1], 0)        
        U.x(2)
        U.x(1)
        if barrier: U.barrier()
        # 8 -> 2
        U.ccx(4, 3, 1)
        U.ccx(4, 3, 0)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 3)
        U.x(0)
        if barrier: U.barrier()        
    elif u_ver == 2:
        # 1 -> 16 -> 4 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()        
        # 1 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()        
        # 16 -> 4
        U.swap(0, 2)
        # 4 -> 1
        # automatic
        if barrier: U.barrier()
        # 2 -> 11
        U.cx(1, 0)
        U.cx(1, 3)
        if barrier: U.barrier()
        # 11 -> 8
        U.ccx(4, 0, 1)
        U.ccx(4, 0, 3)
        if barrier: U.barrier()
        # U.x(2)
        # U.x(1)
        # U.mct([3, 2, 1], 4)
        # U.mct([3, 2, 1], 0)        
        # U.x(2)
        # U.x(1)
        if barrier: U.barrier()
        # # 8 -> 2
        # U.ccx(4, 3, 1)
        # U.ccx(4, 3, 0)
        # if barrier: U.barrier()
        # U.x(0)
        # U.ccx(0, 1, 4)
        # U.ccx(0, 1, 3)
        # U.x(0)
        if barrier: U.barrier()        
    return U

def U2_N21_a2(U, u_ver, barrier=False):
    """U2 for N=21 a=2 r=6."""        
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N21_a2(U, u_ver, barrier)
    if u_ver == 1:
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()
        # 1 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()        
        # 4 -> 16
        U.swap(0, 4)
        # 16 -> 1
        # automatic
        if barrier: U.barrier()        
        # 2 -> 8
        U.x(0)
        U.ccx(0, 1, 3)
        U.x(0)
        U.cx(3, 1)
        if barrier: U.barrier()
        # 8 -> 11
        U.ccx(3, 1, 0)
        if barrier: U.barrier()
        # 11 -> 2
        U.x(0)
        U.ccx(0, 1, 2)
        U.x(0)
        if barrier: U.barrier()        
    if u_ver == 2:
        # 1 -> 4 -> 16 -> 1
        # 2 -> 8 -> 11 -> 2
        if barrier: U.barrier()
        # 1 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()        
        # 4 -> 16
        U.swap(0, 4)
        # 16 -> 1
        # automatic
        if barrier: U.barrier()        
        # 2 -> 8
        U.x(0)
        U.ccx(0, 1, 3)
        U.x(0)
        U.cx(3, 1)
        if barrier: U.barrier()
        # # 8 -> 11
        # U.ccx(3, 1, 0)
        if barrier: U.barrier()
        # # 11 -> 2
        # U.x(0)
        # U.ccx(0, 1, 2)
        # U.x(0)
        if barrier: U.barrier()        
    return U

def U1_N21_a2(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=21 a=2 r=6."""        
    # 1 ->  2 -> 4 -> 8 -> 16 -> 11 -> 1
    if u_ver == 0 or u_ver == 1:
        if barrier: U.barrier()
        # 1 -> 2
        U.swap(0, 1)
        if barrier: U.barrier()
        # 2 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()
        # 2 -> 8
        U.swap(0, 3)
        if barrier: U.barrier()
        # 8 -> 16
        U.swap(0, 4)
        if barrier: U.barrier()
        # 16 -> 11
        U.ccx(0, 1, 3)
        U.x(4)
        U.ccx(0, 4, 1)
        U.x(4)
        U.ccx(0, 1, 3)
        if barrier: U.barrier()
        # 11 -> 1
        U.x(3)
        U.mct([1,2,3,4], 0)
        U.x(3)
        if barrier: U.barrier()
        #
        U.mct([0,1,2], 4)
        if barrier: U.barrier()
        #
        U.x(4)
        U.x(3)
        U.mct([0,3,4],2)
        U.mct([0,3,4],1)    
        U.x(4)
        U.x(3)
        if barrier: U.barrier()            
    elif u_ver == 2:
        if barrier: U.barrier()
        # 1 -> 2
        U.swap(0, 1)
        if barrier: U.barrier()
        # 2 -> 4
        U.swap(0, 2)
        if barrier: U.barrier()
        # 2 -> 8
        U.swap(0, 3)
        if barrier: U.barrier()
        # # 8 -> 16
        # U.swap(0, 4)
        # if barrier: U.barrier()
        # 16 -> 11
        # U.ccx(0, 1, 3)
        # U.x(4)
        # U.ccx(0, 4, 1)
        # U.x(4)
        # U.ccx(0, 1, 3)
        if barrier: U.barrier()
        # # 11 -> 1
        # U.x(3)
        # U.mct([1,2,3,4], 0)
        # U.x(3)
        # if barrier: U.barrier()
        # #
        # U.mct([0,1,2], 4)
        # if barrier: U.barrier()
        # #
        # U.x(4)
        # U.x(3)
        # U.mct([0,3,4],2)
        # U.mct([0,3,4],1)    
        # U.x(4)
        # U.x(3)
        if barrier: U.barrier()            
    return U
