######### Modular Exponentiation Operators (MEO's) ######### 

def U32_N21_a13(U, u_ver, barrier=False):
    """U32 for N=21 a=13 r=2."""
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N21_a13(U, u_ver, barrier)
    return U

def U16_N21_a13(U, u_ver, barrier=False):
    """U16 for N=21 a=13 r=2."""
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N21_a13(U, u_ver, barrier)
    return U

def U8_N21_a13(U, u_ver, barrier=False):
    """U8 for N=21 a=13 r=2."""    
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N21_a13(U, u_ver, barrier)
    return U

def U4_N21_a13(U, u_ver, barrier=False):
    """U4 for N=21 a=13 r=2."""        
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N21_a13(U, u_ver, barrier)
    return U

def U2_N21_a13(U, u_ver, barrier=False):
    """U2 for N=21 a=13 r=2."""        
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N21_a13(U, u_ver, barrier)
    return U

def U1_N21_a13(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=21 a=13 r=2."""        
    # 1 ->  13 -> 1
    if u_ver == 0:
        # 1 -> 13
        if barrier: U.barrier()
        U.cx(0, 2)
        U.cx(0, 3)
        # 13 -> 1
        # automatic
        if barrier: U.barrier()
    return U
