######### Modular Exponentiation Operators (MEO's) ######### 

# N=15 m=5 => U16, U8, U4, U2, U1
# U^p for p=2^0, 2^1, ..., 2^{m-1}
#

def U16_N15(U, a, u_ver, barrier=False):
    """U16"""
    if u_ver not in [0, 1]:
        raise ValueError("u_ver must be 0, 1")    
    if a not in [2,4,7,8,11,13]:
        raise ValueError("'a' must be 2,4,7,8,11,13")    
    if u_ver == 0:
        power = 16
        U1_N15(U, a, u_ver, barrier)
    return U

def U8_N15(U, a, u_ver, barrier=False):
    """U8"""
    if u_ver not in [0, 1]:
        raise ValueError("u_ver must be 0, 1")    
    if a not in [2,4,7,8,11,13]:
        raise ValueError("'a' must be 2,4,7,8,11,13")    
    if u_ver == 0:
        power = 8
        U1_N15(U, a, u_ver, barrier)
    return U

def U4_N15(U, a, u_ver, barrier=False):
    """U4"""
    if u_ver not in [0, 1]:
        raise ValueError("u_ver must be 0, 1")    
    if a not in [2,4,7,8,11,13]:
        raise ValueError("'a' must be 2,4,7,8,11,13")    
    if u_ver == 0:
        power = 4
        U1_N15(U, a, u_ver, barrier)
    return U

def U2_N15(U, a, u_ver, barrier=False):
    """U2"""
    if u_ver not in [0, 1]:
        raise ValueError("u_ver must be 0, 1")    
    if a not in [2,4,7,8,11,13]:
        raise ValueError("'a' must be 2,4,7,8,11,13")    
    if u_ver == 0:
        power = 2
        U1_N15(U, a, u_ver, barrier)
    return U

# ME operator for N=15
def U1_N15(U, a, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=15"""        
    if u_ver not in [0, 1]:
        raise ValueError("u_ver must be 0, 1")    
    if a not in [2,4,7,8,11,13]:
        raise ValueError("'a' must be 2,4,7,8,11,13")    
    if a in [2,13]:
        U.swap(0,1)
        U.swap(1,2)
        U.swap(2,3)
    if a in [7,8]:
        U.swap(2,3)
        U.swap(1,2)
        U.swap(0,1)
    if a in [4, 11]:
        U.swap(1,3)
        U.swap(0,2)
    if a in [7,11,13]:
        for q in range(4):
            U.x(q)
    return U
