######### Modular Exponentiation Operators (MEO's) ######### 

def U512_N143_a5(U, u_ver, barrier=False):
    """ U128 for N143 a=5 r=20."""
    if u_ver == 0 or u_ver == 1:
        power = 512
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    return U

def U256_N143_a5(U, u_ver, barrier=False):
    """ U128 for N143 a=5 r=20."""
    if u_ver == 0 or u_ver == 1:
        power = 256
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    return U

def U128_N143_a5(U, u_ver, barrier=False):
    """ U128 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 128
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1 same as U8
        # 1 -> 92 -> 27 -> 14 -> 1
        if barrier: U.barrier()
        # 1 -> 92
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 6)
        U.cx(2, 0)
        if barrier:  U.barrier()
        # 92 -> 27
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 6)
        if barrier: U.barrier()
        # 27 -> 53
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)            
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()
        # 53 -> 14
        U.x(4)
        U.cx(4, 1)
        U.cx(4, 5)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 1
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 3)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 5)
        U.mct([0, 1, 2], 6)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2 same as U8
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 5 -> 31
        # automatic
        # 31 -> 135
        U.x(6)
        U.mct([1, 5, 6], 7)
        U.x(6)
        U.cx(7, 5)
        if barrier: U.barrier()
        # 135 -> 122
        U.ccx(7, 5, 2)
        U.ccx(7, 5, 1)
        U.ccx(7, 5, 0)
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 70
        U.x(4)
        U.x(6)
        U.mct([4, 5, 6], 3)
        U.mct([4, 5, 6], 2)
        U.mct([4, 5, 6], 1)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 5
        U.cswap(7, 2, 1)
        U.x(1)
        U.x(4)
        U.mct([0,1, 2, 4], 7)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()            
    return U

def U64_N143_a5(U, u_ver, barrier=False): 
    """ U64 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 64
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        if barrier: U.barrier()
        # 1 -> 53
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        if barrier: U.barrier()
        # 53 -> 92
        U.x(2)
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        U.cx(2, 6)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.cx(0, 2)
        U.x(0)
        if barrier: U.barrier()
        # 92 -> 14
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 4)            
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(4, 3, 2)
        U.ccx(4, 3, 1)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 27
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 4) 
        U.mct([0, 1, 6], 2) 
        U.x(0)
        U.x(1)
        U.x(6)
        if barrier: U.barrier()
        U.x(2)
        U.mct([2, 3, 4], 1)
        U.mct([2, 3, 4], 0)            
        U.x(2)
        if barrier: U.barrier()
        # 27 -> 1
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # cycle 2
        # 5 -> 122 -> 31 -> 70 -> 135 -> 5
        # 5 -> 122
        #[5, 122, 31, 70, 135] 
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 4)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 31
        U.x(3)
        U.mct([0, 1, 3], 2)
        U.mct([0, 1, 3], 4)
        U.mct([0, 1, 3], 5)
        U.x(3)
        U.mct([0, 1, 2], 3)
        if barrier: U.barrier()
        # 31 -> 70
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 4)
        U.mct([0, 1, 2, 3], 5)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 135
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 7)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        U.cx(7, 6)
        U.cx(7, 4)
        if barrier: U.barrier()
        # 135 -> 5
        U.x(0)
        U.ccx(0, 7, 5)
        U.ccx(0, 7, 4)
        U.ccx(0, 7, 3)
        U.ccx(0, 7, 2)
        U.x(0)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(6)
        U.mct([1, 2, 3, 6], 7)
        U.mct([1, 2, 3, 6], 0)            
        U.x(1)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()  
    return U


def U32_N143_a5(U, u_ver, barrier=False): 
    """U32 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 32
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 14 -> 53 -> 27 -> 92
        if barrier: U.barrier()
        # 1 -> 14
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(1, 0)
        if barrier: U.barrier()
        # 14 -> 53
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        if barrier: U.barrier()            
        U.x(3)
        U.cx(3, 1)
        U.x(3)
        if barrier: U.barrier()            
        # 53 -> 27
        U.ccx(3, 4, 5)
        U.ccx(3, 4, 0)
        if barrier: U.barrier()            
        # 27 -> 92
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 3)
        U.cx(6, 0)
        U.cx(6, 1)
        if barrier: U.barrier()            
        # 91 -> 1
        U.ccx(5, 6, 0)
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 2)
        U.ccx(5, 6, 3)
        U.ccx(5, 6, 4)            
        if barrier: U.barrier()            
        U.x(1)
        U.x(2)
        U.ccx(1, 2, 5)
        U.ccx(1, 2, 6)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 70 -> 122 -> 135 -> 31 -> 5
        # 5 -> 70
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.x(5)
        U.mct([4, 5, 6], 2)
        U.x(4)
        U.x(5)
        if barrier: U.barrier()
        # 70 -> 122
        U.ccx(0, 6, 2)
        U.ccx(0, 6, 1)
        U.x(2)
        U.mct([1, 2, 6], 5)
        U.mct([1, 2, 6], 0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 135
        U.x(0)
        U.x(2)
        U.x(6)
        U.mct([0, 2, 6], 7)
        U.x(0)
        U.x(2)
        U.x(6)
        U.cx(7, 0)
        U.cx(7, 2)
        U.cx(7, 3)
        if barrier: U.barrier()
        # 135 -> 31
        U.ccx(7, 6, 5)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 3)
        U.ccx(7, 6, 2)
        U.ccx(7, 6, 0)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        if barrier: U.barrier()
        # 31 -> 5
        U.x(3)
        U.x(5)
        U.x(6)
        U.x(7)
        U.mct([7, 6, 5, 3, 1, 0], 4)
        U.mct([7, 6, 5, 3, 1, 0], 2)
        U.x(3)
        U.x(5)
        U.x(6)
        U.x(7)
        if barrier: U.barrier()
        U.x(7)
        U.x(4)
        U.mct([7, 4, 2, 0], 1)
        U.x(7)
        U.x(4)
        if barrier: U.barrier()
    return U

def U16_N143_a5(U, u_ver, barrier=False): # same as U4
    """U16 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 16
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 27 -> 14 -> 92 -> 53 -> 1
        if barrier: U.barrier()            
        # 1 -> 27 
        U.cx(0, 1)
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()            
        # 27 -> 14
        U.x(1)
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.x(1)
        U.cx(2, 0)
        U.cx(2, 1)
        if barrier: U.barrier()            
        # 14 -> 92
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 6)
        U.x(1)
        U.cx(6, 0)
        if barrier: U.barrier()            
        # 92 -> 53
        U.x(0)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 5)
        U.mct([0, 1, 4], 3)
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()            
        # 53 -> 1
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)
        U.x(3)
        U.x(4)
        U.mct([0, 3, 4], 2)
        U.mct([0, 3, 4], 1)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 135 -> 70 -> 31 -> 122 -> 5
        # 5 -> 135
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 7)
        U.mct([0, 1, 6], 4)
        U.mct([0, 1, 6], 3)
        U.x(0)
        U.x(1)
        U.x(6)
        U.cx(7, 0)
        U.cx(7, 1)
        if barrier: U.barrier()            
        # 135 -> 70
        U.ccx(7, 6, 0)
        U.ccx(7, 6, 2)
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 7)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 31
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([3, 4, 5, 6], 1)
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([0, 1, 2, 4], 3)
        if barrier: U.barrier()
        # 31 -> 122
        U.x(2)
        U.ccx(2, 6, 5)
        U.ccx(2, 6, 1)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 5
        U.x(5)
        U.mct([1, 4, 5, 6], 7)            
        U.x(5)
        if barrier: U.barrier()
        U.x(5)
        U.ccx(7, 6, 4)
        U.ccx(7, 6, 3)
        U.ccx(7, 6, 2)
        U.ccx(7, 6, 1)
        U.ccx(7, 6, 0)
        U.x(5)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(4)
        U.mct([0, 1, 2, 3, 4], 6)
        U.mct([0, 1, 2, 3, 4], 7)
        U.x(1)
        U.x(3)
        U.x(4)
        if barrier: U.barrier()
    return U

def U8_N143_a5(U, u_ver, barrier=False):
    """U8 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 8
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1 U8 = U128
        # 1 -> 92 -> 27 -> 14 -> 1
        if barrier: U.barrier()
        # 1 -> 92
        U.cx(0, 2)
        U.cx(0, 3)
        U.cx(0, 4)
        U.cx(0, 6)
        U.cx(2, 0)
        if barrier:  U.barrier()
        # 92 -> 27
        U.cx(0, 1)
        U.cx(0, 2)
        U.cx(0, 6)
        if barrier: U.barrier()
        # 27 -> 53
        U.x(0)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)            
        U.x(0)
        U.cx(5, 0)
        U.cx(5, 1)
        if barrier: U.barrier()
        # 53 -> 14
        U.x(4)
        U.cx(4, 1)
        U.cx(4, 5)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 1
        U.ccx(5, 6, 1)
        U.ccx(5, 6, 3)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 5)
        U.mct([0, 1, 2], 6)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 31 -> 135 -> 122 -> 70 -> 5
        # 5 -> 31
        # automatic
        # 31 -> 135
        U.x(6)
        U.mct([1, 5, 6], 7)
        U.x(6)
        U.cx(7, 5)
        if barrier: U.barrier()
        # 135 -> 122
        U.ccx(7, 5, 2)
        U.ccx(7, 5, 1)
        U.ccx(7, 5, 0)
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 70
        U.x(4)
        U.x(6)
        U.mct([4, 5, 6], 3)
        U.mct([4, 5, 6], 2)
        U.mct([4, 5, 6], 1)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 5
        U.cswap(7, 2, 1)
        U.x(1)
        U.x(4)
        U.mct([0,1, 2, 4], 7)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
    return U


def U4_N143_a5(U, u_ver, barrier=False):
    """U4 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 4
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1: U4 = U64
        # 1 -> 53 -> 92 -> 14 -> 27 -> 1 
        if barrier: U.barrier()
        # 1 -> 53
        U.cx(0, 2)
        U.cx(0, 4)
        U.cx(0, 5)
        if barrier: U.barrier()
        # 53 -> 92
        U.x(2)
        U.cx(2, 0)
        U.cx(2, 3)
        U.cx(2, 4)
        U.cx(2, 6)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.cx(0, 2)
        U.x(0)
        if barrier: U.barrier()
        # 92 -> 14
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.mct([0, 1, 2], 4)            
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(4, 3, 2)
        U.ccx(4, 3, 1)
        U.x(4)
        if barrier: U.barrier()
        # 14 -> 27
        U.x(0)
        U.x(1)
        U.x(6)
        U.mct([0, 1, 6], 4) 
        U.mct([0, 1, 6], 2) 
        U.x(0)
        U.x(1)
        U.x(6)
        if barrier: U.barrier()
        U.x(2)
        U.mct([2, 3, 4], 1)
        U.mct([2, 3, 4], 0)            
        U.x(2)
        if barrier: U.barrier()
        # 27 -> 1
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 3)
        U.mct([0, 1, 2], 5)            
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 122 -> 31 -> 70 -> 135 -> 5
        # 5 -> 122
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 4)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 31
        U.x(3)
        U.mct([0, 1, 3], 2)
        U.mct([0, 1, 3], 4)
        U.mct([0, 1, 3], 5)
        U.x(3)
        U.mct([0, 1, 2], 3)
        if barrier: U.barrier()
        # 31 -> 70
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3], 4)
        U.mct([0, 1, 2, 3], 5)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 135
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 7)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        U.cx(7, 6)
        U.cx(7, 4)
        if barrier: U.barrier()
        # 135 -> 5
        U.x(0)
        U.ccx(0, 7, 5)
        U.ccx(0, 7, 4)
        U.ccx(0, 7, 3)
        U.ccx(0, 7, 2)
        U.x(0)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.x(6)
        U.mct([1, 2, 3, 6], 7)
        U.mct([1, 2, 3, 6], 0)            
        U.x(1)
        U.x(3)
        U.x(6)
        if barrier: U.barrier()
    return U

def U2_N143_a5(U, u_ver, barrier=False):
    """U2 for N143 a=5 r=20."""
    if u_ver == 0:
        power = 2
        for iteration in range(power):
            U1_N143_a5(U, u_ver, barrier)
    elif u_ver == 1:
        # cycle 1
        # 1 -> 25 -> 53 -> 38 -> 92 ->
        # 12 -> 14 -> 64 -> 27 -> 103 -> 1
        if barrier: U.barrier()            
        # 1 -> 25
        U.cx(0, 3)
        U.cx(0, 4)
        if barrier: U.barrier()
        # 25 -> 53
        U.x(3)
        U.ccx(0, 3, 2)
        U.ccx(0, 3, 4)
        U.ccx(0, 3, 5)
        U.x(3)
        if barrier: U.barrier()
        # 53 -> 38
        U.x(4)
        U.cx(4, 3)
        U.cx(4, 1)
        U.cx(4, 0)
        U.x(4)
        if barrier: U.barrier()
        # 38 -> 92
        U.x(4)
        U.mct([5, 4, 3], 6)
        U.mct([5, 4, 3], 0)
        U.x(4)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.ccx(0, 1, 4)
        U.ccx(0, 1, 5)
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        # 92 -> 12
        U.x(0)
        U.x(1)
        U.x(4)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 5)
        U.x(0)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
        # 12 -> 14
        U.ccx(0, 1, 3)
        U.mct([1, 2, 3], 0)
        if barrier: U.barrier()
        # 14 -> 64
        U.x(4)
        U.ccx(0, 4, 2)
        U.ccx(0, 4, 6)
        U.x(4)
        if barrier: U.barrier()
        U.x(4)
        U.ccx(6, 4, 0)
        U.x(4)
        if barrier: U.barrier()
        # 64 -> 27
        U.ccx(0, 1, 2)
        U.ccx(0, 1, 3)
        U.ccx(0, 1, 4)
        if barrier: U.barrier()
        # 27 -> 103
        U.x(0)
        U.mct([0, 1, 4], 6)
        U.mct([0, 1, 4], 3)
        U.x(0)
        U.ccx(6, 5, 4)
        U.ccx(6, 5, 0)
        if barrier: U.barrier()
        # 103 -> 1
        U.mct([6, 5, 4], 3)
        U.mct([6, 5, 4], 2)
        U.mct([6, 5, 4], 1)
        U.mct([6, 5, 4], 0)
        if barrier: U.barrier()            
        U.x(1)
        U.mct([0, 1, 6], 5)
        U.mct([0, 1, 6], 4)
        U.mct([0, 1, 6], 2)
        U.x(1)
        if barrier: U.barrier()
        U.x(1)
        U.x(4)
        U.mct([0, 1, 4], 6)
        U.x(1)
        U.x(4)
        if barrier: U.barrier()
        # cycle 2
        # 5 -> 125 -> 122 -> 47 -> 31 -> 
        # 60 ->70 -> 34 -> 135 -> 86 -> 5
        # 5 -> 125
        U.x(1)
        U.mct([0, 1, 2, 3], 5)
        U.mct([0, 1, 2, 3], 6)
        U.x(1)
        if barrier: U.barrier()
        # 125 -> 122
        U.x(6)
        U.x(4)
        U.mct([6, 5, 4, 0], 2)
        U.mct([6, 5, 4, 0], 1)
        U.mct([6, 5, 4, 0], 7)
        U.x(6)
        U.x(4)
        if barrier: U.barrier()
        U.cx(7, 0)
        U.cx(7, 3)
        U.cx(7, 4)
        U.cx(7, 6)
        if barrier: U.barrier()
        U.x(0)
        U.x(2)
        U.mct([0, 1, 2], 7)
        U.x(0)
        U.x(2)
        if barrier: U.barrier()
        # 122 -> 47
        U.cx(7, 0)
        U.cx(7, 2)
        U.cx(7, 3)
        U.cx(7, 4)
        U.x(4)
        U.x(6)
        U.mct([3,  4, 5, 6], 7)
        U.x(4)
        U.x(6)
        if barrier: U.barrier()
        # 47 -> 31
        U.x(6)
        U.x(7)
        U.mct([3, 4, 5, 6, 7], 2)
        U.mct([3, 4, 5, 6, 7], 1)
        U.mct([3, 4, 5, 6, 7], 0)
        U.x(6)
        U.x(7)
        U.mct([0, 1, 2, 3, 4], 5)
        if barrier: U.barrier()
        # 31 -> 60
        U.cx(7, 6)
        U.cx(7, 4)
        U.cx(7, 3)
        U.cx(7, 0)
        U.x(6)
        U.mct([3, 4, 5, 6], 7)
        U.x(6)
        if barrier: U.barrier()
        # 60 -> 70
        U.x(3)
        U.mct([3, 4, 5, 6], 2)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        if barrier: U.barrier()
        U.x(0)
        U.x(3)
        U.mct([0, 1, 2, 3, 6], 5)
        U.mct([0, 1, 2, 3, 6], 4)
        U.x(0)
        U.x(3)
        if barrier: U.barrier()
        # 70 -> 34
        U.x(4)
        U.x(2)
        U.mct([4, 3, 2], 0)
        U.mct([4, 3, 2], 1)
        U.mct([4, 3, 2], 5)
        U.mct([4, 3, 2], 6)
        U.x(4)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.x(2)
        U.x(4)
        U.mct([0, 1, 2, 4], 3)
        U.x(0)
        U.x(2)
        U.x(4)
        if barrier: U.barrier()
        # 34 -> 135
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2, 3], 7)
        U.mct([0, 1, 2, 3], 6)
        U.mct([0, 1, 2, 3], 4)
        U.x(0)
        U.x(1)
        U.x(2)
        U.cx(7, 0)
        U.cx(7, 1)
        U.cx(7, 2)
        U.cx(7, 3)
        if barrier: U.barrier()
        # 135 -> 86
        U.x(3)
        U.x(5)
        U.mct([3, 4, 5, 6], 2)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        # 86 -> 5
        U.x(0)
        U.x(6)
        U.mct([0, 1, 2, 4, 6], 3)
        U.x(0)
        U.x(6)
        if barrier: U.barrier()
        U.x(3)
        U.x(5)
        U.x(6)
        U.mct([3, 4, 5, 6], 1)
        U.mct([3, 4, 5, 6], 0)
        U.x(3)
        U.x(5)
        U.x(6)
        if barrier: U.barrier()
        U.x(1)
        U.x(5)
        U.mct([0, 1, 2, 5], 4)
        U.x(1)
        U.x(5)
        if barrier: U.barrier()
    return U

def U1_N143_a5(U, u_ver, barrier=False):
    """U1 Modular Exponentiation Operator for N=128 a=5 r=20"""        
    if u_ver == 0 or u_ver == 1:
        # r=20
        # 1 -> 5 -> 25 -> 125 -> 53 -> 122 ->
        # 38 -> 47 -> 92 -> 31 -> 12 -> 60 ->
        # 14 -> 70 -> 64 -> 34 -> 27 -> 135 ->
        # 103 -> 86 -> 1
        # 1 -> 5 
        if barrier: U.barrier()
        U.x(1)
        U.ccx(0, 1, 2)        
        U.x(1)
        # 5 -> 25 
        if barrier: U.barrier()
        U.x(2)
        U.ccx(0, 2, 3)
        U.ccx(0, 2, 4)        
        U.x(2)
        # 25 -> 125 
        if barrier: U.barrier()        
        U.x(1)
        U.mct([3, 2, 1, 0], 5)
        U.mct([3, 2, 1, 0], 6)        
        U.x(1)
        # 125 -> 53 
        if barrier: U.barrier()
        U.x(4)
        U.mct([6, 5, 4], 2)
        U.x(4)
        if barrier: U.barrier()
        U.x(1)
        U.x(3)
        U.mct([5, 3, 2, 1, 0], 4)
        U.mct([5, 3, 2, 1, 0], 6)        
        U.x(1)
        U.x(3)
        if barrier: U.barrier()
        # 53 -> 122 
        U.x(6)
        U.mct([6, 5, 3], 4)
        U.mct([6, 5, 3], 1)
        U.mct([6, 5, 3], 0)        
        U.x(6)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 1, 6)
        U.x(0)
        if barrier: U.barrier()
        # 122 -> 38 
        U.x(6)
        U.mct([6, 5, 1], 4)
        U.mct([6, 5, 1], 3)
        U.mct([6, 5, 1], 2)        
        U.x(6)
        if barrier: U.barrier()
        # 38 -> 47
        U.x(4)
        U.ccx(6, 4, 3)
        U.ccx(6, 4, 0)        
        U.x(4)
        if barrier: U.barrier()
        U.ccx(0, 1, 6)
        if barrier: U.barrier()
        # 47 -> 92
        U.x(0)
        U.x(1)
        U.ccx(0, 1, 5)
        U.ccx(0, 1, 6)        
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        # 92 -> 31
        U.x(6)
        U.mct([6, 4, 3, 2], 5)
        U.mct([6, 4, 3, 2], 1)
        U.mct([6, 4, 3, 2], 0)        
        U.x(6)
        if barrier: U.barrier()
        # 31 -> 12
        U.x(5)
        U.mct([6, 5, 0], 1)
        U.mct([6, 5, 0], 4)        
        U.x(5)
        if barrier: U.barrier()
        U.x(5)
        U.x(4)
        U.mct([5, 4, 3, 2], 6)
        U.mct([5, 4, 3, 2], 0)        
        U.x(5)
        U.x(4)
        if barrier: U.barrier()
        # 12 -> 60
        U.x(0)
        U.x(1)
        U.mct([5, 1, 0], 6)
        U.mct([5, 1, 0], 4)        
        U.x(0)
        U.x(1)
        if barrier: U.barrier()
        # 60 -> 14
        U.x(2)
        U.mct([2, 1, 0], 3) 
        U.mct([2, 1, 0], 4)
        U.mct([2, 1, 0], 5)
        U.mct([2, 1, 0], 6)
        U.x(2)
        if barrier: U.barrier()
        U.x(6)
        U.x(5)
        U.x(4)
        U.mct([6, 5, 4, 1], 0)
        U.mct([6, 5, 4, 1], 2)        
        U.x(6)
        U.x(5)
        U.x(4)
        # 14 -> 70
        U.x(0)
        U.x(2)
        U.x(3)
        U.mct([3, 2, 1, 0], 6)
        U.x(0)
        U.x(2)
        U.x(3)
        if barrier: U.barrier()
        U.x(5)
        U.mct([6, 5, 1], 2)
        U.x(5)
        # 70 -> 64
        U.x(7)
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([7, 6, 5, 4, 3, 2], 0)
        U.mct([7, 6, 5, 4, 3, 2], 1)        
        U.x(7)
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        if barrier: U.barrier()
        U.x(0)
        U.x(1)
        U.x(2)
        U.mct([0, 1, 2], 6)
        U.x(0)
        U.x(1)
        U.x(2)
        if barrier: U.barrier()
        # 64 -> 34
        U.x(6)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([6, 5, 4, 3, 2], 0)
        U.x(6)
        U.x(4)
        U.x(3)
        U.x(2)
        # 34 -> 27
        U.x(3)
        U.mct([3, 2, 1, 0], 6)
        U.x(3) 
        if barrier: U.barrier()
        U.x(5)
        U.mct([5, 4, 1, 0, 3], 2)
        U.mct([5, 4, 1, 0, 2], 3)        
        U.mct([5, 4, 1, 0, 3], 2)        
        U.x(5)
        if barrier: U.barrier()
        # 27 -> 135
        U.x(1)
        U.x(2)
        U.x(3)
        U.mct([3, 2, 1, 0], 7)
        U.mct([3, 2, 1, 0], 6)        
        U.x(1)
        U.x(2)
        U.x(3)
        if barrier: U.barrier()
        U.cx(7, 4)
        U.cx(7, 2)
        U.cx(7, 1)
        if barrier: U.barrier()        
        # 135 -> 103
        U.mct([7, 6], 5)
        U.mct([7, 6], 2)
        if barrier: U.barrier()
        U.x(4)
        U.mct([6, 5, 4], 7)
        U.x(4)
        if barrier: U.barrier()
        # 103 -> 86
        U.mct([7, 6], 5)
        U.mct([7, 6], 2)
        U.mct([7, 6], 3)
        U.mct([7, 6], 4)
        if barrier: U.barrier()
        U.x(5)
        U.x(3)
        U.mct([6, 5, 4, 3], 7)
        U.x(3)
        U.x(5)
        if barrier: U.barrier()
        # 86 ->  1
        U.x(6)
        U.x(5)
        U.x(3)
        U.mct([6, 5, 4, 3], 7)
        U.x(6)
        U.x(5)
        U.x(3)
        if barrier: U.barrier()
        U.x(0)
        U.ccx(0, 7, 1)
        U.ccx(0, 7, 2)
        U.ccx(0, 7, 4)
        U.x(0)
        if barrier: U.barrier()
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        U.mct([6, 5, 4, 3, 2], 0)
        U.mct([6, 5, 4, 3, 2], 7)            
        U.x(6)
        U.x(5)
        U.x(4)
        U.x(3)
        U.x(2)
        if barrier: U.barrier()
    return U
