# -*- coding: utf-8 -*-
"""
Created on Thu Mar 09 21:49:34 2017

@author: Johannes
"""
import inspect               # http://docs.python.org/library/inspect.html
import matplotlib            # http://matplotlib.sourceforge.net
import numpy                 # http://numpy.scipy.org/
import scipy                 # http://scipy.org/
import scipy.odr, scipy.special, scipy.stats
import matplotlib.pyplot as plt
import numpy as np
from matplotlib.widgets import Slider, Button, RadioButtons
from scipy.integrate import ode

N=300
r = 8 
x = np.linspace(-r, r, 2*N) 

s=1.7
k=6#5.5
d=1.5#4.5

#sfreq = Slider(axfreq, 'Freq', 0.1, 30.0, valinit=d, valstep=delta_f)


def D0(x,d):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x-s)**2+d**2))/(np.sqrt((x-s)**2+d**2))+np.exp(k*1j*np.sqrt((x+s)**2+d**2))/(np.sqrt((x+s)**2+d**2)))**2

def D1(x):
    
    return np.absolute(1j*np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2)-np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

def D2(x):
    
    return np.absolute(-np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2)+1j*np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

def D3(x):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2))**2

def D4(x):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

# n standardeviations in the functions will be shown

matplotlib.rc('text', usetex=True)
matplotlib.rc('font', family='serif')
matplotlib.rc('xtick', labelsize=20) 
matplotlib.rc('ytick', labelsize=20)
matplotlib.rcParams['xtick.major.pad'] = 10
matplotlib.rcParams['ytick.major.pad'] = 10

fig = plt.figure(figsize=(18,14), dpi=100, facecolor='w', edgecolor='w')
ax0 = fig.add_subplot(111)
#ax1 = fig.add_subplot(512)
#ax2 = fig.add_subplot(513)
#ax3 = fig.add_subplot(514)
#ax4 = fig.add_subplot(515)

#ax.xaxis.labelpad = 20
#ax.yaxis.labelpad = 20



#plt.hold(True)
 
   
#plt.bar(left=x_model, 
#    height = 2*nSigma*fitError,  
#    width=abs(x_model[0]-x_model[1]), 
#    bottom = curveFit - nSigma*fitError, 
#    orientation = 'vertical', 
#    alpha=0.04, 
#    color = 'purple',
#    edgecolor = None,
#    label = r"$\displaystyle \pm 3\sigma\;\;\mathrm{errorBars}$")


inte='bicubic'
asp='auto'

#ax0.imshow(np.vstack((D1(x)+D2(x),D1(x)+D2(x))), cmap='Greys', aspect=asp,interpolation=inte)
#ax1.imshow(np.vstack((D2(x),D2(x))), cmap='Oranges', aspect=asp,interpolation=inte)
#ax2.imshow(np.vstack((D1(x),D1(x))), cmap='Blues', aspect=asp,interpolation=inte)
#ax3.imshow(np.vstack((D3(x),D3(x))), cmap='Greens', aspect=asp,interpolation=inte)
#ax4.imshow(np.vstack((D4(x),D4(x))), cmap='Greens', aspect=asp,interpolation=inte)
d0= 0.255
d1= 2.625
d2= 6.295

#samp = Slider(ax0, 'Amp', 0., 10.0, valinit=d)
#plt.plot(x, D0(x,d))
#plt.ylim(0,d)

#ax0.plot(x, D0(x,d0)/20+d0, color = 'black', alpha=0.7)
#ax0.plot(x, 0*D0(x,d0)+d0, '--', color = 'black',alpha=0.7)
#ax0.plot(x, D0(x,d1)*2+d1, color = 'black', alpha=0.7)
#ax0.plot(x, 0*D0(x,d1)+d1, '--', color = 'black',alpha=0.7)
#ax0.plot(x, D0(x,d2)*3+d2, color = 'black', alpha=0.7)
#ax0.plot(x, 0*D0(x,d2)+d2, '--', color = 'black',alpha=0.7)
ax0.set_ylim(ymax=1.5*d2, ymin=0)

s=1.7
k=6
def f(x,y):
    return np.sqrt((x-s)**2+y**2)
    
def psi(x,y):
    return np.exp(k*1j*f(x,y))/f(x,y)+np.exp(k*1j*f(-x,y))/f(-x,y)
        
def gradpsix(x,y):
    return (x-s)*np.exp(k*1j*f(x,y))/f(x,y)**3*(k*1j*f(x,y)-1.) +\
           (x+s)*np.exp(k*1j*f(-x,y))/f(-x,y)**3*(k*1j*f(-x,y)-1.)

def gradpsiy(x,y):
    return y*np.exp(k*1j*f(x,y))/f(x,y)**3*(k*1j*f(x,y)-1.) + \
           y*np.exp(k*1j*f(-x,y))/f(-x,y)**3*(k*1j*f(-x,y)-1.)


def B(t, x):
    return [np.imag(gradpsix(x[0],x[1])/psi(x[0],x[1])), np.imag(gradpsiy(x[0],x[1])/psi(x[0],x[1]))]

#x=np.linspace(0,10, 10)
i=0
d=0.25
while i <23:
    delta=0.8/23
    x0, t0 = [-2+(i+1)*delta, d], 0
    r = ode(B)
    r.set_initial_value(x0, t0)
    t1 = 2
    dt = 0.01
    x=[]
    y=[]
    t=[]
    i+=1
    while r.successful() and r.t < t1:
    #print r.y[0]
        r.integrate(r.t+dt)
    #print r.t, r.y[1]
        x += [r.y[0]]
        y += [r.y[1]]
        t += [r.t]
    ax0.plot(x,y, 'black', alpha=1, linewidth=3)
    
i=0
while i <23:
    delta=0.8/23
    x0, t0 = [2-(i+1)*delta, d], 0
    r = ode(B)
    r.set_initial_value(x0, t0)
    t1 = 2
    dt = 0.01
    x=[]
    y=[]
    t=[]
    i+=1
    while r.successful() and r.t < t1:
    #print r.y[0]
        r.integrate(r.t+dt)
    #print r.t, r.y[1]
        x += [r.y[0]]
        y += [r.y[1]]
        t += [r.t]
    ax0.plot(x,y, 'black', alpha=1,linewidth=3)
    
i=0
while i < 19:
    delta=2.4/20
    x0, t0 = [-1.2+(i+1)*delta, d], 0
    r = ode(B)
    r.set_initial_value(x0, t0)
    t1 = 2
    dt = 0.01
    x=[]
    y=[]
    t=[]
    i+=1
    while r.successful() and r.t < t1:
    #print r.y[0]
        r.integrate(r.t+dt)
    #print r.t, r.y[1]
        x += [r.y[0]]
        y += [r.y[1]]
        t += [r.t]
    ax0.plot(x,y, 'black', alpha=1,linewidth=3)
#print psi(1.7,0.3)
#x = np.linspace(-8, 8, 300) 
#ax0.plot(x,np.abs(psi(x,0.9))**2, 'black')
        
x=np.linspace(-10,-2.15, 2)    
ax0.plot(x,np.zeros(len(x)), 'black', linewidth=20)   

x=np.linspace(2.15,10, 2)    
ax0.plot(x,np.zeros(len(x)), 'black', linewidth=20) 

x=np.linspace(-1.25,1.25, 2)    
ax0.plot(x,np.zeros(len(x)), 'black', linewidth=20) 
#ax0.set_ylim(ymax=d2, ymin=0)
#ax2.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))
#ax3.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))

#def update(val):
#    d = samp.val
#    #freq = sfreq.val
#    l.set_ydata(D0(x,d))
#    l1.set_ydata(D0(x,d))
#    ax1.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))
#    ax2.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))
#    ax3.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))
#    ax4.set_ylim(ymax=max(D0(x,d)), ymin=min(D0(x,d)))
#    fig.canvas.draw_idle()
    
#sfreq.on_changed(update)


#samp.on_changed(update)


#plt.plot(x, D0(x))


size=2*28  
#plt.xlabel(r"$\mathrm{\lambda \ (1)$", fontsize=24)
#ax0.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_1 \ \mathrm{or} \ D_2$",size=size)
#ax1.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_1$",size=size)
#ax2.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_2$",size=size)
#ax3.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_3$",size=size)
#ax4.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_4$",size=size)

#ax0.set_ylim(ymax=max(x), ymin=min(x))
#ax1.set_ylim(ymax=max(x), ymin=min(x))
#plt.title(r"$\mathrm{Linear\ fit\ of} \ \mathrm{SiO}_2 \ \mathrm{at\ T} \approx \ 140^\circ \mathrm{C}  $",
#      fontsize=28, color='k')
#plt.legend(loc='best')
#plt.gca().xaxis.set_major_locator(matplotlib.ticker.MaxNLocator(prune='lower'))
#plt.grid()


width=0
ax0.spines['bottom'].set_linewidth(width)
ax0.spines['top'].set_linewidth(width)
ax0.spines['left'].set_linewidth(width)
ax0.spines['right'].set_linewidth(width)

#ax1.spines['bottom'].set_linewidth(width)
#ax1.spines['top'].set_linewidth(width)
#ax1.spines['left'].set_linewidth(width)
#ax1.spines['right'].set_linewidth(width)
#
#ax2.spines['bottom'].set_linewidth(width)
#ax2.spines['top'].set_linewidth(width)
#ax2.spines['left'].set_linewidth(width)
#ax2.spines['right'].set_linewidth(width)
#
#ax3.spines['bottom'].set_linewidth(width)
#ax3.spines['top'].set_linewidth(width)
#ax3.spines['left'].set_linewidth(width)
#ax3.spines['right'].set_linewidth(width)
#
#ax4.spines['bottom'].set_linewidth(width)
#ax4.spines['top'].set_linewidth(width)
#ax4.spines['left'].set_linewidth(width)
#ax4.spines['right'].set_linewidth(width)



ax0.xaxis.set_major_formatter(plt.NullFormatter())
ax0.yaxis.set_major_formatter(plt.NullFormatter())
ax0.xaxis.set_ticks([])
ax0.yaxis.set_ticks([])

#ax1.xaxis.set_major_formatter(plt.NullFormatter())
#ax1.yaxis.set_major_formatter(plt.NullFormatter())
#ax1.xaxis.set_ticks([])
#ax1.yaxis.set_ticks([])
#
#ax2.xaxis.set_major_formatter(plt.NullFormatter())
#ax2.yaxis.set_major_formatter(plt.NullFormatter())
#ax2.xaxis.set_ticks([])
#ax2.yaxis.set_ticks([])
#
#ax3.xaxis.set_major_formatter(plt.NullFormatter())
#ax3.yaxis.set_major_formatter(plt.NullFormatter())
#ax3.xaxis.set_ticks([])
#ax3.yaxis.set_ticks([])
#
#ax4.xaxis.set_major_formatter(plt.NullFormatter())
#ax4.yaxis.set_major_formatter(plt.NullFormatter())
#ax4.xaxis.set_ticks([])
#ax4.yaxis.set_ticks([])

plt.tight_layout()
plt.savefig('interference.png', dpi=600)
plt.show()     