# -*- coding: utf-8 -*-
"""
Created on Thu Mar 09 21:49:34 2017

@author: Johannes
"""
import inspect               # http://docs.python.org/library/inspect.html
import matplotlib            # http://matplotlib.sourceforge.net
import numpy                 # http://numpy.scipy.org/
import scipy                 # http://scipy.org/
import scipy.odr, scipy.special, scipy.stats
import matplotlib.pyplot as plt
import numpy as np



N=300
x = np.linspace(-4, 4, N) 

s=1.7
k=6
d=4.5

def D0(x):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2)+np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

def D1(x):
    
    return np.absolute(1j*np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2)-np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

def D2(x):
    
    return np.absolute(-np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2)+1j*np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

def D3(x):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x-s)**2+d))/(d+(x-s)**2))**2

def D4(x):
    
    return np.absolute(np.exp(k*1j*np.sqrt((x+s)**2+d))/(d+(x+s)**2))**2

# n standardeviations in the functions will be shown

matplotlib.rc('text', usetex=True)
matplotlib.rc('font', family='serif')
matplotlib.rc('xtick', labelsize=20) 
matplotlib.rc('ytick', labelsize=20)
matplotlib.rcParams['xtick.major.pad'] = 10
matplotlib.rcParams['ytick.major.pad'] = 10

fig = plt.figure(figsize=(18,14), dpi=100, facecolor='w', edgecolor='w')
ax0 = fig.add_subplot(211)
ax1 = fig.add_subplot(212)
#ax2 = fig.add_subplot(513)
#ax3 = fig.add_subplot(514)
#ax4 = fig.add_subplot(515)
#ax.xaxis.labelpad = 20
#ax.yaxis.labelpad = 20



#plt.hold(True)
 
   
#plt.bar(left=x_model, 
#    height = 2*nSigma*fitError,  
#    width=abs(x_model[0]-x_model[1]), 
#    bottom = curveFit - nSigma*fitError, 
#    orientation = 'vertical', 
#    alpha=0.04, 
#    color = 'purple',
#    edgecolor = None,
#    label = r"$\displaystyle \pm 3\sigma\;\;\mathrm{errorBars}$")


inte='bicubic'
asp='auto'

ax0.plot(x, D1(x)+D2(x), ':', color='BLACK', linewidth=5)
ax0.plot(x, D2(x), '--', color='orange',linewidth=4)
ax0.plot(x, D1(x), color='blue',linewidth=4)
ax1.plot(x, D3(x), '--', color='green',linewidth=4)
ax1.plot(x, D4(x), color='green',linewidth=4)
ax1.plot(x, D3(x)+D4(x), ':', color='BLACK', linewidth=5)


size=2*22
#plt.xlabel(r"$\mathrm{\lambda \ (1)$", fontsize=24)
ax0.set_xlabel(r"$ \ - \ (D_0, D_1) \ -- \ (D_0, D_2) \ \cdot\cdot \mathrm{\ Sum \ of} \ (D_0, D_1) \ \mathrm{and} \ (D_0, D_2) $"  ,size=size)
ax1.set_xlabel(r"$ \ - \ (D_0, D_4) \ -- \ (D_0, D_3) \ \cdot\cdot \mathrm{\ Sum \ of} \ (D_0, D_3) \ \mathrm{and} \ (D_0, D_4) $",size=size)
#ax2.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_2$",size=size)
#ax3.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_3$",size=size)
#ax4.set_xlabel(r"$ D_0 \ \mathrm{correlated \ with} \ D_4$",size=size)

#ax0.legend()
#ax0.set_ylim(ymax=max(x), ymin=min(x))
#ax1.set_ylim(ymax=max(x), ymin=min(x))
#plt.title(r"$\mathrm{Linear\ fit\ of} \ \mathrm{SiO}_2 \ \mathrm{at\ T} \approx \ 140^\circ \mathrm{C}  $",
#      fontsize=28, color='k')
#plt.legend(loc='best')
#plt.gca().xaxis.set_major_locator(matplotlib.ticker.MaxNLocator(prune='lower'))
#plt.grid()


width=0
ax0.spines['bottom'].set_linewidth(width)
ax0.spines['top'].set_linewidth(width)
ax0.spines['left'].set_linewidth(width)
ax0.spines['right'].set_linewidth(width)

ax1.spines['bottom'].set_linewidth(width)
ax1.spines['top'].set_linewidth(width)
ax1.spines['left'].set_linewidth(width)
ax1.spines['right'].set_linewidth(width)
#
#ax2.spines['bottom'].set_linewidth(width)
#ax2.spines['top'].set_linewidth(width)
#ax2.spines['left'].set_linewidth(width)
#ax2.spines['right'].set_linewidth(width)
#
#ax3.spines['bottom'].set_linewidth(width)
#ax3.spines['top'].set_linewidth(width)
#ax3.spines['left'].set_linewidth(width)
#ax3.spines['right'].set_linewidth(width)
#
#ax4.spines['bottom'].set_linewidth(width)
#ax4.spines['top'].set_linewidth(width)
#ax4.spines['left'].set_linewidth(width)
#ax4.spines['right'].set_linewidth(width)



ax0.xaxis.set_major_formatter(plt.NullFormatter())
ax0.yaxis.set_major_formatter(plt.NullFormatter())
ax0.xaxis.set_ticks([])
ax0.yaxis.set_ticks([])

ax1.xaxis.set_major_formatter(plt.NullFormatter())
ax1.yaxis.set_major_formatter(plt.NullFormatter())
ax1.xaxis.set_ticks([])
ax1.yaxis.set_ticks([])

#ax2.xaxis.set_major_formatter(plt.NullFormatter())
#ax2.yaxis.set_major_formatter(plt.NullFormatter())
#ax2.xaxis.set_ticks([])
#ax2.yaxis.set_ticks([])
#
#ax3.xaxis.set_major_formatter(plt.NullFormatter())
#ax3.yaxis.set_major_formatter(plt.NullFormatter())
#ax3.xaxis.set_ticks([])
#ax3.yaxis.set_ticks([])
#
#ax4.xaxis.set_major_formatter(plt.NullFormatter())
#ax4.yaxis.set_major_formatter(plt.NullFormatter())
#ax4.xaxis.set_ticks([])
#ax4.yaxis.set_ticks([])

plt.tight_layout()
plt.savefig('inte.pdf', dpi=600)
plt.show()     