function wavepacket(its,sav,sav2,init,frm,disp,mode,delay,stad)
%Developed by Chris King Jun 2009 extending to the stadium a CA algorithm 
%of Y.W. Kwon, S. Hosoglu Computers and Structures 86 (2008) 663670

%Generates scar images of superimposed waves, and movies of traveling waves
%in the stadium, rectangle and double slit apparatus (examples below).
%If called in sequence, will save and load matrix files to continue.

%Parameters
%its=iterations, sav saves avi file, sav2 saves last matrices for reloading
%init uses pre-initialized wave packet rather than a pre-saved matrix 
%in the file wmat or wmatn n=0,1,2,etc. if sav2 is set to 1 previously
%this means wavepacket can be called repeatedly without reinitializing
%frm gives which frame of a series is being run 
%disp =1 or 2 display modes, disp=0 no display 
%disp=-1 shows summed abs scar, -2 amplitude sum, -3 squared proability
%to adjust shading of a scar plot adjust lev1 for disp=-1,-2 lev2 for -3 
%mode gives various Gaussian cosine generator wave packets
%mode=1 oblique traveling wave (bow tie) mode=2 horizontal traveling wave
%mode=3 circular wave, mode=4 horizontal packet, mode=5 hrz double period 
%mode=9 bowtie generator, mode=11 diamonds, mode=7 twin pegs mode=13 V 
%mode=6 cosxcosy product, mode=8 cosx+cosy sum mode=12 rectangle
%mode=10 a horizontal wave for double slit,mode=14 vertical wave for lemon
%mode=15 period-6
%delay before showing images or beginning scar summation (usually=0)
%stad=0 stadium, 1=rectangle, 2=double slit, 3=lemon

%Examples 
%wavepacket(3300,0,1,1,0,-1,4,0,0) horizontal scar 3300 steps
%setting other modes as above gives scars for other orbit eigenfunctions 
%wavepacket(1100,1,1,1,0,2,4,550,0) horizontal wave avi from 550 to 1100
%wavepacket(1650,1,1,1,0,2,2,0,0) right moving wave packet avi movie
%wavepacket(1694,0,1,1,0,-1,8,0,1) periodic sum wave function in rectangle
%wavepacket(2299,0,1,1,0,-1,8,0,1) periodic product function in rectangle
%wavepacket(1694,1,1,1,0,2,8,0,1) avi loop movie of periodic sum function
%wavepacket(110,0,1,1,0,2,10,0,2) demo of double slit interference

myh=11*27+2; %dimensions of stadium with 1-pixcell border
myw=2*11*27+2;
figure('position',[400 400 myw myh]);
axes('position',[0 0 1 1]);
if init
    wavef(1,0,1,0,0,0,mode,myh,myw,0,stad)
    load wmat;
    if ~mod(mode,2)
        pos=[(myh+1)/2 myh-116]; %horizontal wave fn clip
    else
        pos=[(myh+1)/2-65 myh-96]; %bow tie
    end
    fac=1/8;
    mysz=max([myh-2,myw-2]);
    ht=32;
    for i=1:myh
        for j=1:myw
            mymat(i,j)=ht*mymat(i,j)*exp(-2*fac/mysz*pi*((i-pos(1))^2+(j-pos(2))^2));        
        end
    end
    if mode<=2
       save('wmat','mymat');
       wavef(60,0,1,1,0,0,mode,myh,myw,0,stad)
    end
    load wmat;
    [myh myw]=size(mymat);
    pos=[(myh+1)/2 (myw+1)/2]; %position at which to clip wave fn
    fac=1/18;
    mysz=max(size(mymat)-2);
    ht=32;
    for i=1:myh
        for j=1:myw
            mymat(i,j)=ht*mymat(i,j)*exp(-2*fac/mysz*pi*((i-pos(1))^2+(j-pos(2))^2));        
        end
    end
    if mode<=2
        save('wmat','mymat');
    end
end
wavef(its,sav,sav2,1,frm,disp,mode,myh,myw,delay,stad)

function wavef(steps,sav,sav2,lod,frm,disp,mode,myh,myw,delay,stad)
%steps=iterations, sav=1 saves an avi file
%sav2 saves the end matrix mymat, lod loads the previous mymat
%frm gives a frame number for a series of function calls
%disp = 0,1,2 as in wavepacket above, mode=1-15 as above
%myh, myw height and width of stadium
%delay delay until viewing step (to speed up inial calculations)
%stad=0-2 as above
lev1=1.5;
lev2=3.2;
pi=3.14159;
fac=1/32;
%fac=1/24;
fac2=(myw-2)/11; %horizontal
%fac2=fac2/2.5894;
%fac2=fac2*11/26;
if mode==5||mode==14
    fac2=fac2/2;
end
if mode==9||mode==1
    fac2=fac2/2.5894; %bow tie
end
if mode==11
    fac2=fac2*sqrt(2)/4; %twin diamonds
end
if mode==7
    fac2=fac2/2.3272; %twin pegs
end    
if mode==13
    fac2=fac2/2.4; %twin V
end    
if mode==12
    fac2=fac2*596/1430; %rectangular orbit
end
if mode==15
    fac2=fac2*8/13.2039; %6 period
end
ht=1;
mymask=zeros(myh,myw);
myimat=zeros(myh,myw,3);
%hold=0;
for i=2:(myh+1)/2
    for j=1:myw
        switch stad
            case 0
                rd=(myh-1)/2;
                hold=j<=myh-2+rd+sqrt(rd^2-(i-(myh+1)/2)^2)&&j>=rd+2-sqrt(rd^2-(i-(myh+1)/2)^2);
            case 1
                hold=(j<=myw-1&&j>=2);
            case 2
                hold=1;
                if j>=myw/2&&j<=myw/2+1
                    if ~(i>=myh/4&&i<=myh/4+10)||(i<=3*myh/4&&i>=3*myh/4-10)
                        hold=0;
                    end
                end
            case 3
               rd=myh-50;
               hold=j<=myw/2+sqrt(rd^2-(i-rd-2)^2)&&j>=myw/2-sqrt(rd^2-(i-rd-2)^2);
         end
        if hold
            mymask(i,j)=1;
            mymask(myh-i+1,j)=1;
        end
    end
end
mymat=zeros(myh,myw);
for i=1:myh
    for j=1:myw
        if mymask(i,j)
            p=1;
            if mode==1||mode==2||mode==3
                mymat(i,j)=ht*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2)^(1/2));
            end
            if mode==4||mode==5
                mymat(i,j)=ht*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*((j-(myw+p)/2)^2)^(1/2));
            end
            if mode==6
                mymat(i,j)=ht*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2))*cos(2*pi*fac2/(myw-2)*(i-(myh+p)/2));
                mymat(i,j)=mymat(i,j)+ht*exp(-2*fac/(myw-2)*pi*((j-(myw+p)/2))^2)*cos(2*pi*fac2/(myw-2)*(j-(myw+p)/2));
            end
            if mode==8
                mymat(i,j)=ht*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2))*cos(2*pi*fac2/(myw-2)*(i-(myh+p)/2));
                mymat(i,j)=mymat(i,j)*exp(-2*fac/(myw-2)*pi*((j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*(j-(myw+p)/2));
            end
            if mode==9
                h=222.8500/257.5541;
                v=129.12/257.5541;
                mymat(i,j)=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-(myw+p)/2)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-(myw+p)/2)));
                mymat(i,j)=ht*mymat(i,j)*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2));
            end
            if mode==11
                h=1/sqrt(2);
                v=h;
                mymat(i,j)=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-(myw+p)/2)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-(myw+p)/2)));
                mymat(i,j)=ht*mymat(i,j)*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2));
            end
            if mode==7
                h=469/511.28;
                v=203.58/511.28;
                hold=cos(2*pi*fac2/(myw-2)*(v*(i-85.94)+h*(j-(myw+p)/2)))+cos(2*pi*fac2/(myw-2)*(v*(i-85.94)-h*(j-(myw+p)/2)));
                hold=ht*hold*exp(-3*fac/(myw-2)*pi*((i-85.94)^2+(j-(myw+p)/2)^2));
                hold2=cos(2*pi*fac2/(myw-2)*(v*(i-214.05)+h*(j-(myw+p)/2)))+cos(2*pi*fac2/(myw-2)*(v*(i-214.05)-h*(j-(myw+p)/2)));
                hold2=ht*hold2*exp(-3*fac/(myw-2)*pi*((i-214.05)^2+(j-(myw+p)/2)^2));
                mymat(i,j)=hold+hold2;
            end
           if mode==13
                h=1/sqrt(2);
                v=h;
                hold=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-446.5)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-446.5)));
                hold=ht*hold*exp(-3*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-446.5)^2));
                hold2=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-150.5)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-150.5)));
                hold2=ht*hold2*exp(-3*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-150.5)^2));
                mymat(i,j)=hold+hold2;
           end
           if mode==15
                h=.549;
                v=.836;
                hold=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-397)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-397)));
                hold=ht*hold*exp(-3*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-397)^2));
                hold2=cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)+h*(j-200)))+cos(2*pi*fac2/(myw-2)*(v*(i-(myh+p)/2)-h*(j-200)));
                hold2=ht*hold2*exp(-3*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-200)^2));
                mymat(i,j)=hold+hold2;
           end
           if mode==12
                hold=ht*exp(-8*fac/(myw-2)*pi*((i-45)^2+(j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*(j-(myw+p)/2));
                hold2=ht*exp(-8*fac/(myw-2)*pi*((i-255)^2+(j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*(j-(myw+p)/2));
                mymat(i,j)=hold+hold2;
           end
           if mode==10
                if j<myw/2
                    mymat(i,j)=cos(2*pi*fac2/(myw-2)*((j-(myw+p)/4)^2)^(1/2));
                end
           end
           if mode==14
                 mymat(i,j)=ht*exp(-2*fac/(myw-2)*pi*((i-(myh+p)/2)^2+(j-(myw+p)/2)^2))*cos(2*pi*fac2/(myw-2)*((i-(myh+p)/2)^2)^(1/2));
           end
   
        end
    end
end
if sav
    aviobj=avifile(strcat('wavee',num2str(frm),'.avi'),'fps',30);
end
if lod
    if frm==0
       load wmat
    else
       load(strcat('wmat',num2str(frm-1)));
    end
    if sav
        show(mymat,1,frm);
        frame=getframe;
        aviobj = addframe(aviobj,frame);
    end
end
mymat2=mymat;
mymat4=mymat;
autocor=zeros(1,steps);
mymat3=zeros(myh,myw);
aNS=0;
aEW=aNS;
for s=1:steps
    for t=0:min(1,steps)
        for i=2:myh-1
            for j=2:myw-1
                if mod(i+j+t,2)==0
                    %apply force if reqd to each (i,j) as follows
                    %dai(t+dt)=(Fi(t+dt)-Fi(t))/mi
                    %vi(t+dt)=vi(t)+ai(t)dt
                    %phi(t+dt)=phi(t)+vi(t+dt)*dt
                    %then iterate chequerboard as below
                    if mymask(i,j)
                        phi=-2*mymat(i,j);
                        if mymask(i+1,j)
                            phi=phi+(mymat(i+1,j));
                        else
                            phi=phi+(mymat(i-1,j));
                        end
                        if mymask(i-1,j)
                            phi=phi+(mymat(i-1,j));
                        else
                            phi=phi+(mymat(i+1,j));
                        end
                        if mymask(i,j+1)
                            phi=phi+(mymat(i,j+1));
                        else
                            phi=phi+(mymat(i,j-1));
                        end
                        if mymask(i,j-1)
                            phi=phi+(mymat(i,j-1));
                        else
                            phi=phi+(mymat(i,j+1));
                        end
                        phi=phi/2;
                        mymat2(i,j)=phi;
                    end
                end
            end
        end
        mymat=mymat2;
        if mode~=10
            mx=max(max(abs(mymat)));
        else
            mx=max(max(abs(mymat(:,myw/2:myw))));
        end
        for i=1:myh
            for j=1:myw
                if mymask(i,j)
                   if disp==1 
                       k=(mymat(i,j)/mx);
                       if k>=0
                           myimat(i,j,1) =k;
                       else
                           myimat(i,j,3) =-k;
                       end
                       myimat(i,j,2) =1/5;
                   end
                   if disp==2
                     k=2*pi*(mymat(i,j)/mx);
                     myimat(i,j,1) = 1/2+1/2*sin(k);
                     myimat(i,j,2) = 1/2+1/2*sin(k+pi/4);
                     myimat(i,j,3) = 1/2+1/2*cos(k);
                   end
                 end
            end
        end
%         if disp>0&&s>delay
%             image(myimat);
%             frame=getframe;
%             if sav
%                 aviobj = addframe(aviobj,frame);
%                 %imwrite(myimat,strcat('im',num2str(s),'.jpg'),'jpg');
%             end
%         end
    end
    if disp>0&&s>delay
        image(myimat);
        frame=getframe;
        if sav
            aviobj = addframe(aviobj,frame);
            %imwrite(myimat,strcat('im',num2str(s),'.jpg'),'jpg');
        end
    end
    if s>=delay
        switch disp
           
            case -2
                if mod(s,floor((myw-2)*2/fac2))==0
                    mymat3=mymat3+mymat;
                end
            case -1
                if mod(s,floor((myw-2)/fac2))==0    
                    mymat3=mymat3+abs(mymat);
                 end
            case -3
                if mod(s,floor((myw-2)/fac2))==0    
                    mymat3=mymat3+mymat.^2;
                end
        end
        %fprintf('%d\n',s);
    end
    if ~mod(s,100)
        fprintf('%d\n',s);
    end
    if s>=delay
        for myi=1:myh
            for myj=1:myw
                autocor(s)=autocor(s)+mymat4(myi,myj)*mymat(myi,myj);
            end
        end
    end
    %fprintf('%d %4.2f\n',s,autocor(s));
end
if sav2
    save('wmat','mymat','mymat3','autocor');
    save(strcat('wmat',num2str(frm)),'mymat','mymat3','autocor');    
end
if disp==-1||disp==-2
    show(mymat3,lev1,frm)
end
if disp==-3
    show(mymat3,lev2,frm)
end
if sav
    aviobj = close(aviobj);
end

function show(mymat,sc,n)
[mylen width]=size(mymat);
myimat=zeros(mylen,width,3);
if sc
    mymat=sc*mymat/max(max(abs(mymat)));
end
for i=1:mylen
    for j=1:width
            k=2*pi*mymat(i,j);
            myimat(i,j,1) = 1/2+1/2*sin(k);
            myimat(i,j,2) = 1/2+1/2*sin(k+pi/4);
            myimat(i,j,3) = 1/2+1/2*cos(k); 
    end
end
image(myimat);
imwrite(myimat,strcat('im',num2str(n),'.jpg'),'jpg');
