function mymat=semiclass(p,q,freq,stps,n,sc,absmode,angoffs)
%plots a semi-classical ray trace for n=reflections
%p,q=starting point, freq=frequency of wave, stps=rays
%sc is image brightness
%semiclass(0,0,15,2^13,3,25,0,0); %semiclassical wave amplitudes
%semiclass(0,0,Inf,2^13,3,25,0,0); %classical caustics
%semiclass(0,0,Inf,1,1200,1,0,pi/5); %period 8 orbit
myw=601;
myh=301;
figure('position',[400 400 myw myh]);
axes('position',[0 0 1 1]);
mymat=zeros(myh,myw);
wb = waitbar(0,'Please wait...');
for i=1:stps
    if ~mod(i,1000)
        waitbar(i/stps,wb)
    end
    th=2*pi*i/stps;
    r=cos(th+angoffs);
    s=sin(th+angoffs);
    a=[1 0;0 1];
    pp=p;
    qq=q;
    ll=0;
    for j=1:n
        [po qo ro so]=nextref(pp,qq,r,s);
        fprintf('%4.5f %d %4.5f\n',a(1,1),j,th);
        mymat=fillorb(pp,qq,po,qo,a,mymat,ll,freq,absmode);
        r=po-pp;
        s=qo-qq;
        l=sqrt(r^2+s^2);
        ll=ll+l;
        l2=[1 0;l 1];
        [P Q]=twocoord(po,qo,r,s);
        R=1;
        if (Q>pi/2&&Q<pi/2+2)||(Q>3*pi/2+2&&Q<3*pi/2+4)
            R=Inf;
        end
        m=[-1 2/R/sin(acos(P));0 -1];
        a=a*m*l2;
        %a=l2*m*a;      
        pp=po;
        qq=qo;
        r=ro;
        s=so;
    end
end
close(wb);
show(mymat,sc,1);
save wmat mymat

function mymat=fillorb(pp,qq,po,qo,a,mymat,ll,freq,absmode)
r=po-pp;
s=qo-qq;
l=sqrt(r^2+s^2);
[myh myw]=size(mymat);
m=(myh-1)/2;
if r~=0&&(abs(r)>abs(s)||s==0)
    for k=0:sign(r)/m:r
        wpos=round(m*(pp+2+k)+1);
        hpos=round(m*(qq+1+k*s/r)+1); 
        mf=a(1,1)*cos(2*pi*(ll+l*k/r)*m/freq);
        if absmode
            mf=abs(mf);
        end
        if freq==Inf
            mf=0.001;
        end
        mymat(hpos,wpos)=mymat(hpos,wpos)+mf;

    end
end
if s~=0&&(abs(r)<=abs(s)||r==0)
    for k=0:sign(s)/m:s;
        hpos=round(m*(qq+1+k)+1);
        wpos=round(m*(pp+2+k*r/s)+1);
        mf=a(1,1)*cos(2*pi*(ll+l*k/s)*m/freq);
        if absmode
            mf=abs(mf);
        end 
        if freq==Inf
            mf=0.001;
        end
        mymat(hpos,wpos)=mymat(hpos,wpos)+mf;
    end
end

function [po qo ro so]=nextref(p,q,r,s)
if abs(s)>.000001
        up=p+r*(sign(s)-q)/s;
        if up>=-1&&up<=1
            po=up;
            qo=sign(s);
            ro=r;
            so=-s;
        else

            sp=sign(up);
                a=r/s;
                b=p-r*q/s;
                ap=2*a*(b-sp);
                rt=sqrt(ap^2-4*(a^2+1)*b*(b-2*sp));
                ym=(-ap-rt)/2/(a^2+1);
                xm=a*ym+b;
                yp=(-ap+rt)/2/(a^2+1);
                xp=a*yp+b;
                if abs(xp-p)>abs(xm-p)
                    x=xp;
                    y=yp;
                else
                    x=xm;
                    y=ym;
                end
                if r*(p-sp)+s*q>0&&abs(xp-p)<.00001
                    x=xp;
                    y=yp;
                end
                if r*(p-sp)+s*q>0&&abs(xm-p)<.00001
                    x=xm;
                    y=ym;
                end              
                po=x;
                qo=y;
                rr=x-sp;
                ss=y;
                dt=r*rr+s*ss;
                m=dt/(rr^2+ss^2);
                ro=-(r+2*(m*rr-r));
                so=-(s+2*(m*ss-s));
        end
else
    rp=sign(r);
    rt=sqrt(1-q^2);
    xm=(+rp-rt);
    xp=(+rp+rt);
    if abs(xp)>abs(xm)
        x=xp;
    else
        x=xm;
    end
    y=q;
    po=x;
    qo=y;
    rr=x-rp;
    ss=y;
    dt=r*rr+s*ss;
    m=dt/(rr^2+ss^2);
    ro=-(r+2*(m*rr-r));
    so=-(s+2*(m*ss-s));
end
        
function [P Q]=twocoord(p,q,r,s)
stsec=mysector(p,q);
switch stsec
    case 1
        a=myang(p-1,q,-pi);
        b=myang(r,s,-pi);
        Q=(1+p)+2+3*pi/2;
        P=cos(b);        
    case 2
        a=myang(p-1,q,-pi);
        b=myang(r,s,-pi);
        Q=(a>0)*(4+2*pi)-a;
        P=cos(pi/2+(b-a));
    case 3
        b=myang(r,s,-pi);
        Q=(1-p)+pi/2;
        P=cos(b+pi);
    case 4
        a=myang(p+1,q,-pi/2);
        b=myang(r,s,-pi/2);
        Q=2*pi+2-a;
        P=cos(pi/2+(b-a));
end

function k=mysector(p,q)
if abs(p)<=1
    if q==1 
        k=1;
    else
        k=3;
    end
end
if p>1
    k=2;
end
if p<-1
    k=4;
end
    
function a=myang(p,q,r)
try
    %a=angle(complex(p,q));
    a=atan2(q,p);
catch
    error('%s %4.5f %4.5f %4.5f','ee',p,q,r);
end
if a<r
    a=a+2*pi;
end

  
function show(mymat,sc,n)
[mylen width]=size(mymat);
myimat=zeros(mylen,width,3);
if sc
    mymat=sc*mymat/max(max(abs(mymat)));
end
for i=1:mylen
    for j=1:width
            k=2*pi*mymat(i,j);
            myimat(i,j,1) = 1/2+1/2*sin(k);
            myimat(i,j,2) = 1/2+1/2*sin(k+pi/4);
            myimat(i,j,3) = 1/2+1/2*cos(k); 
    end
end
image(myimat);
imwrite(myimat,strcat('im',num2str(n),'.jpg'),'jpg');



