function part4(stps,its)
%draws color partition of stadium PQ space
%part4(2^14,2);
%part4(2^16,4);
clf;
hold on
line([pi/2 pi/2],[-1 1],'color',[0 0 0]);
line([pi/2+2 pi/2+2],[-1 1],'color',[0 0 0]);
line([3*pi/2+2 3*pi/2+2],[-1 1],'color',[0 0 0]);
line([3*pi/2+4 3*pi/2+4],[-1 1],'color',[0 0 0]);
plotpart(1,1,stps,its,[1 0 0]);
plotpart(-1,1,stps,its,[1 0 1]);
plotpart(-1,-1,stps,its,[0 0 1]);
plotpart(1,-1,stps,its,[0 1 0]);

axis([0 2*(2+pi) -1 1]);
hold off

function plotpart(p,q,stps,its,col)
pm=zeros(1,stps);
qm=pm;
for i=1:stps
    th=2*pi*(i-1)/(stps-1);
    r=cos(th);
    s=sin(th);
    pp=p;
    qq=q;
    for j=1:its-1
        [pp qq r s]=nextref(pp,qq,r,s);
    end
    [po qo ro so]=nextref(pp,qq,r,s);
    [P Q]=twocoord(po,qo,r,s);
    pm(i)=P;
    qm(i)=Q;
end
plot(qm,pm,'o','MarkerSize',1,'color',col);