function l=pamin(p,q,st,en,stps,prt,sect,internal,av,symet,col)
%plots classical periodic orbits in order of periodicity
%Examples:
%l=pamin(2,0,2,20,80000,1,1,0,1,1,'b');
%l=pamin(0,1,5,5,80000,1,2,0,1,1,'b');
%l=pamin(0,0,5,5,80000,1,3,1,1,1,'b');
%l=pamin(1,0,16,16,80000,1,1,2,1,0,'b');
if av
    aviobj=avifile(strcat('orbs(',num2str(p),',',num2str(q),',',num2str(st),',',num2str(en),').avi'),'fps',5);
end
l=[];
tt=ones(1,stps);
figure('position',[400 400 600 300]);
axes('position',[0 0 1 1]);
for k=st:en
    y=zeros(1,stps);
    e=y;
    b=y;
    %t=y;
    stt=1+~internal;
    for i=stt:stps
        th=sect*pi/2+pi*(i-1)/2/(stps-1);
        r=cos(th);
        s=sin(th);
        [y(i) e(i) b(i)]=approach(p,q,r,s,k);
        %fprintf('%5.5f %5.5f %4.3f\n',r,s,y(i));
        %t(i)=th;
    end
    j=1;
    z=[];
    for i=stt:stps
        if y(i)<.1*sqrt(k)
            myf=0;
            switch i
                case 1
                    if y(i)<y(i+1)&&y(i)<y(i+2)
                        myf=1;
                    end
                case 2
                    if y(i)<y(i+1)&&y(i)<y(i+2)&&y(i)<y(i-1)
                        myf=1;
                    end
                case stps-1
                    if y(i)<y(i-2)&&y(i)<y(i-1)&&y(i)<y(i+1)
                        myf=1;
                    end

                case stps
                    if y(i)<y(i-1)&&y(i)<y(i-2)
                        myf=1;
                    end
                otherwise
                    if y(i)<y(i+1)&&y(i)<y(i-1)&&y(i)<y(i-2)&&y(i)<y(i+2)
                        myf=1;
                    end
            end
            if myf
               myy=y(i);
               myi=i;
               for mypos=-100:99
                   ii=i+mypos/200;
                   th=sect*pi/2+pi*(ii-1)/2/(stps-1);
                   r=cos(th);
                   s=sin(th);
                   [yy ee bb]=approach(p,q,r,s,k);
                   if yy<myy
                     myy=yy;
                     myi=ii;
                   end
               end
               for mypos=0:100
                   iii=myi+mypos/20000;
                   th=sect*pi/2+pi*(iii-1)/2/(stps-1);
                   r=cos(th);
                   s=sin(th);
                   [yy ee bb]=approach(p,q,r,s,k);
                   if yy<myy
                     myy=yy;
                     myi=iii;
                   end
               end
               if myy<.004*sqrt(k)
                   if tt(i)
                      z(j)=myi;
                      y(i)=myy;
                      j=j+1;
                      tt(i)=0;
                   end
               end
            end
 
        end
    end
    for j=1:length(z)
        %th=t(z(j));
        th=sect*pi/2+pi*(z(j)-1)/2/(stps-1);
        r=cos(th);
        s=sin(th);
       % if sign(y(z(j)))>0
        if e(round(z(j)))>0
            [ll d]=testref(p,q,r,s,k,internal>0,0,1,k,internal>0,col);
            if d>0.1*sqrt(k)&&symet;
                if internal
                    [dummy d]=testref(p,q,r,s,k,k,0,1,k,1,col);
                    ll=2*ll;
                else
                    [ll d]=testref(p,q,r,s,k,k+1,0,1,k,0,col);
                end
            end
        else
            if internal>0
               if internal==1
                    %[ll d]=testref(p,q,r,s,k-floor(k/2),k-floor(k/2),0,1,2*k,1);
                    %ll=2*ll;
                    [ll d]=testref(p,q,r,s,k,k,0,1,2*k,1,col);
               else
                    [ll d]=testref(p,q,r,s,k,1,0,1,k,1,col);
               end
            else
              %l(j)=2*testref(p,q,r,s,n-1,n,0,1,n);
              if b(round(z(j)))==1
                  [ll d]=testref(p,q,r,s,k+1,k+2,0,1,2*k,0,col);
              else
                  [po qo ro so]=nextref(p,q,-r,-s);
                  if abs(ro*s-so*r)>.01
                    %[ll d]=testref(p,q,r,s,k-floor(k/2),k+1-floor(k/2),0,1,2*k,0);
                    %ll=2*ll;
                    [ll d]=testref(p,q,r,s,k,k+1,0,1,2*k,0,col);
                  else
                    [ll d]=testref(p,q,r,s,k,0,0,1,2*k,0,col);
                    ll=2*ll;
                  end                 
              end
           end
        end
        l=[l ll];
        if av
            frame=getframe;
            aviobj = addframe(aviobj,frame);
        end
        if prt
            fprintf('%d %d %4.5f %1.2f,%1.2f,%4.3f,%4.3f %4.5f %d %d %4.2f %4.5f\n',j,k,z(j),p,q,r,s,y(round(z(j))),e(round(z(j))),b(round(z(j))),d,ll);
        end
    end
end
if av
    aviobj = close(aviobj);
end
