function orbit(fn,u,v,p,q,its,revits,col,wid,prt,stad)
%fn=filename for wave image (or '') (u,v) start posn (p,q) second posn
%its=reflections revits=reverse orbit reflections 
%col='r','g','b' default black wid=1 makes a wide ray 0 normal
%prt prints the orbit vertices %stad=0 stadium, 3 lemon

%Examples
%orbit('bowtie',300-40,520.35,40,520.35,2,3,'r',1,0,0) %bow tie on scar
%orbit('pegs',150,595,0,478,2,3,'r',1,0) %first peg followed by
%orbit('pegso',150,597-595,0,597-478-1,2,3,'g',1,0,0) %twin pegs on scar
%orbit('',150,2,2,149.66,3,4,'r',0,0,0) %double diamond
%orbit('',150,30,102,300,8,0,'g',0,0,0) %sensitive dependence - green 
%orbit('newo',150,30,101.8,300,8,0,'r',0,0,0) %followed by red
%orbit('',150,30,121.8,300,4000,4000,'r',0,0,0) %dense orbit
%orbit('',150,595,0,499.5,5,6,'r',0,0,0) %asymmetric orbit
%orbit('',298,596-310,2,310,27,27,'r',0,0,0) %switchback
%orbit('',298,298.5,46,550.5,1,2,'r',0,0,0) %V
%orbit('',45,200,45,400,2,3,'r',1,0) %rectangle
%orbit('im0',150,298.5,150-80,298.5+20,30,30,'r',0,0,3) %lemon quasiperiod

if ~isempty(fn)
    A=imread(strcat(fn,'.jpg'),'jpg');
else
    A=zeros(299,596,3);
    A=uint8(A);
end
[x,y,z]=size(A);
myh=x;
myw=y;
figure('position',[400 400 myw myh]);
mymask=zeros(myh,myw);
rd=(myh-1)/2;
% for i=2:(myh+1)/2
%     for j=1:myw
%         hold=j<myw-rd-1+sqrt(rd^2-(i-(myh+1)/2)^2)&&j>rd+1-sqrt(rd^2-(i-(myh+1)/2)^2);
%         if hold
%             mymask(i,j)=1;
%             mymask(myh-i+1,j)=1;
%             if isempty(fn);
%                 A(i,j,:)=255;
%                 A(myh-i+1,j,:)=255;
%             end
%         end
%     end
% end
for i=2:(myh+1)/2
    for j=1:myw
        switch stad
            case 0
                rd=(myh-1)/2;
                hold=j<=myh-2+rd+sqrt(rd^2-(i-(myh+1)/2)^2)&&j>=rd+2-sqrt(rd^2-(i-(myh+1)/2)^2);
            case 1
                hold=(j<=myw-1&&j>=2);
            case 2
                if j>=myw/2&&j<=myw/2+1
                    if ~(i>=myh/4&&i<=myh/4+10)||(i<=3*myh/4&&i>=3*myh/4-10)
                        hold=0;
                    end
                end
            case 3
               rd=myh-50;
               hold=j<=myw/2+sqrt(rd^2-(i-rd-2)^2)&&j>=myw/2-sqrt(rd^2-(i-rd-2)^2);
         end
        if hold
            mymask(i,j)=1;
            mymask(myh-i+1,j)=1;
        end
    end
end
p=p-u;  
q=q-v;
A=ray(u,v,p,q,mymask,A,its,col,fn,wid,prt,stad);
if revits
   A=ray(u,v,-p,-q,mymask,A,revits,col,fn,wid,prt,stad);
end

function A=ray(u,v,p,q,mymask,A,its,col,fn,wid,prt,stad)
[myh myw]=size(mymask);
i=u;
j=v;
switch col
    case 'r'
        c=[255 0 0]';
    case 'g'
        c=[0 255 0]';
    case 'b'
        c=[0 0 255]';
    otherwise
        c=[0 0 0]';
end
k=0;
supp=0;
while k<its
  ri=round(i);
  rj=round(j);
  A(ri,rj,:)=c;
  if wid
     for m=ri-1:ri+1
         for n=rj-1:rj+1
             if m>=1&&m<=myh&&n>=1&&n<=myw
                 if mymask(m,n)
                    A(m,n,:)=c;
                 end
             end
         end
     end
  end
  [ii jj]=next(p,q,i,j,u,v);
  ir=round(ii);
  jr=round(jj);
  if ir<1||ir>myh||jr<1||jr>myw
      fprintf('%s %d %4.2f %4.2f\n','orbit terminated at:',k,ir,jr);
      %save('mym','p','q','i','j','u','v','ii','jj');
      break
  end
  if mymask(ir,jr)||supp
    %supp suppresses for 1 step out of stadium after a refln
    %to avoid an orbit endlessly reflecting if caught in an L.
    if mymask(ir,jr)&&supp 
        supp=~supp;
    end
    i=ii;
    j=jj;
  else
    k=k+1;
    supp=~supp;
    switch stad
        case 0
            rd=(myh-1)/2;
            if jj>rd+1&&jj<myw-rd-1
              p=-p;
            end
            if jj>=myw-rd-1
                qq=j-(myw-rd-1);
                pp=i-(myh+1)/2;
                [p q]=newdir(p,q,pp,qq);
             end
            if jj<=rd+1
                qq=j-(rd+1);
                pp=i-(myh+1)/2;
                [p q]=newdir(p,q,pp,qq);
            end            
        case 3
            rd=myh-50;
            if ii<=(myh+1)/2
               pp=i-rd-2;
               qq=j-myw/2;
            else
               %pp=(myh+1-(i-rd-2));
               pp=-(300-i-rd-2);
               qq=j-myw/2;
            end
            [p q]=newdir(p,q,pp,qq);
    end
    u=i;
    v=j;
    if prt
        fprintf('%d %4.5f %4.5f %4.5f %4.5f %4.5f %4.5f\n',k,i,j,ii,jj,p,q);
    end
  end
end
image(A)
if isempty(fn)
    fn='new';
end
imwrite(A,strcat(fn,'o.jpg'),'jpg','Quality',100);

function [io jo]=next(p,q,i,j,u,v)
if abs(q)>abs(p)
  jo=j+sign(q);
  io=u+p/q*(jo-v);
else
  io=i+sign(p);
  jo=v+q/p*(io-u);
end

function [po qo]=newdir(p,q,pp,qq)
dt=p*pp+q*qq;
if dt>=0
m=(p*pp+q*qq)/(pp*pp+qq*qq);
po=-(p+2*(m*pp-p));
qo=-(q+2*(m*qq-q));
else
    po=p;
    qo=q;
end

 
    