function l=classorbit(p,q,st,en,stps,sect,sensitiv,prt,av,singlevalue)
%Parameters
%p,q=coordinates of origin st,end=start and end periods
%stps=number of angle steps in quadrant sect=1,2,3,4 quadrant
%prt=print results, savim save jpg images
%if internal discount first partial edge. col is color string
%av=produce avi file of orbits,  col=color of plot
%singlevalue is usually zero but can be used to reinvestigate one orbit
%use the angle fraction parameter generated by classorbit in zero mode
%testref can also be used directly to do this


%Exampes:
%l=classorbit(2,0,2,20,80000,1);
%l=classorbit(0,1,5,5,80000,2);
%l=classorbit(0,0,5,5,80000,3,0.00001,1,1,0);
%l=classorbit(2,0,4,4,80000,1,0.00001,1,1,56386.91640); %one orbit at specified angle
%p=classorbit(0.6,0.8,1,20,80000,1,0.00001,1,1,0); %orbit through asymmetric point
if nargin<10
    singlevalue=0;
end
if nargin<9
    av=1;
end
if nargin<8
    prt=1;
end
if nargin<7||sensitiv==0
    sensitiv=0.00008;
end
col='b';
if av
    aviobj=avifile(strcat('orbs(',num2str(p),',',num2str(q),',',num2str(st),',',num2str(en),').avi'),'fps',5);
end
i=isin(p,q);
if i==0
    l=[];
    return
end
internal=0;
if i==1
    internal=1;
end
tt=ones(1,stps);
figure('position',[400 400 600 300]);
axes('position',[0 0 1 1]);
l=[];
for k=st:en %step up the orbit lengths
    if ~singlevalue
        y=zeros(1,stps);
        e=y;
        b=y;
        %t=y;
        stt=1+~internal;
        for i=stt:stps %number of angular rays
            th=sect*pi/2+pi*(i-1)/2/(stps-1);
            r=cos(th);
            s=sin(th);
            [y(i) e(i) b(i)]=approach(p,q,r,s,k); %test each ray for close approach
            %fprintf('%5.5f %5.5f %4.3f\n',r,s,y(i));
            %t(i)=th;
        end
        j=1; 
        z=[]; %z is going to hold all the 'closed' or 'bouncing' orbits
        for i=stt:stps %number of angular rays
            if y(i)<.1*sqrt(k) %test each 'close' ray for a better fit
                myf=0;
                switch i %is the ray closer than its two neighbours?
                    case 1
                        if y(i)<y(i+1)&&y(i)<y(i+2) %start pos only right nhbrs
                            myf=1;
                        end
                    case 2
                        if y(i)<y(i+1)&&y(i)<y(i+2)&&y(i)<y(i-1) %second pos
                            myf=1;
                        end
                    case stps-1
                        if y(i)<y(i-2)&&y(i)<y(i-1)&&y(i)<y(i+1) %secondlast pos
                            myf=1;
                        end

                    case stps
                        if y(i)<y(i-1)&&y(i)<y(i-2) %last pos only left nhbrs
                            myf=1;
                        end
                    otherwise
                        if y(i)<y(i+1)&&y(i)<y(i-1)&&y(i)<y(i-2)&&y(i)<y(i+2) %in between all nhbrs
                            myf=1;
                        end
                end
                if e(i)<0
                    myf=0;
                end
                if myf
                   myy=y(i);
                   myi=i;
                   for mypos=-100:99 %feel through in hundredths of a sector
                       ii=i+mypos/200;
                       th=sect*pi/2+pi*(ii-1)/2/(stps-1);
                       r=cos(th);
                       s=sin(th);
                       [yy ee bb]=approach(p,q,r,s,k);
                       if yy<myy
                         myy=yy;
                         myi=ii;
                       end
                   end
                   for mypos=-100:99 %feel through in 10000ths of a sector
                       iii=myi+mypos/20000;
                       if (iii>=i-1/2)&&(iii<i+1/2)
                           th=sect*pi/2+pi*(iii-1)/2/(stps-1);
                           r=cos(th);
                           s=sin(th);
                           [yy ee bb]=approach(p,q,r,s,k);
                           if yy<myy
                             myy=yy;
                             myi=iii;
                           end
                       end
                   end
                   for mypos=-100:99 %feel through in 10000ths of a sector
                       iii=myi+mypos/2000000;
                       if (iii>=i-1/2)&&(iii<i+1/2)
                           th=sect*pi/2+pi*(iii-1)/2/(stps-1);
                           r=cos(th);
                           s=sin(th);
                           [yy ee bb]=approach(p,q,r,s,k);
                           if yy<myy
                             myy=yy;
                             myi=iii;
                           end
                       end
                   end
                   if myy<sensitiv*k;%sqrt(k) %if its small flagit it into Z
                       if tt(i) %this direction not occupied by a shorter orbit.
                          z(j)=myi;%log this value into z as a closed prbit
                          y(i)=myy;
                          j=j+1;
                          tt(i)=0;
                       end
                   end
                end

            end
        end
    end
    if singlevalue
        z=singlevalue;
    end
    for j=1:length(z) %we are now going to map out the orbits we have found
        %th=t(z(j));
        th=sect*pi/2+pi*(z(j)-1)/2/(stps-1);
        r=cos(th);
        s=sin(th);
        if singlevalue %just get the direction specs for this orbit
            [y(round(z(j))) e(round(z(j))) b(round(z(j)))]=approach(p,q,r,s,k);
        end
        [ll d sens]=testref(p,q,r,s,k,internal>0,0,av,k,internal>0,col);
        %plot the orbit
        l=[l ll];
        if av
            frame=getframe;
            aviobj = addframe(aviobj,frame);
        end
        if prt
            fprintf('%d %d %4.8f %1.2f,%1.2f,%4.3f,%4.3f %4.5f %d %d %4.2f %4.5f %4.5f\n',j,k,z(j),p,q,r,s,y(round(z(j))),e(round(z(j))),b(round(z(j))),d,ll,sens);
        end
    end
end
if av
    aviobj = close(aviobj);
end

function [l d sens]=testref(p,q,r,s,n,m,prt,svas,nn,intr,col)
%Examples
%l=testref(0,0,0.56921,-0.82219,5,0,0)

%(p,q) start point, (r,s)=vector direction, n=iterations, m=reverse its
%prt=print %svas save nn attribute higher number to iterations if repeated
%intr point is internal so discount first partial edge, col is color string

%figure('position',[400 400 600 300]);
clf
hold on
[l d ro so]=tref(p,q,r,s,n,prt,1,intr,col);
[rn sn]=nang(r,s);
[lu du rou sou]=tref(p,q,rn,sn,n,prt,0,intr,col);
sens=abs(angle(complex(ro,so))-angle(complex(rou,sou)));
if m    
    [ll dd ro so]=tref(p,q,-r,-s,m,prt,1,intr,col);
    sens=2*sens;
    l=l+ll;
    d=d+dd;
end
while sens>=pi
    sens=abs(sens-2*pi);
end
plot([-1 1],[0.995,0.995],'r');
plot([-1 1],[-1,-1],'r');
y=linspace(-1,1,100);
xx=-sqrt(1.-y.^2)-1;
plot(xx,y,'r');
xx=sqrt(1.-y.^2)+1;
plot(xx,y,'r');
id=strcat('orbit(',num2str(nn),',',num2str(p),',',num2str(q),',',num2str(r),',',num2str(s),',',num2str(n),',',num2str(m),').jpg');
if svas
    saveas(gcf,id,'jpg');
end
hold off

function [l d r s]=tref(p,q,r,s,n,prt,plt,intr,col)
if prt
    fprintf('%d %4.4f %4.4f %4.4f %4.4f\n',1,p,q,r,s);
end
x=zeros(1,n+1);
y=x;
x(1)=p;
y(1)=q;
l=0;
for i=2:n+1
    pp=p;
    qq=q;
    [p q r s]=nextref(p,q,r,s);
    l=l+sqrt((pp-p)^2+(qq-q)^2);
    x(i)=p;
    y(i)=q;
    if prt
        fprintf('%d %4.4f %4.4f %4.4f %4.4f\n',i,p,q,r,s);
    end
end
d=0;
if intr
    for i=2:floor((n+1)/2)
        d=d+(abs(x(i))-abs(x(n-i+3)))^2+(abs(y(i))-abs(y(n-i+3)))^2;
    end
else
    for i=1:floor((n+1)/2)
        d=d+(abs(x(i))-abs(x(n-i+2)))^2+(abs(y(i))-abs(y(n-i+2)))^2;
    end
end
d=sqrt(d);
if plt
    plot(x,y,col)
end

function [rn sn]=nang(r,s)
ang=angle(complex(r,s));
ang=ang+0.0000001;
rn=cos(ang);
sn=sin(ang);

function [a e bounce]=approach(p,q,r,s,n)
% measures how close the nth reflected ray comes to the start position and direction
pp=p;
qq=q;
rr=r;
ss=s;
bounce=1;
for i=1:n    
    [p q ro so]=nextref(p,q,r,s);
    if abs(ro*s-so*r)<0.001&&(ro*r+so*s)<0 %sets bounce to -1 if there was a bounce
        bounce=-1;
    end
    r=ro;
    s=so;
end
c=closest(p,q,r,s,pp,qq);
d=r*ss-s*rr;
e=sign(s*ss+r*rr);%new vector dot xct positive or negative with old vector
a=sqrt(c^2+d^2); %measures pythagorean combined angular and point distance

function [po qo ro so]=nextref(p,q,r,s)
if abs(s)>.000001
        up=p+r*(sign(s)-q)/s; %finds the x point point on y=+/-1 on the ray
        if up>=-1&&up<=1 %and reflects back if hitting the straight edge
            po=up;
            qo=sign(s);
            ro=r;
            so=-s;
        else %we are hitting a curved portion

            sp=sign(up); %sets left or right circle
                a=r/s;
                b=p-r*q/s;
                ap=2*a*(b-sp);
                rt=sqrt(ap^2-4*(a^2+1)*b*(b-2*sp));%plot the two intersection points of the ray with the circle
                ym=(-ap-rt)/2/(a^2+1);
                xm=a*ym+b;
                yp=(-ap+rt)/2/(a^2+1);
                xp=a*yp+b;
                mm=(ym-q)/s; %mm: (xm,ym)=(p,q)+mm*(u,v)
                pp=(yp-q)/s; %pp: (xp,yp)=(p,q)+pp*(u,v)
                if sign(mm*pp)>0 %if we are outside the circle so both points are on the same semi-ray
                 if abs(xp-p)>abs(xm-p) %choose the most distant one to hit the outside semi-circle
                    x=xp;
                    y=yp;
                 else 
                    x=xm;
                    y=ym;
                 end
                else %otherwise we are inside the circle
                  if mm>0 %choose the point in the positive (u,v) direction           
                    x=xm;
                    y=ym;
                  else
                    x=xp;
                    y=yp;
                  end
                end
                po=x;
                qo=y;
                rr=x-sp;
                ss=y;
                dt=r*rr+s*ss;
                m=dt/(rr^2+ss^2);
                ro=-(r+2*(m*rr-r));
                so=-(s+2*(m*ss-s));
        end
else
    rp=sign(r);
    rt=sqrt(1-q^2);
    xm=(+rp-rt);
    xp=(+rp+rt);
    if abs(xp)>abs(xm)
        x=xp;
    else
        x=xm;
    end
    y=q;
    po=x;
    qo=y;
    rr=x-rp;
    ss=y;
    dt=r*rr+s*ss;
    m=dt/(rr^2+ss^2);
    ro=-(r+2*(m*rr-r));
    so=-(s+2*(m*ss-s));
end
%fprintf('%4.5f %4.5f %4.5f %4.5f %4.5f %4.5f %4.5f %4.5f \n',p,q,r,s,po,qo,ro,so);
        
function c=closest(p,q,r,s,u,v)
t=(r*(u-p)+s*(v-q))/(r^2+s^2);
pp=p+r*t;
qq=q+s*t;
c=sqrt((u-pp)^2+(v-qq)^2);

function log=isin(p,q)
log=0;
if (abs(p)<1&&abs(q)<1)||(p-1)^2+q^2<1||(p+1)^2+q^2<1
    log=1;
end
if (abs(p)<=1&&abs(q)==1)||((p-1)^2+q^2==1&&p>=1)||((p+1)^2+q^2==1&&p<=-1)
    log=2;
end


