function circiter(rad,stps,its)
%iterates an ellipse over stps angles in PQ space its times  
%circiter(0.2,2^11+1,2);
%circiter(0.2,2^16+1,4);
clf;
pm=zeros(1,stps);
qm=pm;
for i=1:stps
    pp=rad*cos(2*pi*(i-1)/(stps-1));
    qq=2+pi+rad*(2+pi)*sin(2*pi*(i-1)/(stps-1));
    [pp qq]=nextPQ(pp,qq,its);
    pm(i)=pp;
    qm(i)=qq;
end
plot(qm,pm,'ok','MarkerSize',1);
axis([0 2*(2+pi) -1 1]);
for i=1:stps
    pm(i)=rad*cos(2*pi*(i-1)/(stps-1));
    qm(i)=2+pi+rad*(2+pi)*sin(2*pi*(i-1)/(stps-1));
end
hold on
plot(qm,pm,'or','MarkerSize',1);
hold off

function [P Q]=nextPQ(P,Q,its)
[p q r s]=fourcoord(P,Q);
for i=1:its
    [p q r s]=nextref(p,q,r,s);
end
[p q rn sn]=nextref(p,q,r,s);
[P Q]=twocoord(p,q,r,s);
    
    